/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.editors.misc.ValueUnitPairParser;
import alma.obsprep.ot.gui.resources.Colors;
import alma.obsprep.services.experts.spectralline.gui.UnitFormat;
import alma.obsprep.services.summaryfeedback.ARRangeSensitivityRenderer;
import alma.obsprep.services.summaryfeedback.AngularResolutionRenderer;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.util.DoubleRange;
import alma.obsprep.util.Range;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Angle;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.Temperature;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import alma.valuetypes.UserUnitValueUnitPair;
import alma.valuetypes.Velocity;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SummaryTableCellRendererFactory {
    private final SummaryTableCellRenderer defaultRenderer = new DefaultSummaryTableCellRenderer();
    private final SummaryTableCellRenderer polnRenderer = new PolarizationRenderer();
    private final SummaryTableCellRenderer skyCoordsRenderer = new SkyCoordinatesCellRenderer();
    private final SummaryTableCellRenderer galxCoodsRenderer = new GalacticCoordinatesCellRenderer();
    private final SummaryTableCellRenderer velocityRenderer = new VelocityCellRenderer();
    private final SummaryTableCellRenderer areaSizeRenderer = new AreaSizeRenderer();
    private final SummaryTableCellRenderer spacingRenderer = new MosaicSpacingRenderer();
    private final SummaryTableCellRenderer booleanRenderer = new BooleanRenderer();

    public SummaryTableCellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public SummaryTableCellRenderer getLeftAlignmentRenderer() {
        DefaultSummaryTableCellRenderer defaultSummaryTableCellRenderer = new DefaultSummaryTableCellRenderer();
        defaultSummaryTableCellRenderer.setHorizontalAlignment(2);
        return defaultSummaryTableCellRenderer;
    }

    public SummaryTableCellRenderer getPolarizationRenderer() {
        return this.polnRenderer;
    }

    public SummaryTableCellRenderer getSkyCoordinatesRenderer() {
        return this.skyCoordsRenderer;
    }

    public SummaryTableCellRenderer getGalacticCoordinatesRenderer() {
        return this.galxCoodsRenderer;
    }

    public SummaryTableCellRenderer getVelocityRenderer() {
        return this.velocityRenderer;
    }

    public SummaryTableCellRenderer getAreaSizeRenderer() {
        return this.areaSizeRenderer;
    }

    public SummaryTableCellRenderer getArcsecRenderer(String string) {
        return new ArcsecRenderer(string);
    }

    public SummaryTableCellRenderer getMosaicSpacingRenderer() {
        return this.spacingRenderer;
    }

    public SummaryTableCellRenderer getBooleanRenderer() {
        return this.booleanRenderer;
    }

    public SummaryTableCellRenderer getRangeRenderer(String string, String string2) {
        return new RangeRenderer(string, string2);
    }

    public SummaryTableCellRenderer getSimpleValueRenderer(String string) {
        return new SimpleValueRenderer(string);
    }

    public SummaryTableCellRenderer getSingleContinuumSkyFrequencyRenderer(String string) {
        return new SingleContinuumSkyFrequencyRenderer(string);
    }

    public SummaryTableCellRenderer getVupRenderer(String string) {
        return new VupRenderer(string, null);
    }

    public SummaryTableCellRenderer getVupRenderer(String string, String string2) {
        return new VupRenderer(string, string2);
    }

    public SummaryTableCellRenderer getVupRenderer(String string, String string2, boolean bl) {
        return new VupRenderer(string, string2, bl);
    }

    public SummaryTableCellRenderer getUserSensitivityRenderer(String string) {
        return new UserSensitivityRenderer(string);
    }

    public SummaryTableCellRenderer getUuVupRenderer(String string) {
        return new UuVupRenderer(string);
    }

    public SummaryTableCellRenderer getEquivalentValuesRenderer(String string, String string2, String string3, String string4) {
        return new EquivalentValuesRenderer(string, string2, string3, string4);
    }

    public SummaryTableCellRenderer getSignificantDigitRenderer() {
        return new SignificantDigitRenderer();
    }

    public SummaryTableCellRenderer getSensitivityRenderer(String string, String string2) {
        return new SensitivityRenderer(string, string2);
    }

    public SummaryTableCellRenderer getSensitivityARRangeRenderer(String string, String string2) {
        return new SensitivityARRangeRenderer(string, string2);
    }

    public SummaryTableCellRenderer getUserFrequencyRenderer(String string, String string2) {
        return new FrequencyRenderer(string, string2);
    }

    public SummaryTableCellRenderer getVupRangeRenderer(String string, String string2) {
        return new VupRangeRenderer(string, string2);
    }

    public SummaryTableCellRenderer getFluxRenderer() {
        return new FluxTableCellRenderer();
    }

    public SummaryTableCellRenderer getSensitivityRangeRenderer() {
        return new SensitivityRangeRenderer();
    }

    public SummaryTableCellRenderer getAngularResolutionRenderer(String string, String string2) {
        return new AngularResolutionRenderer(string, string2);
    }

    public SummaryTableCellRenderer getARRangeSensitivityRenderer(String string, String string2) {
        return new ARRangeSensitivityRenderer(string, string2);
    }

    private class DefaultSummaryTableCellRenderer
    extends SummaryTableCellRenderer {
        private DefaultSummaryTableCellRenderer() {
        }

        @Override
        String format(Object object) {
            if (object == null) {
                return "";
            }
            return object.toString();
        }
    }

    public static abstract class SummaryTableCellRenderer
    extends DefaultTableCellRenderer {
        boolean available = true;

        SummaryTableCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        void unavailable() {
            this.available = false;
        }

        abstract String format(Object var1);

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = this.format(object);
            String string2 = this.available ? string : "";
            return super.getTableCellRendererComponent(jTable, string2, bl, bl2, n, n2);
        }
    }

    private class PolarizationRenderer
    extends SummaryTableCellRenderer {
        private PolarizationRenderer() {
        }

        @Override
        String format(Object object) {
            Double d = (Double)object;
            return String.format("%.1f%%", d);
        }
    }

    private class SkyCoordinatesCellRenderer
    extends SummaryTableCellRenderer {
        private SkyCoordinatesCellRenderer() {
        }

        @Override
        String format(Object object) {
            SkyCoordinates skyCoordinates = (SkyCoordinates)object;
            if (skyCoordinates == null) {
                return "";
            }
            Latitude latitude = skyCoordinates.getLatitude();
            Longitude longitude = skyCoordinates.getLongitude();
            Object object2 = "";
            if (SkyCoordinates.isEquatorial(skyCoordinates.getSystem())) {
                try {
                    String string = longitude.toHHMMSS().split("\\.")[0];
                    String string2 = latitude.toDDMMSS().split("\\.")[0];
                    object2 = string + ", " + string2;
                }
                catch (InvalidCoordException | OutOfRangeException exception) {
                    object2 = String.format("%.1f, %.1f", longitude.getContentInDeg(), latitude.getContentInDeg());
                }
            } else {
                object2 = String.format("%.1f, %.1f", longitude.getContentInDeg(), latitude.getContentInDeg());
            }
            return object2;
        }
    }

    private class GalacticCoordinatesCellRenderer
    extends SummaryTableCellRenderer {
        private GalacticCoordinatesCellRenderer() {
        }

        @Override
        String format(Object object) {
            SkyCoordinates skyCoordinates = (SkyCoordinates)object;
            if (skyCoordinates == null) {
                return "";
            }
            Latitude latitude = skyCoordinates.getLatitude();
            Longitude longitude = skyCoordinates.getLongitude();
            return String.format("%.3f, %.3f", longitude.getContentInDeg(), latitude.getContentInDeg());
        }
    }

    private class VelocityCellRenderer
    extends SummaryTableCellRenderer {
        private VelocityCellRenderer() {
        }

        @Override
        String format(Object object) {
            Velocity velocity = (Velocity)((Object)object);
            double d = velocity.getCenterVelocity().getContentInUnits(Speed.UNIT_KM_S);
            return String.format("%.2f km/s,%s,%s", d, velocity.getReferenceSystem(), velocity.getDopplerCalcType());
        }
    }

    private class AreaSizeRenderer
    extends SummaryTableCellRenderer {
        private AreaSizeRenderer() {
        }

        @Override
        String format(Object object) {
            if (object == null) {
                return "";
            }
            if (object instanceof Angle) {
                Angle angle = (Angle)((Object)object);
                return String.format("%.1f \"", angle.getContentInUnits(Angle.UNIT_ARCSEC));
            }
            if (object instanceof ScienceGoalSummaryParameters.Angle2D) {
                ScienceGoalSummaryParameters.Angle2D angle2D = (ScienceGoalSummaryParameters.Angle2D)object;
                double d = angle2D.getX().getContentInUnits(Angle.UNIT_ARCSEC);
                double d2 = angle2D.getY().getContentInUnits(Angle.UNIT_ARCSEC);
                return String.format("%.0f\" x %.0f\"", d, d2);
            }
            return "";
        }
    }

    private class MosaicSpacingRenderer
    extends VupRenderer {
        private MosaicSpacingRenderer() {
            super("%.1f %s", Angle.UNIT_ARCSEC);
        }

        @Override
        String format(Object object) {
            if (object == null) {
                return "";
            }
            if (((ValueUnitPair)object).getContent() == 0.0) {
                return "offset";
            }
            return super.format(object);
        }
    }

    private class BooleanRenderer
    extends SummaryTableCellRenderer {
        private BooleanRenderer() {
        }

        @Override
        String format(Object object) {
            if (object == null) {
                return "";
            }
            Boolean bl = (Boolean)object;
            return bl != false ? "yes" : "no";
        }
    }

    private class ArcsecRenderer
    extends VupRenderer {
        private ArcsecRenderer(String string) {
            super(string + " \"", Angle.UNIT_ARCSEC);
        }
    }

    private class RangeRenderer
    extends SummaryTableCellRenderer {
        protected String format;
        protected String unit;

        private RangeRenderer(String string, String string2) {
            this.unit = string2;
            this.format = string;
        }

        @Override
        String format(Object object) {
            double d;
            double d2;
            Range range = (Range)object;
            if (object == null) {
                d2 = 0.0;
                d = 0.0;
            } else if (this.unit == null) {
                DoubleRange doubleRange = (DoubleRange)range;
                d = doubleRange.min();
                d2 = doubleRange.max();
            } else {
                VupRange vupRange = (VupRange)range;
                d = vupRange.min().getContentInUnits(this.unit);
                d2 = vupRange.max().getContentInUnits(this.unit);
            }
            return String.format(this.format, d, d2);
        }
    }

    private class SimpleValueRenderer
    extends SummaryTableCellRenderer {
        protected String format;

        private SimpleValueRenderer(String string) {
            this.format = string;
        }

        @Override
        String format(Object object) {
            if (object == null) {
                return "";
            }
            return String.format(this.format, object);
        }
    }

    protected class SingleContinuumSkyFrequencyRenderer
    extends AbstractHighlightValueRenderer {
        public SingleContinuumSkyFrequencyRenderer(String string) {
            super(string);
        }

        @Override
        String format(Object object) {
            Frequency frequency = (Frequency)((Object)object);
            return super.format(frequency == null ? null : Double.valueOf(frequency.getContentInGHz()));
        }

        @Override
        boolean toHighlight(Object object) {
            return false;
        }
    }

    private class VupRenderer
    extends SummaryTableCellRenderer {
        protected String format;
        protected String unit;
        protected boolean minorValue;
        protected ValueUnitPairParser parser = new ValueUnitPairParser();

        private VupRenderer(String string, String string2, boolean bl) {
            this.unit = string2;
            this.format = string;
            this.minorValue = bl;
        }

        private VupRenderer(String string, String string2) {
            this(string, string2, true);
        }

        @Override
        String format(Object object) {
            ValueUnitPair valueUnitPair = (ValueUnitPair)object;
            String string = valueUnitPair == null ? "" : (this.unit == null ? String.format(this.format, valueUnitPair.getContent(), valueUnitPair.getUnit()) : String.format(this.format, valueUnitPair.getContentInUnits(this.unit), this.unit));
            if (this.minorValue && valueUnitPair != null) {
                valueUnitPair = this.parser.parse(string, object.getClass());
                if (valueUnitPair == null) {
                    return string;
                }
                if (valueUnitPair.getContent() == 0.0) {
                    AbstractDoubleWithUnit abstractDoubleWithUnit = (AbstractDoubleWithUnit)object;
                    abstractDoubleWithUnit.convertToUnit(abstractDoubleWithUnit.getFriendlyUnit());
                    string = String.format(this.format, abstractDoubleWithUnit.getContent(), abstractDoubleWithUnit.getUnit());
                    return string;
                }
            }
            return string;
        }
    }

    private class UserSensitivityRenderer
    extends VupRenderer {
        private final VupRenderer temperatureRenderer;

        private UserSensitivityRenderer(String string) {
            super(string, Sensitivity.UNIT_MJY, true);
            this.temperatureRenderer = new VupRenderer(string, Temperature.UNIT_K, true);
        }

        @Override
        String format(Object object) {
            UserSensitivity userSensitivity = (UserSensitivity)object;
            if (userSensitivity == null) {
                return "null";
            }
            if (userSensitivity.inTemperatureUnit()) {
                return this.temperatureRenderer.format((Object)Temperature.createTemperature((double)userSensitivity.getUserContent(), (String)userSensitivity.getUserUnit()));
            }
            if (userSensitivity.inModelUnit()) {
                return super.format((Object)Sensitivity.createSensitivity((double)userSensitivity.getUserContent(), (String)userSensitivity.getUserUnit()));
            }
            return String.format(this.format, userSensitivity.getUserContent(), userSensitivity.getUserUnit());
        }
    }

    private class UuVupRenderer
    extends SummaryTableCellRenderer {
        protected String format;

        private UuVupRenderer(String string) {
            this.format = string;
        }

        @Override
        String format(Object object) {
            UserUnitValueUnitPair userUnitValueUnitPair = (UserUnitValueUnitPair)object;
            return userUnitValueUnitPair == null ? "null" : String.format(this.format, userUnitValueUnitPair.getUserContent(), userUnitValueUnitPair.getUserUnit());
        }
    }

    private class EquivalentValuesRenderer
    extends SummaryTableCellRenderer {
        private final VupRenderer r1;
        private final VupRenderer r2;

        private EquivalentValuesRenderer(String string, String string2, String string3, String string4) {
            this.r1 = new VupRenderer(string, string3);
            this.r2 = new VupRenderer(string2, string4);
        }

        @Override
        String format(Object object) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object == null) {
                return "";
            }
            ValueUnitPair valueUnitPair = (ValueUnitPair)object;
            return this.r1.format(valueUnitPair) + ", " + this.r2.format(valueUnitPair);
        }
    }

    private class SignificantDigitRenderer
    extends SummaryTableCellRenderer {
        private SignificantDigitRenderer() {
        }

        @Override
        String format(Object object) {
            if (object instanceof Double) {
                Double d = (Double)object;
                if (d > 0.1) {
                    return String.format("%.2f", d);
                }
                DecimalFormat decimalFormat = new DecimalFormat("0.#");
                decimalFormat.setMaximumFractionDigits(320);
                return decimalFormat.format(this.roundToSignificantFigures(d, 1));
            }
            return "";
        }

        private double roundToSignificantFigures(double d, int n) {
            if (d == 0.0) {
                return 0.0;
            }
            double d2 = Math.ceil(Math.log10(d < 0.0 ? -d : d));
            int n2 = n - (int)d2;
            double d3 = Math.pow(10.0, n2);
            long l = Math.round(d * d3);
            return (double)l / d3;
        }
    }

    private class SensitivityRenderer
    extends SummaryTableCellRenderer {
        private final String fluxFormat;
        private final String tempFormat;

        @Override
        public String format(Object object) {
            String string;
            if (!(object instanceof UserSensitivity)) {
                return "";
            }
            UserSensitivity userSensitivity = (UserSensitivity)object;
            UnitFormat unitFormat = UnitFormat.fluxDensity(this.fluxFormat);
            double d = userSensitivity.getContentInUnits(UserSensitivity.USERUNIT_JY);
            String string2 = d == 0.0 ? "" : unitFormat.format(d);
            unitFormat = UnitFormat.temperature(this.tempFormat);
            double d2 = userSensitivity.getContentInUnits(UserSensitivity.USERUNIT_K);
            String string3 = string = d2 == 0.0 ? "" : unitFormat.format(d2);
            if ("".equals(string2) || "".equals(string)) {
                if ("".equals(string2) && "".equals(string)) {
                    return "Unknown";
                }
                return string2 + string;
            }
            return string2 + ", " + string;
        }

        public SensitivityRenderer(String string, String string2) {
            this.fluxFormat = string;
            this.tempFormat = string2;
        }
    }

    private class SensitivityARRangeRenderer
    extends SummaryTableCellRenderer {
        private final String fluxFormat;
        private final String tempFormat;

        @Override
        public String format(Object object) {
            String string;
            if (!(object instanceof ArrayList)) {
                return "";
            }
            ArrayList arrayList = (ArrayList)object;
            if (arrayList.size() != 2) {
                return "";
            }
            UserSensitivity userSensitivity = (UserSensitivity)arrayList.get(0);
            UserSensitivity userSensitivity2 = (UserSensitivity)arrayList.get(1);
            UnitFormat unitFormat = UnitFormat.fluxDensity(this.fluxFormat);
            double d = userSensitivity.getContentInUnits(UserSensitivity.USERUNIT_JY);
            String string2 = d == 0.0 ? "" : unitFormat.format(d);
            unitFormat = UnitFormat.temperature(this.tempFormat);
            double d2 = userSensitivity.getContentInUnits(UserSensitivity.USERUNIT_K);
            double d3 = userSensitivity2.getContentInUnits(UserSensitivity.USERUNIT_K);
            String string3 = d2 == 0.0 ? "" : unitFormat.format(d2);
            String string4 = string = d3 == 0.0 ? "" : unitFormat.format(d3);
            if ("".equals(string2) || "".equals(string3) || "".equals(string)) {
                if ("".equals(string2) && "".equals(string3) && "".equals(string)) {
                    return "Unknown";
                }
                return string2 + string3 + string;
            }
            if (d2 == d3 || Math.abs(d2 - d3) < 1.0E-5) {
                return string2 + ", " + string3;
            }
            if (d2 > d3) {
                return string2 + ", " + string + "-" + string3;
            }
            return string2 + ", " + string3 + "-" + string;
        }

        public SensitivityARRangeRenderer(String string, String string2) {
            this.fluxFormat = string;
            this.tempFormat = string2;
        }
    }

    private class FrequencyRenderer
    extends SummaryTableCellRenderer {
        private final String velocityFormat;
        private final String frequencyFormat;

        public FrequencyRenderer(String string, String string2) {
            this.velocityFormat = string;
            this.frequencyFormat = string2;
        }

        @Override
        public String format(Object object) {
            String string;
            if (!(object instanceof UserFrequency)) {
                return "";
            }
            UserFrequency userFrequency = (UserFrequency)object;
            UnitFormat unitFormat = UnitFormat.frequency(this.frequencyFormat);
            double d = userFrequency.getContentInUnits(UserFrequency.USERUNIT_HZ);
            String string2 = d == 0.0 ? "" : unitFormat.format(d);
            unitFormat = UnitFormat.velocity(this.velocityFormat);
            double d2 = userFrequency.getContentInUnits(UserFrequency.USERUNIT_M_S);
            String string3 = string = d2 == 0.0 ? "" : unitFormat.format(d2);
            if ("".equals(string) || "".equals(string2)) {
                if ("".equals(string) && "".equals(string2)) {
                    return "Unknown";
                }
                return string + string2;
            }
            return string + ", " + string2;
        }
    }

    private class VupRangeRenderer
    extends SummaryTableCellRenderer {
        private static final long serialVersionUID = 9151721790277015531L;
        private final String format;
        private final String unit;

        public VupRangeRenderer(String string, String string2) {
            this.format = string;
            this.unit = string2;
        }

        @Override
        public String format(Object object) {
            if (!(object instanceof VupRange)) {
                return "";
            }
            VupRange vupRange = (VupRange)object;
            Object e = vupRange.min();
            Object e2 = vupRange.max();
            return String.format(this.format, e.getContentInUnits(this.unit), e2.getContentInUnits(this.unit), this.unit);
        }
    }

    private class FluxTableCellRenderer
    extends SummaryTableCellRenderer {
        private static final long serialVersionUID = -1400028282500887958L;

        private FluxTableCellRenderer() {
        }

        @Override
        public String format(Object object) {
            if (null == object) {
                return "";
            }
            if (object instanceof Flux) {
                double d = ((Flux)((Object)object)).getContentInUnits(Flux.UNIT_JY);
                return JanskyFormatter.format(d);
            }
            return "";
        }
    }

    private class SensitivityRangeRenderer
    extends SummaryTableCellRenderer {
        private static final long serialVersionUID = -1400028282500887958L;

        private SensitivityRangeRenderer() {
        }

        private String getJanskyFormattedSensitivity(Sensitivity sensitivity) {
            double d = sensitivity.getContentInUnits(Flux.UNIT_JY);
            return JanskyFormatter.format(d);
        }

        @Override
        public String format(Object object) {
            if (null == object) {
                return "";
            }
            if (object instanceof VupRange) {
                VupRange vupRange = (VupRange)object;
                Sensitivity sensitivity = (Sensitivity)((Object)vupRange.min());
                Sensitivity sensitivity2 = (Sensitivity)((Object)vupRange.max());
                return this.getJanskyFormattedSensitivity(sensitivity) + " - " + this.getJanskyFormattedSensitivity(sensitivity2);
            }
            return "";
        }
    }

    private static class JanskyFormatter {
        private JanskyFormatter() {
        }

        public static String format(double d) {
            if (d >= 1.0 && d < 1000.0) {
                return String.format("%.2f Jy", d);
            }
            if (d >= 1000.0 && d < 1000000.0) {
                return String.format("%.2f kJy", d / 1000.0);
            }
            if (d >= 1000000.0) {
                return String.format("%.2f MJy", d / 1000000.0);
            }
            if (d >= 0.001 && d < 1.0) {
                return String.format("%.2f mJy", d * 1000.0);
            }
            if (d <= 0.001) {
                return String.format("%.2f uJy", d * 1000000.0);
            }
            return String.format("%.4f Jy", d);
        }
    }

    protected abstract class AbstractHighlightValueRenderer
    extends SimpleValueRenderer {
        private final Color fgColor;

        protected AbstractHighlightValueRenderer(String string) {
            super(string);
            this.fgColor = this.getForeground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (this.toHighlight(object)) {
                this.setForeground(Colors.OT_RED);
            } else {
                this.setForeground(this.fgColor);
            }
            return component;
        }

        abstract boolean toHighlight(Object var1);
    }
}

