/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering;

import com.apporiented.algorithm.clustering.Distance;
import java.util.ArrayList;
import java.util.List;

public class Cluster {
    private String name;
    private Cluster parent;
    private List<Cluster> children;
    private Distance distance = new Distance();

    public Distance getDistance() {
        return this.distance;
    }

    public Double getWeightValue() {
        return this.distance.getWeight();
    }

    public Double getDistanceValue() {
        return this.distance.getDistance();
    }

    public void setDistance(Distance distance) {
        this.distance = distance;
    }

    public List<Cluster> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Cluster>();
        }
        return this.children;
    }

    public void setChildren(List<Cluster> list) {
        this.children = list;
    }

    public Cluster getParent() {
        return this.parent;
    }

    public void setParent(Cluster cluster) {
        this.parent = cluster;
    }

    public Cluster(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void addChild(Cluster cluster) {
        this.getChildren().add(cluster);
    }

    public boolean contains(Cluster cluster) {
        return this.getChildren().contains(cluster);
    }

    public String toString() {
        return "Cluster " + this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Cluster cluster = (Cluster)object;
        return !(this.name == null ? cluster.name != null : !this.name.equals(cluster.name));
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean isLeaf() {
        return this.getChildren().size() == 0;
    }

    public int countLeafs() {
        return this.countLeafs(this, 0);
    }

    public int countLeafs(Cluster cluster, int n) {
        if (cluster.isLeaf()) {
            ++n;
        }
        for (Cluster cluster2 : cluster.getChildren()) {
            n += cluster2.countLeafs();
        }
        return n;
    }

    public void toConsole(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        String string = this.getName() + (this.isLeaf() ? " (leaf)" : "") + (String)(this.distance != null ? "  distance: " + this.distance : "");
        System.out.println(string);
        for (Cluster cluster : this.getChildren()) {
            cluster.toConsole(n + 1);
        }
    }

    public double getTotalDistance() {
        Double d = this.getDistance() == null ? 0.0 : this.getDistance().getDistance();
        if (this.getChildren().size() > 0) {
            d = d + this.children.get(0).getTotalDistance();
        }
        return d;
    }

    public double getMaxDistance() {
        Double d = this.getDistance() == null ? 0.0 : this.getDistance().getDistance();
        if (this.getChildren().size() > 0) {
            return d > this.children.get(0).getMaxDistance() ? d.doubleValue() : this.children.get(0).getMaxDistance();
        }
        return d;
    }
}

