/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.IOException;
import uk.ac.starlink.table.RandomRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.table.storage.ColumnStore;

class ColumnStoreStarTable
extends WrapperStarTable {
    private final long nrow_;
    private final int ncol_;
    private final ColumnStore[] colStores_;

    public ColumnStoreStarTable(StarTable template, long nrow, ColumnStore[] colStores) {
        super(template);
        this.nrow_ = nrow;
        this.ncol_ = template.getColumnCount();
        this.colStores_ = colStores;
    }

    public boolean isRandom() {
        return true;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public Object getCell(long lrow, int icol) throws IOException {
        return this.colStores_[icol].readCell(lrow);
    }

    public Object[] getRow(long lrow) throws IOException {
        Object[] row = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            row[icol] = this.getCell(lrow, icol);
        }
        return row;
    }

    public RowSequence getRowSequence() throws IOException {
        return new RandomRowSequence(this);
    }
}

