/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager;

import alma.ACSErrTypeCommon.wrappers.AcsJBadParameterEx;
import alma.ACSErrTypeCommon.wrappers.AcsJNullPointerEx;
import alma.ACSErrTypeCommon.wrappers.AcsJUnexpectedExceptionEx;
import alma.acs.alarmsystem.source.AlarmSource;
import alma.acs.alarmsystem.source.AlarmSourceImpl;
import alma.acs.concurrent.DaemonThreadFactory;
import alma.acs.container.ContainerServicesBase;
import alma.acs.exceptions.AcsJException;
import alma.acs.logging.AcsLogLevel;
import alma.acs.util.ACSPorts;
import alma.acs.util.IsoDateFormat;
import alma.jmanagerErrType.wrappers.AcsJCyclicDependencyDetectedEx;
import alma.jmanagerErrType.wrappers.AcsJSyncLockFailedEx;
import alma.maciErrType.wrappers.AcsJCannotGetComponentEx;
import alma.maciErrType.wrappers.AcsJComponentSpecIncompatibleWithActiveComponentEx;
import alma.maciErrType.wrappers.AcsJIncompleteComponentSpecEx;
import alma.maciErrType.wrappers.AcsJInvalidComponentSpecEx;
import alma.maciErrType.wrappers.AcsJNoPermissionEx;
import com.cosylab.acs.maci.Administrator;
import com.cosylab.acs.maci.AuthenticationData;
import com.cosylab.acs.maci.BadParametersException;
import com.cosylab.acs.maci.Client;
import com.cosylab.acs.maci.ClientInfo;
import com.cosylab.acs.maci.Component;
import com.cosylab.acs.maci.ComponentInfo;
import com.cosylab.acs.maci.ComponentSpec;
import com.cosylab.acs.maci.ComponentStatus;
import com.cosylab.acs.maci.Container;
import com.cosylab.acs.maci.ContainerInfo;
import com.cosylab.acs.maci.CoreException;
import com.cosylab.acs.maci.Daemon;
import com.cosylab.acs.maci.HandleConstants;
import com.cosylab.acs.maci.HandleHelper;
import com.cosylab.acs.maci.ImplLang;
import com.cosylab.acs.maci.IntArray;
import com.cosylab.acs.maci.Manager;
import com.cosylab.acs.maci.MessageType;
import com.cosylab.acs.maci.NoDefaultComponentException;
import com.cosylab.acs.maci.NoResourcesException;
import com.cosylab.acs.maci.RemoteException;
import com.cosylab.acs.maci.RemoteTransientException;
import com.cosylab.acs.maci.ServiceDaemon;
import com.cosylab.acs.maci.StatusHolder;
import com.cosylab.acs.maci.SynchronousAdministrator;
import com.cosylab.acs.maci.TimeoutRemoteException;
import com.cosylab.acs.maci.Transport;
import com.cosylab.acs.maci.loadbalancing.LoadBalancingStrategy;
import com.cosylab.acs.maci.manager.CURLHelper;
import com.cosylab.acs.maci.manager.ComponentInfoTopologicalSortManager;
import com.cosylab.acs.maci.manager.HandleDataStore;
import com.cosylab.acs.maci.manager.ManagerShutdown;
import com.cosylab.acs.maci.manager.PingTimerTask;
import com.cosylab.acs.maci.manager.ProfilingReentrantLock;
import com.cosylab.acs.maci.manager.ReaderPreferenceReadWriteLock;
import com.cosylab.acs.maci.manager.TimerTaskClientInfo;
import com.cosylab.acs.maci.manager.TimerTaskContainerInfo;
import com.cosylab.acs.maci.manager.app.ManagerContainerServices;
import com.cosylab.acs.maci.manager.recovery.AdministratorCommandAllocate;
import com.cosylab.acs.maci.manager.recovery.AdministratorCommandDeallocate;
import com.cosylab.acs.maci.manager.recovery.AdministratorCommandSet;
import com.cosylab.acs.maci.manager.recovery.AlarmCleared;
import com.cosylab.acs.maci.manager.recovery.AlarmRaised;
import com.cosylab.acs.maci.manager.recovery.ClientCommandAllocate;
import com.cosylab.acs.maci.manager.recovery.ClientCommandDeallocate;
import com.cosylab.acs.maci.manager.recovery.ClientCommandSet;
import com.cosylab.acs.maci.manager.recovery.ClientInfoCommandComponentAdd;
import com.cosylab.acs.maci.manager.recovery.ClientInfoCommandComponentRemove;
import com.cosylab.acs.maci.manager.recovery.ComponentCommandAckAlloc;
import com.cosylab.acs.maci.manager.recovery.ComponentCommandAllocate;
import com.cosylab.acs.maci.manager.recovery.ComponentCommandAllocateHandle;
import com.cosylab.acs.maci.manager.recovery.ComponentCommandClientAdd;
import com.cosylab.acs.maci.manager.recovery.ComponentCommandClientRemove;
import com.cosylab.acs.maci.manager.recovery.ComponentCommandDeallocate;
import com.cosylab.acs.maci.manager.recovery.ComponentCommandPreallocate;
import com.cosylab.acs.maci.manager.recovery.ComponentCommandSet;
import com.cosylab.acs.maci.manager.recovery.ComponentInfoCommandComponentAdd;
import com.cosylab.acs.maci.manager.recovery.ComponentInfoCommandComponentRemove;
import com.cosylab.acs.maci.manager.recovery.ContainerCommandAllocate;
import com.cosylab.acs.maci.manager.recovery.ContainerCommandDeallocate;
import com.cosylab.acs.maci.manager.recovery.ContainerCommandSet;
import com.cosylab.acs.maci.manager.recovery.ContainerCommandUpdate;
import com.cosylab.acs.maci.manager.recovery.ContainerInfoCommandComponentAdd;
import com.cosylab.acs.maci.manager.recovery.ContainerInfoCommandComponentRemove;
import com.cosylab.acs.maci.manager.recovery.DefaultComponentCommandPut;
import com.cosylab.acs.maci.manager.recovery.UnavailableComponentCommandPut;
import com.cosylab.acs.maci.manager.recovery.UnavailableComponentCommandRemove;
import com.cosylab.acs.maci.plug.ManagerProxy;
import com.cosylab.cdb.client.CDBAccess;
import com.cosylab.cdb.client.DAOProxy;
import com.cosylab.cdb.client.DAOProxyConnectionListener;
import com.cosylab.util.WildcharMatcher;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.omg.CORBA.IntHolder;
import org.prevayler.Prevayler;
import org.prevayler.TransactionWithQuery;

public class ManagerImpl
implements Manager,
HandleConstants,
Serializable {
    private static final long serialVersionUID = 1372046383416324709L;
    private transient Map<Object, GroupedNotifyTask> groupedNotifyTaskMap;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("domain", String.class), new ObjectStreamField("handle", Integer.TYPE), new ObjectStreamField("clients", HandleDataStore.class), new ObjectStreamField("administrators", HandleDataStore.class), new ObjectStreamField("containers", HandleDataStore.class), new ObjectStreamField("components", HandleDataStore.class), new ObjectStreamField("releasedHandles", Map.class), new ObjectStreamField("unavailableComponents", Map.class), new ObjectStreamField("defaultComponents", Map.class), new ObjectStreamField("domains", HashSet.class), new ObjectStreamField("activeAlarms", HashSet.class), new ObjectStreamField("statePersitenceFlag", AtomicBoolean.class)};
    private static final int INTERDOMAIN_MANAGER_HANDLE = 0x5555555;
    private String domain = "";
    private int handle = 0x5000000;
    private HandleDataStore clients = new HandleDataStore(16, 65535);
    private HandleDataStore administrators = new HandleDataStore(16, 65535);
    private HandleDataStore containers = new HandleDataStore(32, 65535);
    private HandleDataStore components = new HandleDataStore(128, 65535);
    private transient Lock componentsLock = null;
    private Map<Integer, HandleMonitorEntry> releasedHandles = new HashMap<Integer, HandleMonitorEntry>();
    private Map<String, ComponentInfo> unavailableComponents = new LinkedHashMap<String, ComponentInfo>();
    private transient Map<String, ComponentInfo> pendingActivations = null;
    private transient Set<String> pendingContainerShutdown = null;
    private transient Map<String, Deque<Container.ComponentInfoCompletionCallback>> pendingContainerAsyncRequests = null;
    private transient Object containerLoggedInMonitor = null;
    private Map<String, ComponentInfo> defaultComponents = new HashMap<String, ComponentInfo>();
    private transient Random random = null;
    private transient Timer heartbeatTask = null;
    private transient Timer delayedDeactivationTask = null;
    private transient Context remoteDirectory = null;
    private transient Object managerComponentReference = null;
    private transient Object remoteDirectoryComponentReference = null;
    private transient Map<String, ReferenceCountingLock> activationSynchronization;
    private transient ReaderPreferenceReadWriteLock activationPendingRWLock;
    private transient AtomicBoolean shutdown;
    private transient ThreadPoolExecutor threadPool;
    private static final String DEFAULT_DOMAIN = "";
    private transient int poolThreads;
    private transient long lockTimeout;
    private transient int clientPingInterval;
    private transient int administratorPingInterval;
    private transient int containerPingInterval;
    private static final int CONTAINER_RIGHTS = 0;
    private transient ManagerShutdown shutdownImplementation = null;
    private transient CDBAccess cdbAccess = null;
    private transient DAOProxy managerDAO = null;
    private transient DAOProxy componentsDAO = null;
    private transient DAOProxy containersDAO = null;
    private transient String[] componentListCache = null;
    private static final String NAME_CDB_COMPONENTSPEC = "ACS.CDBComponentSpec";
    private transient ComponentSpec cdbActivation = null;
    private static final String NAME_LOAD_BALANCING_STRATEGY = "ACS.LoadBalancingStrategy";
    private transient LoadBalancingStrategy loadBalancingStrategy = null;
    private static final String NAME_CDB_DISABLE = "ACS.disableCDB";
    private static final String NAME_HANDLE_MONITORING = "manager.debug.rememberOldHandles";
    private static final String NAME_HANDLE_MONITORING_TIME = "manager.debug.rememberOldHandlesStoreDurationMin";
    private static final int HANDLE_MONITORING_TIME_MIN = 120;
    private transient boolean enableHandleMonitoring;
    private transient int enableHandleMonitoringDurationMins = 120;
    private static final String CURL_URI_SCHEMA = "curl://";
    private static final String NAME_DOMAIN_LIST = "ACS.domains";
    private static final String NAME_DOMAIN_DIRECTORY = "ACS.federationDirectory";
    private transient boolean federationEnabled = false;
    private transient Context federationDirectory = null;
    private HashSet domains = new HashSet();
    private transient Map<String, Manager> managerCache = null;
    private transient Prevayler prevayler = null;
    private transient Transport transport = null;
    private transient ComponentInfoTopologicalSortManager topologySortManager;
    private transient Logger logger;
    private transient AlarmSource alarmSource;
    private HashSet activeAlarms = new HashSet();
    private transient long lastExecutionId = 0L;
    protected transient Map<Client, LinkedList<ClientMessageTask>> clientMessageQueue;
    private transient AtomicInteger threadsUsedPercentage;
    private static final String NAME_SYNC_ACTIVATE = "manager.sync_activate";
    public static final String STATE_PERSISTENCE_DEFAULT = "manager.statePersistance";
    private AtomicBoolean statePersitenceFlag = new AtomicBoolean(Boolean.getBoolean("manager.statePersistance"));
    private volatile int originalId = 0x5000000;
    private volatile int originalContainers = 0;
    protected static final String FAULT_FAMILY = "Manager";
    protected static final String FAULT_MEMBER = "Prevayler";
    protected static final int FAULT_CODE = 2;

    private void reportException(Throwable th) {
        this.logger.log(Level.SEVERE, th.getMessage(), th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerGroupedNotifyTaks(Object key, GroupedRunnable runnable) {
        Map<Object, GroupedNotifyTask> map = this.groupedNotifyTaskMap;
        synchronized (map) {
            GroupedNotifyTask gnt = this.groupedNotifyTaskMap.get(key);
            if (gnt == null) {
                gnt = new GroupedNotifyTask(key, runnable);
                this.groupedNotifyTaskMap.put(key, gnt);
                this.threadPool.execute(gnt);
            } else {
                gnt.addTask(runnable);
            }
        }
    }

    public void setConnectionThreadUsage(int percentage) {
        this.threadsUsedPercentage.set(percentage);
    }

    public void initialize(Prevayler prevayler, CDBAccess cdbAccess, Context context, final Logger logger, ManagerContainerServices managerContainerServices) {
        this.prevayler = prevayler;
        this.remoteDirectory = context;
        this.logger = logger;
        this.initializeDefaultConfiguration();
        if (cdbAccess != null) {
            this.setCDBAccess(cdbAccess);
        }
        this.readManagerConfiguration();
        this.componentsLock = ProfilingReentrantLock.isProfilingEnabled ? new ProfilingReentrantLock("componentsLock") : new ReentrantLock();
        this.random = new Random();
        this.heartbeatTask = new Timer(true);
        this.delayedDeactivationTask = new Timer(true);
        this.containerLoggedInMonitor = new Object();
        this.activationSynchronization = new HashMap<String, ReferenceCountingLock>();
        this.activationPendingRWLock = new ReaderPreferenceReadWriteLock();
        this.shutdown = new AtomicBoolean(false);
        this.threadPool = new ThreadPoolExecutor(this.poolThreads, this.poolThreads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DaemonThreadFactory("managerThreadPool"));
        this.managerCache = new HashMap<String, Manager>();
        this.pendingActivations = new HashMap<String, ComponentInfo>();
        this.pendingContainerShutdown = Collections.synchronizedSet(new HashSet());
        this.pendingContainerAsyncRequests = new HashMap<String, Deque<Container.ComponentInfoCompletionCallback>>();
        this.clientMessageQueue = new HashMap<Client, LinkedList<ClientMessageTask>>();
        this.groupedNotifyTaskMap = new HashMap<Object, GroupedNotifyTask>();
        this.threadsUsedPercentage = new AtomicInteger(0);
        this.threadPool.prestartAllCoreThreads();
        try {
            String componentSpec = System.getProperty(NAME_CDB_COMPONENTSPEC);
            if (componentSpec != null) {
                this.cdbActivation = new ComponentSpec(componentSpec);
                logger.log(Level.INFO, "Using CDB component specification: '" + this.cdbActivation + "'.");
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Failed to parse 'ACS.CDBComponentSpec' variable, " + t.getMessage(), t);
        }
        this.checkLoadBalancingStrategy();
        try {
            this.alarmSource = new AlarmSourceImpl((ContainerServicesBase)managerContainerServices);
            this.alarmSource.start();
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Failed to initialize Alarm System Interface " + ex.getMessage(), ex);
            this.alarmSource = null;
        }
        this.initializePingTasks();
        final long timeInMs = (long)this.enableHandleMonitoringDurationMins * 60L * 1000L;
        if (this.enableHandleMonitoring && this.enableHandleMonitoringDurationMins > 0) {
            this.heartbeatTask.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        ManagerImpl.this.logHandleCleanup(timeInMs);
                    }
                    catch (Throwable th) {
                        logger.log(Level.SEVERE, "Unexpected exception in handle log cleanup task.", th);
                    }
                }
            }, 0L, timeInMs);
        }
        this.topologySortManager = new ComponentInfoTopologicalSortManager(this.components, this.containers, this.activationPendingRWLock, this.pendingContainerShutdown, this.threadPool, logger);
        if (prevayler == null) {
            this.statePersitenceFlag.set(false);
        }
        String enDis = this.statePersitenceFlag.get() ? "enabled" : "disabled";
        logger.info("Manager initialized with state persistence " + enDis + ".");
    }

    private void initializeDefaultConfiguration() {
        this.poolThreads = 10;
        this.lockTimeout = 600000L;
        this.clientPingInterval = 60000;
        this.administratorPingInterval = 45000;
        this.containerPingInterval = 30000;
    }

    private void initializePingTasks() {
        PingTimerTask task;
        TimerTaskContainerInfo containerInfo = null;
        int h = this.containers.first();
        while (h != 0) {
            containerInfo = (TimerTaskContainerInfo)this.containers.get(h);
            h = this.containers.next(h);
            ClientInfo clientInfo = containerInfo.createClientInfo();
            task = new PingTimerTask(this, this.logger, clientInfo, this.alarmSource);
            containerInfo.setTask(task);
            this.heartbeatTask.schedule((TimerTask)task, 0L, containerInfo.getPingInterval());
        }
        TimerTaskClientInfo adminInfo = null;
        h = this.administrators.first();
        while (h != 0) {
            adminInfo = (TimerTaskClientInfo)this.administrators.get(h);
            h = this.administrators.next(h);
            task = new PingTimerTask(this, this.logger, adminInfo, null);
            adminInfo.setTask(task);
            this.heartbeatTask.schedule((TimerTask)task, 0L, (long)this.administratorPingInterval);
        }
        TimerTaskClientInfo clientInfo = null;
        h = this.clients.first();
        while (h != 0) {
            clientInfo = (TimerTaskClientInfo)this.clients.get(h);
            h = this.clients.next(h);
            PingTimerTask task2 = new PingTimerTask(this, this.logger, clientInfo, null);
            clientInfo.setTask(task2);
            this.heartbeatTask.schedule((TimerTask)task2, 0L, (long)this.clientPingInterval);
        }
    }

    private void checkLoadBalancingStrategy() {
        try {
            String loadBalancingStrategyClassName = System.getProperty(NAME_LOAD_BALANCING_STRATEGY);
            if (loadBalancingStrategyClassName != null) {
                Class<?> strategyClass = Class.forName(loadBalancingStrategyClassName);
                Constructor<?> constructor = strategyClass.getConstructor(null);
                if (constructor == null) {
                    throw new IllegalArgumentException("Class '" + strategyClass.getName() + "' does have required default constructor.");
                }
                Object strategyObject = constructor.newInstance(null);
                if (!(strategyObject instanceof LoadBalancingStrategy)) {
                    throw new IllegalArgumentException("Class '" + strategyClass.getName() + "' does not implement '" + LoadBalancingStrategy.class.getName() + "' interface.");
                }
                this.loadBalancingStrategy = (LoadBalancingStrategy)strategyObject;
                this.logger.log(Level.INFO, "Using load balancing strategy: '" + strategyClass.getName() + "'.");
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "Failed to register 'ACS.LoadBalancingStrategy' load balancing strategy: " + t.getMessage(), t);
        }
    }

    public void initializationDone() {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                ManagerImpl.this.initializeServiceDaemons();
                ManagerImpl.this.autoStartComponents();
            }
        });
    }

    public int getHandle() {
        return this.handle;
    }

    public void setDomain(String domain) {
        assert (domain != null);
        this.domain = domain;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    protected synchronized long generateExecutionId() {
        long id;
        this.lastExecutionId = id = Math.max(System.currentTimeMillis(), this.lastExecutionId + 1L);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerInfo[] getContainerInfo(int id, int[] handles, String name_wc) throws AcsJNoPermissionEx {
        if (handles == null) {
            BadParametersException af = new BadParametersException("Non-null 'handles' sequence expected.");
            throw af;
        }
        if (handles.length == 0 && name_wc == null) {
            BadParametersException af = new BadParametersException("Non-null 'names_wc' sequence expected.");
            throw af;
        }
        ContainerInfo[] info = null;
        if (handles.length == 1 && handles[0] == id) {
            this.securityCheck(id, 0);
            info = new ContainerInfo[]{this.getContainerInfo(id)};
        } else if (handles.length > 0) {
            this.securityCheck(id, 0x8000000);
            info = new ContainerInfo[handles.length];
            for (int i = 0; i < handles.length; ++i) {
                info[i] = this.getContainerInfo(handles[i]);
            }
        } else {
            this.securityCheck(id, 0x8000000);
            ArrayList<ContainerInfo> list = new ArrayList<ContainerInfo>();
            HandleDataStore handleDataStore = this.containers;
            synchronized (handleDataStore) {
                int h = this.containers.first();
                while (h != 0) {
                    ContainerInfo containerInfo = (ContainerInfo)this.containers.get(h);
                    if (WildcharMatcher.match((String)name_wc, (String)containerInfo.getName())) {
                        list.add(containerInfo);
                    }
                    h = this.containers.next(h);
                }
            }
            info = new ContainerInfo[list.size()];
            list.toArray(info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientInfo[] getClientInfo(int id, int[] handles, String name_wc) throws AcsJNoPermissionEx {
        if (handles == null) {
            BadParametersException af = new BadParametersException("Non-null 'handles' sequence expected.");
            throw af;
        }
        if (handles.length == 0 && name_wc == null) {
            BadParametersException af = new BadParametersException("Non-null 'names_wc' sequence expected.");
            throw af;
        }
        ClientInfo[] info = null;
        if (handles.length == 1 && handles[0] == id) {
            this.securityCheck(id, 0);
            info = new ClientInfo[]{this.getClientInfo(id)};
        } else if (handles.length > 0) {
            this.securityCheck(id, 0x8000000);
            info = new ClientInfo[handles.length];
            for (int i = 0; i < handles.length; ++i) {
                info[i] = this.getClientInfo(handles[i]);
            }
        } else {
            ClientInfo clientInfo;
            int h;
            this.securityCheck(id, 0x8000000);
            ArrayList<ClientInfo> list = new ArrayList<ClientInfo>();
            HandleDataStore handleDataStore = this.clients;
            synchronized (handleDataStore) {
                h = this.clients.first();
                while (h != 0) {
                    clientInfo = (ClientInfo)this.clients.get(h);
                    if (WildcharMatcher.match((String)name_wc, (String)clientInfo.getName())) {
                        list.add(clientInfo);
                    }
                    h = this.clients.next(h);
                }
            }
            handleDataStore = this.administrators;
            synchronized (handleDataStore) {
                h = this.administrators.first();
                while (h != 0) {
                    clientInfo = (ClientInfo)this.administrators.get(h);
                    if (WildcharMatcher.match((String)name_wc, (String)clientInfo.getName())) {
                        list.add(clientInfo);
                    }
                    h = this.administrators.next(h);
                }
            }
            info = new ClientInfo[list.size()];
            list.toArray(info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentInfo[] getComponentInfo(int id, int[] handles, String name_wc, String type_wc, boolean activeOnly) throws AcsJNoPermissionEx {
        if (handles == null) {
            BadParametersException af = new BadParametersException("Non-null 'handles' sequence expected.");
            throw af;
        }
        if (handles.length == 0 && (name_wc == null || type_wc == null)) {
            BadParametersException af = new BadParametersException("Non-null 'names_wc' or' type_wc' sequence expected.");
            throw af;
        }
        this.securityCheck(id, 0);
        ComponentInfo[] info = null;
        if (handles.length > 0) {
            info = new ComponentInfo[handles.length];
            for (int i = 0; i < handles.length; ++i) {
                info[i] = this.getComponentInfo(handles[i]);
                if (info[i] == null || info[i].getComponent() != null) continue;
                info[i] = null;
            }
        } else {
            DAOProxy componentsDAO;
            if (name_wc.startsWith(CURL_URI_SCHEMA)) {
                URI curl = null;
                try {
                    curl = CURLHelper.createURI(name_wc);
                    if (curl.getAuthority() != null && curl.getAuthority().indexOf(42) >= 0) {
                        throw new IllegalArgumentException("Wildchars not supported in domain names.");
                    }
                }
                catch (URISyntaxException e) {
                    BadParametersException af = new BadParametersException("Invalid CURL syntax in 'names_wc'.");
                    throw af;
                }
                name_wc = this.extractName(curl);
                Manager remoteManager = null;
                if (name_wc.startsWith(CURL_URI_SCHEMA)) {
                    try {
                        String domainName = curl.getAuthority();
                        remoteManager = this.getManagerForDomain(domainName);
                        if (remoteManager == null) {
                            throw new CoreException("Failed to obtain manager for domain '" + domainName + "'.");
                        }
                    }
                    catch (Throwable th) {
                        this.logger.log(Level.WARNING, "Failed to obtain non-local manager required by CURL '" + curl + "'.", th);
                        return null;
                    }
                }
                try {
                    ComponentInfo[] infos;
                    String localName = curl.getPath();
                    if (localName.charAt(0) == '/') {
                        localName = localName.substring(1);
                    }
                    if ((infos = remoteManager.getComponentInfo(0x5555555, handles, localName, type_wc, false)) != null) {
                        String prefix = CURL_URI_SCHEMA + curl.getAuthority() + "/";
                        for (int i = 0; i < infos.length; ++i) {
                            String containerName;
                            if (!infos[i].getName().startsWith(CURL_URI_SCHEMA)) {
                                infos[i].setName(prefix + infos[i].getName());
                            }
                            if ((containerName = infos[i].getContainerName()) == null || containerName.startsWith(CURL_URI_SCHEMA)) continue;
                            infos[i].setContainerName(prefix + containerName);
                        }
                    }
                    return infos;
                }
                catch (Exception ex) {
                    RemoteException re = new RemoteException("Failed to obtain component infos for CURL '" + curl + "' from remote manager.", ex);
                    this.reportException(re);
                    return null;
                }
            }
            HashMap<String, ComponentInfo> map = new HashMap<String, ComponentInfo>();
            this.componentsLock.lock();
            try {
                int h = this.components.first();
                while (h != 0) {
                    ComponentInfo componentInfo = (ComponentInfo)this.components.get(h);
                    if (componentInfo.getComponent() != null && WildcharMatcher.match((String)name_wc, (String)componentInfo.getName()) && WildcharMatcher.match((String)type_wc, (String)componentInfo.getType())) {
                        map.put(componentInfo.getName(), componentInfo);
                    }
                    h = this.components.next(h);
                }
            }
            finally {
                this.componentsLock.unlock();
            }
            if (!activeOnly && (componentsDAO = this.getComponentsDAOProxy()) != null) {
                try {
                    componentsDAO.get_field_data(DEFAULT_DOMAIN);
                    String[] ids = this.getComponentsList();
                    for (int i = 0; i < ids.length; ++i) {
                        String name = ids[i];
                        if (name == null) {
                            this.logger.log(Level.WARNING, "Misconfigured CDB, there is no name of component '" + ids[i] + "' defined.");
                            continue;
                        }
                        if (map.containsKey(name) || name.indexOf("*") == 0 || !WildcharMatcher.match((String)name_wc, (String)name)) continue;
                        String type = this.readStringCharacteristics(componentsDAO, ids[i] + "/Type");
                        if (type == null) {
                            this.logger.log(Level.WARNING, "Misconfigured CDB, there is no type of component '" + name + "' defined.");
                            continue;
                        }
                        if (type.equals("*") || !WildcharMatcher.match((String)type_wc, (String)type)) continue;
                        String code = this.readStringCharacteristics(componentsDAO, ids[i] + "/Code");
                        if (code == null) {
                            this.logger.log(Level.WARNING, "Misconfigured CDB, there is no code of component '" + name + "' defined.");
                            continue;
                        }
                        if (code.equals("*")) continue;
                        String container = this.readStringCharacteristics(componentsDAO, ids[i] + "/Container");
                        if (container == null) {
                            this.logger.log(Level.WARNING, "Misconfigured CDB, there is no container name of component '" + name + "' defined.");
                            continue;
                        }
                        if (container.equals("*")) continue;
                        ComponentInfo retInfo = new ComponentInfo(0, name, type, code, null);
                        retInfo.setContainerName(container);
                        map.put(name, retInfo);
                    }
                }
                catch (Exception ex) {
                    CoreException ce = new CoreException("Failed to obtain component data from the CDB.", ex);
                    this.reportException(ce);
                }
            }
            info = new ComponentInfo[map.size()];
            map.values().toArray(info);
        }
        return info;
    }

    @Override
    public Component getService(int id, URI curl, boolean activate, StatusHolder status) throws AcsJCannotGetComponentEx, AcsJNoPermissionEx {
        return this.getComponent(id, curl, activate, status, true);
    }

    @Override
    public Component getComponent(int id, URI curl, boolean activate, StatusHolder status) throws AcsJCannotGetComponentEx, AcsJNoPermissionEx {
        return this.getComponent(id, curl, activate, status, false);
    }

    private Component getComponent(int id, URI curl, boolean activate, StatusHolder status, boolean allowServices) throws AcsJCannotGetComponentEx, AcsJNoPermissionEx {
        AcsJCannotGetComponentEx ex2 = null;
        String name = this.extractName(curl);
        try {
            this.checkCURL(curl);
        }
        catch (AcsJBadParameterEx e) {
            e.setParameter("curl");
            ex2 = new AcsJCannotGetComponentEx((Throwable)e);
            ex2.setCURL(name);
            throw ex2;
        }
        if (status == null) {
            AcsJNullPointerEx ex = new AcsJNullPointerEx();
            ex.setVariable("status");
            ex2 = new AcsJCannotGetComponentEx((Throwable)ex);
            ex2.setCURL(name);
            throw ex2;
        }
        String requestorName = null;
        if (id != 0) {
            requestorName = this.getRequestorName(id);
            this.logger.log(Level.INFO, "'" + requestorName + "' requested component '" + curl + "'.");
        } else {
            this.logger.log(Level.INFO, "Request for component '" + curl + "' issued.");
        }
        Component component = null;
        if (allowServices && name.equals(FAULT_FAMILY)) {
            if (this.managerComponentReference != null) {
                status.setStatus(ComponentStatus.COMPONENT_ACTIVATED);
            } else {
                status.setStatus(ComponentStatus.COMPONENT_DOES_NO_EXIST);
            }
            component = new ServiceComponent(this.managerComponentReference);
        } else if (allowServices && name.equals("NameService")) {
            if (this.remoteDirectoryComponentReference != null) {
                status.setStatus(ComponentStatus.COMPONENT_ACTIVATED);
            } else {
                status.setStatus(ComponentStatus.COMPONENT_DOES_NO_EXIST);
            }
            component = new ServiceComponent(this.remoteDirectoryComponentReference);
        } else if (allowServices && !name.startsWith(CURL_URI_SCHEMA) && this.isServiceComponent(name)) {
            Object obj = this.lookup(name, null);
            if (obj != null) {
                status.setStatus(ComponentStatus.COMPONENT_ACTIVATED);
            } else {
                status.setStatus(ComponentStatus.COMPONENT_DOES_NO_EXIST);
            }
            component = new ServiceComponent(obj);
        } else {
            this.securityCheck(id, 0);
            try {
                component = this.internalRequestComponent(id, curl, status, activate);
            }
            catch (Throwable ce) {
                ex2 = new AcsJCannotGetComponentEx(ce);
            }
        }
        if (component != null && component.getObject() != null) {
            if (requestorName != null) {
                this.logger.log(Level.INFO, "Component '" + curl + "' provided to '" + requestorName + "'.");
            } else {
                this.logger.log(Level.INFO, "Component '" + curl + "' provided.");
            }
        } else if (ex2 == null && !activate && status.getStatus() == ComponentStatus.COMPONENT_NOT_ACTIVATED) {
            if (requestorName != null) {
                this.logger.log(Level.INFO, "Request from '" + requestorName + "' for component '" + curl + "' completed sucessfully, but component not activated.");
            } else {
                this.logger.log(Level.INFO, "Request for component '" + curl + "' completed sucessfully, but component not activated.");
            }
        } else {
            if (ex2 == null) {
                ex2 = new AcsJCannotGetComponentEx();
            }
            if (requestorName != null) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.WARNING, "Failed to provide component '" + curl + "' to '" + requestorName + "'.", (Throwable)ex2);
                } else {
                    this.logger.log(Level.WARNING, "Failed to provide component '" + curl + "' to '" + requestorName + "'.");
                }
            } else if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.WARNING, "Failed to provide component '" + curl + "'.", (Throwable)ex2);
            } else {
                this.logger.log(Level.FINE, "Failed to provide component '" + curl + "'.");
            }
        }
        if (ex2 != null) {
            ex2.setCURL(name);
            throw ex2;
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component getComponentNonSticky(int id, URI curl) throws AcsJCannotGetComponentEx, AcsJNoPermissionEx {
        String name = this.extractName(curl);
        try {
            this.checkCURL(curl);
        }
        catch (AcsJBadParameterEx e) {
            AcsJCannotGetComponentEx ex2 = new AcsJCannotGetComponentEx((Throwable)e);
            ex2.setCURL(name);
            throw ex2;
        }
        this.securityCheck(id, 0);
        String requestorName = this.getRequestorName(id);
        this.logger.log(Level.FINE, "'" + requestorName + "' requested non-sticky component '" + curl + "'.");
        Component component = null;
        this.componentsLock.lock();
        try {
            int h = this.components.first();
            while (h != 0) {
                ComponentInfo ci = (ComponentInfo)this.components.get(h);
                if (ci.getName().equals(name)) {
                    component = ci.getComponent();
                    break;
                }
                h = this.components.next(h);
            }
        }
        finally {
            this.componentsLock.unlock();
        }
        if (component != null && component.getObject() != null) {
            this.logger.log(Level.FINE, "Non-sticky component '" + curl + "' provided to '" + requestorName + "'.");
        } else {
            this.logger.log(Level.INFO, "Failed to provide non-sticky component '" + curl + "' to '" + requestorName + "'.");
        }
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeComponentImmortal(int id, URI curl, boolean immortalState) throws AcsJCannotGetComponentEx, AcsJNoPermissionEx, AcsJBadParameterEx {
        int h;
        String name = this.extractName(curl);
        this.checkCURL(curl);
        this.securityCheck(id, 0);
        ComponentInfo componentInfo = null;
        this.componentsLock.lock();
        try {
            h = this.components.first();
            while (h != 0) {
                componentInfo = (ComponentInfo)this.components.get(h);
                if (componentInfo.getName().equals(name)) {
                    h = componentInfo.getHandle();
                    break;
                }
                h = this.components.next(h);
            }
            if (h == 0) {
                NoResourcesException af = new NoResourcesException("Component not activated.");
                throw af;
            }
            if (!componentInfo.getClients().contains(id)) {
                this.securityCheck(id, 0x8000000);
            }
            if (immortalState) {
                if (!componentInfo.getClients().contains(this.getHandle())) {
                    this.executeCommand(new ComponentCommandClientAdd(componentInfo.getHandle() & 0xFFFF, this.getHandle()));
                }
                this.logger.log(Level.INFO, "Component " + name + " was made immortal.");
            }
        }
        finally {
            this.componentsLock.unlock();
        }
        if (!immortalState) {
            this.logger.log(Level.INFO, "Component " + name + " was made mortal.");
            this.internalReleaseComponent(this.getHandle(), h, false);
        }
    }

    @Override
    public ClientInfo login(Client reference) throws AcsJNoPermissionEx {
        if (this.shutdown.get()) {
            AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
            npe.setReason("Manager in shutdown state.");
            throw npe;
        }
        if (reference == null) {
            BadParametersException af = new BadParametersException("Non-null 'reference' expected.");
            throw af;
        }
        ClientInfo info = null;
        try {
            long timeStamp;
            long executionId = this.generateExecutionId();
            AuthenticationData reply = null;
            try {
                reply = reference.authenticate(executionId, "Identify yourself");
            }
            catch (RemoteException re) {
                this.logger.log(Level.WARNING, "Communication problem with Client::authenticate() - Retrying once for ICT-18617.", re);
                reply = reference.authenticate(executionId, "Identify yourself");
            }
            if (reply == null) {
                BadParametersException af = new BadParametersException("Invalid response to 'Client::authenticate()' method - non-null structure expected.");
                throw af;
            }
            if (reply.getClientType() == null) {
                BadParametersException af = new BadParametersException("Invalid response to 'Client::authenticate()' method - non-null client type expected.");
                throw af;
            }
            if (reply.getImplLang() == null) {
                BadParametersException af = new BadParametersException("Invalid response to 'Client::authenticate()' method - no-null implementation language expected.");
                throw af;
            }
            String name = reference.name();
            if (name == null) {
                BadParametersException af = new BadParametersException("Invalid response to 'Client::name()' method - non-null string expected.");
                throw af;
            }
            this.logger.log(Level.FINE, "'" + name + "' is logging in.");
            long l = timeStamp = reply.getTimeStamp() > 0L ? reply.getTimeStamp() : System.currentTimeMillis();
            if (reply.getExecutionId() != 0L) {
                executionId = this.generateExecutionId();
            }
            switch (reply.getClientType()) {
                case CONTAINER: {
                    if (reference instanceof Container) {
                        info = this.containerLogin(name, reply, (Container)reference, timeStamp, executionId);
                        break;
                    }
                    AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
                    npe.setReason("Given reply to 'Client::authenticate()' method indicated container login, but given reference does not implement 'maci::Container' interface.");
                    npe.setID(name);
                    throw npe;
                }
                case CLIENT: {
                    info = this.clientLogin(name, reply, reference, timeStamp, executionId);
                    break;
                }
                case ADMINISTRATOR: {
                    if (reference instanceof Administrator) {
                        info = this.administratorLogin(name, reply, (Administrator)reference, timeStamp, executionId);
                        break;
                    }
                    AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
                    npe.setReason("Given reply to 'Client::authenticate()' method indicated administrator login, but given reference does not implement 'maci::Administrator' interface.");
                    npe.setID(name);
                    throw npe;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        catch (AcsJNoPermissionEx npe) {
            throw npe;
        }
        catch (BadParametersException bpe) {
            throw bpe;
        }
        catch (NoResourcesException nre) {
            throw nre;
        }
        catch (RemoteException re) {
            RuntimeException rt = new RuntimeException("Exception caught while examining the client. Login rejected.", re);
            throw rt;
        }
        catch (Throwable ex) {
            RuntimeException rt = new RuntimeException("Unexpected exception during login. Login rejected.", ex);
            throw rt;
        }
        this.logger.log(Level.FINE, "Client with handle '" + HandleHelper.toString(info.getHandle()) + "' has logged in.");
        return info;
    }

    @Override
    public void logout(int id) throws AcsJNoPermissionEx {
        if (this.isShuttingDown()) {
            this.logger.log(Level.FINE, "Logout " + HandleHelper.toString(id) + " skipped because the Manager is shutting down");
            return;
        }
        this.logout(id, false);
    }

    public void logout(int id, boolean pingFailed) throws AcsJNoPermissionEx {
        if (pingFailed) {
            this.logger.log(Level.FINE, "Client with handle '" + HandleHelper.toString(id) + "' is being forcefully logged out due to its unresponsiveness.");
        } else {
            this.logger.log(Level.FINE, "Client with handle '" + HandleHelper.toString(id) + "' is logging out.");
        }
        this.securityCheck(id, 0);
        switch (id & 0xFF000000) {
            case 0x4000000: {
                this.containerLogout(id, pingFailed);
                break;
            }
            case 0x2000000: {
                this.clientLogout(id, pingFailed);
                break;
            }
            case 0x3000000: {
                this.administratorLogout(id, pingFailed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerComponent(int id, URI curl, String type, Component component) throws AcsJNoPermissionEx, AcsJBadParameterEx {
        if (curl == null) {
            AcsJBadParameterEx af = new AcsJBadParameterEx();
            af.setParameter("curl");
            af.setParameterValue("null");
            throw af;
        }
        if (type == null) {
            AcsJBadParameterEx af = new AcsJBadParameterEx();
            af.setParameter("type");
            af.setParameterValue("null");
            throw af;
        }
        if (component == null) {
            AcsJBadParameterEx af = new AcsJBadParameterEx();
            af.setParameter("component");
            af.setParameterValue("null");
            throw af;
        }
        this.checkCURL(curl, false);
        this.securityCheck(id, 0x2000000);
        String name = this.extractName(curl);
        int h = 0;
        this.componentsLock.lock();
        try {
            int handle;
            h = this.components.first();
            while (h != 0) {
                ComponentInfo registeredComponentInfo = (ComponentInfo)this.components.get(h);
                if (registeredComponentInfo.getName().equals(name)) {
                    if (registeredComponentInfo.getType().equals(type)) {
                        if (!registeredComponentInfo.getClients().contains(this.getHandle())) {
                            this.executeCommand(new ComponentCommandClientAdd(registeredComponentInfo.getHandle() & 0xFFFF, this.getHandle()));
                        }
                        int n = registeredComponentInfo.getHandle();
                        return n;
                    }
                    AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
                    npe.setReason("Component with name '" + name + "' but different type already registered.");
                    npe.setID(HandleHelper.toString(id));
                    npe.setProtectedResource(name);
                    throw npe;
                }
                h = this.components.next(h);
            }
            Integer objHandle = (Integer)this.executeCommand(new ComponentCommandAllocate());
            if (objHandle == null || (handle = objHandle.intValue()) == 0) {
                NoResourcesException af = new NoResourcesException("Generation of new handle failed, too many components registred.");
                throw af;
            }
            h = handle | 0x1000000;
            ComponentInfo componentInfo = new ComponentInfo(h |= this.random.nextInt(256) << 16, name, type, null, component);
            componentInfo.setContainer(0);
            componentInfo.setContainerName(null);
            componentInfo.setAccessRights(0x2000000);
            componentInfo.getClients().add(this.getHandle());
            componentInfo.setInterfaces(component.implementedInterfaces());
            this.executeCommand(new ComponentCommandSet(handle, componentInfo));
        }
        finally {
            this.componentsLock.unlock();
        }
        this.logger.log(Level.INFO, "Component '" + name + "' registered.");
        return h;
    }

    @Override
    public void unregisterComponent(int id, int h) throws AcsJNoPermissionEx, AcsJBadParameterEx {
        this.securityCheck(id, 0x2000000);
        this.internalReleaseComponent(this.getHandle(), h, false);
        this.logger.log(Level.INFO, "Component with handle '" + HandleHelper.toString(h) + "' unregistered.");
    }

    @Override
    public Component restartComponent(int id, URI curl) throws AcsJNoPermissionEx, AcsJBadParameterEx {
        this.checkCURL(curl, false);
        this.securityCheck(id, 0);
        Component component = this.internalRestartComponent(id, curl);
        if (component != null) {
            this.logger.log(Level.INFO, "Component '" + curl + "' restarted.");
        } else {
            this.logger.log(Level.INFO, "Failed to restart component '" + curl + "'.");
        }
        return component;
    }

    @Override
    public int releaseComponent(int id, URI curl) throws AcsJNoPermissionEx, AcsJBadParameterEx {
        this.checkCURL(curl);
        this.securityCheck(id, 0);
        String requestorName = this.getRequestorName(id);
        this.logger.log(Level.INFO, "'" + requestorName + "' requested release of component '" + curl + "'.");
        int owners = this.internalReleaseComponent((int)id, (URI)curl, (boolean)(id == this.getHandle() ? true : false)).owners;
        this.logger.log(Level.INFO, "Component '" + curl + "' released by '" + requestorName + "'.");
        return owners;
    }

    @Override
    public void releaseComponentAsync(int id, URI curl, Manager.LongCompletionCallback callback) throws AcsJNoPermissionEx, AcsJBadParameterEx {
        this.checkCURL(curl);
        this.securityCheck(id, 0);
        final String requestorName = this.getRequestorName(id);
        this.logger.log(Level.INFO, "'" + requestorName + "' requested async release of component '" + curl + "'.");
        final int fid = id;
        final URI fcurl = curl;
        final boolean force = id == this.getHandle();
        final Manager.LongCompletionCallback fcallback = callback;
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        ReleaseComponentResult rcr = ManagerImpl.this.internalReleaseComponent(fid, fcurl, force);
                        if (fcallback != null) {
                            if (rcr.exception == null) {
                                ManagerImpl.this.logger.log(Level.INFO, "Component '" + fcurl + "' async released by '" + requestorName + "'.");
                                fcallback.done(rcr.owners);
                            } else {
                                ManagerImpl.this.logger.log(Level.INFO, "Component '" + fcurl + "' async released by '" + requestorName + " with failure'.");
                                fcallback.failed(rcr.owners, rcr.exception);
                            }
                        }
                    }
                    catch (Throwable th) {
                        if (fcallback == null) break block5;
                        fcallback.failed(-1, th);
                    }
                }
            }
        });
    }

    @Override
    public int forceReleaseComponent(int id, URI curl) throws AcsJNoPermissionEx, AcsJBadParameterEx {
        this.checkCURL(curl);
        this.securityCheck(id, 0);
        String requestorName = this.getRequestorName(id);
        this.logger.log(Level.INFO, "'" + requestorName + "' requested forceful release of component '" + curl + "'.");
        int owners = this.internalReleaseComponent((int)id, (URI)curl, (boolean)true).owners;
        this.logger.log(Level.INFO, "Component '" + curl + "' forcefully released by '" + requestorName + "'.");
        return owners;
    }

    public void releaseComponents(int id, URI[] curls) throws AcsJNoPermissionEx {
        if (curls == null) {
            BadParametersException af = new BadParametersException("Non-null CURLs expected.");
            throw af;
        }
        this.securityCheck(id, 0);
        int released = 0;
        for (int i = 0; i < curls.length; ++i) {
            try {
                this.releaseComponent(id, curls[i]);
                ++released;
                continue;
            }
            catch (Exception ex) {
                CoreException ce = new CoreException("Failed to release component '" + curls[i] + "'.", ex);
                this.reportException(ce);
            }
        }
        this.logger.log(Level.INFO, released + " of " + curls.length + " components released.");
    }

    private void checkContainerShutdownState(ContainerInfo containerInfo) throws NoResourcesException {
        String containerName = containerInfo.getName();
        if (this.pendingContainerShutdown.contains(containerName)) {
            NoResourcesException nre = new NoResourcesException("Container '" + containerName + "' is being shutdown.");
            throw nre;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownContainer(int id, String containerName, int action) throws AcsJNoPermissionEx {
        Container container;
        if (containerName == null) {
            BadParametersException af = new BadParametersException("Non-null 'containerName' expected.");
            throw af;
        }
        this.securityCheck(id, 0x4000000);
        ContainerInfo containerInfo = this.getContainerInfo(containerName);
        if (containerInfo == null || (container = containerInfo.getContainer()) == null) {
            NoResourcesException nre = new NoResourcesException("Container '" + containerName + "' not logged in.");
            throw nre;
        }
        this.pendingContainerShutdown.add(containerInfo.getName());
        try {
            try {
                ComponentInfo[] infos = this.topologySortManager.getComponentShutdownOrder(containerInfo);
                this.releaseComponents(infos);
            }
            catch (Throwable th) {
                CoreException ce = new CoreException("Failed to release components on container '" + containerName + "'.", th);
                this.reportException(ce);
            }
            try {
                if (action == 0) {
                    container.disconnect();
                } else {
                    container.shutdown(action);
                }
            }
            catch (Throwable th) {
                NoResourcesException nre = new NoResourcesException("Failed to shutdown container '" + containerName + "'.", th);
                throw nre;
            }
        }
        finally {
            this.pendingContainerShutdown.remove(containerInfo.getName());
        }
    }

    private void releaseComponents(ComponentInfo[] infos) throws AcsJNoPermissionEx {
        if (infos.length > 0) {
            URI[] uris = new URI[infos.length];
            for (int i = 0; i < infos.length; ++i) {
                try {
                    uris[i] = CURLHelper.createURI(infos[i].getName());
                    continue;
                }
                catch (URISyntaxException usi) {
                    BadParametersException hbpe = new BadParametersException(usi.getMessage(), usi);
                    this.reportException(hbpe);
                }
            }
            this.releaseComponents(this.getHandle(), uris);
        }
    }

    @Override
    public void shutdown(int id, int containers) throws AcsJNoPermissionEx {
        this.securityCheck(id, 0x4000000);
        if (id == 0x5000000) {
            id = this.originalId;
        } else {
            this.originalId = id;
        }
        if (containers == 0) {
            containers = this.originalContainers;
        } else {
            this.originalContainers = containers;
        }
        if (this.shutdownImplementation != null && !this.shutdownImplementation.isShutdownInProgress()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!ManagerImpl.this.shutdownImplementation.isShutdownInProgress()) {
                        ManagerImpl.this.shutdownImplementation.shutdown(false);
                    }
                }
            }, "ManagerApplicationShutdown").start();
            return;
        }
        if (this.shutdown.getAndSet(true)) {
            AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
            npe.setReason("Manager already in shutdown state.");
            npe.setID(HandleHelper.toString(id));
            throw npe;
        }
        this.logger.log(Level.INFO, "Manager is shutting down.");
        this.logger.log(Level.FINER, "Canceling heartbeat task.");
        this.heartbeatTask.cancel();
        this.topologySortManager.destroy();
        if (containers != 0) {
            this.logger.log(Level.FINER, "Releasing all components in the system.");
            try {
                this.topologySortManager.requestTopologicalSort();
                this.releaseComponents(this.topologySortManager.getComponentShutdownOrder(null));
            }
            catch (Throwable th) {
                CoreException ce = new CoreException("Failed to release all components in the system.", th);
                this.reportException(ce);
            }
        }
        this.logger.log(Level.FINER, "Notifying containers to disconnect or shutdown.");
        this.notifyContainerDisconnectShutdown(containers);
        this.finalizeFederation();
        this.logger.log(Level.FINER, "Waiting for tasks in thread pool to complete...");
        this.threadPool.shutdown();
        try {
            if (!this.threadPool.awaitTermination(3L, TimeUnit.SECONDS)) {
                this.threadPool.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.alarmSource != null) {
            this.alarmSource.tearDown();
        }
        this.unbind(FAULT_FAMILY, null);
        this.setCDBAccess(null);
        this.destroyComponetsDAOProxy();
        this.destroyContainersDAOProxy();
        this.destroyManagerDAOProxy();
        this.logger.log(Level.INFO, "Manager shutdown completed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInfo containerLogin(String name, AuthenticationData reply, Container container, long timeStamp, long executionId) throws AcsJNoPermissionEx {
        assert (name != null);
        assert (reply != null);
        assert (container != null);
        ContainerInfo containerInfo = null;
        ClientInfo clientInfo = null;
        boolean existingLogin = false;
        HandleDataStore handleDataStore = this.containers;
        synchronized (handleDataStore) {
            int h = this.containers.first();
            while (h != 0) {
                ContainerInfo loggedContainerInfo = (ContainerInfo)this.containers.get(h);
                if (name.equals(loggedContainerInfo.getName())) {
                    Container loggedContainer = loggedContainerInfo.getContainer();
                    if (loggedContainer != null && !loggedContainer.equals(container)) {
                        boolean alive = false;
                        try {
                            int lh = loggedContainer.get_handle();
                            if (lh != 0 && lh == loggedContainerInfo.getHandle()) {
                                alive = true;
                            }
                        }
                        catch (Throwable lh) {
                            // empty catch block
                        }
                        if (alive) {
                            AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
                            Object address = DEFAULT_DOMAIN;
                            try {
                                address = " " + loggedContainer.getRemoteLocation();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            npe.setReason("Rejecting container login, container with name '" + name + "'" + (String)address + " already logged in.");
                            npe.setID(HandleHelper.toString(loggedContainerInfo.getHandle()));
                            npe.setProtectedResource(name);
                            throw npe;
                        }
                        this.logger.log(Level.FINER, "Container '" + name + "' is no longer functional, new container is taking over.");
                    }
                    this.executeCommand(new ContainerCommandUpdate(h, container));
                    existingLogin = true;
                    containerInfo = (TimerTaskContainerInfo)loggedContainerInfo;
                    clientInfo = ((TimerTaskContainerInfo)containerInfo).createClientInfo();
                    break;
                }
                h = this.containers.next(h);
            }
            if (h == 0) {
                int handle;
                Integer objHandle;
                long pingInterval = 0L;
                DAOProxy dao = this.getContainersDAOProxy();
                if (dao != null) {
                    String impLang = this.readStringCharacteristics(dao, name + "/ImplLang", true);
                    ImplLang configuredImplLang = ImplLang.fromString(impLang);
                    if (configuredImplLang != ImplLang.not_specified && configuredImplLang != reply.getImplLang()) {
                        AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
                        npe.setReason("Rejecting container login, container reported '" + reply.getImplLang() + "' implementation language, but configured '" + configuredImplLang + "'.");
                        npe.setProtectedResource(name);
                        throw npe;
                    }
                    pingInterval = this.readLongCharacteristics(dao, name + "/PingInterval", -1, true) * 1000;
                }
                if ((objHandle = (Integer)this.executeCommand(new ContainerCommandAllocate())) == null || (handle = objHandle.intValue()) == 0) {
                    NoResourcesException af = new NoResourcesException("Generation of new handle failed, too many containers logged in.");
                    throw af;
                }
                h = handle | 0x4000000;
                containerInfo = new TimerTaskContainerInfo(h |= this.random.nextInt(256) << 16, name, container, this.containerPingInterval);
                containerInfo.setImplLang(reply.getImplLang());
                if (pingInterval >= 1000L) {
                    containerInfo.setPingInterval(pingInterval);
                }
                clientInfo = ((TimerTaskContainerInfo)containerInfo).createClientInfo();
                PingTimerTask task = new PingTimerTask(this, this.logger, clientInfo, this.alarmSource);
                ((TimerTaskContainerInfo)containerInfo).setTask(task);
                this.heartbeatTask.schedule((TimerTask)task, containerInfo.getPingInterval(), containerInfo.getPingInterval());
                this.executeCommand(new ContainerCommandSet(handle, containerInfo));
            }
        }
        AcsJCannotGetComponentEx acgcex = new AcsJCannotGetComponentEx();
        acgcex.setReason("Request canceled due to container re-login.");
        this.cancelPendingContainerAsyncRequestWithException(containerInfo.getName(), (Throwable)acgcex);
        final boolean recoverContainer = reply.isRecover();
        if (existingLogin) {
            this.containerInternalStateMerge(containerInfo, recoverContainer);
        }
        this.notifyContainerLogin(containerInfo, timeStamp, executionId);
        final ContainerInfo finalInfo = containerInfo;
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                ManagerImpl.this.containerPostLoginActivation(finalInfo, recoverContainer);
            }
        });
        this.logger.log(Level.INFO, "Container '" + name + "' logged in.");
        return clientInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void containerPostLoginActivation(ContainerInfo containerInfo, boolean recoverContainer) {
        String name;
        Integer managerHandle;
        if (containerInfo.getImplLang() == ImplLang.cpp || containerInfo.getImplLang() == ImplLang.not_specified) {
            while (containerInfo.getContainer().get_handle() == 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.isShuttingDown()) {
            return;
        }
        if (this.cdbActivation != null && containerInfo.getName().equals(this.cdbActivation.getContainer())) {
            try {
                StatusHolder status = new StatusHolder();
                ComponentInfo cdbInfo = this.internalRequestComponent(this.getHandle(), this.cdbActivation.getName(), this.cdbActivation.getType(), this.cdbActivation.getCode(), this.cdbActivation.getContainer(), 0, status, true);
                if (status.getStatus() != ComponentStatus.COMPONENT_ACTIVATED) {
                    this.logger.log(Level.SEVERE, "Failed to activate CDB, reason: '" + status.getStatus() + "'.");
                } else if (cdbInfo == null || cdbInfo.getHandle() == 0 || cdbInfo.getComponent() == null) {
                    this.logger.log(Level.SEVERE, "Failed to activate CDB, invalid ComponentInfo returned: '" + cdbInfo + "'.");
                } else {
                    this.logger.log(Level.INFO, "CDB activated on container '" + containerInfo.getName() + "'.");
                }
            }
            catch (Throwable ex) {
                this.logger.log(Level.SEVERE, "Failed to activate CDB on container '" + containerInfo.getName() + "'.", ex);
            }
        }
        HashMap<String, Integer> activationRequests = new HashMap<String, Integer>();
        ArrayList<URI> activationRequestsList = new ArrayList<URI>();
        DAOProxy dao = this.getManagerDAOProxy();
        DAOProxy componentsDAO = this.getComponentsDAOProxy();
        if (dao != null && componentsDAO != null) {
            try {
                String[] startup = dao.get_string_seq("Startup");
                managerHandle = new Integer(this.getHandle());
                for (int i = 0; i < startup.length; ++i) {
                    if (startup[i].length() == 0) continue;
                    String containerName = this.readStringCharacteristics(componentsDAO, startup[i] + "/Container");
                    if (containerName == null) {
                        this.logger.log(Level.WARNING, "Misconfigured CDB, there is no container of component '" + startup[i] + "' defined.");
                        continue;
                    }
                    if (!containerInfo.getName().equals(containerName)) continue;
                    try {
                        URI curl = CURLHelper.createURI(startup[i]);
                        try {
                            this.checkCURL(curl);
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                        activationRequestsList.add(curl);
                        activationRequests.put(startup[i], managerHandle);
                        continue;
                    }
                    catch (URISyntaxException usi) {
                        this.logger.log(Level.WARNING, "Failed to create URI from component name '" + startup[i] + "'.", usi);
                    }
                }
            }
            catch (Throwable th) {
                this.logger.log(Level.WARNING, "Failed to retrieve list of startup components.", th);
            }
        }
        String TRUE_STRING = "true";
        if (componentsDAO != null) {
            try {
                managerHandle = new Integer(this.getHandle());
                componentsDAO.get_field_data(DEFAULT_DOMAIN);
                String[] ids = this.getComponentsList();
                for (int i = 0; i < ids.length; ++i) {
                    String name2 = ids[i];
                    if (name2 == null) {
                        this.logger.log(Level.WARNING, "Misconfigured CDB, there is no name of component '" + ids[i] + "' defined.");
                        continue;
                    }
                    String autostart = this.readStringCharacteristics(componentsDAO, ids[i] + "/Autostart", true);
                    if (autostart == null) {
                        this.logger.log(Level.WARNING, "Misconfigured CDB, there is no autostart attribute of component '" + ids[i] + "' defined.");
                        continue;
                    }
                    if (!autostart.equalsIgnoreCase("true") || activationRequests.containsKey(name2)) continue;
                    String componentContainer = this.readStringCharacteristics(componentsDAO, ids[i] + "/Container", true);
                    if (componentContainer == null) {
                        this.logger.log(Level.WARNING, "Misconfigured CDB, there is no container attribute of component '" + ids[i] + "' defined.");
                        continue;
                    }
                    if (!containerInfo.getName().equals(componentContainer)) continue;
                    try {
                        URI curl = CURLHelper.createURI(name2);
                        try {
                            this.checkCURL(curl, false);
                        }
                        catch (RuntimeException e) {
                            this.reportException(e);
                        }
                        activationRequestsList.add(curl);
                        activationRequests.put(name2, managerHandle);
                        continue;
                    }
                    catch (URISyntaxException usi) {
                        this.logger.log(Level.WARNING, "Failed to create URI from component name '" + name2 + "'.", usi);
                    }
                }
            }
            catch (Throwable ex) {
                this.logger.log(Level.WARNING, "Failed to retrieve list of components.", ex);
            }
        }
        ArrayList<ComponentInfo> cleanupList = new ArrayList<ComponentInfo>();
        if (this.unavailableComponents.size() > 0 && componentsDAO != null) {
            try {
                Integer reactivateHandle = new Integer(0);
                Map<String, ComponentInfo> i = this.unavailableComponents;
                synchronized (i) {
                    String[] names = this.unavailableComponents.keySet().toArray(new String[this.unavailableComponents.size()]);
                    for (int i2 = names.length - 1; i2 >= 0; --i2) {
                        name = names[i2];
                        boolean reactivate = false;
                        ComponentInfo componentInfo = this.unavailableComponents.get(name);
                        if (componentInfo != null && componentInfo.isDynamic() && componentInfo.getDynamicContainerName() != null && componentInfo.getDynamicContainerName().equals(containerInfo.getName())) {
                            reactivate = true;
                        } else {
                            String containerName = this.readStringCharacteristics(componentsDAO, name + "/Container");
                            if (containerName == null) {
                                this.logger.log(Level.WARNING, "Misconfigured CDB, there is no container of component '" + name + "' defined.");
                            } else if (containerInfo.getName().equals(containerName)) {
                                reactivate = true;
                            }
                        }
                        if (!reactivate) continue;
                        if (!recoverContainer && !activationRequests.containsKey(name)) {
                            cleanupList.add(componentInfo);
                            continue;
                        }
                        if (activationRequests.containsKey(name)) {
                            activationRequests.put(name, reactivateHandle);
                            continue;
                        }
                        try {
                            activationRequestsList.add(CURLHelper.createURI(name));
                            activationRequests.put(name, reactivateHandle);
                            continue;
                        }
                        catch (URISyntaxException usi) {
                            this.logger.log(Level.WARNING, "Failed to create URI from component name '" + name + "'.", usi);
                        }
                    }
                }
            }
            catch (Throwable ex) {
                CoreException ce = new CoreException("Failed to obtain component data from the CDB.", ex);
                this.reportException(ce);
            }
        }
        if (cleanupList.size() > 0) {
            for (ComponentInfo componentInfo : cleanupList) {
                this.componentsLock.lock();
                try {
                    int[] owners = componentInfo.getClients().toArray();
                    for (int j = 0; j < owners.length; ++j) {
                        this.removeComponentOwner(componentInfo.getHandle(), owners[j]);
                    }
                    this.executeCommand(new ComponentCommandDeallocate(componentInfo.getHandle() & 0xFFFF, componentInfo.getHandle(), WhyUnloadedReason.REMOVED));
                    this.executeCommand(new UnavailableComponentCommandRemove(componentInfo.getName()));
                    IntArray j = containerInfo.getComponents();
                    synchronized (j) {
                        if (containerInfo.getComponents().contains(componentInfo.getHandle())) {
                            this.executeCommand(new ContainerInfoCommandComponentRemove(containerInfo.getHandle() & 0xFFFF, componentInfo.getHandle()));
                        }
                    }
                }
                finally {
                    this.componentsLock.unlock();
                }
            }
        }
        this.logger.log(Level.INFO, "Container '" + containerInfo.getName() + "' startup statistics: " + activationRequestsList.size() + " components queued to be activated.");
        this.sendMessage(containerInfo.getContainer(), "Startup statistics: " + activationRequestsList.size() + " components queued to be activated.", MessageType.MSG_INFORMATION, (short)1);
        int activated = 0;
        StatusHolder status = new StatusHolder();
        for (URI uri : activationRequestsList) {
            try {
                name = this.extractName(uri);
                int requestor = (Integer)activationRequests.get(name);
                this.internalRequestComponent(requestor, uri, status);
                if (status.getStatus() != ComponentStatus.COMPONENT_ACTIVATED) {
                    this.logger.log(Level.WARNING, "Failed to activate autostart component '" + uri + "', reason: '" + status.getStatus() + "'.");
                    continue;
                }
                ++activated;
            }
            catch (Throwable ex) {
                this.logger.log(Level.WARNING, "Failed to activate autostart component '" + uri + "'.", ex);
            }
        }
        this.logger.log(Level.INFO, "Container '" + containerInfo.getName() + "' startup statistics: " + activated + " of " + activationRequestsList.size() + " components activated.");
        this.sendMessage(containerInfo.getContainer(), "Startup statistics: " + activated + " of " + activationRequestsList.size() + " components activated.", MessageType.MSG_INFORMATION, (short)2);
        Object object = this.containerLoggedInMonitor;
        synchronized (object) {
            this.containerLoggedInMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void containerInternalStateMerge(ContainerInfo containerInfo, boolean recoverContainer) throws AcsJNoPermissionEx {
        Object componentInfo;
        IntArray managerContainersComponents;
        assert (containerInfo != null);
        ComponentInfo[] infos = null;
        try {
            infos = containerInfo.getContainer().get_component_info(new int[0]);
        }
        catch (Throwable ex) {
            this.logger.log(Level.SEVERE, "Failed to query state of container '" + containerInfo.getName() + "'.", ex);
        }
        boolean requireTopologySort = false;
        IntArray intArray = containerInfo.getComponents();
        synchronized (intArray) {
            managerContainersComponents = new IntArray(containerInfo.getComponents().toArray());
        }
        if (infos != null && infos.length > 0) {
            this.componentsLock.lock();
            try {
                ComponentInfo componentInfo2;
                int handle;
                int i;
                for (i = 0; i < infos.length; ++i) {
                    if (infos[i].getHandle() == 0 || (infos[i].getHandle() & 0x1000000) != 0x1000000 || infos[i].getName() == null || infos[i].getType() == null || infos[i].getCode() == null || infos[i].getComponent() == null || infos[i].getContainer() == 0 || infos[i].getInterfaces() == null) {
                        AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
                        npe.setReason("Inconsistent container state - component information is not valid, rejecting container.");
                        npe.setID(containerInfo.getName());
                        npe.setProtectedResource(infos[i].getName());
                        throw npe;
                    }
                    handle = infos[i].getHandle() & 0xFFFF;
                    if (this.components.isAllocated(handle)) {
                        componentInfo2 = (ComponentInfo)this.components.get(handle);
                        if (componentInfo2 != null && componentInfo2.getHandle() == infos[i].getHandle() && componentInfo2.getName().equals(infos[i].getName()) && (componentInfo2.getContainer() == 0 || componentInfo2.getContainer() == infos[i].getContainer())) continue;
                        AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
                        npe.setReason("Inconsistent container state - components information do not match, rejecting container.");
                        npe.setID(containerInfo.getName());
                        if (componentInfo2 != null) {
                            npe.setProtectedResource(componentInfo2.getName());
                        }
                        throw npe;
                    }
                    int h = this.components.first();
                    while (h != 0) {
                        componentInfo = (ComponentInfo)this.components.get(h);
                        if (((ComponentInfo)componentInfo).getName().equals(infos[i].getName())) {
                            AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
                            npe.setReason("Inconsistent container state - component with name '" + ((ComponentInfo)componentInfo).getName() + "' already registered with different handle, rejecting container.");
                            npe.setID(containerInfo.getName());
                            npe.setProtectedResource(((ComponentInfo)componentInfo).getName());
                            throw npe;
                        }
                        h = this.components.next(h);
                    }
                }
                for (i = 0; i < infos.length; ++i) {
                    Serializable info;
                    handle = infos[i].getHandle() & 0xFFFF;
                    if (this.components.isAllocated(handle)) {
                        componentInfo2 = (ComponentInfo)this.components.get(handle);
                        componentInfo2.setComponent(infos[i].getComponent());
                        componentInfo2.setContainer(infos[i].getContainer());
                        componentInfo2.setContainerName(infos[i].getContainerName());
                        componentInfo = this.unavailableComponents;
                        synchronized (componentInfo) {
                            this.executeCommand(new UnavailableComponentCommandRemove(componentInfo2.getName()));
                        }
                        int[] clients = componentInfo2.getClients().toArray();
                        this.notifyComponentAvailable(0, clients, new ComponentInfo[]{componentInfo2});
                    } else {
                        info = new ComponentInfo(infos[i].getHandle(), infos[i].getName(), infos[i].getType(), infos[i].getCode(), infos[i].getComponent());
                        info.setContainer(infos[i].getContainer());
                        info.setContainerName(infos[i].getContainerName());
                        info.setInterfaces(infos[i].getInterfaces());
                        info.setAccessRights(0);
                        if (!this.hasCDBEntry((ComponentInfo)info)) {
                            info.setDynamic(true);
                            info.setDynamicContainerName(containerInfo.getName());
                        }
                        this.executeCommand(new ComponentCommandAllocateHandle(handle));
                        this.executeCommand(new ComponentCommandSet(handle, info));
                        requireTopologySort = true;
                    }
                    managerContainersComponents.remove(infos[i].getHandle());
                    info = containerInfo.getComponents();
                    synchronized (info) {
                        if (!containerInfo.getComponents().contains(infos[i].getHandle())) {
                            this.executeCommand(new ContainerInfoCommandComponentAdd(containerInfo.getHandle() & 0xFFFF, infos[i].getHandle()));
                        }
                        continue;
                    }
                }
            }
            finally {
                this.componentsLock.unlock();
            }
        }
        for (int i = 0; i < managerContainersComponents.size(); ++i) {
            int componentHandle = managerContainersComponents.get(i);
            this.executeCommand(new ContainerInfoCommandComponentRemove(containerInfo.getHandle() & 0xFFFF, componentHandle));
            this.componentsLock.lock();
            try {
                int handle = componentHandle & 0xFFFF;
                if (this.components.isAllocated(handle)) {
                    componentInfo = (ComponentInfo)this.components.get(handle);
                    if (componentInfo == null) {
                        this.logger.log(Level.SEVERE, "Internal state is not consistent (no ComponentInfo).");
                        continue;
                    }
                    this.makeUnavailable((ComponentInfo)componentInfo);
                    if (recoverContainer) continue;
                    int[] owners = ((ComponentInfo)componentInfo).getClients().toArray();
                    for (int j = 0; j < owners.length; ++j) {
                        this.removeComponentOwner(componentHandle, owners[j]);
                    }
                    this.executeCommand(new ComponentCommandDeallocate(handle, ((ComponentInfo)componentInfo).getHandle(), WhyUnloadedReason.REMOVED));
                    requireTopologySort = true;
                    continue;
                }
                this.logger.log(Level.SEVERE, "Internal state is not consistent.");
                continue;
            }
            finally {
                this.componentsLock.unlock();
            }
        }
        if (requireTopologySort) {
            this.topologySortManager.notifyTopologyChange(containerInfo.getHandle());
        }
    }

    private void initializeServiceDaemons() {
        String[] daemons;
        DAOProxy dao = this.getManagerDAOProxy();
        if (dao == null) {
            return;
        }
        try {
            daemons = dao.get_string_seq("ServiceDaemons");
        }
        catch (Throwable th) {
            this.logger.log(Level.WARNING, "No list of services daemons available in the CDB. In an operational environment using ACS daemons, this is a severe error!! It is OK only if you run the system without using these daemons. ");
            return;
        }
        for (int i = 0; i < daemons.length; ++i) {
            try {
                ServiceDaemon daemon = this.transport.getServiceDaemon(daemons[i]);
                if (daemon == null) {
                    throw new RuntimeException("Failed to resolve service daemon reference '" + daemons[i] + "'.");
                }
                daemon.setManagerReference(this.transport.getManagerReference());
                continue;
            }
            catch (Throwable th) {
                this.logger.config("Failed to set manager reference on service daemon on host '" + daemons[i] + "'.");
            }
        }
    }

    private void autoStartComponents() {
        String name;
        LinkedHashSet<String> activationRequestsList = new LinkedHashSet<String>();
        DAOProxy dao = this.getManagerDAOProxy();
        DAOProxy componentsDAO = this.getComponentsDAOProxy();
        DAOProxy containersDAO = this.getContainersDAOProxy();
        if (componentsDAO == null || containersDAO == null) {
            return;
        }
        if (dao != null) {
            try {
                String[] startup = dao.get_string_seq("Startup");
                for (int i = 0; i < startup.length; ++i) {
                    if (startup[i].length() == 0) continue;
                    activationRequestsList.add(startup[i]);
                }
            }
            catch (Throwable th) {
                this.logger.log(Level.WARNING, "Failed to retrieve list of startup components.", th);
            }
        }
        String TRUE_STRING = "true";
        try {
            componentsDAO.get_field_data(DEFAULT_DOMAIN);
            String[] ids = this.getComponentsList();
            for (int i = 0; i < ids.length; ++i) {
                name = ids[i];
                if (name == null) {
                    this.logger.log(Level.WARNING, "Misconfigured CDB, there is no name of component '" + ids[i] + "' defined.");
                    continue;
                }
                String autostart = this.readStringCharacteristics(componentsDAO, ids[i] + "/Autostart", true);
                if (autostart == null) {
                    this.logger.log(Level.WARNING, "Misconfigured CDB, there is no autostart attribute of component '" + ids[i] + "' defined.");
                    continue;
                }
                if (!autostart.equalsIgnoreCase("true")) continue;
                activationRequestsList.add(name);
            }
        }
        catch (Throwable ex) {
            this.logger.log(Level.WARNING, "Failed to retrieve list of components.", ex);
        }
        LinkedHashSet<String> startupContainers = new LinkedHashSet<String>();
        Iterator iterator = activationRequestsList.iterator();
        while (iterator.hasNext()) {
            name = (String)iterator.next();
            try {
                String containerName = this.readStringCharacteristics(componentsDAO, name + "/Container", true);
                if (containerName == null) {
                    iterator.remove();
                    continue;
                }
                if (containerName.equals("*")) continue;
                String host = this.readStringCharacteristics(containersDAO, containerName + "/DeployInfo/Host", true);
                String startOnDemand = this.readStringCharacteristics(containersDAO, containerName + "/DeployInfo/StartOnDemand", true);
                if (host != null && startOnDemand != null && startOnDemand.equalsIgnoreCase("TRUE")) {
                    startupContainers.add(containerName);
                }
                iterator.remove();
            }
            catch (Throwable ex) {
                this.logger.log(Level.WARNING, "Failed to retrieve list of components.", ex);
            }
        }
        int activated = 0;
        for (String containerName : startupContainers) {
            try {
                this.startUpContainer(containerName);
            }
            catch (Throwable ex) {
                this.logger.log(Level.WARNING, "Failed to auto-start container to auto-start components.", ex);
            }
        }
        StatusHolder status = new StatusHolder();
        for (String name2 : activationRequestsList) {
            try {
                URI uri = CURLHelper.createURI(name2);
                this.internalRequestComponent(this.getHandle(), uri, status);
                if (status.getStatus() != ComponentStatus.COMPONENT_ACTIVATED) {
                    this.logger.log(Level.FINE, "Failed to auto-activate requested component '" + name2 + "', reason: '" + status.getStatus() + "'.");
                    continue;
                }
                ++activated;
            }
            catch (Throwable ex) {
                CoreException ce = new CoreException("Failed to request component '" + name2 + "'.", ex);
                this.reportException(ce);
            }
        }
    }

    private boolean hasCDBEntry(ComponentInfo componentInfo) {
        assert (componentInfo != null);
        try {
            ContainerInfo containerInfo;
            DAOProxy dao = this.getComponentsDAOProxy();
            if (dao == null || this.readStringCharacteristics(dao, componentInfo.getName(), true) == null) {
                return false;
            }
            String type = this.readStringCharacteristics(dao, componentInfo.getName() + "/Type", true);
            if (type == null || !type.equals(componentInfo.getType())) {
                return false;
            }
            String code = this.readStringCharacteristics(dao, componentInfo.getName() + "/Code", true);
            if (code == null || !code.equals(componentInfo.getCode())) {
                return false;
            }
            String container = this.readStringCharacteristics(dao, componentInfo.getName() + "/Container", true);
            if (container == null) {
                return false;
            }
            return !(componentInfo.isDynamic() ? componentInfo.getDynamicContainerName() != null && !container.equals(componentInfo.getDynamicContainerName()) : (containerInfo = this.getContainerInfo(componentInfo.getContainer())) != null && !containerInfo.getName().equals(container));
        }
        catch (Throwable t) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInfo administratorLogin(String name, AuthenticationData reply, Administrator administrator, long timeStamp, long executionId) throws AcsJNoPermissionEx {
        assert (name != null);
        assert (administrator != null);
        TimerTaskClientInfo clientInfo = null;
        HandleDataStore handleDataStore = this.administrators;
        synchronized (handleDataStore) {
            int handle;
            int h = this.administrators.first();
            while (h != 0) {
                ClientInfo loggedAdministratorInfo = (ClientInfo)this.administrators.get(h);
                if (administrator.equals(loggedAdministratorInfo.getClient())) {
                    return loggedAdministratorInfo;
                }
                h = this.administrators.next(h);
            }
            Integer objHandle = (Integer)this.executeCommand(new AdministratorCommandAllocate());
            if (objHandle == null || (handle = objHandle.intValue()) == 0) {
                NoResourcesException af = new NoResourcesException("Generation of new handle failed, too many administrators logged in.");
                throw af;
            }
            h = handle | 0x3000000;
            clientInfo = new TimerTaskClientInfo(h |= this.random.nextInt(256) << 16, name, administrator);
            clientInfo.setAccessRights(0xE000000);
            PingTimerTask task = new PingTimerTask(this, this.logger, clientInfo, null);
            clientInfo.setTask(task);
            this.heartbeatTask.schedule((TimerTask)task, this.administratorPingInterval, (long)this.administratorPingInterval);
            this.executeCommand(new AdministratorCommandSet(handle, clientInfo));
        }
        this.notifyClientLogin(clientInfo, timeStamp, executionId);
        this.logger.log(Level.INFO, "Administrator '" + name + "' logged in.");
        return clientInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInfo clientLogin(String name, AuthenticationData reply, Client client, long timeStamp, long executionId) throws AcsJNoPermissionEx {
        assert (name != null);
        assert (client != null);
        TimerTaskClientInfo clientInfo = null;
        HandleDataStore handleDataStore = this.clients;
        synchronized (handleDataStore) {
            int handle;
            int h = this.clients.first();
            while (h != 0) {
                ClientInfo loggedClientInfo = (ClientInfo)this.clients.get(h);
                if (client.equals(loggedClientInfo.getClient())) {
                    return loggedClientInfo;
                }
                h = this.clients.next(h);
            }
            int usage = this.threadsUsedPercentage.get();
            if (usage > 90) {
                throw new NoResourcesException("Thread usage too high (%" + usage + "), rejecting login.");
            }
            Integer objHandle = (Integer)this.executeCommand(new ClientCommandAllocate());
            if (objHandle == null || (handle = objHandle.intValue()) == 0) {
                NoResourcesException af = new NoResourcesException("Generation of new handle failed, too many clients logged in.");
                throw af;
            }
            h = handle | 0x2000000;
            clientInfo = new TimerTaskClientInfo(h |= this.random.nextInt(256) << 16, name, client);
            clientInfo.setAccessRights(0x2000000);
            PingTimerTask task = new PingTimerTask(this, this.logger, clientInfo, null);
            clientInfo.setTask(task);
            this.heartbeatTask.schedule((TimerTask)task, this.clientPingInterval, (long)this.clientPingInterval);
            this.executeCommand(new ClientCommandSet(handle, clientInfo));
        }
        this.notifyClientLogin(clientInfo, timeStamp, executionId);
        this.logger.log(Level.INFO, "Client '" + name + "' logged in.");
        return clientInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void containerLogout(int id, boolean pingFailed) {
        TimerTaskContainerInfo containerInfo = null;
        HandleDataStore handleDataStore = this.containers;
        synchronized (handleDataStore) {
            int handle = id & 0xFFFF;
            if (!this.containers.isAllocated(handle)) {
                return;
            }
            containerInfo = (TimerTaskContainerInfo)this.containers.get(handle);
            AcsJCannotGetComponentEx acgcex = new AcsJCannotGetComponentEx();
            acgcex.setReason("Request canceled due to container logout.");
            this.cancelPendingContainerAsyncRequestWithException(containerInfo.getName(), (Throwable)acgcex);
            this.executeCommand(new ContainerCommandDeallocate(handle, id, pingFailed ? WhyUnloadedReason.DISAPPEARED : WhyUnloadedReason.REMOVED));
        }
        containerInfo.getTask().cancel();
        this.markContainersComponentsUnavailable(containerInfo);
        this.notifyContainerLogout(containerInfo, System.currentTimeMillis());
        Container container = containerInfo.getContainer();
        if (container != null) {
            container.release();
        }
        this.logger.log(Level.INFO, "Container '" + containerInfo.getName() + "' logged out.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markContainersComponentsUnavailable(TimerTaskContainerInfo containerInfo) {
        int[] markUnavailable;
        Object object = containerInfo.getComponents();
        synchronized (object) {
            markUnavailable = containerInfo.getComponents().toArray();
        }
        if (markUnavailable.length > 0) {
            this.componentsLock.lock();
            try {
                object = this.unavailableComponents;
                synchronized (object) {
                    for (int i = markUnavailable.length - 1; i >= 0; --i) {
                        ComponentInfo componentInfo;
                        int handle = markUnavailable[i] & 0xFFFF;
                        if (!this.components.isAllocated(handle) || (componentInfo = (ComponentInfo)this.components.get(handle)) == null) continue;
                        this.makeUnavailable(componentInfo);
                    }
                }
            }
            finally {
                this.componentsLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeUnavailable(ComponentInfo componentInfo) {
        boolean notificationNeeded;
        String componentName = null;
        int[] clients = null;
        Map<String, ComponentInfo> map = this.unavailableComponents;
        synchronized (map) {
            notificationNeeded = !this.unavailableComponents.containsKey(componentInfo.getName());
            this.executeCommand(new UnavailableComponentCommandPut(componentInfo.getName(), componentInfo));
            if (notificationNeeded) {
                componentName = componentInfo.getName();
                clients = componentInfo.getClients().toArray();
            }
            componentInfo.setComponent(null);
            componentInfo.setContainer(0);
        }
        if (notificationNeeded) {
            this.notifyComponentUnavailable(0, clients, new String[]{componentName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientLogout(int id, boolean pingFailed) {
        TimerTaskClientInfo clientInfo = null;
        int[] componentsArray = null;
        HandleDataStore handleDataStore = this.clients;
        synchronized (handleDataStore) {
            int handle = id & 0xFFFF;
            if (!this.clients.isAllocated(handle)) {
                return;
            }
            clientInfo = (TimerTaskClientInfo)this.clients.get(handle);
            this.executeCommand(new ClientCommandDeallocate(handle, id, pingFailed ? WhyUnloadedReason.DISAPPEARED : WhyUnloadedReason.REMOVED));
            componentsArray = clientInfo.getComponents().toArray();
        }
        clientInfo.getTask().cancel();
        this.threadPool.execute(new ReleaseComponentTask(clientInfo.getHandle(), componentsArray));
        this.notifyClientLogout(clientInfo, System.currentTimeMillis());
        Client client = clientInfo.getClient();
        if (client != null) {
            client.release();
        }
        this.logger.log(Level.INFO, "Client '" + clientInfo.getName() + "' logged out.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void administratorLogout(int id, boolean pingFailed) {
        TimerTaskClientInfo clientInfo = null;
        int[] componentsArray = null;
        HandleDataStore handleDataStore = this.administrators;
        synchronized (handleDataStore) {
            int handle = id & 0xFFFF;
            if (!this.administrators.isAllocated(handle)) {
                return;
            }
            clientInfo = (TimerTaskClientInfo)this.administrators.get(handle);
            this.executeCommand(new AdministratorCommandDeallocate(handle, id, pingFailed ? WhyUnloadedReason.DISAPPEARED : WhyUnloadedReason.REMOVED));
            componentsArray = clientInfo.getComponents().toArray();
        }
        clientInfo.getTask().cancel();
        this.threadPool.execute(new ReleaseComponentTask(clientInfo.getHandle(), componentsArray));
        this.notifyClientLogout(clientInfo, System.currentTimeMillis());
        Client client = clientInfo.getClient();
        if (client != null) {
            client.release();
        }
        this.logger.log(Level.INFO, "Administrator '" + clientInfo.getName() + "' logged out.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInfo[] getAdministrators(int excludeHandle) {
        ClientInfo[] admins = null;
        HandleDataStore handleDataStore = this.administrators;
        synchronized (handleDataStore) {
            int len = this.administrators.size();
            if (len > 0) {
                ArrayList<ClientInfo> list = new ArrayList<ClientInfo>();
                int h = this.administrators.first();
                while (h != 0) {
                    ClientInfo adminInfo = (ClientInfo)this.administrators.get(h);
                    if (adminInfo.getHandle() != excludeHandle) {
                        list.add(adminInfo);
                    }
                    h = this.administrators.next(h);
                }
                if (list.size() > 0) {
                    admins = new ClientInfo[list.size()];
                    list.toArray(admins);
                }
            }
        }
        return admins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerInfo[] getContainersInfo() {
        ContainerInfo[] acts = null;
        HandleDataStore handleDataStore = this.containers;
        synchronized (handleDataStore) {
            int len = this.containers.size();
            if (len > 0) {
                ArrayList<ContainerInfo> list = new ArrayList<ContainerInfo>();
                int h = this.containers.first();
                while (h != 0) {
                    ContainerInfo actInfo = (ContainerInfo)this.containers.get(h);
                    list.add(actInfo);
                    h = this.containers.next(h);
                }
                if (list.size() > 0) {
                    acts = new ContainerInfo[list.size()];
                    list.toArray(acts);
                }
            }
        }
        return acts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientInfo[] getClientInfo() {
        ClientInfo clientInfo;
        int h;
        ArrayList<ClientInfo> list = new ArrayList<ClientInfo>();
        HandleDataStore handleDataStore = this.clients;
        synchronized (handleDataStore) {
            h = this.clients.first();
            while (h != 0) {
                clientInfo = (ClientInfo)this.clients.get(h);
                list.add(clientInfo);
                h = this.clients.next(h);
            }
        }
        handleDataStore = this.administrators;
        synchronized (handleDataStore) {
            h = this.administrators.first();
            while (h != 0) {
                clientInfo = (ClientInfo)this.administrators.get(h);
                list.add(clientInfo);
                h = this.clients.next(h);
            }
        }
        ClientInfo[] infos = null;
        if (list.size() > 0) {
            infos = new ClientInfo[list.size()];
            list.toArray(infos);
        }
        return infos;
    }

    private ClientInfo[] getClients(int excludeHandle, int[] handles) {
        assert (handles != null);
        ClientInfo[] clients = null;
        ArrayList<ClientInfo> list = new ArrayList<ClientInfo>();
        for (int i = 0; i < handles.length; ++i) {
            if (handles[i] == excludeHandle) continue;
            if ((handles[i] & 0xFF000000) == 0x1000000) {
                ContainerInfo containerInfo;
                ComponentInfo componentInfo = this.getComponentInfo(handles[i]);
                if (componentInfo == null || (containerInfo = this.getContainerInfo(componentInfo.getContainer())) == null) continue;
                ClientInfo info = new ClientInfo(containerInfo.getHandle(), containerInfo.getName(), containerInfo.getContainer());
                list.add(info);
                continue;
            }
            ClientInfo info = this.getClientInfo(handles[i]);
            if (info == null) continue;
            list.add(info);
        }
        if (list.size() > 0) {
            clients = new ClientInfo[list.size()];
            list.toArray(clients);
        }
        return clients;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeComponentOwner(int componentHandle, int owner) {
        if ((owner & 0xFF000000) == 0x1000000) {
            ComponentInfo componentInfo = this.getComponentInfo(owner);
            if (componentInfo != null) {
                this.componentsLock.lock();
                try {
                    this.executeCommand(new ComponentInfoCommandComponentRemove(owner & 0xFFFF, componentHandle));
                }
                finally {
                    this.componentsLock.unlock();
                }
            }
        } else {
            ClientInfo clientInfo = this.getClientInfo(owner);
            if (clientInfo != null) {
                HandleDataStore handleDataStore = this.clients;
                synchronized (handleDataStore) {
                    this.executeCommand(new ClientInfoCommandComponentRemove(owner, componentHandle));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addComponentOwner(int componentHandle, int owner) {
        if ((owner & 0xFF000000) == 0x1000000) {
            ComponentInfo componentInfo = this.getComponentInfo(owner);
            if (componentInfo == null) return;
            this.componentsLock.lock();
            try {
                if (componentInfo.getComponents().contains(componentHandle)) return;
                this.executeCommand(new ComponentInfoCommandComponentAdd(owner & 0xFFFF, componentHandle));
                return;
            }
            finally {
                this.componentsLock.unlock();
            }
        }
        ClientInfo clientInfo = this.getClientInfo(owner);
        if (clientInfo == null) return;
        HandleDataStore handleDataStore = this.clients;
        synchronized (handleDataStore) {
            if (clientInfo.getComponents().contains(componentHandle)) return;
            this.executeCommand(new ClientInfoCommandComponentAdd(owner, componentHandle));
            return;
        }
    }

    private void notifyClientLogin(ClientInfo clientInfo, final long timeStamp, final long executionId) {
        assert (clientInfo != null);
        ClientInfo[] admins = this.getAdministrators(clientInfo.getHandle());
        if (admins != null) {
            for (int i = 0; i < admins.length; ++i) {
                class ClientLoggedInTask
                extends DefaultGroupedRunnable {
                    private ClientInfo administratorInfo;
                    private ClientInfo clientInfo;

                    public ClientLoggedInTask(ClientInfo administratorInfo, ClientInfo clientInfo) {
                        this.administratorInfo = administratorInfo;
                        this.clientInfo = clientInfo;
                    }

                    @Override
                    public void run() {
                        try {
                            ((Administrator)this.administratorInfo.getClient()).clientLoggedIn(this.clientInfo, timeStamp, executionId);
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Administrator.clientLoggedIn' on " + this.administratorInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Administrator.clientLoggedIn' on " + this.administratorInfo + ".", re);
                        }
                    }
                }
                ClientLoggedInTask task = new ClientLoggedInTask(admins[i], clientInfo);
                if (admins[i].getClient() instanceof SynchronousAdministrator) {
                    task.run();
                    continue;
                }
                this.registerGroupedNotifyTaks(admins[i].getClient(), task);
            }
        }
    }

    private void notifyContainerLogin(ContainerInfo containerInfo, final long timeStamp, final long executionId) {
        assert (containerInfo != null);
        ClientInfo[] admins = this.getAdministrators(containerInfo.getHandle());
        if (admins != null) {
            for (int i = 0; i < admins.length; ++i) {
                class ContainerLoggedInTask
                extends DefaultGroupedRunnable {
                    private ClientInfo administratorInfo;
                    private ContainerInfo containerInfo;

                    public ContainerLoggedInTask(ClientInfo administratorInfo, ContainerInfo containerInfo) {
                        this.administratorInfo = administratorInfo;
                        this.containerInfo = containerInfo;
                    }

                    @Override
                    public void run() {
                        try {
                            ((Administrator)this.administratorInfo.getClient()).containerLoggedIn(this.containerInfo, timeStamp, executionId);
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Administrator.containerLoggedIn' on " + this.administratorInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Administrator.containerLoggedIn' on " + this.administratorInfo + ".", re);
                        }
                    }
                }
                ContainerLoggedInTask task = new ContainerLoggedInTask(admins[i], containerInfo);
                if (admins[i].getClient() instanceof SynchronousAdministrator) {
                    task.run();
                    continue;
                }
                this.registerGroupedNotifyTaks(admins[i].getClient(), task);
            }
        }
    }

    private void notifyClientLogout(ClientInfo clientInfo, final long timeStamp) {
        assert (clientInfo != null);
        ClientInfo[] admins = this.getAdministrators(clientInfo.getHandle());
        if (admins != null) {
            for (int i = 0; i < admins.length; ++i) {
                class ClientLoggedOutTask
                extends DefaultGroupedRunnable {
                    private ClientInfo administratorInfo;
                    private ClientInfo clientInfo;

                    public ClientLoggedOutTask(ClientInfo administratorInfo, ClientInfo clientInfo) {
                        this.administratorInfo = administratorInfo;
                        this.clientInfo = clientInfo;
                    }

                    @Override
                    public void run() {
                        try {
                            ((Administrator)this.administratorInfo.getClient()).clientLoggedOut(this.clientInfo.getHandle(), timeStamp);
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Administrator.clientLoggedOut' on " + this.administratorInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Administrator.clientLoggedOut' on " + this.administratorInfo + ".", re);
                        }
                    }
                }
                ClientLoggedOutTask task = new ClientLoggedOutTask(admins[i], clientInfo);
                if (admins[i].getClient() instanceof SynchronousAdministrator) {
                    task.run();
                    continue;
                }
                this.registerGroupedNotifyTaks(admins[i].getClient(), task);
            }
        }
    }

    private void notifyContainerLogout(ContainerInfo containerInfo, final long timeStamp) {
        assert (containerInfo != null);
        ClientInfo[] admins = this.getAdministrators(containerInfo.getHandle());
        if (admins != null) {
            for (int i = 0; i < admins.length; ++i) {
                class ContainerLoggedOutTask
                extends DefaultGroupedRunnable {
                    private ClientInfo administratorInfo;
                    private ContainerInfo containerInfo;

                    public ContainerLoggedOutTask(ClientInfo administratorInfo, ContainerInfo containerInfo) {
                        this.administratorInfo = administratorInfo;
                        this.containerInfo = containerInfo;
                    }

                    @Override
                    public void run() {
                        try {
                            ((Administrator)this.administratorInfo.getClient()).containerLoggedOut(this.containerInfo.getHandle(), timeStamp);
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Administrator.containerLoggedOut' on " + this.administratorInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Administrator.containerLoggedOut' on " + this.administratorInfo + ".", re);
                        }
                    }
                }
                ContainerLoggedOutTask task = new ContainerLoggedOutTask(admins[i], containerInfo);
                if (admins[i].getClient() instanceof SynchronousAdministrator) {
                    task.run();
                    continue;
                }
                this.registerGroupedNotifyTaks(admins[i].getClient(), task);
            }
        }
    }

    private void notifyContainerDisconnectShutdown(int code) {
        ContainerInfo[] acts = this.getContainersInfo();
        if (acts != null) {
            for (int i = 0; i < acts.length; ++i) {
                class ContainerDisconnectTask
                implements Runnable {
                    private ContainerInfo containerInfo;

                    public ContainerDisconnectTask(ContainerInfo containerInfo) {
                        this.containerInfo = containerInfo;
                    }

                    @Override
                    public void run() {
                        try {
                            this.containerInfo.getContainer().disconnect();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Container.disconnect' on " + this.containerInfo + ".", re);
                        }
                    }
                }
                class ContainerShutdownTask
                implements Runnable {
                    private int code;
                    private ContainerInfo containerInfo;

                    public ContainerShutdownTask(ContainerInfo containerInfo, int code) {
                        this.containerInfo = containerInfo;
                        this.code = code;
                    }

                    @Override
                    public void run() {
                        try {
                            this.containerInfo.getContainer().shutdown(this.code);
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Container.shutdown' on " + this.containerInfo + ".", re);
                        }
                    }
                }
                Runnable task = code == 0 ? new ContainerDisconnectTask(acts[i]) : new ContainerShutdownTask(acts[i], code);
                this.threadPool.execute(task);
            }
        }
    }

    private void notifyContainerShutdownOrder(ContainerInfo containerInfo, int[] handles) {
        class ContainerSetShutdownOrderTask
        implements Runnable {
            private int[] handles;
            private ContainerInfo containerInfo;

            public ContainerSetShutdownOrderTask(ContainerInfo containerInfo, int[] handles) {
                this.containerInfo = containerInfo;
                this.handles = handles;
            }

            @Override
            public void run() {
                try {
                    this.containerInfo.getContainer().set_component_shutdown_order(this.handles);
                }
                catch (RemoteException re) {
                    ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Container.set_component_shutdown_order' on " + this.containerInfo + ".", re);
                }
            }
        }
        this.threadPool.execute(new ContainerSetShutdownOrderTask(containerInfo, handles));
    }

    private void notifyClientDisconnectShutdown() {
        ClientInfo[] clts = this.getClientInfo();
        if (clts != null) {
            for (int i = 0; i < clts.length; ++i) {
                class ClientDisconnectTask
                extends DefaultGroupedRunnable {
                    private ClientInfo clientInfo;

                    public ClientDisconnectTask(ClientInfo clientInfo) {
                        this.clientInfo = clientInfo;
                    }

                    @Override
                    public void run() {
                        try {
                            this.clientInfo.getClient().disconnect();
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Client.disconnect' on " + this.clientInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Client.disconnect' on " + this.clientInfo + ".", re);
                        }
                    }
                }
                ClientDisconnectTask task = new ClientDisconnectTask(clts[i]);
                this.registerGroupedNotifyTaks(clts[i].getClient(), task);
            }
        }
    }

    private void notifyComponentRequested(int[] requestors, int[] components, final long timeStamp) {
        assert (requestors != null);
        assert (components != null);
        ClientInfo[] admins = this.getAdministrators(0);
        if (admins != null) {
            for (int i = 0; i < admins.length; ++i) {
                class ComponentRequestedTask
                extends DefaultGroupedRunnable {
                    private ClientInfo administratorInfo;
                    private int[] requestors;
                    private int[] components;

                    public ComponentRequestedTask(ClientInfo administratorInfo, int[] requestors, int[] components) {
                        this.administratorInfo = administratorInfo;
                        this.requestors = requestors;
                        this.components = components;
                    }

                    @Override
                    public void run() {
                        try {
                            ((Administrator)this.administratorInfo.getClient()).components_requested(this.requestors, this.components, timeStamp);
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Administrator.components_requested' on " + this.administratorInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Administrator.components_requested' on " + this.administratorInfo + ".", re);
                        }
                    }
                }
                ComponentRequestedTask task = new ComponentRequestedTask(admins[i], requestors, components);
                if (admins[i].getClient() instanceof SynchronousAdministrator) {
                    task.run();
                    continue;
                }
                this.registerGroupedNotifyTaks(admins[i].getClient(), task);
            }
        }
    }

    private void notifyComponentActivated(final ComponentInfo componentInfo, final long timeStamp, final long executionId) {
        assert (componentInfo != null);
        ClientInfo[] admins = this.getAdministrators(0);
        if (admins != null) {
            for (int i = 0; i < admins.length; ++i) {
                class ComponentActivatedTask
                extends DefaultGroupedRunnable {
                    private ClientInfo administratorInfo;

                    public ComponentActivatedTask(ClientInfo administratorInfo) {
                        this.administratorInfo = administratorInfo;
                    }

                    @Override
                    public void run() {
                        try {
                            ((Administrator)this.administratorInfo.getClient()).component_activated(componentInfo, timeStamp, executionId);
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Administrator.component_activated' on " + this.administratorInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Administrator.component_activated' on " + this.administratorInfo + ".", re);
                        }
                    }
                }
                ComponentActivatedTask task = new ComponentActivatedTask(admins[i]);
                if (admins[i].getClient() instanceof SynchronousAdministrator) {
                    task.run();
                    continue;
                }
                this.registerGroupedNotifyTaks(admins[i].getClient(), task);
            }
        }
    }

    private void notifyComponentDeactivated(final int handle, final long timeStamp) {
        assert (handle != 0);
        ClientInfo[] admins = this.getAdministrators(0);
        if (admins != null) {
            for (int i = 0; i < admins.length; ++i) {
                class ComponentDeactivatedTask
                extends DefaultGroupedRunnable {
                    private ClientInfo administratorInfo;

                    public ComponentDeactivatedTask(ClientInfo administratorInfo) {
                        this.administratorInfo = administratorInfo;
                    }

                    @Override
                    public void run() {
                        try {
                            ((Administrator)this.administratorInfo.getClient()).component_deactivated(handle, timeStamp);
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Administrator.component_deactivated' on " + this.administratorInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Administrator.component_deactivated' on " + this.administratorInfo + ".", re);
                        }
                    }
                }
                ComponentDeactivatedTask task = new ComponentDeactivatedTask(admins[i]);
                if (admins[i].getClient() instanceof SynchronousAdministrator) {
                    task.run();
                    continue;
                }
                this.registerGroupedNotifyTaks(admins[i].getClient(), task);
            }
        }
    }

    private void notifyComponentReleased(int[] requestors, int[] components, final long timeStamp) {
        assert (requestors != null);
        assert (components != null);
        ClientInfo[] admins = this.getAdministrators(0);
        if (admins != null) {
            for (int i = 0; i < admins.length; ++i) {
                class ComponentReleasedTask
                extends DefaultGroupedRunnable {
                    private ClientInfo administratorInfo;
                    private int[] requestors;
                    private int[] components;

                    public ComponentReleasedTask(ClientInfo administratorInfo, int[] requestors, int[] components) {
                        this.administratorInfo = administratorInfo;
                        this.requestors = requestors;
                        this.components = components;
                    }

                    @Override
                    public void run() {
                        try {
                            ((Administrator)this.administratorInfo.getClient()).components_released(this.requestors, this.components, timeStamp);
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Administrator.components_released' on " + this.administratorInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Administrator.components_released' on " + this.administratorInfo + ".", re);
                        }
                    }
                }
                ComponentReleasedTask task = new ComponentReleasedTask(admins[i], requestors, components);
                if (admins[i].getClient() instanceof SynchronousAdministrator) {
                    task.run();
                    continue;
                }
                this.registerGroupedNotifyTaks(admins[i].getClient(), task);
            }
        }
    }

    private void notifyComponentAvailable(int excludeClient, int[] clientHandles, ComponentInfo[] info) {
        assert (this.clients != null);
        assert (info != null);
        ClientInfo[] clients = this.getClients(excludeClient, clientHandles);
        if (clients != null) {
            for (int i = 0; i < clients.length; ++i) {
                class ComponentAvailableTask
                extends DefaultGroupedRunnable {
                    private ClientInfo clientInfo;
                    private ComponentInfo[] info;

                    public ComponentAvailableTask(ClientInfo clientInfo, ComponentInfo[] info) {
                        this.clientInfo = clientInfo;
                        this.info = info;
                    }

                    @Override
                    public void run() {
                        try {
                            this.clientInfo.getClient().components_available(this.info);
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Client.components_available' on " + this.clientInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Client.components_available' on " + this.clientInfo + ".", re);
                        }
                    }
                }
                ComponentAvailableTask task = new ComponentAvailableTask(clients[i], info);
                if (clients[i].getClient() instanceof SynchronousAdministrator) {
                    task.run();
                    continue;
                }
                this.registerGroupedNotifyTaks(clients[i].getClient(), task);
            }
        }
    }

    private void notifyComponentUnavailable(int excludeClient, int[] clientHandles, String[] names) {
        assert (this.clients != null);
        assert (names != null);
        ClientInfo[] clients = this.getClients(excludeClient, clientHandles);
        if (clients != null) {
            for (int i = 0; i < clients.length; ++i) {
                class ComponentUnavailableTask
                extends DefaultGroupedRunnable {
                    private ClientInfo clientInfo;
                    private String[] names;

                    public ComponentUnavailableTask(ClientInfo clientInfo, String[] names) {
                        this.clientInfo = clientInfo;
                        this.names = names;
                    }

                    @Override
                    public void run() {
                        try {
                            this.clientInfo.getClient().components_unavailable(this.names);
                        }
                        catch (RemoteTransientException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteTransientException caught while invoking 'Client.components_unavailable' on " + this.clientInfo + ".", re);
                            this.cancelAll();
                        }
                        catch (RemoteException re) {
                            ManagerImpl.this.logger.log(Level.WARNING, "RemoteException caught while invoking 'Client.components_unavailable' on " + this.clientInfo + ".", re);
                        }
                    }
                }
                ComponentUnavailableTask task = new ComponentUnavailableTask(clients[i], names);
                if (clients[i].getClient() instanceof SynchronousAdministrator) {
                    task.run();
                    continue;
                }
                this.registerGroupedNotifyTaks(clients[i].getClient(), task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(Client client, String message, MessageType messageType, short messageID) {
        assert (client != null);
        assert (message != null);
        assert (messageType != null);
        boolean newClient = false;
        Map<Client, LinkedList<ClientMessageTask>> map = this.clientMessageQueue;
        synchronized (map) {
            LinkedList<ClientMessageTask> list = this.clientMessageQueue.get(client);
            if (list == null) {
                list = new LinkedList();
                this.clientMessageQueue.put(client, list);
                newClient = true;
            }
            list.addLast(new ClientMessageTask(client, message, messageType, messageID));
        }
        if (newClient) {
            class ClientQueuMessageTask
            implements Runnable {
                private Client client;

                public ClientQueuMessageTask(Client client) {
                    this.client = client;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean moreMessages = true;
                    while (moreMessages) {
                        ClientMessageTask clientTask;
                        Map<Client, LinkedList<ClientMessageTask>> map = ManagerImpl.this.clientMessageQueue;
                        synchronized (map) {
                            LinkedList<ClientMessageTask> list = ManagerImpl.this.clientMessageQueue.get(this.client);
                            if (list == null) {
                                break;
                            }
                            clientTask = list.removeFirst();
                            boolean bl = moreMessages = !list.isEmpty();
                            if (!moreMessages) {
                                ManagerImpl.this.clientMessageQueue.remove(this.client);
                            }
                        }
                        if (clientTask == null) continue;
                        clientTask.run();
                    }
                }
            }
            this.threadPool.execute(new ClientQueuMessageTask(client));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void securityCheck(int id, int requiredRights) throws AcsJNoPermissionEx {
        try {
            AcsJNoPermissionEx npe;
            if (id != this.getHandle() && this.shutdown.get()) {
                AcsJNoPermissionEx npe2 = new AcsJNoPermissionEx();
                npe2.setID(HandleHelper.toString(id));
                npe2.setReason("Manager in shutdown state.");
                throw npe2;
            }
            int handle = id & 0xFFFF;
            int grantedRights = 0;
            boolean invalidHandle = true;
            switch (id & 0xFF000000) {
                case 0x4000000: {
                    Serializable info;
                    HandleDataStore handleDataStore = this.containers;
                    synchronized (handleDataStore) {
                        if (this.containers.isAllocated(handle)) {
                            info = (ContainerInfo)this.containers.get(handle);
                            if (((ContainerInfo)info).getHandle() == id) {
                                invalidHandle = false;
                            }
                            grantedRights = 0;
                        }
                        break;
                    }
                }
                case 0x2000000: {
                    Serializable info;
                    HandleDataStore handleDataStore = this.clients;
                    synchronized (handleDataStore) {
                        if (this.clients.isAllocated(handle)) {
                            info = (ClientInfo)this.clients.get(handle);
                            if (((ClientInfo)info).getHandle() == id) {
                                invalidHandle = false;
                            }
                            grantedRights = ((ClientInfo)info).getAccessRights();
                        }
                        break;
                    }
                }
                case 0x3000000: {
                    Serializable info;
                    HandleDataStore handleDataStore = this.administrators;
                    synchronized (handleDataStore) {
                        if (this.administrators.isAllocated(handle)) {
                            info = (ClientInfo)this.administrators.get(handle);
                            if (((ClientInfo)info).getHandle() == id) {
                                invalidHandle = false;
                            }
                            grantedRights = ((ClientInfo)info).getAccessRights();
                        }
                        break;
                    }
                }
                case 0x1000000: {
                    this.componentsLock.lock();
                    try {
                        if (!this.components.isAllocated(handle)) break;
                        ComponentInfo info = (ComponentInfo)this.components.get(handle);
                        if (info != null && info.getHandle() == id) {
                            invalidHandle = false;
                        }
                        grantedRights = 0x2000000;
                        break;
                    }
                    finally {
                        this.componentsLock.unlock();
                    }
                }
                case 0x5000000: {
                    invalidHandle = false;
                    grantedRights = 0xE000000;
                }
            }
            if (invalidHandle) {
                npe = new AcsJNoPermissionEx();
                npe.setID(HandleHelper.toString(id));
                HandleMonitorEntry hme = this.getHandleReleaseLog(id);
                if (hme != null) {
                    String timeISO = IsoDateFormat.formatDate((Date)new Date(hme.timestamp));
                    switch (hme.reason) {
                        case REMOVED: {
                            npe.setReason("Invalid handle, handle was properly removed at " + timeISO + ".");
                            break;
                        }
                        case TIMEOUT: {
                            npe.setReason("Invalid handle, handle was removed due to timeout at " + timeISO + ".");
                            break;
                        }
                        case DISAPPEARED: {
                            npe.setReason("Invalid handle, handle was removed due to client/container/component disappearing at " + timeISO + ".");
                        }
                    }
                } else if (this.enableHandleMonitoringDurationMins <= 0) {
                    npe.setReason("Invalid handle, handle was never known.");
                } else {
                    npe.setReason("Invalid handle, handle is not known for the last " + this.enableHandleMonitoringDurationMins + " minutes.");
                }
                throw npe;
            }
            if ((grantedRights & requiredRights) != requiredRights) {
                npe = new AcsJNoPermissionEx();
                npe.setID(HandleHelper.toString(id));
                npe.setReason("Insufficient rights.");
                throw npe;
            }
        }
        catch (AcsJNoPermissionEx ex) {
            this.logger.log((Level)AcsLogLevel.DELOUSE, "securityCheck fails with AcsJNoPermissionEx:", ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInfo getClientInfo(int id) {
        int handle = id & 0xFFFF;
        ClientInfo info = null;
        switch (id & 0xFF000000) {
            case 0x2000000: {
                HandleDataStore handleDataStore = this.clients;
                synchronized (handleDataStore) {
                    if (this.clients.isAllocated(handle)) {
                        info = (ClientInfo)this.clients.get(handle);
                    }
                    break;
                }
            }
            case 0x3000000: {
                HandleDataStore handleDataStore = this.administrators;
                synchronized (handleDataStore) {
                    if (this.administrators.isAllocated(handle)) {
                        info = (ClientInfo)this.administrators.get(handle);
                    }
                    break;
                }
            }
        }
        return info;
    }

    public ClientInfo noSyncGetClientInfo(int id) {
        int handle = id & 0xFFFF;
        ClientInfo info = null;
        switch (id & 0xFF000000) {
            case 0x2000000: {
                if (!this.clients.isAllocated(handle)) break;
                info = (ClientInfo)this.clients.get(handle);
                break;
            }
            case 0x3000000: {
                if (!this.administrators.isAllocated(handle)) break;
                info = (ClientInfo)this.administrators.get(handle);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerInfo getContainerInfo(int id) {
        int handle = id & 0xFFFF;
        ContainerInfo info = null;
        HandleDataStore handleDataStore = this.containers;
        synchronized (handleDataStore) {
            if (this.containers.isAllocated(handle)) {
                info = (ContainerInfo)this.containers.get(handle);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerInfo getContainerInfo(String name) {
        assert (name != null);
        ContainerInfo info = null;
        HandleDataStore handleDataStore = this.containers;
        synchronized (handleDataStore) {
            int h = this.containers.first();
            while (h != 0) {
                ContainerInfo containerInfo = (ContainerInfo)this.containers.get(h);
                if (name.equals(containerInfo.getName())) {
                    info = containerInfo;
                    break;
                }
                h = this.containers.next(h);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentInfo getComponentInfo(int id) {
        int handle = id & 0xFFFF;
        ComponentInfo info = null;
        this.componentsLock.lock();
        try {
            if (this.components.isAllocated(handle)) {
                info = (ComponentInfo)this.components.get(handle);
            }
        }
        finally {
            this.componentsLock.unlock();
        }
        return info;
    }

    private Component internalRequestComponent(int requestor, URI curl, StatusHolder status) throws AcsJCannotGetComponentEx {
        return this.internalRequestComponent(requestor, curl, status, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component internalRequestComponent(int requestor, URI curl, StatusHolder status, boolean activate) throws AcsJCannotGetComponentEx {
        String name = this.extractName(curl);
        try {
            this.checkCyclicDependency(requestor, name);
        }
        catch (AcsJCyclicDependencyDetectedEx e) {
            AcsJCannotGetComponentEx cgce = new AcsJCannotGetComponentEx((Throwable)e);
            cgce.setCURL(name);
            throw cgce;
        }
        long lockTimeoutMillis = this.getLockTimeout();
        String lockNotAcquiredCause = this.acquireSynchronizationObject(name, lockTimeoutMillis, "request component " + name);
        if (lockNotAcquiredCause == null) {
            boolean releaseRWLock = true;
            try {
                this.activationPendingRWLock.readLock().lock();
                ComponentInfo componentInfo = null;
                try {
                    componentInfo = this.internalNoSyncRequestComponent(requestor, name, null, null, null, -2147483646, status, activate);
                }
                catch (AcsJComponentSpecIncompatibleWithActiveComponentEx ciwace) {
                    status.setStatus(ComponentStatus.COMPONENT_NOT_ACTIVATED);
                    AcsJCannotGetComponentEx cgce = new AcsJCannotGetComponentEx((Throwable)ciwace);
                    cgce.setCURL(name);
                    throw cgce;
                }
                if (componentInfo != null) {
                    Component component = componentInfo.getComponent();
                    return component;
                }
                Component component = null;
                return component;
            }
            finally {
                if (releaseRWLock) {
                    this.activationPendingRWLock.readLock().unlock();
                }
                this.releaseSynchronizationObject(name);
            }
        }
        String msg = "Failed to obtain synchronization lock for component '" + name + "' within '" + lockTimeoutMillis + "' ms, possible deadlock; locked to '" + lockNotAcquiredCause + "'.";
        this.logger.fine(msg);
        NoResourcesException nre = new NoResourcesException(msg);
        throw nre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ComponentInfo> doCycleCheck(int requestor, int requested) {
        this.componentsLock.lock();
        try {
            ComponentInfo info = (ComponentInfo)this.components.get(requested & 0xFFFF);
            if (info == null) {
                ArrayList<ComponentInfo> arrayList = null;
                return arrayList;
            }
            if (requested == requestor) {
                ArrayList<ComponentInfo> list = new ArrayList<ComponentInfo>();
                list.add(info);
                ArrayList<ComponentInfo> arrayList = list;
                return arrayList;
            }
            int[] subcomponents = info.getComponents().toArray();
            for (int i = 0; i < subcomponents.length; ++i) {
                ArrayList<ComponentInfo> list = this.doCycleCheck(requestor, subcomponents[i]);
                if (list == null) continue;
                list.add(info);
                ArrayList<ComponentInfo> arrayList = list;
                return arrayList;
            }
        }
        finally {
            this.componentsLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCyclicDependency(int requestor, String requestedComponentName) throws AcsJCyclicDependencyDetectedEx {
        if ((requestor & 0xFF000000) != 0x1000000) {
            return;
        }
        ComponentInfo componentInfo = null;
        this.componentsLock.lock();
        try {
            ComponentInfo pendingComponentInfo;
            int h = this.components.first();
            while (h != 0) {
                ComponentInfo info = (ComponentInfo)this.components.get(h);
                if (info.getName().equals(requestedComponentName)) {
                    componentInfo = info;
                    break;
                }
                h = this.components.next(h);
            }
            Map<String, ComponentInfo> map = this.pendingActivations;
            synchronized (map) {
                pendingComponentInfo = this.pendingActivations.get(requestedComponentName);
            }
            if (componentInfo != null && pendingComponentInfo == null) {
                return;
            }
            if (componentInfo == null) {
                componentInfo = pendingComponentInfo;
            }
            if (componentInfo == null) {
                return;
            }
            ArrayList<ComponentInfo> pathList = this.doCycleCheck(requestor, componentInfo.getHandle());
            if (pathList == null) {
                return;
            }
            StringBuffer pathBuffer = new StringBuffer();
            for (int i = pathList.size() - 1; i >= 0; --i) {
                pathBuffer.append(pathList.get(i).getName()).append(" -> ");
            }
            pathBuffer.append(componentInfo.getName());
            AcsJCyclicDependencyDetectedEx cde = new AcsJCyclicDependencyDetectedEx();
            cde.setCURL(requestedComponentName);
            cde.setRequestor(requestor);
            throw cde;
        }
        finally {
            this.componentsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentInfo internalRequestComponent(int requestor, String name, String type, String code, String containerName, int keepAliveTime, StatusHolder status, boolean activate) throws AcsJCannotGetComponentEx, AcsJSyncLockFailedEx, AcsJComponentSpecIncompatibleWithActiveComponentEx {
        AcsJCannotGetComponentEx bcex = null;
        if (name == null) {
            bcex = new AcsJCannotGetComponentEx();
            this.logger.log(Level.SEVERE, "Cannot activate component with NULL name.", (Throwable)bcex);
            throw bcex;
        }
        if (status == null) {
            bcex = new AcsJCannotGetComponentEx();
            this.logger.log(Level.SEVERE, "Component " + name + " has NULL status.", (Throwable)bcex);
            throw bcex;
        }
        try {
            this.checkCyclicDependency(requestor, name);
        }
        catch (AcsJCyclicDependencyDetectedEx e) {
            AcsJCannotGetComponentEx cgce = new AcsJCannotGetComponentEx((Throwable)e);
            cgce.setCURL(name);
            throw cgce;
        }
        String lockNotAcquiredCause = this.acquireSynchronizationObject(name, this.getLockTimeout(), "request component " + name);
        if (lockNotAcquiredCause == null) {
            boolean releaseRWLock = true;
            try {
                this.activationPendingRWLock.readLock().lock();
                ComponentInfo componentInfo = this.internalNoSyncRequestComponent(requestor, name, type, code, containerName, keepAliveTime, status, activate);
                return componentInfo;
            }
            finally {
                if (releaseRWLock) {
                    this.activationPendingRWLock.readLock().unlock();
                }
                this.releaseSynchronizationObject(name);
            }
        }
        AcsJSyncLockFailedEx slfe = new AcsJSyncLockFailedEx();
        slfe.setCURL(name);
        slfe.setRequestor(requestor);
        slfe.setProperty("lockCause", lockNotAcquiredCause);
        throw slfe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentInfo internalNoSyncRequestComponent(int requestor, String name, String type, String code, String containerName, int keepAliveTime, StatusHolder status, boolean activate) throws AcsJCannotGetComponentEx, AcsJComponentSpecIncompatibleWithActiveComponentEx {
        boolean timeoutError;
        long activationTime;
        long executionId;
        ContainerInfo containerInfo;
        Container container;
        int h;
        ComponentInfo componentInfo;
        boolean reactivate;
        boolean isDynamicComponent;
        boolean isOtherDomainComponent;
        AcsJCannotGetComponentEx bcex;
        block70: {
            Manager remoteManager;
            block69: {
                ImplLang containerImplLang;
                String componentImplLang;
                block68: {
                    DAOProxy dao;
                    bcex = null;
                    if (name == null) {
                        bcex = new AcsJCannotGetComponentEx();
                        bcex.setReason("Cannot activate component with NULL name.");
                        throw bcex;
                    }
                    if (status == null) {
                        bcex = new AcsJCannotGetComponentEx();
                        bcex.setReason("Component " + name + " has NULL status.");
                        throw bcex;
                    }
                    isOtherDomainComponent = name.startsWith(CURL_URI_SCHEMA);
                    isDynamicComponent = isOtherDomainComponent ? false : type != null || code != null || containerName != null;
                    reactivate = false;
                    componentInfo = null;
                    this.componentsLock.lock();
                    try {
                        h = this.components.first();
                        while (h != 0) {
                            componentInfo = (ComponentInfo)this.components.get(h);
                            if (componentInfo.getName().equals(name)) {
                                Map<String, ComponentInfo> map = this.unavailableComponents;
                                synchronized (map) {
                                    if (this.unavailableComponents.containsKey(name)) {
                                        reactivate = true;
                                    }
                                }
                                ContainerInfo containerInfo2 = this.getContainerInfo(componentInfo.getContainer());
                                if (type != null && !componentInfo.getType().equals(type) || code != null && componentInfo.getCode() != null && !componentInfo.getCode().equals(code) || !reactivate && containerInfo2 != null && containerName != null && !containerInfo2.getName().equals(containerName)) {
                                    AcsJComponentSpecIncompatibleWithActiveComponentEx ciwace = new AcsJComponentSpecIncompatibleWithActiveComponentEx();
                                    ciwace.setCURL(componentInfo.getName());
                                    ciwace.setComponentType(componentInfo.getType());
                                    ciwace.setComponentCode(componentInfo.getCode() != null ? componentInfo.getCode() : "<unknown>");
                                    ciwace.setContainerName(containerInfo2 != null ? containerInfo2.getName() : "<none>");
                                    throw ciwace;
                                }
                                if (activate) {
                                    ComponentInfo requestorComponentInfo;
                                    if (reactivate) {
                                        break;
                                    }
                                    if (requestor != 0 && !componentInfo.getClients().contains(requestor)) {
                                        this.executeCommand(new ComponentCommandClientAdd(componentInfo.getHandle() & 0xFFFF, requestor));
                                    }
                                    if (requestor != this.getHandle() && requestor != 0) {
                                        this.addComponentOwner(componentInfo.getHandle(), requestor);
                                    }
                                    this.notifyComponentRequested(new int[]{requestor}, new int[]{componentInfo.getHandle()}, System.currentTimeMillis());
                                    if ((requestor & 0xFF000000) == 0x1000000 && (requestorComponentInfo = this.getComponentInfo(requestor)) != null && requestorComponentInfo.getContainerName() != null && requestorComponentInfo.getContainerName().equals(componentInfo.getContainerName())) {
                                        this.topologySortManager.notifyTopologyChange(componentInfo.getContainer());
                                    }
                                    status.setStatus(ComponentStatus.COMPONENT_ACTIVATED);
                                    requestorComponentInfo = componentInfo;
                                    return requestorComponentInfo;
                                }
                                if (reactivate) {
                                    status.setStatus(ComponentStatus.COMPONENT_NOT_ACTIVATED);
                                } else {
                                    status.setStatus(ComponentStatus.COMPONENT_ACTIVATED);
                                }
                                ComponentInfo requestorComponentInfo = componentInfo;
                                return requestorComponentInfo;
                            }
                            h = this.components.next(h);
                        }
                    }
                    finally {
                        this.componentsLock.unlock();
                    }
                    if (reactivate && componentInfo.isDynamic()) {
                        if (componentInfo.getType() == null || componentInfo.getCode() == null || componentInfo.getDynamicContainerName() == null) {
                            bcex = new AcsJCannotGetComponentEx();
                            bcex.setReason("Failed to reactivate dynamic component '" + componentInfo + "'.");
                            status.setStatus(ComponentStatus.COMPONENT_DOES_NO_EXIST);
                            throw bcex;
                        }
                        type = componentInfo.getType();
                        code = componentInfo.getCode();
                        containerName = componentInfo.getDynamicContainerName();
                        keepAliveTime = componentInfo.getKeepAliveTime();
                    } else if (!(isOtherDomainComponent || type != null && code != null && containerName != null)) {
                        dao = this.getComponentsDAOProxy();
                        if (dao == null || this.readStringCharacteristics(dao, name, true) == null) {
                            Object ref = this.lookup(name, null);
                            if (ref != null) {
                                status.setStatus(ComponentStatus.COMPONENT_ACTIVATED);
                                return new ComponentInfo(0, name, null, null, new ServiceComponent(ref));
                            }
                            bcex = new AcsJCannotGetComponentEx();
                            bcex.setReason("Component " + name + " not found in CDB.");
                            status.setStatus(ComponentStatus.COMPONENT_DOES_NO_EXIST);
                            throw bcex;
                        }
                        if (code == null && (code = this.readStringCharacteristics(dao, name + "/Code")) == null) {
                            bcex = new AcsJCannotGetComponentEx();
                            bcex.setReason("Misconfigured CDB, there is no code of component '" + name + "' defined.");
                            status.setStatus(ComponentStatus.COMPONENT_DOES_NO_EXIST);
                            throw bcex;
                        }
                        if (type == null && (type = this.readStringCharacteristics(dao, name + "/Type")) == null) {
                            bcex = new AcsJCannotGetComponentEx();
                            bcex.setReason("Misconfigured CDB, there is no type of component '" + name + "' defined.");
                            status.setStatus(ComponentStatus.COMPONENT_DOES_NO_EXIST);
                            throw bcex;
                        }
                        if (containerName == null && (containerName = this.readStringCharacteristics(dao, name + "/Container")) == null) {
                            bcex = new AcsJCannotGetComponentEx();
                            bcex.setReason("Misconfigured CDB, there is no container of component '" + name + "' defined.");
                            status.setStatus(ComponentStatus.COMPONENT_DOES_NO_EXIST);
                            throw bcex;
                        }
                        if (keepAliveTime == -2147483646) {
                            keepAliveTime = this.readLongCharacteristics(dao, name + "/KeepAliveTime", 0, true);
                        }
                    }
                    if (keepAliveTime == -2147483646) {
                        dao = this.getComponentsDAOProxy();
                        keepAliveTime = dao != null ? this.readLongCharacteristics(dao, name + "/KeepAliveTime", 0, true) : 0;
                    }
                    dao = this.getComponentsDAOProxy();
                    componentImplLang = null;
                    if (dao != null) {
                        componentImplLang = this.readStringCharacteristics(dao, name + "/ImplLang", true);
                    }
                    if (!activate) {
                        status.setStatus(ComponentStatus.COMPONENT_NOT_ACTIVATED);
                        return null;
                    }
                    container = null;
                    containerInfo = null;
                    remoteManager = null;
                    if (isOtherDomainComponent) {
                        try {
                            String domainName = CURLHelper.createURI(name).getAuthority();
                            remoteManager = this.getManagerForDomain(domainName);
                            if (remoteManager == null) {
                                bcex = new AcsJCannotGetComponentEx();
                                bcex.setReason("Failed to obtain manager for domain '" + domainName + "'.");
                                throw bcex;
                            }
                            break block68;
                        }
                        catch (Throwable th) {
                            bcex = new AcsJCannotGetComponentEx(th);
                            bcex.setReason("Failed to obtain non-local manager required by component '" + name + "'.'");
                            status.setStatus(ComponentStatus.COMPONENT_NOT_ACTIVATED);
                            throw bcex;
                        }
                    }
                    containerInfo = this.getContainerInfo(containerName);
                    if (containerInfo == null) {
                        containerInfo = this.startUpContainer(containerName);
                    }
                    if (containerInfo != null) {
                        this.checkContainerShutdownState(containerInfo);
                        container = containerInfo.getContainer();
                    }
                    if (container == null) {
                        bcex = new AcsJCannotGetComponentEx();
                        bcex.setReason("Container '" + containerName + "' required by component '" + name + "' is not logged in.");
                        status.setStatus(ComponentStatus.COMPONENT_NOT_ACTIVATED);
                        throw bcex;
                    }
                }
                if ((containerImplLang = containerInfo.getImplLang()) != null && containerImplLang != ImplLang.not_specified && componentImplLang != null && ImplLang.fromString(componentImplLang) != containerImplLang) {
                    AcsJCannotGetComponentEx af = new AcsJCannotGetComponentEx();
                    af.setReason("Component and container implementation language do not match (" + componentImplLang + " != " + containerImplLang.name() + ")");
                    throw af;
                }
                this.componentsLock.lock();
                try {
                    if (!reactivate) {
                        Integer objHandle = (Integer)this.executeCommand(new ComponentCommandPreallocate());
                        int n = h = objHandle == null ? 0 : objHandle;
                    }
                    if (h == 0) {
                        AcsJCannotGetComponentEx af = new AcsJCannotGetComponentEx();
                        af.setReason("Preallocation of new handle failed, too many registered components.");
                        throw af;
                    }
                    if (reactivate) break block69;
                    ComponentInfo data = new ComponentInfo(h | 0x1000000, name, type, code, null);
                    data.setKeepAliveTime(keepAliveTime);
                    this.executeCommand(new ComponentCommandSet(h, data));
                    Map<String, ComponentInfo> map = this.pendingActivations;
                    synchronized (map) {
                        this.pendingActivations.put(name, data);
                    }
                    if ((requestor & 0xFF000000) == 0x1000000) {
                        this.addComponentOwner(data.getHandle(), requestor);
                    }
                }
                finally {
                    this.componentsLock.unlock();
                }
            }
            componentInfo = null;
            executionId = 0L;
            activationTime = 0L;
            timeoutError = false;
            if (isOtherDomainComponent) {
                try {
                    ComponentInfo[] infos;
                    URI curlName = CURLHelper.createURI(name);
                    StatusHolder statusHolder = new StatusHolder();
                    remoteManager.getComponent(0x5555555, curlName, true, statusHolder);
                    activationTime = System.currentTimeMillis();
                    if (statusHolder.getStatus() != ComponentStatus.COMPONENT_ACTIVATED) break block70;
                    String localName = curlName.getPath();
                    if (localName.charAt(0) == '/') {
                        localName = localName.substring(1);
                    }
                    if ((infos = remoteManager.getComponentInfo(0x5555555, new int[0], localName, "*", true)) != null && infos.length == 1) {
                        componentInfo = infos[0];
                        componentInfo.setContainerName(CURL_URI_SCHEMA + curlName.getAuthority() + "/" + componentInfo.getContainerName());
                    }
                }
                catch (Throwable ex) {
                    bcex = new AcsJCannotGetComponentEx(ex);
                    bcex.setReason("Failed to obtain component '" + name + "' from remote manager.");
                    timeoutError = ex instanceof TimeoutRemoteException;
                }
            } else {
                String handleReadable = HandleHelper.toString(h | 0x1000000);
                this.logger.log(Level.INFO, "Activating component '" + name + "' (" + handleReadable + ") on container '" + containerInfo.getName() + "'.");
                boolean callSyncActivate = System.getProperties().containsKey(NAME_SYNC_ACTIVATE);
                if (callSyncActivate) {
                    try {
                        executionId = this.generateExecutionId();
                        activationTime = System.currentTimeMillis();
                        componentInfo = container.activate_component(h | 0x1000000, executionId, name, code, type);
                    }
                    catch (Throwable ex) {
                        bcex = new AcsJCannotGetComponentEx(ex);
                        bcex.setReason("Failed to activate component '" + name + "' on container '" + containerName + "'.");
                        timeoutError = ex instanceof TimeoutRemoteException;
                    }
                } else {
                    try {
                        ComponentInfo ret;
                        executionId = this.generateExecutionId();
                        activationTime = System.currentTimeMillis();
                        ComponentInfoCompletionCallbackImpl callback = new ComponentInfoCompletionCallbackImpl(requestor, name, type, code, containerName, keepAliveTime, status, isOtherDomainComponent, isDynamicComponent, h, reactivate, container, containerInfo, executionId, activationTime);
                        this.addPendingContainerAsyncRequest(containerName, callback);
                        try {
                            container.activate_component_async(h | 0x1000000, executionId, name, code, type, callback);
                        }
                        catch (Throwable t) {
                            this.removePendingContainerAsyncRequest(containerName, callback);
                            throw t;
                        }
                        this.logger.log((Level)AcsLogLevel.DELOUSE, "Asynchronous activation of component '" + name + "' (" + handleReadable + ") is running on container '" + containerInfo.getName() + "'.");
                        try {
                            ret = callback.waitUntilActivated(this.getLockTimeout());
                        }
                        catch (Throwable t) {
                            this.removePendingContainerAsyncRequest(containerName, callback);
                            throw t;
                        }
                        this.logger.log((Level)AcsLogLevel.DELOUSE, "Asynchronous activation of component '" + name + "' (" + handleReadable + ") has finished on container '" + containerInfo.getName() + "'.");
                        return ret;
                    }
                    catch (Throwable ex) {
                        bcex = new AcsJCannotGetComponentEx(ex);
                        bcex.setReason("Failed to activate component '" + name + "' on container '" + containerName + "'.");
                        throw bcex;
                    }
                }
            }
        }
        return this.internalNoSyncRequestComponentPhase2(requestor, name, type, code, containerName, keepAliveTime, status, bcex, isOtherDomainComponent, isDynamicComponent, h, reactivate, componentInfo, container, containerInfo, executionId, activationTime, timeoutError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingContainerAsyncRequest(String containerName, Container.ComponentInfoCompletionCallback callback) {
        Map<String, Deque<Container.ComponentInfoCompletionCallback>> map = this.pendingContainerAsyncRequests;
        synchronized (map) {
            Deque<Container.ComponentInfoCompletionCallback> list = this.pendingContainerAsyncRequests.get(containerName);
            if (list == null) {
                list = new ArrayDeque<Container.ComponentInfoCompletionCallback>();
                this.pendingContainerAsyncRequests.put(containerName, list);
            }
            list.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePendingContainerAsyncRequest(String containerName, Container.ComponentInfoCompletionCallback callback) {
        Map<String, Deque<Container.ComponentInfoCompletionCallback>> map = this.pendingContainerAsyncRequests;
        synchronized (map) {
            Deque<Container.ComponentInfoCompletionCallback> list = this.pendingContainerAsyncRequests.get(containerName);
            if (list == null) {
                return false;
            }
            boolean removed = list.remove(callback);
            if (list.size() == 0) {
                this.pendingContainerAsyncRequests.remove(containerName);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPendingContainerAsyncRequestWithException(String containerName, Throwable cause) {
        Map<String, Deque<Container.ComponentInfoCompletionCallback>> map = this.pendingContainerAsyncRequests;
        synchronized (map) {
            Deque<Container.ComponentInfoCompletionCallback> list = this.pendingContainerAsyncRequests.get(containerName);
            if (list == null) {
                return;
            }
            while (!list.isEmpty()) {
                try {
                    list.getLast().failed(null, cause);
                }
                catch (Throwable th) {
                    new AcsJUnexpectedExceptionEx(th).log(this.logger);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentInfo internalNoSyncRequestComponentPhase2(int requestor, String name, String type, String code, String containerName, int keepAliveTime, StatusHolder status, AcsJCannotGetComponentEx bcex, boolean isOtherDomainComponent, boolean isDynamicComponent, int h, boolean reactivate, ComponentInfo componentInfo, Container container, ContainerInfo containerInfo, long executionId, long activationTime, boolean timeoutError) throws AcsJCannotGetComponentEx {
        int[] clients;
        if ((requestor & 0xFF000000) == 0x1000000) {
            this.removeComponentOwner(h | 0x1000000, requestor);
        }
        Map<String, ComponentInfo> map = this.pendingActivations;
        synchronized (map) {
            this.pendingActivations.remove(name);
        }
        if (componentInfo == null || componentInfo.getHandle() == 0 || componentInfo.getComponent() == null) {
            if (bcex == null) {
                this.logger.log(Level.SEVERE, "Failed to activate component '" + name + "' (" + HandleHelper.toString(h | 0x1000000) + ").");
            } else {
                bcex.setReason("Failed to activate component '" + name + "' (" + HandleHelper.toString(h | 0x1000000) + ").");
            }
            this.componentsLock.lock();
            try {
                if (!reactivate) {
                    this.executeCommand(new ComponentCommandDeallocate(h, h | 0x1000000, timeoutError ? WhyUnloadedReason.TIMEOUT : WhyUnloadedReason.REMOVED, true));
                }
            }
            finally {
                this.componentsLock.unlock();
            }
            status.setStatus(ComponentStatus.COMPONENT_NOT_ACTIVATED);
            if (bcex == null) {
                return null;
            }
            throw bcex;
        }
        this.logger.log(Level.INFO, "Component '" + name + "' (" + HandleHelper.toString(h | 0x1000000) + ") activated successfully.");
        if (!isOtherDomainComponent && !componentInfo.getComponent().doesImplement(type)) {
            this.logger.log(Level.SEVERE, "Activated component '" + name + "' does not implement specified type '" + type + "'.");
        }
        if (isOtherDomainComponent) {
            componentInfo.setHandle(h | 0x1000000);
            componentInfo.setClients(new IntArray());
            componentInfo.setComponents(new IntArray(0));
            componentInfo.setContainer(0);
            type = componentInfo.getType();
            code = componentInfo.getCode();
        }
        this.componentsLock.lock();
        try {
            if (componentInfo.getHandle() != (h | 0x1000000)) {
                int componentHandle = componentInfo.getHandle() & 0xFFFF;
                if (this.components.isAllocated(componentHandle)) {
                    if (!reactivate) {
                        this.executeCommand(new ComponentCommandDeallocate(h, componentInfo.getHandle(), WhyUnloadedReason.REMOVED, true));
                    }
                    bcex = new AcsJCannotGetComponentEx();
                    bcex.setReason("Container '" + containerName + "' returned another '" + name + "' component handle than given, failed to fix handle since returned handle is already allocated.");
                    this.logger.log(Level.SEVERE, "Container '" + containerName + "' returned another '" + name + "' component handle than given, failed to fix handle since returned handle is already allocated.", (Throwable)bcex);
                    status.setStatus(ComponentStatus.COMPONENT_ACTIVATED);
                    throw bcex;
                }
                ComponentInfo existingData = null;
                if (!reactivate) {
                    this.executeCommand(new ComponentCommandDeallocate(h, componentInfo.getHandle(), WhyUnloadedReason.REPLACED, true));
                } else {
                    existingData = (ComponentInfo)this.components.get(h);
                    this.executeCommand(new ComponentCommandDeallocate(h, componentInfo.getHandle(), WhyUnloadedReason.REPLACED));
                }
                Integer objHandle = (Integer)this.executeCommand(new ComponentCommandAllocateHandle(componentHandle, true));
                if (objHandle == null || (h = objHandle.intValue()) == 0) {
                    bcex = new AcsJCannotGetComponentEx();
                    bcex.setReason("Container '" + containerName + "' returned another '" + name + "' component handle than given, failed to fix handle due to handle relocation failure.");
                    this.logger.log(Level.SEVERE, "Container '" + containerName + "' returned another '" + name + "' component handle than given, failed to fix handle due to handle relocation failure.", (Throwable)bcex);
                    status.setStatus(ComponentStatus.COMPONENT_ACTIVATED);
                    throw bcex;
                }
                if (existingData != null) {
                    this.executeCommand(new ComponentCommandSet(h, existingData));
                }
                this.logger.log(Level.WARNING, "Container '" + containerName + "' returned another '" + name + "' component handle than given, handle fixed.");
            }
            ComponentInfo existingData = (ComponentInfo)this.components.get(h);
            ComponentInfo data = new ComponentInfo(componentInfo.getHandle(), name, type, code, componentInfo.getComponent());
            if (existingData != null) {
                data.setClients(existingData.getClients());
                data.setComponents(existingData.getComponents());
            }
            if (requestor != 0 && !data.getClients().contains(requestor)) {
                data.getClients().add(requestor);
            }
            if (keepAliveTime <= -1 && !data.getClients().contains(this.getHandle())) {
                data.getClients().add(this.getHandle());
            }
            data.setKeepAliveTime(keepAliveTime);
            if (isOtherDomainComponent) {
                data.setContainer(0);
                data.setContainerName(componentInfo.getContainerName());
            } else {
                data.setContainer(containerInfo.getHandle());
                data.setContainerName(containerInfo.getName());
            }
            data.setAccessRights(0);
            data.setInterfaces(componentInfo.getInterfaces());
            if (isDynamicComponent) {
                data.setDynamic(true);
                data.setDynamicContainerName(containerName);
            }
            this.executeCommand(new ComponentCommandSet(h, data));
            if (!reactivate) {
                this.executeCommand(new ComponentCommandAckAlloc(h));
            }
            componentInfo = data;
            clients = componentInfo.getClients().toArray();
        }
        finally {
            this.componentsLock.unlock();
        }
        if (!isOtherDomainComponent) {
            if ((requestor & 0xFF000000) == 0x1000000) {
                this.addComponentOwner(componentInfo.getHandle(), requestor);
            }
            boolean constructed = false;
            try {
                componentInfo.getComponent().construct();
                constructed = true;
            }
            catch (Throwable ex) {
                bcex = new AcsJCannotGetComponentEx(ex);
                bcex.setReason("Failed to construct component '" + name + "', exception caught when invoking 'construct()' method.");
            }
            if ((requestor & 0xFF000000) == 0x1000000) {
                this.removeComponentOwner(componentInfo.getHandle(), requestor);
            }
            if (!constructed) {
                this.componentsLock.lock();
                try {
                    if (!reactivate) {
                        this.executeCommand(new ComponentCommandDeallocate(h, componentInfo.getHandle(), WhyUnloadedReason.REMOVED));
                    }
                    try {
                        container.deactivate_component(componentInfo.getHandle());
                    }
                    catch (Exception ex) {
                        bcex = new AcsJCannotGetComponentEx((Throwable)ex);
                        bcex.setReason("Failed to deactivate component '" + name + "' on container '" + containerName + "'.");
                    }
                    status.setStatus(ComponentStatus.COMPONENT_NOT_ACTIVATED);
                    throw bcex;
                }
                catch (Throwable throwable) {
                    this.componentsLock.unlock();
                    throw throwable;
                }
            }
        }
        if (requestor != this.getHandle() && requestor != 0) {
            this.addComponentOwner(componentInfo.getHandle(), requestor);
        }
        if (!isOtherDomainComponent) {
            IntArray intArray = containerInfo.getComponents();
            synchronized (intArray) {
                if (!containerInfo.getComponents().contains(componentInfo.getHandle())) {
                    this.executeCommand(new ContainerInfoCommandComponentAdd(containerInfo.getHandle() & 0xFFFF, componentInfo.getHandle()));
                }
            }
        }
        if (reactivate) {
            Map<String, ComponentInfo> map2 = this.unavailableComponents;
            synchronized (map2) {
                this.executeCommand(new UnavailableComponentCommandRemove(name));
            }
        }
        if (!isOtherDomainComponent) {
            this.notifyComponentActivated(componentInfo, activationTime, executionId);
        }
        if (reactivate) {
            this.notifyComponentAvailable(requestor, clients, new ComponentInfo[]{componentInfo});
        }
        this.notifyComponentRequested(new int[]{requestor}, new int[]{componentInfo.getHandle()}, activationTime);
        if (reactivate) {
            this.logger.log(Level.FINE, "Component '" + name + "' (" + HandleHelper.toString(componentInfo.getHandle()) + ") reactivated.");
        } else {
            this.logger.log(Level.FINE, "Component '" + name + "' (" + HandleHelper.toString(componentInfo.getHandle()) + ") activated.");
        }
        if (containerInfo != null) {
            this.topologySortManager.notifyTopologyChange(containerInfo.getHandle());
        }
        status.setStatus(ComponentStatus.COMPONENT_ACTIVATED);
        return componentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleaseComponentResult internalReleaseComponent(int owner, URI curl, boolean force) throws AcsJNoPermissionEx, AcsJBadParameterEx {
        int h = 0;
        String name = this.extractName(curl);
        this.componentsLock.lock();
        try {
            h = this.components.first();
            while (h != 0) {
                ComponentInfo componentInfo = (ComponentInfo)this.components.get(h);
                if (componentInfo.getName().equals(name)) {
                    h = componentInfo.getHandle();
                    break;
                }
                h = this.components.next(h);
            }
        }
        finally {
            this.componentsLock.unlock();
        }
        if (h != 0) {
            return this.internalReleaseComponent(owner, h, force);
        }
        return new ReleaseComponentResult(0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDeactivateComponent(String name) {
        String lockNotAcquiredCause = this.acquireSynchronizationObject(name, this.lockTimeout, "deactivate component " + name);
        if (lockNotAcquiredCause == null) {
            boolean releaseRWLock = false;
            try {
                ComponentInfo componentInfo = null;
                this.componentsLock.lock();
                try {
                    int h = this.components.first();
                    while (h != 0) {
                        ComponentInfo ci = (ComponentInfo)this.components.get(h);
                        if (ci.getName().equals(name)) {
                            if (ci.getClients().size() > 0) {
                                return;
                            }
                            componentInfo = ci;
                            break;
                        }
                        h = this.components.next(h);
                    }
                }
                finally {
                    this.componentsLock.unlock();
                }
                if (componentInfo == null) {
                    return;
                }
                releaseRWLock = true;
                this.activationPendingRWLock.readLock().lock();
                try {
                    this.internalNoSyncDeactivateComponent(componentInfo);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            finally {
                if (releaseRWLock) {
                    this.activationPendingRWLock.readLock().unlock();
                }
                this.releaseSynchronizationObject(name);
            }
        } else {
            NoResourcesException nre = new NoResourcesException("Failed to obtain synchronization lock for component '" + name + "', possible deadlock; locked to '" + lockNotAcquiredCause + "'.");
            throw nre;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleaseComponentResult internalReleaseComponent(int owner, int h, boolean force) throws AcsJNoPermissionEx, AcsJBadParameterEx {
        String name = null;
        this.componentsLock.lock();
        try {
            int handle = h & 0xFFFF;
            ComponentInfo componentInfo = null;
            if (this.components.isAllocated(handle)) {
                componentInfo = (ComponentInfo)this.components.get(handle);
            }
            if (componentInfo == null) {
                AcsJBadParameterEx ex = new AcsJBadParameterEx();
                ex.setParameter("componentInfo");
                ex.setParameterValue("null");
                throw ex;
            }
            if (componentInfo.getHandle() != h) {
                AcsJBadParameterEx ex = new AcsJBadParameterEx();
                ex.setParameter("h");
                throw ex;
            }
            name = componentInfo.getName();
        }
        finally {
            this.componentsLock.unlock();
        }
        String lockNotAcquiredCause = this.acquireSynchronizationObject(name, this.lockTimeout, "release component " + name);
        if (lockNotAcquiredCause == null) {
            boolean releaseRWLock = true;
            try {
                this.activationPendingRWLock.readLock().lock();
                ReleaseComponentResult releaseComponentResult = this.internalNoSyncReleaseComponent(owner, h, force);
                return releaseComponentResult;
            }
            finally {
                if (releaseRWLock) {
                    this.activationPendingRWLock.readLock().unlock();
                }
                this.releaseSynchronizationObject(name);
            }
        }
        NoResourcesException nre = new NoResourcesException("Failed to obtain synchronization lock for component '" + name + "', possible deadlock; locked to '" + lockNotAcquiredCause + "'.");
        throw nre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleaseComponentResult internalNoSyncReleaseComponent(int owner, int h, boolean force) throws AcsJNoPermissionEx {
        ComponentInfo ownerComponentInfo;
        ComponentInfo componentInfo;
        int owners;
        block27: {
            int handle = h & 0xFFFF;
            owners = 0;
            componentInfo = null;
            this.componentsLock.lock();
            try {
                if (this.components.isAllocated(handle)) {
                    componentInfo = (ComponentInfo)this.components.get(handle);
                }
                if (componentInfo == null || componentInfo.getHandle() != h) {
                    BadParametersException af = new BadParametersException("Invalid component handle.");
                    throw af;
                }
                if (!componentInfo.getClients().contains(owner)) {
                    if (!force) {
                        AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
                        npe.setReason("Unregistering component that client does not own.");
                        npe.setID(HandleHelper.toString(owner));
                        npe.setProtectedResource(componentInfo.getName());
                        throw npe;
                    }
                } else {
                    this.executeCommand(new ComponentCommandClientRemove(componentInfo.getHandle() & 0xFFFF, owner));
                    if (owner != this.getHandle()) {
                        this.removeComponentOwner(componentInfo.getHandle(), owner);
                    }
                }
                if ((owners = componentInfo.getClients().size()) != 0) break block27;
                Map<String, ComponentInfo> npe = this.unavailableComponents;
                synchronized (npe) {
                    if (this.unavailableComponents.containsKey(componentInfo.getName())) {
                        this.executeCommand(new UnavailableComponentCommandRemove(componentInfo.getName()));
                    }
                }
            }
            finally {
                this.componentsLock.unlock();
            }
        }
        ReleaseComponentResult result = new ReleaseComponentResult(owners, null);
        if (force) {
            try {
                this.internalNoSyncDeactivateComponent(componentInfo);
            }
            catch (Throwable th) {
                result.exception = th;
            }
        } else if (owners == 0) {
            int keepAliveTime = 0;
            String name = componentInfo.getName();
            boolean isOtherDomainComponent = name.startsWith(CURL_URI_SCHEMA);
            if (!isOtherDomainComponent && (keepAliveTime = componentInfo.getKeepAliveTime()) == -2147483646) {
                DAOProxy dao = this.getComponentsDAOProxy();
                keepAliveTime = dao != null ? this.readLongCharacteristics(dao, name + "/KeepAliveTime", 0, true) : 0;
            }
            if (keepAliveTime == 0) {
                try {
                    this.internalNoSyncDeactivateComponent(componentInfo);
                }
                catch (Throwable th) {
                    result.exception = th;
                }
            } else if (keepAliveTime > 0) {
                this.delayedDeactivationTask.schedule((TimerTask)new DeactivateComponentTask(name), keepAliveTime * 1000);
            }
        }
        this.notifyComponentReleased(new int[]{owner}, new int[]{h}, System.currentTimeMillis());
        this.logger.log(Level.FINE, "Component '" + componentInfo.getName() + "' (" + HandleHelper.toString(componentInfo.getHandle()) + ") released.");
        if (owners == 0 || force) {
            this.topologySortManager.notifyTopologyChange(componentInfo.getContainer());
        } else if ((owner & 0xFF000000) == 0x1000000 && (ownerComponentInfo = this.getComponentInfo(owner)) != null && ownerComponentInfo.getContainerName() != null && ownerComponentInfo.getContainerName().equals(componentInfo.getContainerName())) {
            this.topologySortManager.notifyTopologyChange(componentInfo.getContainer());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalNoSyncDeactivateComponent(ComponentInfo componentInfo) throws Throwable {
        block42: {
            int handle = componentInfo.getHandle() & 0xFFFF;
            int owners = componentInfo.getClients().size();
            try {
                String name = componentInfo.getName();
                boolean isOtherDomainComponent = name.startsWith(CURL_URI_SCHEMA);
                if (isOtherDomainComponent) {
                    Manager remoteManager = null;
                    try {
                        String domainName = CURLHelper.createURI(name).getAuthority();
                        remoteManager = this.getManagerForDomain(domainName);
                        if (remoteManager == null) {
                            throw new CoreException("Failed to obtain manager for domain '" + domainName + "'.");
                        }
                    }
                    catch (Throwable th) {
                        this.logger.log(Level.WARNING, "Failed to obtain non-local manager required by component '" + name + "'.", th);
                        throw th;
                    }
                    try {
                        URI curlName = CURLHelper.createURI(name);
                        remoteManager.releaseComponent(0x5555555, curlName);
                        break block42;
                    }
                    catch (Throwable th) {
                        this.logger.log(Level.WARNING, "Failed to release component '" + componentInfo.getName() + "' on remote manager.'", th);
                        throw th;
                    }
                }
                Container container = null;
                ContainerInfo containerInfo = null;
                int containerHandle = componentInfo.getContainer();
                if (containerHandle != 0) {
                    containerInfo = this.getContainerInfo(containerHandle);
                    if (containerInfo != null) {
                        IntArray intArray = containerInfo.getComponents();
                        synchronized (intArray) {
                            if (containerInfo.getComponents().contains(componentInfo.getHandle())) {
                                this.executeCommand(new ContainerInfoCommandComponentRemove(containerInfo.getHandle() & 0xFFFF, componentInfo.getHandle()));
                            }
                        }
                        container = containerInfo.getContainer();
                    }
                    if (container == null) {
                        String containerName = containerInfo != null ? containerInfo.getName() : HandleHelper.toString(componentInfo.getContainer());
                        this.logger.log(Level.WARNING, "Container '" + containerName + "' required by component '" + componentInfo.getName() + "' is not logged in.");
                    }
                }
                if (container == null) break block42;
                this.logger.log(Level.INFO, "Deactivating component '" + componentInfo.getName() + "' (" + HandleHelper.toString(componentInfo.getHandle()) + ") on container '" + containerInfo.getName() + "'.");
                try {
                    componentInfo.getComponent().destruct();
                }
                catch (Throwable ex) {
                    RemoteException re = new RemoteException("Failed to destruct component '" + componentInfo.getName() + "', exception caught when invoking 'destruct()' method.", ex);
                    this.logger.log(Level.SEVERE, re.getMessage(), re);
                    throw ex;
                }
                long deactivationTime = 0L;
                try {
                    container.deactivate_component(componentInfo.getHandle());
                    deactivationTime = System.currentTimeMillis();
                }
                catch (AcsJException aex) {
                    deactivationTime = System.currentTimeMillis();
                    this.logger.log(Level.SEVERE, aex.getMessage(), aex);
                    throw aex;
                }
                catch (Throwable ex) {
                    deactivationTime = System.currentTimeMillis();
                    RemoteException re = new RemoteException("Failed to deactivate component '" + componentInfo.getName() + "' (" + HandleHelper.toString(componentInfo.getHandle()) + ") on container '" + containerInfo.getName() + "'.", ex);
                    this.logger.log(Level.SEVERE, re.getMessage(), re);
                    throw ex;
                }
                finally {
                    if (deactivationTime != 0L) {
                        this.notifyComponentDeactivated(componentInfo.getHandle(), deactivationTime);
                    }
                    this.conditionalShutdownContainer(containerInfo);
                }
            }
            finally {
                if (owners == 0) {
                    this.componentsLock.lock();
                    try {
                        this.executeCommand(new ComponentCommandDeallocate(handle, componentInfo.getHandle(), WhyUnloadedReason.REMOVED));
                    }
                    finally {
                        this.componentsLock.unlock();
                    }
                }
                this.logger.log(Level.INFO, "Component '" + componentInfo.getName() + "' (" + HandleHelper.toString(componentInfo.getHandle()) + ") deactivated.");
                int[] subcomponents = null;
                IntArray intArray = componentInfo.getComponents();
                synchronized (intArray) {
                    if (componentInfo.getComponents().size() > 0) {
                        IntArray toCleanupList = new IntArray();
                        IntArray comps = componentInfo.getComponents();
                        for (int i = 0; i < comps.size(); ++i) {
                            if (!this.components.isAllocated(comps.get(i) & 0xFFFF)) continue;
                            toCleanupList.add(comps.get(i));
                        }
                        if (toCleanupList.size() > 0) {
                            subcomponents = toCleanupList.toArray();
                        }
                    }
                }
                if (subcomponents != null && subcomponents.length > 0) {
                    new ReleaseComponentTask(componentInfo.getHandle(), subcomponents).run();
                }
                if (owners > 0) {
                    this.makeUnavailable(componentInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerInfo startUpContainer(String containerName) {
        String LOCK_NAME = "container-" + containerName;
        String lockNotAcquiredCause = this.acquireSynchronizationObject(LOCK_NAME, this.lockTimeout, "start-up container " + containerName);
        if (lockNotAcquiredCause == null) {
            try {
                ContainerInfo info = this.getContainerInfo(containerName);
                if (info != null) {
                    ContainerInfo containerInfo = info;
                    return containerInfo;
                }
                ContainerInfo containerInfo = this.internalNoSyncStartUpContainer(containerName);
                return containerInfo;
            }
            finally {
                this.releaseSynchronizationObject(LOCK_NAME);
            }
        }
        NoResourcesException nre = new NoResourcesException("Failed to obtain synchronization lock for container '" + containerName + "', possible deadlock; locked to '" + lockNotAcquiredCause + "'.");
        throw nre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContainerInfo internalNoSyncStartUpContainer(String containerName) {
        String impLang;
        DAOProxy dao = this.getContainersDAOProxy();
        if (dao == null) {
            return null;
        }
        String startOnDemand = this.readStringCharacteristics(dao, containerName + "/DeployInfo/StartOnDemand", true);
        if (startOnDemand == null || !startOnDemand.equalsIgnoreCase("TRUE")) {
            return null;
        }
        String host = this.readStringCharacteristics(dao, containerName + "/DeployInfo/Host", true);
        if (host == null) {
            return null;
        }
        Object flags = this.readStringCharacteristics(dao, containerName + "/DeployInfo/Flags", true);
        if (flags == null) {
            flags = DEFAULT_DOMAIN;
        }
        if ((impLang = this.readStringCharacteristics(dao, containerName + "/ImplLang", true)) == null) {
            impLang = DEFAULT_DOMAIN;
        }
        flags = (String)flags + " -m " + this.transport.getManagerReference();
        short instance = (short)ACSPorts.getBasePort();
        try {
            Daemon daemon = this.transport.getDaemon(host);
            if (daemon == null) {
                throw new RuntimeException("Failed to get daemon.");
            }
            daemon.startContainer(impLang, containerName, instance, (String)flags);
        }
        catch (Throwable th) {
            RemoteException re = new RemoteException("Failed to connect to ACS daemon on host '" + host + "' to start container '" + containerName + "'.", th);
            this.logger.log(Level.SEVERE, re.getMessage(), re);
            return null;
        }
        int CONTAINER_STARTUP_TIMEOUT = 120000;
        Object object = this.containerLoggedInMonitor;
        synchronized (object) {
            long start;
            for (int waitTime = 120000; waitTime > 0; waitTime -= (int)(System.currentTimeMillis() - start)) {
                start = System.currentTimeMillis();
                try {
                    this.containerLoggedInMonitor.wait(waitTime);
                }
                catch (InterruptedException e) {
                    return null;
                }
                ContainerInfo info = this.getContainerInfo(containerName);
                if (info == null) continue;
                return info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conditionalShutdownContainer(ContainerInfo containerInfo) {
        int componentsCount;
        IntArray intArray = containerInfo.getComponents();
        synchronized (intArray) {
            componentsCount = containerInfo.getComponents().size();
        }
        if (componentsCount > 0) {
            return;
        }
        int keepAliveTime = -1;
        DAOProxy dao = this.getContainersDAOProxy();
        if (dao != null) {
            keepAliveTime = this.readLongCharacteristics(dao, containerInfo.getName() + "/DeployInfo/KeepAliveTime", keepAliveTime, true);
        }
        if (keepAliveTime >= 0) {
            this.delayedDeactivationTask.schedule((TimerTask)new ShutdownContainerTask(containerInfo.getName()), keepAliveTime * 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component internalRestartComponent(int owner, URI curl) throws AcsJNoPermissionEx {
        int h = 0;
        String name = this.extractName(curl);
        this.componentsLock.lock();
        try {
            h = this.components.first();
            while (h != 0) {
                ComponentInfo componentInfo = (ComponentInfo)this.components.get(h);
                if (componentInfo.getName().equals(name)) {
                    h = componentInfo.getHandle();
                    break;
                }
                h = this.components.next(h);
            }
        }
        finally {
            this.componentsLock.unlock();
        }
        if (h != 0) {
            return this.internalRestartComponent(owner, h);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component internalRestartComponent(int owner, int h) throws AcsJNoPermissionEx {
        String name = null;
        this.componentsLock.lock();
        try {
            int handle = h & 0xFFFF;
            ComponentInfo componentInfo = null;
            if (this.components.isAllocated(handle)) {
                componentInfo = (ComponentInfo)this.components.get(handle);
            }
            if (componentInfo == null || componentInfo.getHandle() != h) {
                BadParametersException af = new BadParametersException("Invalid component handle.");
                throw af;
            }
            name = componentInfo.getName();
        }
        finally {
            this.componentsLock.unlock();
        }
        String lockNotAcquiredCause = this.acquireSynchronizationObject(name, this.lockTimeout, "restart component " + name);
        if (lockNotAcquiredCause == null) {
            boolean releaseRWLock = true;
            try {
                this.activationPendingRWLock.readLock().lock();
                Component component = this.internalNoSyncRestartComponent(owner, h);
                return component;
            }
            finally {
                if (releaseRWLock) {
                    this.activationPendingRWLock.readLock().unlock();
                }
                this.releaseSynchronizationObject(name);
            }
        }
        NoResourcesException nre = new NoResourcesException("Failed to obtain synchronization lock for component '" + name + "', possible deadlock; locked to '" + lockNotAcquiredCause + "'.");
        throw nre;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Component internalNoSyncRestartComponent(int owner, int h) throws AcsJNoPermissionEx {
        int handle = h & 0xFFFF;
        ComponentInfo componentInfo = null;
        this.componentsLock.lock();
        try {
            if (this.components.isAllocated(handle)) {
                componentInfo = (ComponentInfo)this.components.get(handle);
            }
            if (componentInfo == null || componentInfo.getHandle() != h) {
                BadParametersException af = new BadParametersException("Invalid component handle.");
                throw af;
            }
            if (!componentInfo.getClients().contains(owner)) {
                AcsJNoPermissionEx npe = new AcsJNoPermissionEx();
                npe.setReason("Restarting component that client does not own.");
                npe.setID(HandleHelper.toString(owner));
                npe.setProtectedResource(componentInfo.getName());
                throw npe;
            }
        }
        finally {
            this.componentsLock.unlock();
        }
        Container container = null;
        ContainerInfo containerInfo = null;
        int containerHandle = componentInfo.getContainer();
        if (containerHandle != 0) {
            containerInfo = this.getContainerInfo(containerHandle);
            if (containerInfo != null) {
                this.checkContainerShutdownState(containerInfo);
                container = containerInfo.getContainer();
            }
            if (container == null) {
                String containerName = containerInfo != null ? containerInfo.getName() : HandleHelper.toString(componentInfo.getContainer());
                this.logger.log(Level.WARNING, "Container '" + containerName + "' required by component '" + componentInfo.getName() + "' is not logged in.");
            }
        }
        Component component = null;
        if (container != null) {
            try {
                component = container.restart_component(componentInfo.getHandle());
                if (component == null) {
                    RemoteException re = new RemoteException("Failed to restart component '" + componentInfo.getName() + "', 'null' returned.");
                    throw re;
                }
            }
            catch (Throwable ex) {
                RemoteException re = new RemoteException("Failed to restart component '" + componentInfo.getName() + "' on container '" + containerInfo.getName() + "'.", ex);
                this.logger.log(Level.SEVERE, re.getMessage(), re);
            }
        }
        this.logger.log(Level.FINE, "Component '" + componentInfo.getName() + "' restarted.");
        return component;
    }

    @Override
    public ComponentInfo getDefaultComponent(int id, String type) throws AcsJNoPermissionEx, NoDefaultComponentException {
        if (type == null) {
            BadParametersException af = new BadParametersException("Non-null 'type' expected.");
            throw af;
        }
        this.securityCheck(id, 0);
        this.logger.log(Level.INFO, "Getting default component for type '" + type + "'.");
        ComponentInfo componentInfo = this.internalRequestDefaultComponent(id, type);
        return componentInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentInfo internalRequestDefaultComponent(int requestor, String type) throws NoDefaultComponentException {
        CoreException huse;
        DAOProxy componentsDAO;
        String defaultComponentName = null;
        ComponentInfo defaultComponentInfo = null;
        Map<String, ComponentInfo> map = this.defaultComponents;
        synchronized (map) {
            defaultComponentInfo = this.defaultComponents.get(type);
        }
        if (defaultComponentInfo != null) {
            defaultComponentName = defaultComponentInfo.getName();
        }
        if (defaultComponentName == null && (componentsDAO = this.getComponentsDAOProxy()) != null) {
            try {
                componentsDAO.get_field_data(DEFAULT_DOMAIN);
                String[] ids = this.getComponentsList();
                for (int i = 0; i < ids.length; ++i) {
                    String isDefault;
                    String name = ids[i];
                    if (name == null) {
                        this.logger.log(Level.WARNING, "Misconfigured CDB, there is no type of component '" + ids[i] + "' defined.");
                        continue;
                    }
                    if (name.equals("*")) continue;
                    String componentType = this.readStringCharacteristics(componentsDAO, ids[i] + "/Type");
                    if (type == null) {
                        this.logger.log(Level.WARNING, "Misconfigured CDB, there is no type of component '" + name + "' defined.");
                        continue;
                    }
                    String TRUE_STRING = "true";
                    if (!type.equals(componentType) || (isDefault = this.readStringCharacteristics(componentsDAO, ids[i] + "/Default", true)) == null || !isDefault.equalsIgnoreCase("true")) continue;
                    defaultComponentName = name;
                    break;
                }
            }
            catch (Throwable ex) {
                CoreException ce = new CoreException("Failed to obtain component data from the CDB.", ex);
                this.reportException(ce);
            }
        }
        if (defaultComponentInfo != null) {
            try {
                StatusHolder status = new StatusHolder();
                ContainerInfo containerInfo = this.getContainerInfo(defaultComponentInfo.getContainer());
                if (containerInfo == null) {
                    CoreException huse2 = new CoreException("Failed to return default component: '" + defaultComponentName + "', container with '" + HandleHelper.toString(defaultComponentInfo.getContainer()) + "' not logged in.");
                    this.reportException(huse2);
                    return null;
                }
                ComponentInfo componentInfo = this.internalRequestComponent(requestor, defaultComponentInfo.getName(), defaultComponentInfo.getType(), defaultComponentInfo.getCode(), containerInfo.getName(), 0, status, true);
                if (componentInfo == null || status.getStatus() != ComponentStatus.COMPONENT_ACTIVATED) {
                    huse = new CoreException("Failed to obtain default component: '" + defaultComponentName + "'.");
                    this.reportException(huse);
                    return null;
                }
                return componentInfo;
            }
            catch (Throwable t) {
                CoreException huse3 = new CoreException("Failed to return default component: '" + defaultComponentName + "'.", t);
                this.reportException(huse3);
                return null;
            }
        }
        if (defaultComponentName != null) {
            URI curl = null;
            try {
                curl = CURLHelper.createURI(defaultComponentName);
            }
            catch (URISyntaxException use) {
                CoreException huse4 = new CoreException("Failed to create CURL from default component name: '" + defaultComponentName + "'.", use);
                this.reportException(huse4);
                return null;
            }
            try {
                StatusHolder status = new StatusHolder();
                Component component = this.internalRequestComponent(requestor, curl, status, true);
                if (component == null || status.getStatus() != ComponentStatus.COMPONENT_ACTIVATED) {
                    huse = new CoreException("Failed to obtain default component: '" + defaultComponentName + "'.");
                    this.reportException(huse);
                    return null;
                }
                ComponentInfo[] componentInfo = this.getComponentInfo(requestor, new int[0], defaultComponentName, type, true);
                if (componentInfo == null || componentInfo.length != 1) {
                    CoreException huse5 = new CoreException("Failed to obtain activated default component ComponentInfo: '" + defaultComponentName + "'.");
                    this.reportException(huse5);
                    return null;
                }
                return componentInfo[0];
            }
            catch (Throwable t) {
                CoreException huse6 = new CoreException("Failed to return default component: '" + defaultComponentName + "'.", t);
                this.reportException(huse6);
                return null;
            }
        }
        NoDefaultComponentException ndce = new NoDefaultComponentException("No default component for type '" + type + "' found.");
        throw ndce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentInfo getDynamicComponent(int id, ComponentSpec componentSpec, boolean markAsDefault) throws AcsJCannotGetComponentEx, AcsJNoPermissionEx, AcsJIncompleteComponentSpecEx, AcsJInvalidComponentSpecEx, AcsJComponentSpecIncompatibleWithActiveComponentEx {
        try {
            if (componentSpec == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("componentSpec");
                throw ex;
            }
            if (componentSpec.getName() == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("componentSpec.Name");
                throw ex;
            }
            if (componentSpec.getType() == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("componentSpec.Type");
                throw ex;
            }
            if (componentSpec.getCode() == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("componentSpec.Code");
                throw ex;
            }
            if (componentSpec.getContainer() == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("componentSpec.Container");
                throw ex;
            }
            if (componentSpec.getName().length() == 0) {
                AcsJBadParameterEx ex = new AcsJBadParameterEx();
                ex.setParameter("componentSpec.Name");
                ex.setParameterValue("EMPTY");
                ex.setReason("Non empty Component Name expected");
                throw ex;
            }
        }
        catch (AcsJNullPointerEx e) {
            AcsJInvalidComponentSpecEx ex = new AcsJInvalidComponentSpecEx((Throwable)e);
            throw ex;
        }
        catch (AcsJBadParameterEx e) {
            AcsJInvalidComponentSpecEx ex = new AcsJInvalidComponentSpecEx((Throwable)e);
            throw ex;
        }
        this.securityCheck(id, 0);
        ComponentInfo componentInfo = null;
        try {
            componentInfo = this.internalRequestDynamicComponent(id, componentSpec);
        }
        catch (AcsJSyncLockFailedEx e) {
            AcsJCannotGetComponentEx ex = new AcsJCannotGetComponentEx();
            ex.setCURL(componentSpec.getName());
            ex.setReason("Failed to get Synchronisation lock");
            throw ex;
        }
        if (componentInfo != null && markAsDefault) {
            Map<String, ComponentInfo> e = this.defaultComponents;
            synchronized (e) {
                this.executeCommand(new DefaultComponentCommandPut(componentInfo.getType(), componentInfo));
            }
            this.logger.log(Level.INFO, "'" + componentInfo.getName() + "' has been marked as a default component of type '" + componentInfo.getType() + "'.");
        }
        if (componentInfo == null) {
            AcsJCannotGetComponentEx ex = new AcsJCannotGetComponentEx();
            ex.setCURL(componentSpec.getName());
            throw ex;
        }
        return componentInfo;
    }

    public ComponentInfo[] getDynamicComponents(int id, ComponentSpec[] components) throws AcsJNoPermissionEx {
        if (components == null) {
            BadParametersException af = new BadParametersException("Non-null 'components' expected.");
            throw af;
        }
        this.securityCheck(id, 0);
        int obtained = 0;
        ComponentInfo[] componentInfos = new ComponentInfo[components.length];
        for (int i = 0; i < components.length; ++i) {
            try {
                componentInfos[i] = this.getDynamicComponent(id, components[i], false);
                ++obtained;
                continue;
            }
            catch (Exception ex) {
                componentInfos[i] = null;
                CoreException ce = new CoreException("Failed to get dynamic component '" + components[i] + "'.", ex);
                this.reportException(ce);
            }
        }
        this.logger.log(Level.INFO, obtained + " of " + components.length + " dynamic components obtained.");
        return componentInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentInfo getCollocatedComponent(int id, ComponentSpec componentSpec, boolean markAsDefault, URI targetComponentURI) throws AcsJCannotGetComponentEx, AcsJNoPermissionEx, AcsJIncompleteComponentSpecEx, AcsJInvalidComponentSpecEx, AcsJComponentSpecIncompatibleWithActiveComponentEx {
        ComponentInfo componentInfo;
        try {
            if (componentSpec == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("componentSpec");
                throw ex;
            }
            if (componentSpec.getName() == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("componentSpec.Name");
                throw ex;
            }
            if (componentSpec.getType() == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("componentSpec.Type");
                throw ex;
            }
            if (componentSpec.getCode() == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("componentSpec.Code");
                throw ex;
            }
            if (componentSpec.getContainer() == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("componentSpec.Container");
                throw ex;
            }
            if (componentSpec.getName().length() == 0) {
                AcsJBadParameterEx ex = new AcsJBadParameterEx();
                ex.setParameter("componentSpec.Name");
                ex.setParameterValue("EMPTY");
                ex.setReason("Non empty Component Name expected");
                throw ex;
            }
            if (targetComponentURI == null) {
                AcsJNullPointerEx ex = new AcsJNullPointerEx();
                ex.setVariable("targetComponentURI");
                throw ex;
            }
            if (!componentSpec.getContainer().equals("*")) {
                AcsJBadParameterEx ex = new AcsJBadParameterEx();
                ex.setParameter("componentSpec.Container");
                ex.setParameterValue(componentSpec.getContainer());
                ex.setReason("COMPSPEC_ANY expected");
                throw ex;
            }
        }
        catch (AcsJNullPointerEx e) {
            AcsJInvalidComponentSpecEx ex = new AcsJInvalidComponentSpecEx((Throwable)e);
            throw ex;
        }
        catch (AcsJBadParameterEx e) {
            AcsJInvalidComponentSpecEx ex = new AcsJInvalidComponentSpecEx((Throwable)e);
            throw ex;
        }
        this.securityCheck(id, 0);
        String name = this.extractName(targetComponentURI);
        int h = 0;
        ComponentInfo targetComponentInfo = null;
        this.componentsLock.lock();
        try {
            h = this.components.first();
            while (h != 0) {
                componentInfo = (ComponentInfo)this.components.get(h);
                if (componentInfo.getName().equals(name)) {
                    targetComponentInfo = componentInfo;
                    break;
                }
                h = this.components.next(h);
            }
        }
        finally {
            this.componentsLock.unlock();
        }
        if (targetComponentInfo == null) {
            String containerName;
            DAOProxy componentsDAO = this.getComponentsDAOProxy();
            if (componentsDAO != null && (containerName = this.readStringCharacteristics(componentsDAO, name + "/Container", true)) != null) {
                componentSpec.setContainer(containerName);
            }
        } else {
            componentSpec.setContainer(targetComponentInfo.getContainerName());
        }
        if (componentSpec.getContainer().equals("*")) {
            AcsJIncompleteComponentSpecEx ex = new AcsJIncompleteComponentSpecEx();
            ex.setCURL(name);
            ex.setContainerName(componentSpec.getContainer());
            throw ex;
        }
        componentInfo = null;
        try {
            componentInfo = this.internalRequestDynamicComponent(id, componentSpec);
        }
        catch (AcsJSyncLockFailedEx e) {
            AcsJCannotGetComponentEx ex = new AcsJCannotGetComponentEx();
            ex.setCURL(name);
            ex.setReason("Failed to get Synchronisation lock");
            throw ex;
        }
        if (componentInfo != null && markAsDefault) {
            Map<String, ComponentInfo> e = this.defaultComponents;
            synchronized (e) {
                this.executeCommand(new DefaultComponentCommandPut(componentInfo.getType(), componentInfo));
            }
            this.logger.log(Level.INFO, "'" + componentInfo.getName() + "' has been marked as a default component of type '" + componentInfo.getType() + "'.");
        }
        if (componentInfo == null) {
            AcsJCannotGetComponentEx ex = new AcsJCannotGetComponentEx();
            ex.setCURL(name);
            throw ex;
        }
        return componentInfo;
    }

    private String[] searchDynamicComponent(String[] fieldNames, String[] requiredValues, boolean[] equalityRequired, int[] equalityPoints, IntHolder keepAliveTimeHolder) {
        assert (fieldNames != null);
        assert (equalityRequired != null);
        assert (equalityPoints != null);
        assert (fieldNames.length == equalityRequired.length);
        assert (equalityRequired.length == equalityPoints.length);
        DAOProxy componentsDAO = this.getComponentsDAOProxy();
        if (componentsDAO == null) {
            return null;
        }
        String[] fieldIDs = null;
        try {
            componentsDAO.get_field_data(DEFAULT_DOMAIN);
            fieldIDs = this.getComponentsList();
        }
        catch (Exception ex) {
            CoreException af = new CoreException("Failed to retrieve data from CDB.", ex);
            this.reportException(af);
            return null;
        }
        int len = fieldNames.length;
        int maxPoints = Integer.MIN_VALUE;
        String[] bestMatch = null;
        String[] currentMatch = new String[len];
        int bestMatchKeepAliveTime = -2147483646;
        for (int fi = 0; fi < fieldIDs.length; ++fi) {
            int i;
            int points = 0;
            for (i = 0; i < len; ++i) {
                boolean processingNameField = "Name".equals(fieldNames[i]);
                String fieldValue = null;
                if (processingNameField) {
                    if (Character.isDigit(fieldIDs[fi].charAt(fieldIDs[fi].length() - 1))) {
                        String readFieldValue = this.readStringCharacteristics(componentsDAO, fieldIDs[fi] + "/Name", true);
                        fieldValue = fieldIDs[fi].substring(0, fieldIDs[fi].indexOf(readFieldValue) + readFieldValue.length());
                    } else {
                        fieldValue = fieldIDs[fi];
                    }
                } else {
                    fieldValue = this.readStringCharacteristics(componentsDAO, fieldIDs[fi] + "/" + fieldNames[i], true);
                }
                if (fieldValue == null) break;
                boolean equals = requiredValues[i].equals(fieldValue);
                if (equalityRequired[i]) {
                    if (!equals) break;
                    currentMatch[i] = fieldValue;
                    continue;
                }
                currentMatch[i] = fieldValue;
                if (equals) {
                    points += equalityPoints[i];
                    continue;
                }
                if (processingNameField && (fieldValue.indexOf("*") == -1 || !WildcharMatcher.match((String)fieldValue, (String)requiredValues[i]))) break;
            }
            if (i != len || points <= maxPoints) continue;
            maxPoints = points;
            if (bestMatch == null) {
                bestMatch = new String[len];
            }
            System.arraycopy(currentMatch, 0, bestMatch, 0, len);
            bestMatchKeepAliveTime = this.readLongCharacteristics(componentsDAO, fieldIDs[fi] + "/KeepAliveTime", -2147483646, true);
        }
        keepAliveTimeHolder.value = bestMatchKeepAliveTime;
        return bestMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentInfo internalRequestDynamicComponent(int requestor, ComponentSpec componentSpec) throws AcsJCannotGetComponentEx, AcsJSyncLockFailedEx, AcsJNoPermissionEx, AcsJIncompleteComponentSpecEx, AcsJInvalidComponentSpecEx, AcsJComponentSpecIncompatibleWithActiveComponentEx {
        int i;
        Object ex;
        String containerName;
        String[] result;
        boolean unspecifiedName = componentSpec.getName().endsWith("*");
        boolean unspecifiedType = componentSpec.getType().equals("*");
        if (unspecifiedName && unspecifiedType) {
            AcsJInvalidComponentSpecEx ex2 = new AcsJInvalidComponentSpecEx();
            ex2.setReason("'name' and 'type' cannot be both '*'.");
            throw ex2;
        }
        if (!(unspecifiedName || unspecifiedType || componentSpec.getCode().equals("*") || componentSpec.getContainer().equals("*"))) {
            StatusHolder statusHolder = new StatusHolder();
            return this.internalRequestComponent(requestor, componentSpec.getName(), componentSpec.getType(), componentSpec.getCode(), componentSpec.getContainer(), -2147483646, statusHolder, true);
        }
        String[] fieldNames = new String[]{"Name", "Type", "Code", "Container"};
        String[] requiredValues = new String[]{componentSpec.getName(), componentSpec.getType(), componentSpec.getCode(), componentSpec.getContainer()};
        int[] equalityPoints = new int[]{8, 4, 2, 1};
        boolean[] equalityRequired = null;
        boolean allowNameGeneration = false;
        boolean prohibitSearch = false;
        if (!unspecifiedName && !unspecifiedType) {
            equalityRequired = new boolean[]{false, true, false, false};
            allowNameGeneration = true;
        } else if (!unspecifiedName && unspecifiedType) {
            equalityRequired = new boolean[]{true, false, false, false};
        } else if (unspecifiedName && !unspecifiedType) {
            equalityRequired = new boolean[]{true, true, false, false};
            if (!componentSpec.getCode().equals("*") && !componentSpec.getContainer().equals("*")) {
                prohibitSearch = true;
            }
            allowNameGeneration = true;
        }
        IntHolder keepAliveTimeHolder = new IntHolder(-2147483646);
        String[] stringArray = result = prohibitSearch ? null : this.searchDynamicComponent(fieldNames, requiredValues, equalityRequired, equalityPoints, keepAliveTimeHolder);
        if (result == null) {
            boolean failed = true;
            if (!(!allowNameGeneration && unspecifiedName || unspecifiedType || componentSpec.getCode().equals("*"))) {
                if (!componentSpec.getContainer().equals("*")) {
                    result = new String[]{componentSpec.getName(), componentSpec.getType(), componentSpec.getCode(), componentSpec.getContainer()};
                    failed = false;
                } else if (this.loadBalancingStrategy != null && (containerName = this.loadBalancingStrategy.selectContainer(this.getClientInfo(requestor), this.getContainersInfo())) != null) {
                    result = new String[]{componentSpec.getName(), componentSpec.getType(), componentSpec.getCode(), containerName};
                    failed = false;
                }
            }
            if (failed) {
                ex = new AcsJInvalidComponentSpecEx();
                ex.setReason("Requested ComponentSpec does not match any entry in the CDB.");
                throw ex;
            }
        }
        for (i = 0; i < result.length; ++i) {
            if (requiredValues[i].equals("*")) continue;
            result[i] = requiredValues[i];
        }
        i = 0;
        if (allowNameGeneration) {
            ++i;
        }
        while (i < result.length) {
            if (result[i].equals("*")) {
                if (fieldNames[i].equals("Container") && this.loadBalancingStrategy != null && (containerName = this.loadBalancingStrategy.selectContainer(this.getClientInfo(requestor), this.getContainersInfo())) != null) {
                    result[i] = containerName;
                } else {
                    ex = new AcsJIncompleteComponentSpecEx();
                    ex.setReason("'" + fieldNames[i] + "' equals '*'.");
                    throw ex;
                }
            }
            ++i;
        }
        if (allowNameGeneration && result[0].endsWith("*")) {
            ex = this;
            synchronized (ex) {
                result[0] = result[0].equals("*") ? result[1] + "_" + System.currentTimeMillis() : result[0].substring(0, result[0].length() - 1) + "_" + System.currentTimeMillis();
                if (result[0].indexOf(47) >= 0) {
                    result[0] = result[0].replaceAll("/", "_");
                }
            }
        }
        StatusHolder statusHolder = new StatusHolder();
        return this.internalRequestComponent(requestor, result[0], result[1], result[2], result[3], keepAliveTimeHolder.value, statusHolder, true);
    }

    private void bind(String name, String type, Object object) {
        this.bind(this.remoteDirectory, name, type, object);
    }

    private void bind(Context remoteDirectory, String name, String type, Object object) {
        assert (name != null);
        if (name.startsWith(CURL_URI_SCHEMA)) {
            return;
        }
        if (remoteDirectory != null) {
            try {
                int pos = name.indexOf(47);
                if (pos != -1) {
                    if (pos == 0 || pos == name.length()) {
                        throw new IllegalArgumentException("Invalid hierarchical name '" + name + "'.");
                    }
                    String parent = name.substring(0, pos);
                    String child = name.substring(pos + 1);
                    Context parentContext = null;
                    try {
                        parentContext = (Context)remoteDirectory.lookup(parent);
                    }
                    catch (NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                    if (parentContext == null) {
                        parentContext = remoteDirectory.createSubcontext(parent);
                    }
                    this.bind(parentContext, child, type, object);
                    return;
                }
                NameParser parser = remoteDirectory.getNameParser(DEFAULT_DOMAIN);
                Name n = type != null ? parser.parse(name + "." + type) : parser.parse(name);
                if (name.endsWith(".D")) {
                    remoteDirectory.rebind(n, object);
                } else {
                    remoteDirectory.bind(n, object);
                }
            }
            catch (NameAlreadyBoundException nabe) {
                this.rebind(remoteDirectory, name, type, object);
            }
            catch (NamingException ne) {
                CoreException ce = new CoreException("Failed to bind name '" + name + "' to the remote directory.", ne);
                this.logger.log(Level.FINE, ce.getMessage(), ce);
            }
        }
    }

    private void rebind(Context remoteDirectory, String name, String type, Object object) {
        assert (name != null);
        if (name.startsWith(CURL_URI_SCHEMA)) {
            return;
        }
        if (remoteDirectory != null) {
            try {
                NameParser parser = remoteDirectory.getNameParser(DEFAULT_DOMAIN);
                Name n = type != null ? parser.parse(name + "." + type) : parser.parse(name);
                remoteDirectory.rebind(n, object);
            }
            catch (NamingException ne) {
                CoreException ce = new CoreException("Failed to rebind name '" + name + "' to the remote directory.", ne);
                this.logger.log(Level.FINE, ce.getMessage(), ce);
            }
        }
    }

    private Object lookup(String name, String type) {
        return this.lookup(this.remoteDirectory, name, type);
    }

    private Object lookup(Context remoteDirectory, String name, String type) {
        assert (name != null);
        if (name.startsWith(CURL_URI_SCHEMA)) {
            return null;
        }
        Object resolved = null;
        if (remoteDirectory != null) {
            try {
                NameParser parser = remoteDirectory.getNameParser(DEFAULT_DOMAIN);
                Name n = type != null ? parser.parse(name + "." + type) : parser.parse(name);
                resolved = remoteDirectory.lookup(n);
            }
            catch (NamingException ne) {
                CoreException ce = new CoreException("Failed to lookup name '" + name + "' in the remote directory.", ne);
                this.logger.log(Level.FINE, ce.getMessage(), ce);
            }
        }
        return resolved;
    }

    private void unbind(String name, String type) {
        this.unbind(this.remoteDirectory, name, type);
    }

    private void unbind(Context remoteDirectory, String name, String type) {
        assert (name != null);
        if (name.startsWith(CURL_URI_SCHEMA)) {
            return;
        }
        if (remoteDirectory != null) {
            try {
                NameParser parser = remoteDirectory.getNameParser(DEFAULT_DOMAIN);
                Name n = type != null ? parser.parse(name + "." + type) : parser.parse(name);
                remoteDirectory.unbind(n);
                this.cleanupEmptyFContext(remoteDirectory, name);
            }
            catch (NamingException ne) {
                CoreException ce = new CoreException("Failed to unbind name '" + name + "' from the remote directory.", ne);
                this.logger.log(Level.FINE, ce.getMessage(), ce);
            }
        }
    }

    private void cleanupEmptyFContext(Context remoteDirectory, String name) {
        try {
            int pos = name.lastIndexOf(47);
            if (pos != -1) {
                if (pos == 0 || pos == name.length()) {
                    throw new IllegalArgumentException("Invalid hierarchical name '" + name + "'.");
                }
                String parent = name.substring(0, pos);
                if (parent.endsWith(".F") && !remoteDirectory.list(parent).hasMore()) {
                    remoteDirectory.unbind(parent);
                    this.cleanupEmptyFContext(remoteDirectory, parent);
                }
            }
        }
        catch (Throwable th) {
            CoreException ce = new CoreException("Failed to unbind (potential) empty context for '" + name + "'.", th);
            this.logger.log(Level.FINE, ce.getMessage(), ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequestorName(int id) {
        int reqHandle = id & 0xFFFF;
        boolean invalidHandle = true;
        StringBuffer name = new StringBuffer(30);
        switch (id & 0xFF000000) {
            case 0x4000000: {
                HandleDataStore handleDataStore = this.containers;
                synchronized (handleDataStore) {
                    ContainerInfo info;
                    if (this.containers.isAllocated(reqHandle) && (info = (ContainerInfo)this.containers.get(reqHandle)).getHandle() == id) {
                        invalidHandle = false;
                        name.append(info.getName());
                    }
                    break;
                }
            }
            case 0x2000000: {
                HandleDataStore handleDataStore = this.clients;
                synchronized (handleDataStore) {
                    ClientInfo info;
                    if (this.clients.isAllocated(reqHandle) && (info = (ClientInfo)this.clients.get(reqHandle)).getHandle() == id) {
                        invalidHandle = false;
                        name.append(info.getName());
                    }
                    break;
                }
            }
            case 0x3000000: {
                HandleDataStore handleDataStore = this.administrators;
                synchronized (handleDataStore) {
                    ClientInfo info;
                    if (this.administrators.isAllocated(reqHandle) && (info = (ClientInfo)this.administrators.get(reqHandle)).getHandle() == id) {
                        invalidHandle = false;
                        name.append(info.getName());
                    }
                    break;
                }
            }
            case 0x1000000: {
                this.componentsLock.lock();
                try {
                    ComponentInfo info;
                    if (!this.components.isAllocated(reqHandle) || (info = (ComponentInfo)this.components.get(reqHandle)) == null || info.getHandle() != id) break;
                    invalidHandle = false;
                    name.append(info.getName());
                    break;
                }
                finally {
                    this.componentsLock.unlock();
                }
            }
            case 0x5000000: {
                name.append(FAULT_FAMILY);
                invalidHandle = false;
            }
        }
        if (invalidHandle) {
            name.append("<unknown>");
        }
        return name.toString();
    }

    private void checkCURL(URI curl) throws AcsJBadParameterEx {
        this.checkCURL(curl, true);
    }

    private void checkCURL(URI curl, boolean allowNonLocalDomains) throws AcsJBadParameterEx {
        if (curl == null) {
            AcsJBadParameterEx af = new AcsJBadParameterEx();
            af.setParameter("curl");
            af.setParameterValue("null");
            throw af;
        }
        if (curl.getPath() == null || curl.getPath().length() == 0 || curl.getScheme() != null && curl.getScheme().startsWith(CURL_URI_SCHEMA)) {
            AcsJBadParameterEx af = new AcsJBadParameterEx();
            af.setParameter("curl");
            af.setParameterValue(curl.toString());
            throw af;
        }
        if (!allowNonLocalDomains && !this.isLocalDomainCURL(curl)) {
            String domain = curl.getAuthority();
            AcsJBadParameterEx af = new AcsJBadParameterEx();
            af.setParameter("curl");
            af.setParameterValue("CURL does not belong to this domain ('" + domain + "' not one of '" + this.domains + "').");
            throw af;
        }
    }

    private boolean isLocalDomainCURL(URI curl) {
        String domain = curl.getAuthority();
        return domain == null || domain.length() == 0 || this.domains.contains(domain);
    }

    private String extractName(URI curl) {
        if (curl == null) {
            return DEFAULT_DOMAIN;
        }
        if (this.isLocalDomainCURL(curl)) {
            String name = curl.getPath();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            return name;
        }
        return curl.toString();
    }

    public boolean isServiceComponent(String name) {
        assert (name != null);
        boolean retVal = false;
        DAOProxy dao = this.getManagerDAOProxy();
        if (dao != null) {
            try {
                String[] names = dao.get_string_seq("ServiceComponents");
                for (int i = 0; i < names.length; ++i) {
                    if (!name.equals(names[i])) continue;
                    retVal = true;
                    break;
                }
            }
            catch (Throwable ex) {
                CoreException ce = new CoreException("Failed to retrieve list of service components.", ex);
                this.logger.log(Level.FINE, ce.getMessage(), ce);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String acquireSynchronizationObject(String name, long msec, String acquireTaskDesc) {
        ReferenceCountingLock lock;
        if (acquireTaskDesc == null) {
            acquireTaskDesc = "(unknown lock cause)";
        }
        Map<String, ReferenceCountingLock> map = this.activationSynchronization;
        synchronized (map) {
            lock = this.activationSynchronization.get(name);
            if (lock == null) {
                lock = new ReferenceCountingLock();
                this.activationSynchronization.put(name, lock);
            } else {
                lock.increment();
            }
        }
        boolean success = lock.acquire(msec);
        if (!success) {
            this.releaseSynchronizationObject(name, false);
            return (String)lock.getUserData();
        }
        lock.setUserData(acquireTaskDesc);
        return null;
    }

    private void releaseSynchronizationObject(String name) {
        this.releaseSynchronizationObject(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSynchronizationObject(String name, boolean release) {
        Map<String, ReferenceCountingLock> map = this.activationSynchronization;
        synchronized (map) {
            ReferenceCountingLock lock = this.activationSynchronization.get(name);
            if (lock != null) {
                if (lock.decrement() <= 0) {
                    this.activationSynchronization.remove(name);
                }
                if (release) {
                    lock.release();
                }
            }
        }
    }

    private synchronized DAOProxy getManagerDAOProxy() {
        if (System.getProperties().containsKey(NAME_CDB_DISABLE)) {
            return null;
        }
        if (this.managerDAO == null) {
            this.managerDAO = this.createDAO("MACI/Managers/Manager");
        }
        return this.managerDAO;
    }

    private void readManagerConfiguration() {
        this.enableHandleMonitoring = System.getProperties().containsKey(NAME_HANDLE_MONITORING);
        this.enableHandleMonitoringDurationMins = Integer.getInteger(NAME_HANDLE_MONITORING_TIME, 120);
        DAOProxy managerDAO = this.getManagerDAOProxy();
        if (managerDAO == null) {
            return;
        }
        this.clientPingInterval = (int)(this.readDoubleCharacteristics(managerDAO, "ClientPingInterval", (double)this.clientPingInterval / 1000.0, true) * 1000.0);
        this.clientPingInterval = Math.max(1000, this.clientPingInterval);
        this.administratorPingInterval = (int)(this.readDoubleCharacteristics(managerDAO, "AdministratorPingInterval", (double)this.administratorPingInterval / 1000.0, true) * 1000.0);
        this.administratorPingInterval = Math.max(1000, this.administratorPingInterval);
        this.containerPingInterval = (int)(this.readDoubleCharacteristics(managerDAO, "ContainerPingInterval", (double)this.containerPingInterval / 1000.0, true) * 1000.0);
        this.containerPingInterval = Math.max(1000, this.containerPingInterval);
        try {
            long t;
            String strTimeOut = System.getProperty("jacorb.connection.client.pending_reply_timeout");
            if (strTimeOut != null && (t = Long.valueOf(strTimeOut).longValue()) > 0L) {
                this.lockTimeout = t + 60000L;
                if (this.lockTimeout < 0L) {
                    this.lockTimeout = Long.MAX_VALUE;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.poolThreads = this.readLongCharacteristics(managerDAO, "ServerThreads", this.poolThreads, true);
        this.poolThreads = Math.max(3, this.poolThreads);
    }

    private synchronized void destroyManagerDAOProxy() {
        if (this.managerDAO != null) {
            this.destroyDAO(this.managerDAO);
        }
        this.managerDAO = null;
    }

    private synchronized DAOProxy getComponentsDAOProxy() {
        if (System.getProperties().containsKey(NAME_CDB_DISABLE)) {
            return null;
        }
        if (this.componentsDAO == null) {
            this.componentsDAO = this.createDAO("MACI/Components");
            if (this.componentsDAO != null) {
                this.componentListCache = this.refreshComponentsList(this.componentsDAO);
                this.componentsDAO.addConnectionListener(new DAOProxyConnectionListener(){

                    public void connected(DAOProxy proxy) {
                        ManagerImpl.this.componentListCache = ManagerImpl.this.refreshComponentsList(proxy);
                    }

                    public void disconnected(DAOProxy proxy) {
                    }
                });
            }
        }
        return this.componentsDAO;
    }

    private String[] getComponentsList() {
        return this.componentListCache;
    }

    private String[] refreshComponentsList(DAOProxy dc) {
        ArrayList<CallSite> componentList = new ArrayList<CallSite>();
        try {
            LinkedHashSet<String> nodes = new LinkedHashSet<String>();
            nodes.add(DEFAULT_DOMAIN);
            String[] subnodes = this.cdbAccess.getSubNodes(dc);
            if (subnodes != null) {
                for (int i = 0; i < subnodes.length; ++i) {
                    nodes.add(subnodes[i]);
                }
            }
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                Object prefix = iter.next().toString();
                if (((String)prefix).length() > 0) {
                    prefix = (String)prefix + "/";
                }
                String attributes = dc.get_field_data((String)prefix + "_characteristics");
                StringTokenizer tokenizer = new StringTokenizer(attributes, ",");
                while (tokenizer.hasMoreTokens()) {
                    String subname = tokenizer.nextToken().toString();
                    String componentName = (String)prefix + subname;
                    if (this.readStringCharacteristics(dc, componentName + "/Name", true) == null) continue;
                    componentList.add((CallSite)((Object)componentName));
                }
            }
        }
        catch (Throwable th) {
            CoreException ce = new CoreException("Failed to obtain list of all components.", th);
            this.logger.log(Level.WARNING, ce.getMessage(), ce);
        }
        String[] retVal = new String[componentList.size()];
        componentList.toArray(retVal);
        this.logger.log(Level.INFO, "Found " + retVal.length + " component entries in the configuration database.");
        return retVal;
    }

    private synchronized void destroyComponetsDAOProxy() {
        if (this.componentsDAO != null) {
            this.destroyDAO(this.componentsDAO);
        }
        this.componentsDAO = null;
    }

    private synchronized DAOProxy getContainersDAOProxy() {
        if (System.getProperties().containsKey(NAME_CDB_DISABLE)) {
            return null;
        }
        if (this.containersDAO == null) {
            this.containersDAO = this.createDAO("MACI/Containers");
        }
        return this.containersDAO;
    }

    private synchronized void destroyContainersDAOProxy() {
        if (this.containersDAO != null) {
            this.destroyDAO(this.containersDAO);
        }
        this.containersDAO = null;
    }

    private DAOProxy createDAO(String entity) {
        assert (entity != null);
        DAOProxy dao = null;
        if (this.cdbAccess != null) {
            try {
                dao = this.cdbAccess.createDAO(entity);
            }
            catch (Throwable th) {
                this.logger.log(Level.FINE, "Failed to create DAO for '" + entity + "'.");
            }
        }
        return dao;
    }

    private String readStringCharacteristics(DAOProxy dao, String path) {
        return this.readStringCharacteristics(dao, path, false);
    }

    private String readStringCharacteristics(DAOProxy dao, String path, boolean silent) {
        String retVal;
        block3: {
            assert (path != null);
            retVal = null;
            try {
                retVal = dao.get_string(path);
            }
            catch (Throwable th) {
                CoreException ce = new CoreException("Failed to read '" + path + "' field on DAO dao '" + dao + "'.", th);
                if (silent) break block3;
                this.reportException(ce);
            }
        }
        return retVal;
    }

    private int readLongCharacteristics(DAOProxy dao, String path, int defaultValue, boolean silent) {
        int retVal;
        block3: {
            assert (path != null);
            retVal = defaultValue;
            try {
                retVal = dao.get_long(path);
            }
            catch (Throwable th) {
                CoreException ce = new CoreException("Failed to read '" + path + "' field on DAO dao '" + dao + "'.", th);
                if (silent) break block3;
                this.reportException(ce);
            }
        }
        return retVal;
    }

    private double readDoubleCharacteristics(DAOProxy dao, String path, double defaultValue, boolean silent) {
        double retVal;
        block3: {
            assert (path != null);
            retVal = defaultValue;
            try {
                retVal = dao.get_double(path);
            }
            catch (Throwable th) {
                CoreException ce = new CoreException("Failed to read '" + path + "' field on DAO dao '" + dao + "'.", th);
                if (silent) break block3;
                this.reportException(ce);
            }
        }
        return retVal;
    }

    private void destroyDAO(DAOProxy dao) {
        if (dao != null) {
            try {
                dao.destroy();
            }
            catch (Throwable th) {
                CoreException ce = new CoreException("Failed to destroy DAO dao '" + dao + "'.", th);
                this.logger.log(Level.FINE, ce.getMessage(), th);
            }
        }
    }

    public void initializeFederation(Hashtable federationDirectoryProperties) throws CoreException {
        assert (federationDirectoryProperties != null);
        HashSet<String> givenDomainList = new HashSet<String>();
        try {
            String domainList = System.getProperty(NAME_DOMAIN_LIST);
            if (domainList != null) {
                StringTokenizer tokenizer = new StringTokenizer(domainList, ", ");
                while (tokenizer.hasMoreTokens()) {
                    String domainName = tokenizer.nextToken();
                    if (domainName.indexOf(47) != -1) continue;
                    givenDomainList.add(domainName);
                }
            }
            if (givenDomainList.size() > 0) {
                this.logger.log(Level.INFO, "Using domain list: " + givenDomainList + ".");
            }
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "Failed to parse domain list 'ACS.domains' variable, " + t.getMessage(), t);
        }
        if (this.domains.size() != 0 && !this.domains.equals(givenDomainList)) {
            CoreException ie = new CoreException("Given domain list is not consistent with recovery data: " + givenDomainList + " != " + this.domains + ".");
            throw ie;
        }
        if (this.domains.size() == 0 && givenDomainList.size() != 0) {
            this.domains = givenDomainList;
        }
        if (this.domains.size() == 0) {
            this.logger.log(Level.CONFIG, "No domain list given, manager federation disabled.");
            return;
        }
        if (this.remoteDirectoryComponentReference == null) {
            this.logger.log(Level.WARNING, "No valid local domain naming service reference found, manager federation disabled.");
            return;
        }
        String domainNS = System.getProperty(NAME_DOMAIN_DIRECTORY);
        if (domainNS == null) {
            this.logger.log(Level.WARNING, "No federation directory reference given, manager federation disabled.");
            return;
        }
        federationDirectoryProperties.put("java.naming.provider.url", domainNS);
        this.logger.log(Level.INFO, "Connecting to the federation directory with reference '" + domainNS + "'...");
        try {
            this.federationDirectory = new InitialContext(federationDirectoryProperties);
        }
        catch (Throwable th) {
            this.logger.log(Level.INFO, "Failed to connect to the federation directory with reference '" + domainNS + "'...", th);
            return;
        }
        this.logger.log(Level.INFO, "Connected to the federation directory with reference '" + domainNS + "'.");
        Iterator iter = this.domains.iterator();
        while (iter.hasNext()) {
            this.bind(this.federationDirectory, ManagerImpl.dottedToHierarchical(iter.next().toString()), null, this.remoteDirectoryComponentReference);
        }
        this.federationEnabled = true;
        this.logger.log(Level.INFO, "Manager federation enabled.");
        this.domain = this.domains.size() == 1 ? this.domains.iterator().next().toString() : this.domains.toString();
    }

    private static String dottedToHierarchical(String dottedName) {
        String kindSuffix = ".D";
        StringTokenizer tokenizer = new StringTokenizer(dottedName, ".");
        if (!tokenizer.hasMoreTokens()) {
            return dottedName;
        }
        String name = tokenizer.nextToken().toString() + ".D";
        while (tokenizer.hasMoreTokens()) {
            name = tokenizer.nextToken().toString() + ".D/" + name;
        }
        return name;
    }

    private static String convertToHiearachical(String componentName) {
        if (componentName.indexOf(47) == -1) {
            return componentName;
        }
        String kindSuffix = ".F";
        StringTokenizer tokenizer = new StringTokenizer(componentName, "/");
        if (!tokenizer.hasMoreTokens()) {
            return componentName;
        }
        StringBuffer name = new StringBuffer(componentName.length() + 10);
        name.append(tokenizer.nextToken().toString());
        while (tokenizer.hasMoreTokens()) {
            name.append(".F").append('/').append(tokenizer.nextToken().toString());
        }
        return name.toString();
    }

    private synchronized Manager getManagerForDomain(String domainName) {
        if (this.managerCache.containsKey(domainName)) {
            return this.managerCache.get(domainName);
        }
        Object obj = this.lookup(this.federationDirectory, ManagerImpl.dottedToHierarchical(domainName) + "/Manager", null);
        if (obj == null) {
            return null;
        }
        ManagerProxy remoteManager = new ManagerProxy(obj);
        this.managerCache.put(domainName, remoteManager);
        return remoteManager;
    }

    private void finalizeFederation() {
        if (!this.federationEnabled) {
            return;
        }
        Iterator iter = this.domains.iterator();
        while (iter.hasNext()) {
            this.unbind(this.federationDirectory, ManagerImpl.dottedToHierarchical(iter.next().toString()), null);
        }
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("ManagerImpl = { ");
        sbuff.append("domain = '");
        sbuff.append(this.domain);
        sbuff.append("' }");
        return new String(sbuff);
    }

    public void reportPrevaylerState(boolean raise, Throwable alarmEx) {
        if (raise) {
            this.logger.log(Level.WARNING, "Manager persistence subsystem failed to store pesistent data.", alarmEx);
        } else {
            this.logger.log(Level.FINER, "Manager persistence subsystem is functional.");
        }
        if (this.alarmSource == null) {
            return;
        }
        try {
            this.alarmSource.setAlarm(FAULT_FAMILY, FAULT_MEMBER, 2, raise);
        }
        catch (Throwable th) {
            this.logger.log(Level.WARNING, "Failed to send alarm.", th);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatePersistence(int id, boolean enable) throws AcsJNoPermissionEx {
        this.securityCheck(id, 0x8000000);
        if (this.prevayler != null) {
            Prevayler prevayler = this.prevayler;
            synchronized (prevayler) {
                block11: {
                    if (enable) {
                        if (this.statePersitenceFlag.get()) {
                            return;
                        }
                        try {
                            Prevayler prevayler2 = this.prevayler;
                            synchronized (prevayler2) {
                                this.statePersitenceFlag.set(true);
                                this.prevayler.takeSnapshot();
                                break block11;
                            }
                        }
                        catch (Exception e) {
                            this.statePersitenceFlag.set(false);
                            throw new NoResourcesException("Failed to create current state snapshot: " + e.toString());
                        }
                    }
                    this.statePersitenceFlag.set(false);
                }
            }
        }
    }

    public AtomicBoolean getStatePersitenceFlag() {
        return this.statePersitenceFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable executeCommand(TransactionWithQuery<ManagerImpl, Serializable> command) throws NoResourcesException {
        if (this.prevayler != null && this.statePersitenceFlag.get()) {
            try {
                Serializable retVal;
                Prevayler prevayler = this.prevayler;
                synchronized (prevayler) {
                    retVal = (Serializable)this.prevayler.execute(command);
                }
                this.reportPrevaylerState(false, null);
                return retVal;
            }
            catch (Exception ex) {
                this.reportPrevaylerState(true, ex);
            }
            catch (Throwable th) {
                throw new NoResourcesException("Failed to execute command.", th);
            }
        }
        try {
            return (Serializable)command.executeAndQuery((Object)this, null);
        }
        catch (Throwable th) {
            throw new NoResourcesException("Failed to execute command.", th);
        }
    }

    public HandleDataStore getContainers() {
        return this.containers;
    }

    public HandleDataStore getAdministrators() {
        return this.administrators;
    }

    public HandleDataStore getClients() {
        return this.clients;
    }

    public HandleDataStore getComponents() {
        return this.components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logHandleRelease(int handle, WhyUnloadedReason reason) {
        if (!this.enableHandleMonitoring) {
            return;
        }
        long now = System.currentTimeMillis();
        Map<Integer, HandleMonitorEntry> map = this.releasedHandles;
        synchronized (map) {
            this.releasedHandles.put(handle, new HandleMonitorEntry(now, reason));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logHandleCleanup(long maxAgeMs) {
        if (!this.enableHandleMonitoring) {
            return;
        }
        long now = System.currentTimeMillis();
        Map<Integer, HandleMonitorEntry> map = this.releasedHandles;
        synchronized (map) {
            ArrayList<Integer> toRemoveList = new ArrayList<Integer>();
            for (Map.Entry<Integer, HandleMonitorEntry> entry : this.releasedHandles.entrySet()) {
                if (now - entry.getValue().timestamp <= maxAgeMs) continue;
                toRemoveList.add(entry.getKey());
            }
            for (Integer key : toRemoveList) {
                this.releasedHandles.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandleMonitorEntry getHandleReleaseLog(int handle) {
        Map<Integer, HandleMonitorEntry> map = this.releasedHandles;
        synchronized (map) {
            return this.releasedHandles.get(handle);
        }
    }

    public Map<Integer, HandleMonitorEntry> getReleasedHandles() {
        return this.releasedHandles;
    }

    public Map getUnavailableComponents() {
        return this.unavailableComponents;
    }

    public Map<String, ComponentInfo> getDefaultComponents() {
        return this.defaultComponents;
    }

    public Context getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public void setRemoteDirectory(Context remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    public Object getManagerComponentReference() {
        return this.managerComponentReference;
    }

    public Object getRemoteDirectoryComponentReference() {
        return this.remoteDirectoryComponentReference;
    }

    public void setManagerComponentReference(Object managerComponentReference) {
        if (this.managerComponentReference != null) {
            this.unbind(FAULT_FAMILY, null);
        }
        this.managerComponentReference = managerComponentReference;
        if (this.managerComponentReference != null) {
            this.bind(FAULT_FAMILY, null, managerComponentReference);
        }
    }

    public void setRemoteDirectoryComponentReference(Object remoteDirectoryComponentReference) {
        this.remoteDirectoryComponentReference = remoteDirectoryComponentReference;
    }

    public boolean isShuttingDown() {
        return this.shutdown.get();
    }

    public ManagerShutdown getShutdownImplementation() {
        return this.shutdownImplementation;
    }

    public void setShutdownImplementation(ManagerShutdown shutdownImplementation) {
        this.shutdownImplementation = shutdownImplementation;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(long l) {
        this.lockTimeout = l;
    }

    public void setCDBAccess(CDBAccess cdbAccess) {
        this.destroyComponetsDAOProxy();
        this.destroyManagerDAOProxy();
        if (this.cdbAccess != null) {
            this.cdbAccess.destroy();
        }
        this.cdbAccess = cdbAccess;
        if (cdbAccess != null) {
            this.getManagerDAOProxy();
            this.getComponentsDAOProxy();
        }
    }

    public HashSet getActiveAlarms() {
        return this.activeAlarms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveAlarm(String faultMember) {
        HashSet hashSet = this.activeAlarms;
        synchronized (hashSet) {
            return this.activeAlarms.contains(faultMember);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarmRaised(String faultMember) {
        HashSet hashSet = this.activeAlarms;
        synchronized (hashSet) {
            this.executeCommand(new AlarmRaised(faultMember));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarmCleared(String faultMember) {
        HashSet hashSet = this.activeAlarms;
        synchronized (hashSet) {
            this.executeCommand(new AlarmCleared(faultMember));
        }
    }

    private class GroupedNotifyTask
    implements Runnable {
        private final Object key;
        private final Deque<GroupedRunnable> tasks = new LinkedList<GroupedRunnable>();

        public GroupedNotifyTask(Object key, GroupedRunnable task) {
            this.key = key;
            this.addTask(task);
        }

        public void addTask(GroupedRunnable task) {
            this.tasks.addLast(task);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block10: {
                Map<Object, GroupedNotifyTask> map;
                GroupedRunnable taskToRun;
                do {
                    map = ManagerImpl.this.groupedNotifyTaskMap;
                    synchronized (map) {
                        taskToRun = this.tasks.pollFirst();
                        if (taskToRun == null) {
                            ManagerImpl.this.groupedNotifyTaskMap.remove(this.key);
                            break block10;
                        }
                    }
                    try {
                        taskToRun.run();
                    }
                    catch (Throwable th) {
                        ManagerImpl.this.logger.log(Level.SEVERE, "Unhandeled exception caught.", th);
                    }
                } while (!taskToRun.isCancelAll());
                map = ManagerImpl.this.groupedNotifyTaskMap;
                synchronized (map) {
                    this.tasks.clear();
                    ManagerImpl.this.groupedNotifyTaskMap.remove(this.key);
                }
            }
        }
    }

    static interface GroupedRunnable
    extends Runnable {
        public void cancelAll();

        public boolean isCancelAll();
    }

    class ServiceComponent
    implements Component {
        private final Object object;

        public ServiceComponent(Object object) {
            assert (object != null);
            this.object = object;
        }

        @Override
        public void construct() throws RemoteException {
        }

        @Override
        public void destruct() throws RemoteException {
        }

        @Override
        public Object getObject() {
            return this.object;
        }

        @Override
        public String[] implementedInterfaces() {
            return new String[]{this.object.getClass().getName()};
        }

        @Override
        public boolean doesImplement(String type) {
            return false;
        }
    }

    class ReleaseComponentResult {
        public int owners;
        public Throwable exception;

        public ReleaseComponentResult(int owners, Throwable exception) {
            this.owners = owners;
            this.exception = exception;
        }
    }

    public static enum WhyUnloadedReason {
        REMOVED,
        TIMEOUT,
        DISAPPEARED,
        REPLACED;

    }

    class ReleaseComponentTask
    implements Runnable {
        private final int h;
        private final int[] handles;

        public ReleaseComponentTask(int h, int handle) {
            this.h = h;
            this.handles = new int[]{handle};
        }

        public ReleaseComponentTask(int h, int[] handles) {
            assert (handles != null);
            this.h = h;
            this.handles = handles;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.handles.length; ++i) {
                try {
                    ManagerImpl.this.internalReleaseComponent(this.h, this.handles[i], false);
                    continue;
                }
                catch (Throwable ex) {
                    CoreException ce = new CoreException("Failed to release component with handle '" + this.handles[i] + "'.", ex);
                    ManagerImpl.this.reportException(ce);
                }
            }
        }
    }

    private class ClientMessageTask
    implements Runnable {
        private Client client;
        private String message;
        private MessageType messageType;
        private short messageID;

        public ClientMessageTask(Client client, String message, MessageType messageType, short messageID) {
            this.client = client;
            this.message = message;
            this.messageType = messageType;
            this.messageID = messageID;
        }

        @Override
        public void run() {
            try {
                if (this.messageID > 0) {
                    this.client.taggedmessage(this.messageType, this.messageID, this.message);
                } else {
                    this.client.message(this.messageType, this.message);
                }
            }
            catch (Throwable re) {
                ManagerImpl.this.logger.log(Level.WARNING, "Exception caught while invoking 'Client.message' on " + this.client + ".", re);
            }
        }
    }

    static class HandleMonitorEntry
    implements Serializable {
        private static final long serialVersionUID = -5661590007096077942L;
        public final long timestamp;
        public final WhyUnloadedReason reason;

        public HandleMonitorEntry(long timestamp, WhyUnloadedReason reason) {
            this.timestamp = timestamp;
            this.reason = reason;
        }
    }

    private class ComponentInfoCompletionCallbackImpl
    implements Container.ComponentInfoCompletionCallback {
        final int requestor;
        final String name;
        final String type;
        final String code;
        final String containerName;
        final int keepAliveTime;
        final StatusHolder status;
        final boolean isOtherDomainComponent;
        final boolean isDynamicComponent;
        final int h;
        final boolean reactivate;
        final Container container;
        final ContainerInfo containerInfo;
        final long executionId;
        final long activationTime;
        boolean timeoutError;
        private final Object sync = new Object();
        private volatile ComponentInfo componentInfo;
        private volatile Throwable exception = null;
        private volatile boolean done = false;

        public ComponentInfoCompletionCallbackImpl(int requestor, String name, String type, String code, String containerName, int keepAliveTime, StatusHolder status, boolean isOtherDomainComponent, boolean isDynamicComponent, int h, boolean reactivate, Container container, ContainerInfo containerInfo, long executionId, long activationTime) {
            this.requestor = requestor;
            this.name = name;
            this.type = type;
            this.code = code;
            this.containerName = containerName;
            this.keepAliveTime = keepAliveTime;
            this.status = status;
            this.isOtherDomainComponent = isOtherDomainComponent;
            this.isDynamicComponent = isDynamicComponent;
            this.h = h;
            this.reactivate = reactivate;
            this.container = container;
            this.containerInfo = containerInfo;
            this.executionId = executionId;
            this.activationTime = activationTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ComponentInfo waitUntilActivated(long timeToWait) throws Throwable {
            Object object = this.sync;
            synchronized (object) {
                while (!this.done) {
                    try {
                        this.sync.wait(timeToWait);
                        if (this.done) continue;
                        throw new TimeoutRemoteException("Activation did not finish in time.");
                    }
                    catch (InterruptedException ex) {
                        this.exception = ex;
                        break;
                    }
                }
                if (this.exception != null) {
                    throw this.exception;
                }
                return this.componentInfo;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(ComponentInfo result) {
            ManagerImpl.this.logger.log((Level)AcsLogLevel.DEBUG, "Container responded with 'done' callback to indicate activation of a component '" + this.name + "'.");
            if (!ManagerImpl.this.removePendingContainerAsyncRequest(this.containerName, this)) {
                ManagerImpl.this.logger.log((Level)AcsLogLevel.DEBUG, "Duplicate async callback response (with 'done') for a component '" + this.name + "'.");
                return;
            }
            Object object = this.sync;
            synchronized (object) {
                try {
                    this.componentInfo = ManagerImpl.this.internalNoSyncRequestComponentPhase2(this.requestor, this.name, this.type, this.code, this.containerName, this.keepAliveTime, this.status, null, this.isOtherDomainComponent, this.isDynamicComponent, this.h, this.reactivate, result, this.container, this.containerInfo, this.executionId, this.activationTime, this.timeoutError);
                }
                catch (Throwable th) {
                    this.exception = th;
                    ManagerImpl.this.logger.log((Level)AcsLogLevel.DEBUG, "Failed to process the freshly activated '" + this.name + "' component's data.", th);
                }
                finally {
                    this.done = true;
                    this.sync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(ComponentInfo result, Throwable exception) {
            if (!ManagerImpl.this.removePendingContainerAsyncRequest(this.containerName, this)) {
                ManagerImpl.this.logger.log((Level)AcsLogLevel.DEBUG, "Duplicate async callback response (with 'failed') for a component '" + this.name + "'.");
                return;
            }
            Object object = this.sync;
            synchronized (object) {
                try {
                    boolean timeoutError = exception instanceof TimeoutRemoteException;
                    AcsJCannotGetComponentEx bcex = exception instanceof AcsJCannotGetComponentEx ? (AcsJCannotGetComponentEx)exception : new AcsJCannotGetComponentEx(exception);
                    ManagerImpl.this.logger.log(Level.SEVERE, "Failed to activate component '" + this.name + "' on container '" + this.containerName + "'.", (Throwable)bcex);
                    this.componentInfo = ManagerImpl.this.internalNoSyncRequestComponentPhase2(this.requestor, this.name, this.type, this.code, this.containerName, this.keepAliveTime, this.status, bcex, this.isOtherDomainComponent, this.isDynamicComponent, this.h, this.reactivate, result, this.container, this.containerInfo, this.executionId, this.activationTime, timeoutError);
                }
                catch (Throwable th) {
                    this.exception = th;
                }
                finally {
                    this.done = true;
                    this.sync.notifyAll();
                }
            }
        }
    }

    class DeactivateComponentTask
    extends TimerTask {
        private final String name;

        public DeactivateComponentTask(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            try {
                ManagerImpl.this.internalDeactivateComponent(this.name);
            }
            catch (Throwable th) {
                CoreException ce = new CoreException("Failed to deactivate component '" + this.name + "'.", th);
                ManagerImpl.this.reportException(ce);
            }
        }
    }

    class ShutdownContainerTask
    extends TimerTask {
        private final String containerName;

        public ShutdownContainerTask(String containerName) {
            this.containerName = containerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ContainerInfo containerInfo = ManagerImpl.this.getContainerInfo(this.containerName);
                if (containerInfo == null) {
                    return;
                }
                IntArray intArray = containerInfo.getComponents();
                synchronized (intArray) {
                    if (containerInfo.getComponents().size() > 0) {
                        return;
                    }
                }
                int SHUTDOWN_CONTAINER_ACTION = 512;
                ManagerImpl.this.shutdownContainer(ManagerImpl.this.getHandle(), this.containerName, 512);
            }
            catch (Throwable th) {
                CoreException ce = new CoreException("Failed to shutdown container '" + this.containerName + "'.", th);
                ManagerImpl.this.reportException(ce);
            }
        }
    }

    class ReferenceCountingLock {
        private final AtomicInteger references = new AtomicInteger(1);
        private final Lock lock = new ReentrantLock();
        private Object userData = null;

        public boolean acquire(long msecs) {
            try {
                return this.lock.tryLock(msecs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                return false;
            }
        }

        public void release() {
            this.lock.unlock();
        }

        public int referenceCount() {
            return this.references.get();
        }

        public int increment() {
            return this.references.incrementAndGet();
        }

        public int decrement() {
            return this.references.decrementAndGet();
        }

        public Object getUserData() {
            return this.userData;
        }

        public void setUserData(Object userData) {
            this.userData = userData;
        }
    }

    abstract class DefaultGroupedRunnable
    implements GroupedRunnable {
        private boolean cancelAll = false;

        DefaultGroupedRunnable() {
        }

        @Override
        public void cancelAll() {
            this.cancelAll = true;
        }

        @Override
        public boolean isCancelAll() {
            return this.cancelAll;
        }
    }

    class RequestComponentTask
    implements Runnable {
        private final int h;
        private final URI[] curls;

        public RequestComponentTask(int h, URI curl) {
            assert (curl != null);
            this.h = h;
            this.curls = new URI[]{curl};
        }

        public RequestComponentTask(int h, URI[] curls) {
            assert (curls != null);
            this.h = h;
            this.curls = curls;
        }

        @Override
        public void run() {
            StatusHolder status = new StatusHolder();
            for (int i = 0; i < this.curls.length; ++i) {
                try {
                    ManagerImpl.this.internalRequestComponent(this.h, this.curls[i], status);
                    if (status.getStatus() == ComponentStatus.COMPONENT_ACTIVATED) continue;
                    ManagerImpl.this.logger.log(Level.FINE, "Failed to activate requested component '" + this.curls[i] + "', reason: '" + status.getStatus() + "'.");
                    continue;
                }
                catch (Throwable ex) {
                    CoreException ce = new CoreException("Failed to request component '" + this.curls[i] + "'.", ex);
                    ManagerImpl.this.reportException(ce);
                }
            }
        }
    }
}

