/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager.app;

import com.cosylab.acs.maci.manager.app.RecoveryFilesRemover;
import com.cosylab.util.FileHelper;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.prevayler.Prevayler;

public class RecoverySnapshotTask
extends TimerTask {
    private final Timer t = new Timer(true);
    private final Prevayler prevayler;
    private final String recoveryLocation;
    private final AtomicBoolean enableFlag;

    public RecoverySnapshotTask(Prevayler prevayler, long period, String recoveryLocation, AtomicBoolean enableFlag) {
        this.prevayler = prevayler;
        this.recoveryLocation = recoveryLocation;
        this.enableFlag = enableFlag;
        this.t.schedule((TimerTask)this, period, period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Prevayler prevayler = this.prevayler;
            synchronized (prevayler) {
                if (this.enableFlag.get()) {
                    this.prevayler.takeSnapshot();
                }
            }
            FileHelper.setFileAttributes((String)"g+w", (String)this.recoveryLocation);
            RecoveryFilesRemover.removeRecoveryFiles(new File(this.recoveryLocation));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

