/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.ukatc.xsltchain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class ApplicationProperties {
    private Properties props;
    String appname;
    String rcname;
    String syspname;

    ApplicationProperties(String appname) {
        this.appname = appname;
        this.rcname = "." + appname + "rc";
        this.syspname = String.valueOf(appname) + "rc";
        this.props = new Properties();
        this.props.setProperty("PropertyFile", "");
    }

    ApplicationProperties(String appname, String rcname) {
        this.appname = appname;
        this.rcname = rcname;
        this.syspname = String.valueOf(appname) + "rc";
        this.props = new Properties();
        this.props.setProperty("PropertyFile", "");
    }

    void Merge(Properties p) {
        this.props.putAll((Map<?, ?>)p);
    }

    public static Properties get_properties(String FileName) throws IOException {
        File pf = new File(FileName);
        if (pf.canRead()) {
            FileInputStream ps = new FileInputStream(pf);
            Properties p = new Properties();
            p.load(ps);
            p.setProperty("PropertyFile", FileName);
            return p;
        }
        return null;
    }

    public void load_defaults() throws IOException {
        String config_filename = System.getProperty(this.syspname);
        if (config_filename != null && this.MergePropertyFile(config_filename)) {
            throw new FileNotFoundException("Not found or not readable :" + config_filename);
        }
        String fs = System.getProperty("file.separator");
        String CWD = System.getProperty("user.dir");
        config_filename = String.valueOf(CWD) + fs + this.syspname;
        this.MergePropertyFile(config_filename);
        String homedir = System.getProperty("user.home");
        config_filename = String.valueOf(homedir) + fs + this.syspname;
        this.MergePropertyFile(config_filename);
    }

    boolean MergePropertyFile(String filename) throws IOException {
        Properties p = ApplicationProperties.get_properties(filename);
        if (p == null) {
            return false;
        }
        this.Merge(p);
        return true;
    }
}

