/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Logger;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.util.Base64OutputStream;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOSerializer;

public class VOTableWriter
implements StarTableWriter {
    private DataFormat dataFormat = DataFormat.TABLEDATA;
    private boolean inline = true;
    private String xmlDeclaration = "<?xml version='1.0'?>";
    private String doctypeDeclaration = "";
    private String votableVersion = "1.1";
    public static final String DEFAULT_XML_DECLARATION = "<?xml version='1.0'?>";
    public static final String DEFAULT_DOCTYPE_DECLARATION = "";
    public static final String DEFAULT_VOTABLE_VERSION = "1.1";
    private static final Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VOTableWriter() {
        this(DataFormat.TABLEDATA, true);
    }

    public VOTableWriter(DataFormat dataFormat, boolean inline) {
        this.dataFormat = dataFormat;
        this.inline = inline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable startab, String location, StarTableOutput sto) throws IOException {
        OutputStream out = null;
        try {
            File file;
            out = sto.getOutputStream(location);
            File file2 = file = out instanceof FileOutputStream ? new File(location) : null;
            if (!this.inline && file == null) {
                throw new TableFormatException("Can't write non-inline format to a stream");
            }
            this.writeStarTable(startab, out, file);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void writeStarTable(StarTable startab, OutputStream out) throws IOException {
        this.writeStarTable(startab, out, null);
    }

    public void writeStarTable(StarTable startab, OutputStream out, File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
        VOSerializer serializer = VOSerializer.makeSerializer(this.dataFormat, startab);
        this.writePreTableXML(serializer, writer);
        serializer.writePreDataXML(writer);
        if (this.inline || file == null) {
            if (!this.inline) {
                if (!$assertionsDisabled && file != null) {
                    throw new AssertionError();
                }
                logger.warning("Writing VOTable inline - can't do href when no filename is supplied");
            }
            if (serializer instanceof VOSerializer.StreamableVOSerializer) {
                String tagname;
                VOSerializer.StreamableVOSerializer streamer = (VOSerializer.StreamableVOSerializer)serializer;
                if (this.dataFormat == DataFormat.FITS) {
                    tagname = "FITS";
                } else if (this.dataFormat == DataFormat.BINARY) {
                    tagname = "BINARY";
                } else {
                    throw new AssertionError((Object)("Unknown format " + this.dataFormat.toString()));
                }
                writer.write("<DATA>");
                writer.newLine();
                writer.write('<' + tagname + '>');
                writer.newLine();
                writer.write("<STREAM encoding='base64'>");
                writer.newLine();
                writer.flush();
                Base64OutputStream b64strm = new Base64OutputStream((OutputStream)new BufferedOutputStream(out), 16);
                DataOutputStream dataout = new DataOutputStream((OutputStream)b64strm);
                streamer.streamData(dataout);
                dataout.flush();
                b64strm.endBase64();
                b64strm.flush();
                writer.write("</STREAM>");
                writer.newLine();
                writer.write("</" + tagname + ">");
                writer.newLine();
                writer.write("</DATA>");
                writer.newLine();
            } else {
                serializer.writeInlineDataElement(writer);
            }
        } else {
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError();
            }
            String basename = file.getName();
            int dotpos = basename.lastIndexOf(46);
            basename = dotpos > 0 ? basename.substring(0, dotpos) : basename;
            String extension = this.dataFormat == DataFormat.FITS ? ".fits" : ".bin";
            String dataname = basename + "-data" + extension;
            File datafile = new File(file.getParentFile(), dataname);
            DataOutputStream dataout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(datafile)));
            serializer.writeHrefDataElement(writer, dataname, dataout);
            dataout.close();
        }
        serializer.writePostDataXML(writer);
        this.writePostTableXML(serializer, writer);
        writer.flush();
    }

    public void writeInlineStarTable(StarTable startab, BufferedWriter writer) throws IOException {
        VOSerializer serializer = VOSerializer.makeSerializer(this.dataFormat, startab);
        this.writePreTableXML(serializer, writer);
        serializer.writeInlineTableElement(writer);
        this.writePostTableXML(serializer, writer);
        writer.flush();
    }

    protected void writePreTableXML(VOSerializer serializer, BufferedWriter writer) throws IOException {
        if (this.xmlDeclaration != null && this.xmlDeclaration.length() > 0) {
            writer.write(this.xmlDeclaration);
            writer.newLine();
        }
        if (this.doctypeDeclaration != null && this.doctypeDeclaration.length() > 0) {
            writer.write(this.doctypeDeclaration);
            writer.newLine();
        }
        writer.write("<VOTABLE");
        if (this.votableVersion != null && this.votableVersion.matches("1.[1-9]")) {
            writer.write(VOSerializer.formatAttribute("version", this.votableVersion));
            if (this.doctypeDeclaration == null || this.doctypeDeclaration.length() == 0) {
                String votableNamespace;
                String votableSchemaLocation = votableNamespace = "http://www.ivoa.net/xml/VOTable/v" + this.votableVersion;
                writer.newLine();
                writer.write(VOSerializer.formatAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
                writer.newLine();
                writer.write(VOSerializer.formatAttribute("xsi:schemaLocation", votableNamespace + " " + votableSchemaLocation));
                writer.newLine();
                writer.write(VOSerializer.formatAttribute("xmlns", votableNamespace));
            }
        }
        writer.write(">");
        writer.newLine();
        writer.write("<!--");
        writer.newLine();
        writer.write(" !  VOTable written by STIL version " + IOUtils.getResourceContents((Class)StarTable.class, (String)"stil.version") + " (" + VOSerializer.formatText(this.getClass().getName()) + ")");
        writer.newLine();
        writer.write(" !  at " + AbstractFitsTableWriter.getCurrentDate());
        writer.newLine();
        writer.write(" !-->");
        writer.newLine();
        writer.write("<RESOURCE>");
        writer.newLine();
    }

    protected void writePostTableXML(VOSerializer serializer, BufferedWriter writer) throws IOException {
        writer.write("</RESOURCE>");
        writer.newLine();
        writer.write("</VOTABLE>");
        writer.newLine();
    }

    public boolean looksLikeFile(String filename) {
        return filename.endsWith(".xml") || filename.endsWith(".vot") || filename.endsWith(".votable");
    }

    public String getFormatName() {
        StringBuffer fname = new StringBuffer("votable");
        if (this.dataFormat == DataFormat.TABLEDATA) {
            fname.append("-tabledata");
            return fname.toString();
        }
        if (this.dataFormat == DataFormat.FITS) {
            fname.append("-fits");
        } else if (this.dataFormat == DataFormat.BINARY) {
            fname.append("-binary");
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        fname.append(this.inline ? "-inline" : "-href");
        return fname.toString();
    }

    public String getMimeType() {
        String type = "application/x-votable+xml";
        String encoding = this.dataFormat == DataFormat.TABLEDATA ? "TABLEDATA" : (this.dataFormat == DataFormat.BINARY ? "BINARY" : (this.dataFormat == DataFormat.FITS ? "FITS" : null));
        return "application/x-votable+xml" + (encoding == null ? DEFAULT_DOCTYPE_DECLARATION : "; encoding=\"" + encoding + "\"");
    }

    public void setDataFormat(DataFormat format) {
        this.dataFormat = format;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public boolean getInline() {
        return this.inline;
    }

    public void setXMLDeclaration(String xmlDecl) {
        this.xmlDeclaration = xmlDecl;
    }

    public String getXMLDeclaration() {
        return this.xmlDeclaration;
    }

    public void setDoctypeDeclaration(String doctypeDecl) {
        this.doctypeDeclaration = doctypeDecl;
    }

    public String getDoctypeDeclaration() {
        return this.doctypeDeclaration;
    }

    public static StarTableWriter[] getStarTableWriters() {
        return new StarTableWriter[]{new VOTableWriter(DataFormat.TABLEDATA, true), new VOTableWriter(DataFormat.BINARY, true), new VOTableWriter(DataFormat.FITS, false), new VOTableWriter(DataFormat.BINARY, false), new VOTableWriter(DataFormat.FITS, true)};
    }

    static {
        $assertionsDisabled = !VOTableWriter.class.desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.votable");
    }
}

