/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;

public class GridBagLayouter {
    public static final int SCHEME1 = 1;
    public static final int SCHEME2 = 2;
    public static final int SCHEME3 = 3;
    public static final int SCHEME4 = 4;
    public static final int SCHEME5 = 5;
    private Container container = null;
    private GridBagConstraints gbc = new GridBagConstraints();
    private int scheme = 1;
    private int entryCount = 0;
    private Insets insets = new Insets(2, 0, 0, 2);

    public GridBagLayouter(Container container) {
        this(container, 1);
    }

    public GridBagLayouter(Container container, int scheme) {
        this.container = container;
        container.setLayout(new GridBagLayout());
        this.scheme = scheme;
        this.resetGbc();
    }

    public void add(String label, boolean complete) {
        this.add((Component)new JLabel(label), complete);
    }

    public void add(String label) {
        this.add(label, false);
    }

    public void add(Component component, boolean complete) {
        switch (this.scheme) {
            case 1: {
                this.addScheme1(component, complete);
                break;
            }
            case 2: {
                this.addScheme2(component, complete);
                break;
            }
            case 3: {
                this.addScheme3(component, complete);
                break;
            }
            case 4: {
                this.addScheme4(component, complete);
                break;
            }
            case 5: {
                this.addScheme5(component, complete);
            }
        }
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
        this.gbc.insets = insets;
    }

    private void addScheme1(Component component, boolean complete) {
        if (component instanceof JLabel) {
            this.setForLabel();
        } else {
            this.setForNonLabel();
        }
        this.container.add(component, this.gbc);
        if (complete) {
            this.eatLine();
        }
    }

    private void addScheme2(Component component, boolean complete) {
        if (component instanceof JLabel) {
            this.setForLabel();
        } else {
            this.setForNonLabel();
        }
        double weight = 0.0;
        switch (this.entryCount) {
            case 0: {
                weight = 0.15;
                break;
            }
            case 2: {
                weight = 0.85;
            }
        }
        this.gbc.weightx = weight;
        if (complete) {
            this.gbc.gridwidth = 0;
            this.entryCount = 0;
        } else {
            ++this.entryCount;
        }
        this.container.add(component, this.gbc);
    }

    private void addScheme3(Component component, boolean complete) {
        if (component instanceof JLabel) {
            this.setForLabel();
        } else {
            this.setForNonLabel();
        }
        if (complete) {
            this.gbc.gridwidth = 0;
            this.gbc.fill = 2;
            this.gbc.weightx = 1.0;
        }
        this.container.add(component, this.gbc);
    }

    private void addScheme4(Component component, boolean complete) {
        if (component instanceof JLabel) {
            this.setForLabel();
        } else {
            this.setForNonLabel();
        }
        if (complete) {
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            if (this.entryCount == 0) {
                this.gbc.fill = 1;
                this.gbc.weighty = 1.0;
            } else {
                this.gbc.fill = 2;
            }
            this.entryCount = 0;
        } else {
            ++this.entryCount;
        }
        this.container.add(component, this.gbc);
        this.gbc.weighty = 0.0;
    }

    private void addScheme5(Component component, boolean complete) {
        this.setForNonLabel();
        this.container.add(component, this.gbc);
        if (complete) {
            this.eatLine();
        }
    }

    public void add(Component component, GridBagConstraints gbc) {
        this.container.add(component, gbc);
    }

    private void resetGbc() {
        this.gbc.insets = this.insets;
        switch (this.scheme) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                this.gbc.anchor = 17;
                this.gbc.fill = 0;
                this.gbc.gridwidth = 1;
                this.gbc.weightx = 0.0;
                break;
            }
            case 2: {
                this.gbc.anchor = 13;
                this.gbc.fill = 2;
                this.gbc.gridwidth = 1;
                this.gbc.weightx = 0.0;
            }
        }
    }

    private void setForLabel() {
        this.resetGbc();
        switch (this.scheme) {
            case 1: 
            case 3: 
            case 4: {
                this.gbc.anchor = 13;
                break;
            }
            case 2: 
            case 5: {
                this.gbc.anchor = 17;
            }
        }
    }

    private void setForNonLabel() {
        this.resetGbc();
    }

    public void eatLine() {
        this.resetGbc();
        this.gbc.gridwidth = 0;
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.container.add(Box.createHorizontalGlue(), this.gbc);
    }

    public void eatSpare() {
        this.resetGbc();
        this.gbc.gridwidth = 0;
        this.gbc.gridheight = 0;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this.container.add(Box.createVerticalGlue(), this.gbc);
    }

    public Container getContainer() {
        return this.container;
    }
}

