/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.science.Quantity;
import jsky.science.Time;
import jsky.util.Resources;
import jsky.util.gui.RangeSlider;

public class QuantitySlider
extends JPanel
implements PropertyChangeListener,
ChangeListener,
ActionListener,
MouseListener {
    public static final String MINQUANTITY_PROPERTY = "MinQ";
    public static final String MAXQUANTITY_PROPERTY = "MaxQ";
    public static final String QUANTITY_PROPERTY = "MinQ";
    Quantity fScaleMin;
    Quantity fScaleMax;
    Quantity fMinValue;
    Quantity fMaxValue;
    boolean fMinChangeable = false;
    boolean fMaxChangeable = false;
    RangeSlider fSlider;
    JButton fButtonNewMin;
    JButton fButtonNewMax;
    Timer fTimer;
    protected boolean fIsBordered;
    protected String fTitle;
    protected JLabel fLabelTitle;
    protected TitledBorder fBorder;
    protected boolean fShowExtent = false;

    public QuantitySlider() {
        this(0, new Time(50.0), new Time(0.0), new Time(100.0), "Exposure Time", true);
    }

    public QuantitySlider(Quantity inQ, Quantity scaleMin, Quantity scaleMax, String title) {
        this(0, inQ, inQ, scaleMin, scaleMax, title, true, false);
    }

    public QuantitySlider(int orient, Quantity inQ, Quantity scaleMin, Quantity scaleMax, String title, boolean borderOn) {
        this(orient, inQ, inQ, scaleMin, scaleMax, title, borderOn, false);
    }

    public QuantitySlider(int orient, Quantity minQ, Quantity maxQ, Quantity scaleMin, Quantity scaleMax, String title, boolean borderOn) {
        this(orient, minQ, maxQ, scaleMin, scaleMax, title, borderOn, true);
    }

    public QuantitySlider(int orient, Quantity inMinQ, Quantity inMaxQ, Quantity scaleMin, Quantity scaleMax, String title, boolean borderOn, boolean showExtent) {
        this.fScaleMin = scaleMin;
        this.fScaleMax = scaleMax;
        this.fMinValue = inMinQ;
        this.fMaxValue = inMaxQ;
        this.fTimer = new Timer(100, this);
        this.fTimer.setRepeats(false);
        this.fTitle = title;
        this.fIsBordered = borderOn;
        this.fShowExtent = showExtent;
        this.addFields(orient, showExtent);
        this.updateTitle();
    }

    protected void updateTitle() {
        StringBuffer sb = new StringBuffer();
        if (this.fTitle != null) {
            sb.append(this.fTitle);
            sb.append(": ");
        }
        sb.append(this.fMinValue.toString());
        if (this.fShowExtent) {
            sb.append(" - ");
            sb.append(this.fMaxValue.toString());
        }
        String newtitle = sb.toString();
        if (this.fIsBordered) {
            this.setBorder(BorderFactory.createTitledBorder(newtitle));
        } else {
            this.fLabelTitle.setText(newtitle);
        }
    }

    private void addFields(int orient, boolean showExtent) {
        int fontsize;
        this.setLayout(new BorderLayout(0, 0));
        JPanel panelNorth = new JPanel(new BorderLayout(0, 0));
        if (!this.fIsBordered) {
            panelNorth.setLayout(new GridLayout(1, 2, 0, 0));
            this.fLabelTitle = new JLabel("", 2);
            panelNorth.add(this.fLabelTitle);
        }
        this.add((Component)panelNorth, "North");
        Image icon = QuantitySlider.findImage(this, "JumpLeft16.gif");
        if (icon == null) {
            this.fButtonNewMin = new JButton("|<");
            fontsize = this.fButtonNewMin.getFont().getSize() - 1;
            this.fButtonNewMin.setFont(new Font(this.fButtonNewMin.getFont().getName(), this.fButtonNewMin.getFont().getStyle(), fontsize));
        } else {
            this.fButtonNewMin = new JButton(new ImageIcon(icon));
            this.fButtonNewMin.setPreferredSize(new Dimension(18, 18));
            this.fButtonNewMin.setMinimumSize(new Dimension(18, 18));
            this.fButtonNewMin.setMaximumSize(new Dimension(18, 18));
            this.fButtonNewMin.setBorderPainted(false);
        }
        icon = QuantitySlider.findImage(this, "JumpRight16.gif");
        if (icon == null) {
            this.fButtonNewMax = new JButton(">|");
            fontsize = this.fButtonNewMax.getFont().getSize() - 1;
            this.fButtonNewMax.setFont(new Font(this.fButtonNewMax.getFont().getName(), this.fButtonNewMax.getFont().getStyle(), fontsize));
        } else {
            this.fButtonNewMax = new JButton(new ImageIcon(icon));
            this.fButtonNewMax.setPreferredSize(new Dimension(18, 18));
            this.fButtonNewMax.setMinimumSize(new Dimension(18, 18));
            this.fButtonNewMax.setMaximumSize(new Dimension(18, 18));
            this.fButtonNewMax.setBorderPainted(false);
        }
        this.fSlider = new RangeSlider(orient, (int)this.fScaleMin.getValue(), (int)this.fScaleMax.getValue(), (int)this.fMinValue.getValue(), (int)(this.fMaxValue.getValue() - this.fMinValue.getValue()), showExtent);
        this.updateTicks();
        if (orient == 0) {
            this.add((Component)this.fButtonNewMin, "West");
            this.add((Component)this.fButtonNewMax, "East");
        } else {
            this.add((Component)this.fButtonNewMin, "South");
            this.add((Component)this.fButtonNewMax, "North");
        }
        JPanel cPanel = new JPanel(new FlowLayout(1, 0, 0));
        this.add((Component)cPanel, "Center");
        cPanel.add((Component)this.fSlider);
        this.fButtonNewMax.addActionListener(this);
        this.fSlider.addChangeListener((ChangeListener)this);
        this.fButtonNewMin.addActionListener(this);
        this.fSlider.addMouseListener((MouseListener)this);
        this.fSlider.setToolTipText("Drag slider to change value, or double click to type a new value");
        this.fButtonNewMin.setToolTipText("Click to change minimum scale value");
        this.fButtonNewMax.setToolTipText("Click to change maximum scale value");
        this.fSlider.requestFocus();
    }

    public void setSliderDelay(int delay) {
        this.fTimer.setInitialDelay(delay);
    }

    public boolean isMinimumChangeable() {
        return this.fMinChangeable;
    }

    public boolean isMaximumChangeable() {
        return this.fMaxChangeable;
    }

    public void setMinimumChangeable(boolean b) {
        this.fMinChangeable = b;
        this.fButtonNewMin.setVisible(b);
    }

    public void setMaximumChangeable(boolean b) {
        this.fMaxChangeable = b;
        this.fButtonNewMax.setVisible(b);
    }

    private void updateTicks() {
        int ticks = (int)((this.fScaleMax.getValue() - this.fScaleMin.getValue()) / 4.0);
        this.fSlider.setLabelTable(null);
        this.fSlider.setMajorTickSpacing(ticks);
        this.fSlider.setMinorTickSpacing(ticks / 5);
    }

    public Quantity getQuantity() {
        return this.fMinValue;
    }

    public Quantity getExtent() {
        return this.fMaxValue;
    }

    public boolean getValueIsAdjusting() {
        return this.fSlider.getValueIsAdjusting();
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.fSlider) {
            this.fTimer.restart();
            int newV = this.fSlider.getValue();
            this.setMinQuantity(this.fMinValue.newInstance(newV));
            this.setMaxQuantity(this.fMaxValue.newInstance(newV += this.fSlider.getExtent()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.fTimer) {
            this.firePropertyChange("MinQ", null, this.fMinValue);
            this.firePropertyChange(MAXQUANTITY_PROPERTY, null, this.fMaxValue);
        } else if (event.getSource() == this.fButtonNewMin) {
            StringBuffer sb = new StringBuffer("Enter new minimum value (");
            sb.append(this.fMinValue.getDefaultUnits());
            sb.append("):");
            double val = this.popupQuantityRequest("New Minimum Value", sb.toString());
            if (!Double.isNaN(val)) {
                this.setScaleMinimum((int)val);
            }
        } else if (event.getSource() == this.fButtonNewMax) {
            StringBuffer sb = new StringBuffer("Enter new maximum value (");
            sb.append(this.fMinValue.getDefaultUnits());
            sb.append("):");
            double val = this.popupQuantityRequest("New Maximum Value", sb.toString());
            if (!Double.isNaN(val)) {
                this.setScaleMaximum((int)val);
            }
        }
    }

    public double popupQuantityRequest(String title, String message) {
        double returnValue = Double.NaN;
        String reply = JOptionPane.showInputDialog(this, message, title, 3);
        if (reply != null) {
            try {
                returnValue = Double.parseDouble(reply);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public void setScaleMinimum(int m) {
        this.fScaleMin = this.fScaleMin.newInstance(m);
        this.updateTicks();
        this.fSlider.setMinimum((int)Math.floor(m));
    }

    public void setScaleMaximum(int m) {
        this.fScaleMax = this.fScaleMax.newInstance(m);
        this.updateTicks();
        this.fSlider.setMaximum((int)Math.ceil(m));
    }

    public void setQuantity(Quantity inQ) {
        this.setMinQuantity(inQ);
    }

    public void setMinQuantity(Quantity inQ) {
        Quantity oldQ = this.fMinValue;
        this.fMinValue = inQ;
        this.updateTitle();
        this.updateScaleMinMax((int)this.fMinValue.getValue());
        this.fSlider.setValue((int)inQ.getValue());
        this.firePropertyChange("MinQ", oldQ, inQ);
    }

    public void setMaxQuantity(Quantity inQ) {
        Quantity oldQ = this.fMaxValue;
        this.fMaxValue = inQ;
        this.updateTitle();
        this.updateScaleMinMax((int)this.fMaxValue.getValue());
        this.fSlider.setExtent((int)(this.fMaxValue.getValue() - this.fMinValue.getValue()));
        this.firePropertyChange(MAXQUANTITY_PROPERTY, oldQ, inQ);
    }

    protected void updateScaleMinMax(int newvalue) {
        if ((double)newvalue > this.fScaleMax.getValue()) {
            this.setScaleMaximum(newvalue);
        }
        if ((double)newvalue < this.fScaleMin.getValue()) {
            this.setScaleMinimum(newvalue);
        }
    }

    public static void main(String[] args) {
        QuantitySlider timeSlider1 = new QuantitySlider(0, new Time(20.0), new Time(50.0), new Time(0.0), new Time(100.0), "Exposure Time", false);
        JOptionPane.showMessageDialog(null, timeSlider1);
        System.exit(0);
    }

    private static Image findImage(Component inComp, String inName) {
        ImageIcon icon = (ImageIcon)Resources.getIcon((String)inName);
        if (icon == null) {
            return null;
        }
        return icon.getImage();
    }

    private static Image loadImage(Component inComp, URL inUrl) {
        if (inComp == null) {
            throw new IllegalArgumentException("loadImage called with null Component");
        }
        if (inUrl == null) {
            return null;
        }
        Image loadedImage = null;
        try {
            Image tempImg = null;
            MediaTracker mt = new MediaTracker(inComp);
            tempImg = Toolkit.getDefaultToolkit().getImage(inUrl);
            mt.addImage(tempImg, 0);
            mt.waitForID(0);
            loadedImage = tempImg;
        }
        catch (Exception e) {
            loadedImage = null;
        }
        return loadedImage;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            if (this.fSlider.thumbContains(e.getX(), e.getY())) {
                StringBuffer sb = new StringBuffer("Enter new min value (");
                sb.append(this.fMinValue.getDefaultUnits());
                sb.append("):");
                double val = this.popupQuantityRequest("Min Value", sb.toString());
                if (!Double.isNaN(val)) {
                    Quantity newQ = this.fMinValue.newInstance(val);
                    this.setMinQuantity(newQ);
                }
            } else if (this.fSlider.extentContains(e.getX(), e.getY())) {
                StringBuffer sb = new StringBuffer("Enter new max value (");
                sb.append(this.fMaxValue.getDefaultUnits());
                sb.append("):");
                double val = this.popupQuantityRequest("Max Value", sb.toString());
                if (!Double.isNaN(val)) {
                    Quantity newQ = this.fMaxValue.newInstance(val);
                    this.setMaxQuantity(newQ);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

