/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.LinearAlgebra;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.linear.AbstractSolver;
import org.la4j.linear.LinearSystemSolver;

public class LeastNormSolver
extends AbstractSolver
implements LinearSystemSolver {
    protected LeastNormSolver(Matrix a) {
        super(a);
    }

    @Override
    public Vector solve(Vector b) {
        this.ensureRHSIsCorrect(b);
        Matrix temp = this.self().multiply(this.self().rotate());
        Matrix pseudoInverse = this.self().rotate().multiply(temp.withInverter(LinearAlgebra.InverterFactory.GAUSS_JORDAN).inverse());
        return pseudoInverse.multiply(b);
    }

    @Override
    public boolean applicableTo(Matrix matrix) {
        int r = matrix.rank();
        return r == matrix.rows() || r == matrix.columns();
    }
}

