/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.vector;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.iterator.VectorIterator;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.matrix.sparse.CRSMatrix;
import org.la4j.operation.VectorMatrixOperation;
import org.la4j.operation.VectorOperation;
import org.la4j.operation.VectorVectorOperation;
import org.la4j.vector.DenseVector;
import org.la4j.vector.VectorFactory;
import org.la4j.vector.functor.VectorAccumulator;
import org.la4j.vector.functor.VectorProcedure;
import org.la4j.vector.sparse.CompressedVector;

public abstract class SparseVector
extends Vector {
    protected int cardinality;

    public static SparseVector zero(int length) {
        return CompressedVector.zero(length);
    }

    public static SparseVector zero(int length, int capacity) {
        return CompressedVector.zero(length);
    }

    public static SparseVector random(int length, double density, Random random) {
        return CompressedVector.random(length, density, random);
    }

    public static SparseVector fromArray(double[] array) {
        return CompressedVector.fromArray(array);
    }

    public static SparseVector fromCSV(String csv) {
        return Vector.fromCSV(csv).to(Vectors.SPARSE);
    }

    public static SparseVector fromMatrixMarket(String mm) {
        return Vector.fromMatrixMarket(mm).to(Vectors.SPARSE);
    }

    public static SparseVector fromCollection(Collection<? extends Number> list) {
        return Vector.fromCollection(list).to(Vectors.SPARSE);
    }

    public static SparseVector fromMap(Map<Integer, ? extends Number> map, int length) {
        return CompressedVector.fromMap(map, length);
    }

    public SparseVector(int length) {
        this(length, 0);
    }

    public SparseVector(int length, int cardinality) {
        super(length);
        this.cardinality = cardinality;
    }

    public int cardinality() {
        return this.cardinality;
    }

    public double density() {
        return (double)this.cardinality / (double)this.length;
    }

    @Override
    public double get(int i) {
        return this.getOrElse(i, 0.0);
    }

    public abstract double getOrElse(int var1, double var2);

    public boolean isZeroAt(int i) {
        return !this.nonZeroAt(i);
    }

    public abstract boolean nonZeroAt(int var1);

    public double foldNonZero(VectorAccumulator accumulator) {
        this.eachNonZero(Vectors.asAccumulatorProcedure(accumulator));
        return accumulator.accumulate();
    }

    public void eachNonZero(VectorProcedure procedure) {
        VectorIterator it = this.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            procedure.apply(i, x);
        }
    }

    @Override
    public Vector add(double value) {
        DenseVector result = DenseVector.constant(this.length, value);
        VectorIterator it = this.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            result.set(i, x + value);
        }
        return result;
    }

    @Override
    public Vector multiply(double value) {
        Vector result = this.blank();
        VectorIterator it = this.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            result.set(i, x * value);
        }
        return result;
    }

    @Override
    public double max() {
        double max = this.foldNonZero(Vectors.mkMaxAccumulator());
        return max > 0.0 ? max : 0.0;
    }

    @Override
    public double min() {
        double min = this.foldNonZero(Vectors.mkMinAccumulator());
        return min < 0.0 ? min : 0.0;
    }

    @Override
    public double euclideanNorm() {
        return this.foldNonZero(Vectors.mkEuclideanNormAccumulator());
    }

    @Override
    public double manhattanNorm() {
        return this.foldNonZero(Vectors.mkManhattanNormAccumulator());
    }

    @Override
    public double infinityNorm() {
        double norm = this.foldNonZero(Vectors.mkInfinityNormAccumulator());
        return norm > 0.0 ? norm : 0.0;
    }

    public abstract VectorIterator nonZeroIterator();

    @Override
    public <T extends Vector> T to(VectorFactory<T> factory) {
        T result = factory.apply(this.length);
        VectorIterator it = this.nonZeroIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            ((Vector)result).set(i, x);
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = 17;
        VectorIterator it = this.nonZeroIterator();
        while (it.hasNext()) {
            long x = ((Double)it.next()).longValue();
            long i = it.index();
            result = 37 * result + (int)(x ^ x >>> 32);
            result = 37 * result + (int)(i ^ i >>> 32);
        }
        return result;
    }

    @Override
    public <T> T apply(VectorOperation<T> operation) {
        operation.ensureApplicableTo(this);
        return operation.apply(this);
    }

    @Override
    public <T> T apply(VectorVectorOperation<T> operation, Vector that) {
        return that.apply(operation.partiallyApply(this));
    }

    @Override
    public <T> T apply(VectorMatrixOperation<T> operation, Matrix that) {
        return that.apply(operation.partiallyApply(this));
    }

    @Override
    public Matrix toRowMatrix() {
        VectorIterator it = this.nonZeroIterator();
        CRSMatrix result = CRSMatrix.zero(1, this.length);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int j = it.index();
            ((Matrix)result).set(0, j, x);
        }
        return result;
    }

    @Override
    public Matrix toColumnMatrix() {
        VectorIterator it = this.nonZeroIterator();
        ColumnMajorSparseMatrix result = ColumnMajorSparseMatrix.zero(this.length, 1);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            result.set(i, 0, x);
        }
        return result;
    }

    @Override
    public Matrix toDiagonalMatrix() {
        VectorIterator it = this.nonZeroIterator();
        RowMajorSparseMatrix result = RowMajorSparseMatrix.zero(this.length, this.length);
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            result.set(i, i, x);
        }
        return result;
    }

    @Override
    public String toMatrixMarket(NumberFormat formatter) {
        StringBuilder out = new StringBuilder();
        VectorIterator it = this.nonZeroIterator();
        out.append("%%MatrixMarket vector coordinate real\n");
        out.append(this.length).append(' ').append(this.cardinality).append('\n');
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.index();
            out.append(i + 1).append(' ').append(formatter.format(x)).append('\n');
        }
        return out.toString();
    }

    protected void ensureIndexIsInBounds(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException("Index '" + i + "' is invalid.");
        }
    }
}

