/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.table.renderer;

import com.cosylab.logging.client.EntryTypeIcon;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class EntryTypeRenderer
extends JLabel
implements TableCellRenderer {
    private Color bColor;
    private Color fColor;
    private boolean showDescription;

    public EntryTypeRenderer(boolean showDescription) {
        this.showDescription = showDescription;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.fColor = table.getSelectionForeground();
            this.bColor = table.getSelectionBackground();
        } else {
            this.fColor = table.getForeground();
            this.bColor = table.getBackground();
        }
        this.setForeground(this.fColor);
        this.setBackground(this.bColor);
        this.setFont(table.getFont());
        if (value == null) {
            return this;
        }
        if (value instanceof LogTypeHelper) {
            this.setIcon(EntryTypeIcon.getIcon((LogTypeHelper)value));
            this.setFont(table.getFont());
            if (this.showDescription) {
                this.setText(((LogTypeHelper)value).logEntryType);
            } else {
                this.setText("");
            }
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.bColor);
        g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        super.paint(g);
    }

    public void viewDescription(boolean b) {
        this.showDescription = b;
    }
}

