/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.sampler;

import skyview.geometry.Sampler;
import skyview.survey.Image;

public class Spline
extends Sampler {
    private double[] zout = new double[2];
    private int xmin = 0;
    private int ymin = 0;
    private int splineDegree = 3;
    private double[] image;
    private double[] xWeight = new double[6];
    private double[] yWeight = new double[6];
    private int[] xIndex = new int[6];
    private int[] yIndex = new int[6];

    @Override
    public String getName() {
        return "Spline " + this.splineDegree + " sampler";
    }

    @Override
    public String getDescription() {
        return "Sample using splines of the given order";
    }

    @Override
    public void setOrder(int order) {
        if (order < 2 || order > 5) {
            throw new Error("Invalid order for spline (should be between 2 and 5)");
        }
        this.splineDegree = order;
    }

    @Override
    public void setInput(Image inImage) {
        if (inImage.getDepth() > 1) {
            throw new Error("Spline Sampler cannot handle 3-D images");
        }
        super.setInput(inImage);
        if (this.bounds == null) {
            this.image = new double[inImage.getWidth() * inImage.getHeight()];
            for (int i = 0; i < this.image.length; ++i) {
                this.image[i] = inImage.getData(i);
            }
        } else {
            this.getBoundedInput(inImage, this.bounds);
        }
        this.samplesToCoefficients();
    }

    private void getBoundedInput(Image inImage, int[] bounds) {
        double xi0 = 1.0E10;
        double xie = -1.0E10;
        double yi0 = 1.0E10;
        double yie = -1.0E10;
        for (int i = 0; i < bounds.length; ++i) {
            double[] zin = this.outImage.getCenter(bounds[i]);
            this.trans.transform(zin, this.zout);
            if (this.zout[0] < xi0) {
                xi0 = this.zout[0];
            }
            if (this.zout[0] > xie) {
                xie = this.zout[0];
            }
            if (this.zout[1] < yi0) {
                yi0 = this.zout[1];
            }
            if (!(this.zout[1] > yie)) continue;
            yie = this.zout[1];
        }
        double dx = xie - xi0;
        double dy = yie - yi0;
        int ixi0 = (int)Math.floor(xi0 -= 0.05 * dx + (double)this.splineDegree);
        int ixie = (int)Math.ceil(xie += 0.05 * dx + (double)this.splineDegree);
        int iyi0 = (int)Math.floor(yi0 -= 0.05 * dy + (double)this.splineDegree);
        int iyie = (int)Math.ceil(yie += 0.05 * dy + (double)this.splineDegree);
        if (ixi0 < 0) {
            ixi0 = 0;
        }
        if (iyi0 < 0) {
            iyi0 = 0;
        }
        if (ixie >= this.inWidth) {
            ixie = this.inWidth - 1;
        }
        if (iyie >= this.inHeight) {
            iyie = this.inHeight - 1;
        }
        int oldWidth = this.inWidth;
        this.inWidth = ixie - ixi0 + 1;
        this.inHeight = iyie - iyi0 + 1;
        this.image = new double[this.inWidth * this.inHeight];
        this.xmin = ixi0;
        this.ymin = iyi0;
        int outOff = 0;
        for (int y = 0; y < this.inHeight; ++y) {
            int inOff = (y + this.ymin) * oldWidth + this.xmin;
            for (int x = 0; x < this.inWidth; ++x) {
                this.image[outOff] = inImage.getData(inOff);
                ++outOff;
                ++inOff;
            }
        }
    }

    private int samplesToCoefficients() {
        int NbPoles;
        double[] Pole = new double[2];
        switch (this.splineDegree) {
            case 2: {
                NbPoles = 1;
                Pole[0] = Math.sqrt(8.0) - 3.0;
                break;
            }
            case 3: {
                NbPoles = 1;
                Pole[0] = Math.sqrt(3.0) - 2.0;
                break;
            }
            case 4: {
                NbPoles = 2;
                Pole[0] = Math.sqrt(664.0 - Math.sqrt(438976.0)) + Math.sqrt(304.0) - 19.0;
                Pole[1] = Math.sqrt(664.0 + Math.sqrt(438976.0)) - Math.sqrt(304.0) - 19.0;
                break;
            }
            case 5: {
                NbPoles = 2;
                Pole[0] = Math.sqrt(67.5 - Math.sqrt(4436.25)) + Math.sqrt(26.25) - 6.5;
                Pole[1] = Math.sqrt(67.5 + Math.sqrt(4436.25)) - Math.sqrt(26.25) - 6.5;
                break;
            }
            default: {
                System.err.println("Invalid spline degree\n");
                return 1;
            }
        }
        double[] Line2 = new double[this.inWidth];
        for (int y = 0; y < this.inHeight; ++y) {
            this.getRow(this.image, y, Line2, this.inWidth);
            this.convertToInterpolationCoefficients(Line2, this.inWidth, Pole, NbPoles, 1.0E-14);
            this.putRow(this.image, y, Line2, this.inWidth);
        }
        Line2 = new double[this.inHeight];
        for (int x = 0; x < this.inWidth; ++x) {
            this.getColumn(this.image, this.inWidth, x, Line2, this.inHeight);
            this.convertToInterpolationCoefficients(Line2, this.inHeight, Pole, NbPoles, 1.0E-14);
            this.putColumn(this.image, this.inWidth, x, Line2, this.inHeight);
        }
        return 0;
    }

    private void convertToInterpolationCoefficients(double[] c, int DataLength, double[] z, int NbPoles, double Tolerance) {
        int k;
        double Lambda = 1.0;
        if (DataLength == 1) {
            return;
        }
        for (k = 0; k < NbPoles; ++k) {
            Lambda = Lambda * (1.0 - z[k]) * (1.0 - 1.0 / z[k]);
        }
        int n = 0;
        while (n < DataLength) {
            int n2 = n++;
            c[n2] = c[n2] * Lambda;
        }
        for (k = 0; k < NbPoles; ++k) {
            int n3;
            c[0] = this.initialCausalCoefficient(c, DataLength, z[k], Tolerance);
            for (n3 = 1; n3 < DataLength; ++n3) {
                int n4 = n3;
                c[n4] = c[n4] + z[k] * c[n3 - 1];
            }
            c[DataLength - 1] = this.initialAntiCausalCoefficient(c, DataLength, z[k]);
            for (n3 = DataLength - 2; 0 <= n3; --n3) {
                c[n3] = z[k] * (c[n3 + 1] - c[n3]);
            }
        }
    }

    private double initialCausalCoefficient(double[] c, int DataLength, double z, double Tolerance) {
        int Horizon = DataLength;
        if (Tolerance > 0.0) {
            Horizon = (int)Math.ceil(Math.log(Tolerance) / Math.log(Math.abs(z)));
        }
        if (Horizon < DataLength) {
            double zn = z;
            double Sum = c[0];
            for (int n = 1; n < Horizon; ++n) {
                Sum += zn * c[n];
                zn *= z;
            }
            return Sum;
        }
        double zn = z;
        double iz = 1.0 / z;
        double z2n = Math.pow(z, DataLength - 1);
        double Sum = c[0] + z2n * c[DataLength - 1];
        z2n *= z2n * iz;
        for (int n = 1; n <= DataLength - 2; ++n) {
            Sum += (zn + z2n) * c[n];
            zn *= z;
            z2n *= iz;
        }
        return Sum / (1.0 - zn * zn);
    }

    private void getColumn(double[] Image2, int Width, int x, double[] Line2, int Height) {
        for (int y = 0; y < Height; ++y) {
            Line2[y] = Image2[y * Width + x];
        }
    }

    private void getRow(double[] Image2, int y, double[] Line2, int Width) {
        System.arraycopy(Image2, y * Width, Line2, 0, Width);
    }

    private double initialAntiCausalCoefficient(double[] c, int DataLength, double z) {
        return z / (z * z - 1.0) * (z * c[DataLength - 2] + c[DataLength - 1]);
    }

    private void putColumn(double[] Image2, int Width, int x, double[] Line2, int Height) {
        for (int y = 0; y < Height; ++y) {
            Image2[y * Width + x] = Line2[y];
        }
    }

    private void putRow(double[] Image2, int y, double[] Line2, int Width) {
        System.arraycopy(Line2, 0, Image2, y * Width, Width);
    }

    public double interpolatedValue(double x, double y) {
        double w;
        int k;
        int j;
        int i;
        int Width2 = 2 * this.inWidth - 2;
        int Height2 = 2 * this.inHeight - 2;
        if (this.splineDegree % 2 != 0) {
            i = (int)Math.floor(x) - this.splineDegree / 2;
            j = (int)Math.floor(y) - this.splineDegree / 2;
            for (k = 0; k <= this.splineDegree; ++k) {
                this.xIndex[k] = i++;
                this.yIndex[k] = j++;
            }
        } else {
            i = (int)Math.floor(x + 0.5) - this.splineDegree / 2;
            j = (int)Math.floor(y + 0.5) - this.splineDegree / 2;
            for (k = 0; k <= this.splineDegree; ++k) {
                this.xIndex[k] = i++;
                this.yIndex[k] = j++;
            }
        }
        switch (this.splineDegree) {
            case 2: {
                w = x - (double)this.xIndex[1];
                this.xWeight[1] = 0.75 - w * w;
                this.xWeight[2] = 0.5 * (w - this.xWeight[1] + 1.0);
                this.xWeight[0] = 1.0 - this.xWeight[1] - this.xWeight[2];
                w = y - (double)this.yIndex[1];
                this.yWeight[1] = 0.75 - w * w;
                this.yWeight[2] = 0.5 * (w - this.yWeight[1] + 1.0);
                this.yWeight[0] = 1.0 - this.yWeight[1] - this.yWeight[2];
                break;
            }
            case 3: {
                w = x - (double)this.xIndex[1];
                this.xWeight[3] = 0.16666666666666666 * w * w * w;
                this.xWeight[0] = 0.16666666666666666 + 0.5 * w * (w - 1.0) - this.xWeight[3];
                this.xWeight[2] = w + this.xWeight[0] - 2.0 * this.xWeight[3];
                this.xWeight[1] = 1.0 - this.xWeight[0] - this.xWeight[2] - this.xWeight[3];
                w = y - (double)this.yIndex[1];
                this.yWeight[3] = 0.16666666666666666 * w * w * w;
                this.yWeight[0] = 0.16666666666666666 + 0.5 * w * (w - 1.0) - this.yWeight[3];
                this.yWeight[2] = w + this.yWeight[0] - 2.0 * this.yWeight[3];
                this.yWeight[1] = 1.0 - this.yWeight[0] - this.yWeight[2] - this.yWeight[3];
                break;
            }
            case 4: {
                w = x - (double)this.xIndex[2];
                double w2 = w * w;
                double t = 0.16666666666666666 * w2;
                this.xWeight[0] = 0.5 - w;
                this.xWeight[0] = this.xWeight[0] * this.xWeight[0];
                this.xWeight[0] = this.xWeight[0] * (0.041666666666666664 * this.xWeight[0]);
                double t0 = w * (t - 0.4583333333333333);
                double t1 = 0.19791666666666666 + w2 * (0.25 - t);
                this.xWeight[1] = t1 + t0;
                this.xWeight[3] = t1 - t0;
                this.xWeight[4] = this.xWeight[0] + t0 + 0.5 * w;
                this.xWeight[2] = 1.0 - this.xWeight[0] - this.xWeight[1] - this.xWeight[3] - this.xWeight[4];
                w = y - (double)this.yIndex[2];
                w2 = w * w;
                t = 0.16666666666666666 * w2;
                this.yWeight[0] = 0.5 - w;
                this.yWeight[0] = this.yWeight[0] * this.yWeight[0];
                this.yWeight[0] = this.yWeight[0] * (0.041666666666666664 * this.yWeight[0]);
                t0 = w * (t - 0.4583333333333333);
                t1 = 0.19791666666666666 + w2 * (0.25 - t);
                this.yWeight[1] = t1 + t0;
                this.yWeight[3] = t1 - t0;
                this.yWeight[4] = this.yWeight[0] + t0 + 0.5 * w;
                this.yWeight[2] = 1.0 - this.yWeight[0] - this.yWeight[1] - this.yWeight[3] - this.yWeight[4];
                break;
            }
            case 5: {
                w = x - (double)this.xIndex[2];
                double w2 = w * w;
                this.xWeight[5] = 0.008333333333333333 * w * w2 * w2;
                double w4 = (w2 -= w) * w2;
                double t = w2 * (w2 - 3.0);
                this.xWeight[0] = 0.041666666666666664 * (0.2 + w2 + w4) - this.xWeight[5];
                double t0 = 0.041666666666666664 * (w2 * (w2 - 5.0) + 9.2);
                double t1 = -0.08333333333333333 * (w -= 0.5) * (t + 4.0);
                this.xWeight[2] = t0 + t1;
                this.xWeight[3] = t0 - t1;
                t0 = 0.0625 * (1.8 - t);
                t1 = 0.041666666666666664 * w * (w4 - w2 - 5.0);
                this.xWeight[1] = t0 + t1;
                this.xWeight[4] = t0 - t1;
                w = y - (double)this.yIndex[2];
                w2 = w * w;
                this.yWeight[5] = 0.008333333333333333 * w * w2 * w2;
                w4 = (w2 -= w) * w2;
                t = w2 * (w2 - 3.0);
                this.yWeight[0] = 0.041666666666666664 * (0.2 + w2 + w4) - this.yWeight[5];
                t0 = 0.041666666666666664 * (w2 * (w2 - 5.0) + 9.2);
                t1 = -0.08333333333333333 * (w -= 0.5) * (t + 4.0);
                this.yWeight[2] = t0 + t1;
                this.yWeight[3] = t0 - t1;
                t0 = 0.0625 * (1.8 - t);
                t1 = 0.041666666666666664 * w * (w4 - w2 - 5.0);
                this.yWeight[1] = t0 + t1;
                this.yWeight[4] = t0 - t1;
            }
        }
        for (k = 0; k <= this.splineDegree; ++k) {
            int n = this.inWidth == 1 ? 0 : (this.xIndex[k] = this.xIndex[k] < 0 ? -this.xIndex[k] - Width2 * (-this.xIndex[k] / Width2) : this.xIndex[k] - Width2 * (this.xIndex[k] / Width2));
            if (this.inWidth <= this.xIndex[k]) {
                this.xIndex[k] = Width2 - this.xIndex[k];
            }
            int n2 = this.inHeight == 1 ? 0 : (this.yIndex[k] = this.yIndex[k] < 0 ? -this.yIndex[k] - Height2 * (-this.yIndex[k] / Height2) : this.yIndex[k] - Height2 * (this.yIndex[k] / Height2));
            if (this.inWidth > this.yIndex[k]) continue;
            this.yIndex[k] = Height2 - this.yIndex[k];
        }
        double interpolated = 0.0;
        for (j = 0; j <= this.splineDegree; ++j) {
            w = 0.0;
            for (i = 0; i <= this.splineDegree; ++i) {
                w += this.xWeight[i] * this.image[this.yIndex[j] * this.inWidth + this.xIndex[i]];
            }
            interpolated += this.yWeight[j] * w;
        }
        return interpolated;
    }

    @Override
    public void sample(int pix) {
        double[] zin = this.outImage.getCenter(pix);
        this.trans.transform(zin, this.zout);
        double x = this.zout[0] - 0.5 - (double)this.xmin;
        double y = this.zout[1] - 0.5 - (double)this.ymin;
        if (x < 0.0 || x > (double)this.inWidth || y < 0.0 || y > (double)this.inHeight) {
            return;
        }
        this.outImage.setData(pix, this.interpolatedValue(x, y));
    }
}

