/*
 * Decompiled with CFR 0.152.
 */
package skyview.geometry.spheredistorter;

import skyview.geometry.SphereDistorter;
import skyview.geometry.Transformer;

public class Besselian
extends SphereDistorter {
    private static final double D2PI = Math.PI * 2;
    private static final double pmf = 2.0626480624709636E7;
    private double[] v = new double[3];
    private double[] t1 = new double[3];

    @Override
    public SphereDistorter inverse() {
        return new BesselianInverse();
    }

    @Override
    public boolean isInverse(Transformer t) {
        return t instanceof BesselianInverse;
    }

    @Override
    public String getName() {
        return "Besselian distorter";
    }

    @Override
    public String getDescription() {
        return "A Besselian (FK4 based) distortion.  Dynamic terms are not included.";
    }

    @Override
    public final void transform(double[] x, double[] y) {
        int i;
        int i2;
        double[] a = new double[]{-1.62557E-6, -3.1919E-7, -1.3843E-7};
        double[][] emi = new double[][]{{0.9999256795, 0.0111814828, 0.0048590039}, {-0.0111814828, 0.9999374849, -2.71771E-5}, {-0.004859004, -2.71557E-5, 0.9999881946}};
        for (i2 = 0; i2 < 3; ++i2) {
            this.t1[i2] = x[0] * emi[i2][0] + x[1] * emi[i2][1] + x[2] * emi[i2][2];
        }
        for (i2 = 0; i2 < 3; ++i2) {
            y[i2] = this.t1[i2];
        }
        double rxyz = Math.sqrt(y[0] * y[0] + y[1] * y[1] + y[2] * y[2]);
        double w = 0.0;
        for (i = 0; i < 3; ++i) {
            w += a[i] * y[i];
        }
        for (i = 0; i < 3; ++i) {
            this.t1[i] = (1.0 - w) * y[i] + a[i] * rxyz;
        }
        rxyz = Math.sqrt(this.t1[0] * this.t1[0] + this.t1[1] * this.t1[1] + this.t1[2] * this.t1[2]);
        for (i = 0; i < 3; ++i) {
            w += a[i] * y[i];
        }
        for (i = 0; i < 3; ++i) {
            y[i] = (1.0 - w) * y[i] + a[i] * rxyz;
        }
        rxyz = Math.sqrt(y[0] * y[0] + y[1] * y[1] + y[2] * y[2]);
        i = 0;
        while (i < 3) {
            int n = i++;
            y[n] = y[n] / rxyz;
        }
    }

    public class BesselianInverse
    extends SphereDistorter {
        @Override
        public String getName() {
            return "Inv. " + Besselian.this.getName();
        }

        @Override
        public SphereDistorter inverse() {
            return Besselian.this;
        }

        @Override
        public boolean isInverse(Transformer t) {
            return t instanceof Besselian;
        }

        @Override
        public String getDescription() {
            return Besselian.this.getDescription() + " (inverse)";
        }

        @Override
        public final void transform(double[] x, double[] y) {
            int i;
            double[] a = new double[]{-1.62557E-6, -3.1919E-7, -1.3843E-7};
            double[][] em1 = new double[][]{{0.9999256782, -0.0111820611, -0.0048579477}, {0.011182061, 0.9999374784, -2.71765E-5}, {0.0048579479, -2.71474E-5, 0.9999881997}};
            double[][] em2 = new double[][]{{-5.51E-4, -0.238565, 0.435739}, {0.238514, -0.002667, -0.008541}, {-0.435623, 0.012254, 0.002117}};
            double w = 0.0;
            for (i = 0; i < 3; ++i) {
                w += a[i] * x[i];
            }
            for (i = 0; i < 3; ++i) {
                ((Besselian)Besselian.this).t1[i] = x[i] - a[i] - w * x[i];
            }
            for (i = 0; i < 3; ++i) {
                y[i] = Besselian.this.t1[i];
            }
            for (i = 0; i < 3; ++i) {
                ((Besselian)Besselian.this).t1[i] = y[0] * em1[i][0] + y[1] * em1[i][1] + y[2] * em1[i][2];
                ((Besselian)Besselian.this).v[i] = y[0] * em2[i][0] + y[1] * em2[i][1] + y[2] * em2[i][2];
            }
            for (i = 0; i < 3; ++i) {
                y[i] = Besselian.this.t1[i];
            }
            double tdelta = -2.42406840554768E-6;
            for (int i2 = 0; i2 < 3; ++i2) {
                int n = i2;
                y[n] = y[n] + tdelta * Besselian.this.v[i2];
            }
            double rxyz = Math.sqrt(y[0] * y[0] + y[1] * y[1] + y[2] * y[2]);
            int i3 = 0;
            while (i3 < 3) {
                int n = i3++;
                y[n] = y[n] / rxyz;
            }
        }
    }
}

