/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.factory;

import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.info.ClassInfo;
import org.exolab.castor.builder.info.CollectionInfo;
import org.exolab.castor.builder.info.FieldInfo;
import org.exolab.castor.builder.info.NodeType;
import org.exolab.castor.builder.info.nature.XMLInfoNature;
import org.exolab.castor.builder.types.XSType;
import org.exolab.castor.mapping.xml.BindXml;
import org.exolab.castor.mapping.xml.ClassChoice;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.types.BindXmlNodeType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JType;

public final class MappingFileSourceFactory {
    public MappingFileSourceFactory(BuilderConfiguration config) {
        if (config == null) {
            String err = "The argument 'config' must not be null.";
            throw new IllegalArgumentException(err);
        }
    }

    public ClassMapping createMapping(ClassInfo classInfo) {
        FieldInfo[] elements;
        FieldInfo[] atts;
        ClassInfo base;
        boolean isAbstract;
        String nsURI;
        JClass jClass = classInfo.getJClass();
        String className = jClass.getName();
        ClassMapping classMapping = new ClassMapping();
        classMapping.setName(className);
        MapTo mapTo = new MapTo();
        classMapping.setMapTo(mapTo);
        XMLInfoNature xmlNature = new XMLInfoNature(classInfo);
        String nsPrefix = xmlNature.getNamespacePrefix();
        if (nsPrefix != null && nsPrefix.length() > 0) {
            mapTo.setNsPrefix(nsPrefix);
        }
        if ((nsURI = xmlNature.getNamespaceURI()) != null && nsURI.length() > 0) {
            mapTo.setNsUri(nsURI);
        }
        mapTo.setXml(xmlNature.getNodeName());
        mapTo.setElementDefinition(xmlNature.isElementDefinition());
        if (xmlNature.isChoice()) {
            // empty if block
        }
        if (!(isAbstract = classInfo.isAbstract())) {
            isAbstract = jClass.getModifiers().isAbstract();
        }
        classInfo.setAbstract(isAbstract);
        if (classInfo.getFieldCount() == 0) {
            return classMapping;
        }
        if (classInfo.allowContent()) {
            this.createFieldMapping(classMapping, classInfo.getTextField(), null);
        }
        if ((base = classInfo.getBaseClass()) != null) {
            classMapping.setExtends(base.getJClass().getName());
        }
        for (FieldInfo member : atts = classInfo.getAttributeFields()) {
            if (member.isTransient() || base != null && base.getAttributeField(xmlNature.getNodeName()) != null) continue;
            this.createFieldMapping(classMapping, member, nsURI);
        }
        for (FieldInfo member : elements = classInfo.getElementFields()) {
            if (member.isTransient() || base != null && base.getElementField(xmlNature.getNodeName()) != null) continue;
            this.createFieldMapping(classMapping, member, nsURI);
        }
        return classMapping;
    }

    private void createFieldMapping(ClassMapping classMapping, FieldInfo member, String nsURI) {
        ClassChoice classChoice;
        boolean isText;
        XMLInfoNature xmlNature = new XMLInfoNature(member);
        XSType xsType = xmlNature.getSchemaType();
        boolean any = false;
        NodeType nodeType = xmlNature.getNodeType();
        boolean isAttribute = nodeType == NodeType.ATTRIBUTE;
        boolean bl = isText = nodeType == NodeType.TEXT;
        if (member.getName().equals("_anyObject")) {
            any = true;
        }
        if (xsType.isCollection()) {
            xsType = new XMLInfoNature(((CollectionInfo)member).getContent()).getSchemaType();
        }
        if ((classChoice = classMapping.getClassChoice()) == null) {
            classChoice = new ClassChoice();
            classMapping.setClassChoice(classChoice);
        }
        FieldMapping fieldMap = new FieldMapping();
        classChoice.addFieldMapping(fieldMap);
        String fieldName = member.getName();
        if (fieldName.charAt(0) == '_') {
            fieldName = fieldName.substring(1);
        }
        fieldMap.setName(fieldName);
        String className = MappingFileSourceFactory.getClassName(xsType.getJType());
        if (className.equals("byte[]")) {
            className = "bytes";
        }
        fieldMap.setType(className);
        BindXml bindXml = new BindXml();
        fieldMap.setBindXml(bindXml);
        String nodeName = xmlNature.getNodeName();
        if (nodeName != null && !isText) {
            bindXml.setName(nodeName);
        }
        if (isAttribute) {
            bindXml.setNode(BindXmlNodeType.ATTRIBUTE);
        } else if (isText) {
            bindXml.setNode(BindXmlNodeType.TEXT);
        } else {
            bindXml.setNode(BindXmlNodeType.ELEMENT);
        }
        switch (xsType.getType()) {
            case 26: {
                bindXml.setReference(true);
                break;
            }
            case 25: {
                classMapping.addIdentity(member.getName());
                break;
            }
            case 18: {
                bindXml.setType("QName");
            }
        }
        fieldMap.setHandler(member.getXMLFieldHandler());
        if (member.isContainer()) {
            fieldMap.setContainer(true);
        }
        if (xmlNature.isRequired()) {
            fieldMap.setRequired(true);
        }
        if (member.isNillable()) {
            // empty if block
        }
        if (any) {
            bindXml.setMatches("*");
        }
    }

    private static String getClassName(JType jType) {
        if (jType.isPrimitive()) {
            return jType.getName();
        }
        return jType.toString();
    }
}

