/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jsky.coords.DMS;
import jsky.coords.HMS;

public class SexagesimalTableCellRenderer
extends DefaultTableCellRenderer {
    private boolean _isRA;
    private boolean _showSeconds = true;

    public SexagesimalTableCellRenderer(boolean isRA) {
        this._isRA = isRA;
        this.setHorizontalAlignment(0);
    }

    public SexagesimalTableCellRenderer(boolean isRA, boolean showSeconds) {
        this(isRA);
        this._showSeconds = showSeconds;
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        double val = Double.NaN;
        if (value != null) {
            if (value instanceof Float) {
                val = ((Float)value).doubleValue();
            } else if (value instanceof Double) {
                val = (Double)value;
            }
        }
        if (!Double.isNaN(val)) {
            if (this._isRA) {
                HMS hms = new HMS(val / 15.0);
                ((JLabel)component).setText(hms.toString(this._showSeconds));
            } else {
                DMS dms = new DMS(val);
                ((JLabel)component).setText(dms.toString(this._showSeconds));
            }
        }
        return component;
    }
}

