/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.gui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import jsky.coords.WorldCoordinateConverter;
import jsky.coords.WorldCoords;
import jsky.image.gui.ImageDisplayMenuBar;
import jsky.image.gui.ImageHistoryItem;
import jsky.image.gui.MainImageDisplay;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.Resources;
import jsky.util.gui.DialogUtil;

public class ImageHistoryList {
    private static final I18N _I18N = I18N.getInstance(ImageHistoryList.class);
    private static final String HISTORY_LIST_NAME = "imageHistoryList";
    private static boolean _firstTime = true;
    private MainImageDisplay _imageDisplay;
    private Stack<ImageHistoryItem> _backStack = new Stack();
    private Stack<ImageHistoryItem> _forwStack = new Stack();
    private boolean _noStack = false;
    private LinkedList<ImageHistoryItem> _historyList;
    private int _maxHistoryItems = 20;
    private AbstractAction _backAction = new AbstractAction(_I18N.getString("back"), Resources.getIcon("Back24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("imageBackTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                ImageHistoryList.this.back();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _forwAction = new AbstractAction(_I18N.getString("forward"), Resources.getIcon("Forward24.gif")){
        {
            this.putValue("ShortDescription", _I18N.getString("imageForwardTip"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                ImageHistoryList.this.forward();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };

    public ImageHistoryList(MainImageDisplay imageDisplay) {
        this._imageDisplay = imageDisplay;
        this.loadHistory();
        this.cleanupHistoryList();
        if (_firstTime) {
            _firstTime = false;
            this.cleanupImageCache();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ImageHistoryList.this.saveHistory(true);
            }
        });
    }

    protected void addToHistory() {
        if (this._imageDisplay.getFilename() == null) {
            return;
        }
        ImageHistoryItem historyItem = this.makeImageHistoryItem();
        if (!this._noStack) {
            this._backStack.push(historyItem);
            this._backAction.setEnabled(true);
            if (this._forwStack.size() != 0) {
                this._forwStack.clear();
                this._forwAction.setEnabled(false);
            }
        }
        this.addToHistory(historyItem);
    }

    protected void addToHistory(ImageHistoryItem historyItem) {
        ListIterator it = ((LinkedList)this._historyList.clone()).listIterator(0);
        int i = 0;
        while (it.hasNext()) {
            ImageHistoryItem item = (ImageHistoryItem)it.next();
            if (item.title.equals(historyItem.title)) {
                this._historyList.remove(i);
            }
            ++i;
        }
        this._historyList.addFirst(historyItem);
        if (this._historyList.size() > this._maxHistoryItems) {
            ImageHistoryItem item = this._historyList.removeLast();
            String cacheDir = Preferences.getPreferences().getCacheDir().getPath();
            if (item.filename.startsWith(cacheDir)) {
                new File(item.filename).deleteOnExit();
            }
        }
    }

    protected ImageHistoryItem makeImageHistoryItem() {
        String object;
        double ra = Double.NaN;
        double dec = Double.NaN;
        String radecStr = "";
        if (this._imageDisplay.isWCS()) {
            WorldCoordinateConverter wcs = this._imageDisplay.getWCS();
            WorldCoords center = new WorldCoords(wcs.getWCSCenter(), wcs.getEquinox());
            radecStr = radecStr + center.toString();
            ra = center.getRaDeg();
            dec = center.getDecDeg();
        }
        String name = "";
        if (this._imageDisplay.getFilename() != null) {
            name = new File(this._imageDisplay.getFilename()).getName();
        }
        object = (object = this._imageDisplay.getObjectName()) == null || object.startsWith("dss") ? "" : object + ": ";
        String title = name;
        if (object.length() != 0 || radecStr.length() != 0) {
            title = title + " [" + object + radecStr + "]";
        }
        return new ImageHistoryItem(this._imageDisplay, ra, dec, title, this._imageDisplay.getOrigURL(), this._imageDisplay.getFilename());
    }

    public int getMaxHistoryItems() {
        return this._maxHistoryItems;
    }

    public void setMaxHistoryItems(int n) {
        this._maxHistoryItems = n;
    }

    protected LinkedList mergeHistoryList() {
        Object[] items = this._historyList.toArray();
        this.loadHistory();
        for (int i = items.length - 1; i >= 0; --i) {
            this.addToHistory((ImageHistoryItem)items[i]);
        }
        return this._historyList;
    }

    public void clearHistory() {
        String cacheDir = Preferences.getPreferences().getCacheDir().getPath();
        for (ImageHistoryItem historyItem : this._historyList) {
            File file;
            if (!historyItem.filename.startsWith(cacheDir) || !(file = new File(historyItem.filename)).exists()) continue;
            try {
                file.delete();
            }
            catch (Exception exception) {}
        }
        this._historyList = new LinkedList();
        this._backAction.setEnabled(false);
        this._backStack.clear();
        this._forwAction.setEnabled(false);
        this._forwStack.clear();
        this.saveHistory(false);
    }

    protected void saveHistory(boolean merge) {
        try {
            LinkedList<ImageHistoryItem> l = merge ? this.mergeHistoryList() : this._historyList;
            Preferences.getPreferences().serialize(HISTORY_LIST_NAME, l);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadHistory() {
        try {
            this._historyList = (LinkedList)Preferences.getPreferences().deserialize(HISTORY_LIST_NAME);
        }
        catch (Exception ignored) {
            this._historyList = new LinkedList();
        }
    }

    protected void cleanupHistoryList() {
        ListIterator it = ((LinkedList)this._historyList.clone()).listIterator(0);
        while (it.hasNext()) {
            ImageHistoryItem historyItem = (ImageHistoryItem)it.next();
            File file = new File(historyItem.filename);
            if (file.exists()) continue;
            this._historyList.remove(historyItem);
        }
    }

    protected void cleanupImageCache() {
        String cacheDir = Preferences.getPreferences().getCacheDir().getPath();
        File dir = new File(cacheDir);
        if (dir.isDirectory()) {
            File[] files;
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("jsky");
                }
            };
            for (File file : files = dir.listFiles(filter)) {
                if (this.fileInHistoryList(file)) continue;
                file.delete();
            }
        }
    }

    public boolean fileInHistoryList(File file) {
        return this.getImageHistoryItem(file) != null;
    }

    protected ImageHistoryItem getImageHistoryItem(File file) {
        ListIterator it = ((LinkedList)this._historyList.clone()).listIterator(0);
        while (it.hasNext()) {
            ImageHistoryItem historyItem = (ImageHistoryItem)it.next();
            File f = new File(historyItem.filename);
            if (!f.equals(file.getAbsoluteFile())) continue;
            return historyItem;
        }
        return null;
    }

    public void back() {
        if (this._backStack.size() == 0) {
            return;
        }
        if (!this._imageDisplay.checkSave()) {
            return;
        }
        if (this._imageDisplay.getFilename() != null) {
            this._forwStack.push(this.makeImageHistoryItem());
            this._forwAction.setEnabled(true);
        }
        ImageHistoryItem historyItem = this._backStack.pop();
        if (this._backStack.size() == 0) {
            this._backAction.setEnabled(false);
        }
        ImageDisplayMenuBar.setCurrentImageDisplay(this._imageDisplay);
        this._noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this._noStack = false;
    }

    public void forward() {
        if (this._forwStack.size() == 0) {
            return;
        }
        if (!this._imageDisplay.checkSave()) {
            return;
        }
        if (this._imageDisplay.getFilename() != null) {
            this._backStack.push(this.makeImageHistoryItem());
            this._backAction.setEnabled(true);
        }
        ImageHistoryItem historyItem = this._forwStack.pop();
        if (this._forwStack.size() == 0) {
            this._forwAction.setEnabled(false);
        }
        ImageDisplayMenuBar.setCurrentImageDisplay(this._imageDisplay);
        this._noStack = true;
        try {
            historyItem.actionPerformed(null);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
        this._noStack = false;
    }

    public void addHistoryMenuItems(JMenu menu) {
        ListIterator<ImageHistoryItem> it = this._historyList.listIterator(0);
        while (it.hasNext()) {
            ImageHistoryItem historyItem = it.next();
            File file = new File(historyItem.filename);
            if (!file.exists()) {
                it.remove();
                continue;
            }
            menu.add(historyItem);
        }
    }

    public boolean loadCachedImage(double ra, double dec) {
        LinkedList<ImageHistoryItem> l = new LinkedList<ImageHistoryItem>(this._historyList);
        if (this._imageDisplay.getFilename() != null) {
            l.add(0, this.makeImageHistoryItem());
        }
        ListIterator<ImageHistoryItem> it = l.listIterator(0);
        while (it.hasNext()) {
            ImageHistoryItem historyItem = it.next();
            File file = new File(historyItem.filename);
            if (!file.exists()) {
                this._historyList.remove(historyItem);
                continue;
            }
            if (!historyItem.match(ra, dec)) continue;
            if (this._imageDisplay.getFilename() != null && this._imageDisplay.getFilename().equals(historyItem.filename)) {
                return false;
            }
            ImageDisplayMenuBar.setCurrentImageDisplay(this._imageDisplay);
            historyItem.actionPerformed(null);
            return true;
        }
        this._imageDisplay.blankImage(ra, dec);
        return false;
    }

    protected void setDownloadState(boolean downloading) {
        if (downloading) {
            this._backAction.setEnabled(false);
            this._forwAction.setEnabled(false);
        } else {
            this._backAction.setEnabled(this._backStack.size() > 0);
            this._forwAction.setEnabled(this._forwStack.size() > 0);
        }
    }

    public AbstractAction getBackAction() {
        return this._backAction;
    }

    public AbstractAction getForwAction() {
        return this._forwAction;
    }

    public void setNoStack(boolean noStack) {
        this._noStack = noStack;
    }
}

