/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.plastic;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ListModel;
import uk.ac.starlink.plastic.Agent;
import uk.ac.starlink.plastic.ApplicationItem;
import uk.ac.starlink.plastic.ApplicationListModel;
import uk.ac.starlink.plastic.MessageValidator;
import uk.ac.starlink.plastic.MinimalHub;
import uk.ac.starlink.plastic.PlasticListWindow;
import uk.ac.starlink.plastic.RequestThread;
import uk.ac.starlink.plastic.ServerSet;

public class PlasticHub
extends MinimalHub {
    private final Map agentMap_ = this.getAgentMap();
    private PrintStream logOut_;
    private PrintStream warnOut_;
    private boolean verbose_;
    private boolean warnings_;
    private ApplicationListModel listModel_;
    private MessageValidator validator_;
    private int nReq_;

    public PlasticHub(ServerSet servers) throws RemoteException {
        super(servers);
    }

    void register(Agent agent) {
        int i;
        URI[] msgs;
        if (this.verbose_) {
            this.log("Register: " + agent);
            this.log("    ID:");
            this.log("        " + agent.getId());
            this.log("    Connection:");
            this.log("        " + agent.getConnection());
            msgs = agent.getSupportedMessages();
            if (msgs.length > 0) {
                this.log("    Supported Messages:");
                for (i = 0; i < msgs.length; ++i) {
                    this.log("        " + msgs[i]);
                }
            }
        }
        if (this.warnings_) {
            msgs = agent.getSupportedMessages();
            for (i = 0; i < msgs.length; ++i) {
                if (this.validator_.getDefinition(msgs[i]) != null) continue;
                this.warn("Unknown message: " + msgs[i]);
            }
        }
        if (this.verbose_) {
            this.log("");
        }
        if (this.listModel_ != null) {
            this.listModel_.register(agent.getId(), agent.getName(), Arrays.asList(agent.getSupportedMessages()));
        }
        super.register(agent);
    }

    public void unregister(URI id) {
        Agent agent = (Agent)this.agentMap_.get(id);
        if (agent != null) {
            if (this.listModel_ != null) {
                this.listModel_.unregister(id);
            }
            if (this.verbose_) {
                this.log("Unregister: " + agent);
                this.log("");
            }
        } else if (this.warnings_) {
            this.warn("Attempt to unregister unknown listener: " + id);
        }
        super.unregister(id);
    }

    public String getName(URI id) {
        String result = super.getName(id);
        if (this.warnings_ && result == null) {
            this.warn("getName() request for unknown listener: " + id);
        }
        return result;
    }

    public List getUnderstoodMessages(URI id) {
        List result = super.getUnderstoodMessages(id);
        if (this.warnings_ && result == null) {
            this.warn("getUnderstoodMessages() request for unknown listener: " + id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ListModel getApplicationListModel() {
        if (this.listModel_ == null) {
            ArrayList<ApplicationItem> appList = new ArrayList<ApplicationItem>();
            Map map = this.agentMap_;
            synchronized (map) {
                Iterator it = this.agentMap_.entrySet().iterator();
                while (it.hasNext()) {
                    Agent agent = (Agent)it.next().getValue();
                    List<URI> msgList = Arrays.asList(agent.getSupportedMessages());
                    appList.add(new ApplicationItem(agent.getId(), agent.getName(), msgList));
                }
            }
            ApplicationItem[] apps = appList.toArray(new ApplicationItem[0]);
            this.listModel_ = new ApplicationListModel(apps);
        }
        return this.listModel_;
    }

    Map requestTo(URI sender, URI message, List args, Agent[] agents) {
        this.logRequest(sender, message, args, agents, true);
        return super.requestTo(sender, message, args, agents);
    }

    void requestAsynchTo(URI sender, URI message, List args, Agent[] agents) {
        this.logRequest(sender, message, args, agents, false);
        super.requestAsynchTo(sender, message, args, agents);
    }

    private void logRequest(URI sender, URI message, List args, Agent[] agents, boolean isSynch) {
        int reqId = ++this.nReq_;
        if (this.verbose_) {
            this.log((isSynch ? "Synchronous" : "Asynchronous") + " request " + reqId);
            this.log("    Sender:  " + this.stringify(sender));
            this.log("    Message: " + message);
            if (args.size() > 0) {
                this.log("    Args:    " + this.stringify(args));
            }
        }
        if (this.warnings_) {
            if (!this.isRegistered(sender)) {
                this.warn("    request from unknown listener: " + sender);
            }
            String[] warnlines = this.validator_.validateRequest(sender, message, args);
            for (int i = 0; i < warnlines.length; ++i) {
                this.warn("    !! " + warnlines[i]);
            }
        }
        if (this.verbose_) {
            this.log("");
        }
    }

    RequestThread createRequestThread(final Agent agent, URI sender, final URI message, List args) {
        return new RequestThread(agent, sender, message, args){

            public void run() {
                if (PlasticHub.this.verbose_) {
                    PlasticHub.this.log("        -> " + agent);
                }
                super.run();
                if (PlasticHub.this.verbose_) {
                    String result;
                    try {
                        result = PlasticHub.this.stringify(this.getResult());
                    }
                    catch (IOException e) {
                        result = PlasticHub.this.stringify(e);
                    }
                    PlasticHub.this.log("        <- " + agent + ": " + result);
                }
                if (PlasticHub.this.warnings_) {
                    try {
                        String[] warnlines = PlasticHub.this.validator_.validateResponse(message, this.getResult());
                        for (int i = 0; i < warnlines.length; ++i) {
                            PlasticHub.this.warn("    !! " + warnlines[i]);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public void stop() {
        if (this.verbose_ && !this.isStopped()) {
            this.log("Hub stopped.");
        }
        super.stop();
    }

    public void setLogStream(PrintStream out) {
        this.verbose_ = out != null;
        this.logOut_ = out;
    }

    public void setWarningStream(PrintStream out) {
        this.warnings_ = out != null;
        this.warnOut_ = out;
        if (this.warnings_ && this.validator_ == null) {
            this.validator_ = new MessageValidator();
        }
    }

    private void log(String line) {
        this.logOut_.println(line);
    }

    private void warn(String line) {
        this.warnOut_.println(line);
    }

    private String stringify(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof URI) {
            Object agent = this.agentMap_.get(value);
            if (agent instanceof Agent) {
                return "id:" + agent.toString();
            }
            if (value.equals(this.getHubId())) {
                return "id:hub";
            }
            return value.toString();
        }
        if (value instanceof Collection) {
            Collection set = (Collection)value;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append('(');
            if (!set.isEmpty()) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    sbuf.append(' ');
                    sbuf.append(this.stringify(it.next()));
                    sbuf.append(it.hasNext() ? (char)',' : ' ');
                }
            }
            sbuf.append(')');
            return sbuf.toString();
        }
        if (value instanceof Throwable) {
            ((Throwable)value).printStackTrace();
            return value.toString();
        }
        String s = value == null ? "null" : value.toString();
        s = s.length() < 60 ? s : s.substring(0, 57) + "...";
        s = s.replaceAll("\n", "\\n");
        return s;
    }

    private boolean isRegistered(URI id) {
        return this.agentMap_.containsKey(id);
    }

    public static PlasticHub startHub(PrintStream logOut, PrintStream warnOut) throws IOException, RemoteException {
        return PlasticHub.startHub(logOut, warnOut, new File(System.getProperty("user.home"), ".plastic"));
    }

    public static PlasticHub startHub(PrintStream logOut, PrintStream warnOut, File configFile) throws RemoteException, IOException {
        ServerSet servers = new ServerSet(configFile);
        final PlasticHub hub = new PlasticHub(servers);
        hub.setLogStream(logOut);
        hub.setWarningStream(warnOut);
        if (logOut != null) {
            logOut.println("Hub started.");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                hub.stop();
            }
        });
        return hub;
    }

    public static void main(String[] args) throws RemoteException, IOException {
        String usage = "\nUsage:\n       " + PlasticHub.class.getName() + "\n           " + " [-verbose]" + " [-warn]" + " [-gui]" + "\n";
        PrintStream logOut = null;
        PrintStream warnOut = null;
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean gui = false;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-verbose")) {
                it.remove();
                logOut = System.out;
            }
            if (arg.equals("-warn")) {
                it.remove();
                warnOut = System.out;
                continue;
            }
            if (arg.equals("-gui")) {
                it.remove();
                gui = true;
                continue;
            }
            if (!arg.startsWith("-h")) continue;
            System.out.println(usage);
            return;
        }
        if (!argList.isEmpty()) {
            System.err.println(usage);
            System.exit(1);
        }
        PlasticHub hub = PlasticHub.startHub(logOut, warnOut, new File(System.getProperty("user.home"), ".plastic"));
        if (gui) {
            PlasticListWindow window = new PlasticListWindow(hub.getApplicationListModel());
            window.setTitle("PlasticHub");
            window.pack();
            window.setDefaultCloseOperation(3);
            window.setVisible(true);
        }
    }
}

