/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.ExpectedPropertiesElements;
import alma.obsprep.bo.obsproject.SingleContinuumNonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.SpectralLineNonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.SpectralScanNonOverlappingBandwidthCalculator;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;

public abstract class NonOverlappingBandwidthCalculator {
    SpectralSetupParameters ssp;
    Velocity sourceVelocity;

    public NonOverlappingBandwidthCalculator(SpectralSetupParameters spectralSetupParameters, Velocity velocity) {
        this.ssp = spectralSetupParameters;
        this.sourceVelocity = velocity;
    }

    public static NonOverlappingBandwidthCalculator getCalculator(SpectralSetupParameters spectralSetupParameters, TargetParameters targetParameters) {
        Velocity velocity = targetParameters.getSourceVelocity();
        String string = spectralSetupParameters.getType();
        if (SpectralSetupParameters.TYPE_CONTINUUM.equals(string)) {
            return new SingleContinuumNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
        }
        if (SpectralSetupParameters.TYPE_SCAN.equals(string)) {
            return new SpectralScanNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
        }
        return new SpectralLineNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
    }

    public static NonOverlappingBandwidthCalculator getCalculator(SpectralSetupParameters spectralSetupParameters, ExpectedPropertiesElements expectedPropertiesElements) {
        Velocity velocity = expectedPropertiesElements.velocity;
        String string = spectralSetupParameters.getType();
        if (SpectralSetupParameters.TYPE_CONTINUUM.equals(string)) {
            return new SingleContinuumNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
        }
        if (SpectralSetupParameters.TYPE_SCAN.equals(string)) {
            return new SpectralScanNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
        }
        return new SpectralLineNonOverlappingBandwidthCalculator(spectralSetupParameters, velocity);
    }

    public Frequency calculate() {
        Frequency frequency = this.calculatePerPoln();
        if (frequency == null) {
            return null;
        }
        CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(this.ssp.getPolarisation());
        return (Frequency)frequency.multiply(corrPolarization.getObsCount());
    }

    public abstract Frequency calculatePerPoln();
}

