/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.defaulters;

import alma.hla.runtime.obsprep.interfaces.PropertyChangeNotifier;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public abstract class Trigger
implements PropertyChangeListener {
    protected Object[] dependents;
    protected PropertyChangeNotifier[] principals;

    public Trigger(PropertyChangeNotifier propertyChangeNotifier, Object object) {
        this.principals = new PropertyChangeNotifier[1];
        this.principals[0] = propertyChangeNotifier;
        this.dependents = new Object[1];
        this.dependents[0] = object;
        this.registerWithPrincipals();
    }

    public Trigger(PropertyChangeNotifier propertyChangeNotifier, Object[] objectArray) {
        this.principals = new PropertyChangeNotifier[1];
        this.principals[0] = propertyChangeNotifier;
        this.dependents = objectArray;
        this.registerWithPrincipals();
    }

    public Trigger(PropertyChangeNotifier[] propertyChangeNotifierArray, Object object) {
        this.principals = propertyChangeNotifierArray;
        this.dependents = new Object[1];
        this.dependents[0] = object;
        this.registerWithPrincipals();
    }

    public Trigger(PropertyChangeNotifier[] propertyChangeNotifierArray, Object[] objectArray) {
        this.principals = propertyChangeNotifierArray;
        this.dependents = objectArray;
        this.registerWithPrincipals();
    }

    public abstract void fire(PropertyChangeEvent var1);

    public Object getDependent() {
        if (this.dependents.length > 1) {
            throw new RuntimeException("Trigger " + this + " has more than one dependent.");
        }
        return this.dependents[0];
    }

    public Object[] getDependents() {
        return this.dependents;
    }

    public PropertyChangeNotifier getPrincipal() {
        if (this.principals.length > 1) {
            throw new RuntimeException("Trigger " + this + " has more than one principal.");
        }
        return this.principals[0];
    }

    public PropertyChangeNotifier[] getPrincipals() {
        return this.principals;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fire(propertyChangeEvent);
    }

    private void registerWithPrincipals() {
        for (int i = 0; i < this.principals.length; ++i) {
            PropertyChangeNotifier propertyChangeNotifier = this.principals[i];
            if (propertyChangeNotifier == null) continue;
            propertyChangeNotifier.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.principals.length > 1 ? "many" : "one").append("-to-").append(this.dependents.length > 1 ? "many" : "one").append("-rule[").append(this.hashCode()).append("]");
        return stringBuilder.toString();
    }

    public void deactivate() {
        for (int i = 0; i < this.principals.length; ++i) {
            PropertyChangeNotifier propertyChangeNotifier = this.principals[i];
            if (propertyChangeNotifier == null) continue;
            propertyChangeNotifier.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }
}

