/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.verifiers;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.ot.boEditors.ValueUnitPairVerifier;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.models.sciencegoals.SfiScanSetupModel;
import alma.valuetypes.Frequency;
import javax.swing.JTextField;

public class SpectralScanRepresentativeFrequencyVerifier
extends ValueUnitPairVerifier {
    protected SfiScanSetupModel spectralScanModel;

    public SpectralScanRepresentativeFrequencyVerifier(ValueUnitPairEditor valueUnitPairEditor, SfiScanSetupModel sfiScanSetupModel) {
        super(valueUnitPairEditor);
        this.spectralScanModel = sfiScanSetupModel;
    }

    @Override
    public Object validate(JTextField jTextField) throws OutOfRangeException, NumberFormatException {
        if (this.spectralScanModel == null) {
            return null;
        }
        ValueUnitPair valueUnitPair = this.spectralScanModel.getStartFrequencyModel().getVUP();
        ValueUnitPair valueUnitPair2 = this.spectralScanModel.getEndFrequencyModel().getVUP();
        if (valueUnitPair == null || valueUnitPair2 == null) {
            throw new OutOfRangeException("Rep. freq. should be in the scan range");
        }
        Double d = this.spectralScanModel.getStartFrequencyModel().getVUP().getContent();
        Double d2 = this.spectralScanModel.getEndFrequencyModel().getVUP().getContent();
        if (d == 0.0 || d2 == 0.0) {
            throw new OutOfRangeException("Rep. freq. should be in the scan range");
        }
        SpectralScan.SpectralScanTunings spectralScanTunings = null;
        try {
            spectralScanTunings = this.spectralScanModel.getTunings();
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            return null;
        }
        try {
            this.setMinMax(((Frequency)((Object)spectralScanTunings.getAchievedScanRange().min())).getContentInGHz(), ((Frequency)((Object)spectralScanTunings.getAchievedScanRange().max())).getContentInGHz(), true, true);
        }
        catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            return null;
        }
        Double d3 = (Double)super.validate(jTextField);
        return d3;
    }
}

