/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.widgets;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class UndoableTextArea
extends JTextArea {
    private static final String UNDO_ACTION = "UndoAction";
    private static final String REDO_ACTION = "RedoAction";
    final UndoManager undoMgr = new UndoManager();

    public UndoableTextArea() {
        this.setupUndo();
    }

    public UndoableTextArea(String string) {
        super(string);
        this.setupUndo();
    }

    private void setupUndo() {
        this.getDocument().addUndoableEditListener(undoableEditEvent -> this.undoMgr.addEdit(undoableEditEvent.getEdit()));
        this.getActionMap().put(UNDO_ACTION, new AbstractAction(UNDO_ACTION){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (UndoableTextArea.this.undoMgr.canUndo()) {
                        UndoableTextArea.this.undoMgr.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    cannotUndoException.printStackTrace();
                }
            }
        });
        this.getActionMap().put(REDO_ACTION, new AbstractAction(REDO_ACTION){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (UndoableTextArea.this.undoMgr.canRedo()) {
                        UndoableTextArea.this.undoMgr.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    cannotRedoException.printStackTrace();
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(90, 128), UNDO_ACTION);
        this.getInputMap().put(KeyStroke.getKeyStroke(89, 128), REDO_ACTION);
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if (this.undoMgr != null) {
            this.undoMgr.discardAllEdits();
        }
    }
}

