/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.obsprep.ot.actions.About;
import alma.obsprep.ot.actions.Add;
import alma.obsprep.ot.actions.AddInteractor;
import alma.obsprep.ot.actions.Attach;
import alma.obsprep.ot.actions.BatchGenerationAction;
import alma.obsprep.ot.actions.CalTool;
import alma.obsprep.ot.actions.CloneProjectTreeNode;
import alma.obsprep.ot.actions.Close;
import alma.obsprep.ot.actions.Copy;
import alma.obsprep.ot.actions.Cut;
import alma.obsprep.ot.actions.Delete;
import alma.obsprep.ot.actions.DisplayProjectTimeSummary;
import alma.obsprep.ot.actions.DumpXML;
import alma.obsprep.ot.actions.DumpXMLInteractor;
import alma.obsprep.ot.actions.ExpTimeCalc;
import alma.obsprep.ot.actions.ExpandCollapseTreeNodes;
import alma.obsprep.ot.actions.Export;
import alma.obsprep.ot.actions.ExportSB;
import alma.obsprep.ot.actions.FindNode;
import alma.obsprep.ot.actions.GenerateWholePDFAction;
import alma.obsprep.ot.actions.HelpCookbook;
import alma.obsprep.ot.actions.HelpReferenceManual;
import alma.obsprep.ot.actions.HelpUserManual;
import alma.obsprep.ot.actions.ImportInvestigators;
import alma.obsprep.ot.actions.ImportLibrary;
import alma.obsprep.ot.actions.ImportProject;
import alma.obsprep.ot.actions.ImportStandardLibrary;
import alma.obsprep.ot.actions.LOSolutionTool;
import alma.obsprep.ot.actions.NewDDTProposal;
import alma.obsprep.ot.actions.NewProject;
import alma.obsprep.ot.actions.NewProposal;
import alma.obsprep.ot.actions.NewSupplementalCallProposal;
import alma.obsprep.ot.actions.OusComponentProtect;
import alma.obsprep.ot.actions.Paste;
import alma.obsprep.ot.actions.ProjectBackupAction;
import alma.obsprep.ot.actions.ProjectBackupRestoreAction;
import alma.obsprep.ot.actions.Quit;
import alma.obsprep.ot.actions.ReleaseNotes;
import alma.obsprep.ot.actions.Rename;
import alma.obsprep.ot.actions.Repair;
import alma.obsprep.ot.actions.Resume;
import alma.obsprep.ot.actions.RetrieveAsNew;
import alma.obsprep.ot.actions.RetrieveAsNewACASupplementalCallProposal;
import alma.obsprep.ot.actions.RetrieveAsNewDDTProposal;
import alma.obsprep.ot.actions.RetrieveLibrary;
import alma.obsprep.ot.actions.RetrieveProject;
import alma.obsprep.ot.actions.RevertProjectFromDisk;
import alma.obsprep.ot.actions.SavePreferences;
import alma.obsprep.ot.actions.SeeProblem;
import alma.obsprep.ot.actions.SetRepresentativeTarget;
import alma.obsprep.ot.actions.ShowPreferences;
import alma.obsprep.ot.actions.Store;
import alma.obsprep.ot.actions.SummaryFeedbackAction;
import alma.obsprep.ot.actions.Suspend;
import alma.obsprep.ot.actions.Terminate;
import alma.obsprep.ot.actions.Validate;
import alma.obsprep.ot.actions.ViewFeedback;
import alma.obsprep.ot.actions.ViewOverview;
import alma.obsprep.ot.actions.WizardAction;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ProjectRepository;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreePanels;
import alma.obsprep.util.MiscUtils;
import java.awt.Toolkit;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class OTActions {
    public static Action createAction(Action action, ActionProperties actionProperties) {
        if (actionProperties.name == null) {
            throw new NullPointerException("name should be defined");
        }
        action.putValue("Name", actionProperties.name);
        if (actionProperties.shortDesc != null) {
            action.putValue("ShortDescription", actionProperties.shortDesc);
        }
        if (actionProperties.longDesc != null) {
            action.putValue("LongDescription", actionProperties.longDesc);
        }
        if (actionProperties.mnemonic != -1) {
            action.putValue("MnemonicKey", actionProperties.mnemonic);
            if (actionProperties.mnemonicIndex != -1) {
                action.putValue("SwingDisplayedMnemonicIndexKey", actionProperties.mnemonicIndex);
            }
        }
        if (actionProperties.accelKey != -1) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(actionProperties.accelKey, actionProperties.accelMask));
        }
        if (actionProperties.icon != null) {
            action.putValue("SmallIcon", actionProperties.icon);
        }
        if (actionProperties.toggle != null) {
            action.putValue("SwingSelectedKey", actionProperties.toggle);
        }
        return action;
    }

    public static class ActionProperties {
        public String name = null;
        public String shortDesc = null;
        public String longDesc = null;
        public int mnemonic = -1;
        public int mnemonicIndex = -1;
        public int accelKey = -1;
        public int accelMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        public Icon icon;
        public Boolean toggle;
    }

    public static class ApplicationWide {
        public Action about;
        public Action disableOusCompProtect;
        public Action enableOusCompProtect;
        public Action expTimeCalc;
        public Action importStdLibrary;
        public Action importLibrary;
        public Action retrieveLibrary;
        public Action quit;
        public Action releasenotes;
        public Action seeNextProblem;
        public Action seePreviousProblem;
        public Action workOffline;
        public Action preferencesDialog;
        public Action viewOverview;
        public Action viewFeedback;
        public Action helpUserManual;
        public Action helpReferenceManual;
        public Action helpCookbook;
        public Action savePreferences;

        public void initialize(ObservingToolController observingToolController, ObservingToolGui observingToolGui, ProjectRepository projectRepository) {
            ActionProperties actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Save Preferences";
            actionProperties.name = "Save Preferences";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.savePreferences = OTActions.createAction(new SavePreferences(observingToolController), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "About...";
            actionProperties.name = "About...";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.about = OTActions.createAction(new About(observingToolController), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Release Notes...";
            actionProperties.name = "Release Notes...";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.releasenotes = OTActions.createAction(new ReleaseNotes(observingToolController), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Disable Edit Protect";
            actionProperties.shortDesc = "Disable Edit Protect for ObsUnitSets and their components";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.disableOusCompProtect = OTActions.createAction(new OusComponentProtect(observingToolGui, false), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Enable Edit Protect";
            actionProperties.shortDesc = "Enable Edit Protect for ObsUnitSets and their components";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.enableOusCompProtect = OTActions.createAction(new OusComponentProtect(observingToolGui, true), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Sensitivity Calculator...";
            actionProperties.name = "Sensitivity Calculator...";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.runETC;
            this.expTimeCalc = OTActions.createAction(new ExpTimeCalc(), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "User Manual";
            actionProperties.name = "User Manual";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 113;
            actionProperties.accelMask = 0;
            actionProperties.icon = Icons.help;
            this.helpUserManual = OTActions.createAction(new HelpUserManual(observingToolController), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Reference Manual";
            actionProperties.name = "Reference Manual";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 114;
            actionProperties.accelMask = 0;
            actionProperties.icon = Icons.help;
            this.helpReferenceManual = OTActions.createAction(new HelpReferenceManual(observingToolController), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Cookbook";
            actionProperties.name = "Cookbook";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 115;
            actionProperties.accelMask = 0;
            actionProperties.icon = Icons.help;
            this.helpCookbook = OTActions.createAction(new HelpCookbook(observingToolController), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Show ALMA Template Library";
            actionProperties.shortDesc = "Show the ALMA Template Library";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.library;
            this.importStdLibrary = OTActions.createAction(new ImportStandardLibrary(observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "From Disk...";
            actionProperties.shortDesc = "Open Project from Disk for use as Template";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.open;
            this.importLibrary = OTActions.createAction(new ImportLibrary(observingToolGui, false), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "From ALMA Archive...";
            actionProperties.shortDesc = "Open Project from ALMA Archive for use as Template";
            actionProperties.icon = Icons.retrieveFromArchive;
            this.retrieveLibrary = OTActions.createAction(new RetrieveLibrary(observingToolGui, projectRepository), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Quit";
            actionProperties.name = "Quit";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.quit = OTActions.createAction(new Quit(observingToolController), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Go to next Problem";
            actionProperties.name = "Go to next Problem";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 46;
            actionProperties.icon = Icons.seeNextProblem;
            this.seeNextProblem = OTActions.createAction(new SeeProblem(observingToolController, true), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Go to previous Problem";
            actionProperties.name = "Go to previous Problem";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 44;
            actionProperties.icon = Icons.seePreviousProblem;
            this.seePreviousProblem = OTActions.createAction(new SeeProblem(observingToolController, false), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Preferences";
            actionProperties.name = "Preferences";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            actionProperties.accelKey = 80;
            this.preferencesDialog = OTActions.createAction(new ShowPreferences(observingToolController, "NoChange"), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Overview";
            actionProperties.shortDesc = "View the overview panel";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 72;
            actionProperties.icon = null;
            this.viewOverview = OTActions.createAction(new ViewOverview(observingToolController), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Feedback";
            actionProperties.shortDesc = "View the feedback panel";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 70;
            actionProperties.icon = null;
            this.viewFeedback = OTActions.createAction(new ViewFeedback(observingToolController), actionProperties);
        }
    }

    public static class ProjectTiedActions {
        public Action addObsUnitSet;
        public Action addSchedblock;
        public Action addObservingGroup;
        public Action addTarget;
        public Action addFieldSource;
        public Action addBLSpectralSpec;
        public Action addACASpectralSpec;
        public Action addSquareLawSpectralSpec;
        public Action addOpticalCameraSpec;
        public Action addScienceParameters;
        public Action addPhaseCalParameters;
        public Action addPointingCalParameters;
        public Action addAmplitudeCalParameters;
        public Action addPolarizationCalParameters;
        public Action addFocusCalParameters;
        public Action addAtmosphericCalParameters;
        public Action addDelayCalParameters;
        public Action addCheckSourceCalParameters;
        public Action addSidebandRatioCalParameters;
        public Action addBandpassCalParameters;
        public Action addOpticalPointingParameters;
        public Action addHolographyParameters;
        public Action addCalibratorSurveyGoal;
        public Action addOpticalPointingScienceGoal;
        public Action addPhase2ScienceGoal;
        public Action addPhaseIScienceGoal;
        public Action addCalibratorSurveyScienceGoal;
        public Action addHolographySetup;
        public Action addAstroHolographySetup;
        public Action addRadiometricPointing;
        public Action addBaselineCalibrationGoal;
        public Action addRadiometricPointingParameters;
        public Action addDGCReferenceCalParameters;
        public Action addDGCScienceCalParameters;
        public Action attachComponents;
        public Action dumpXMLToWindow;
        public Action dumpXMLToClipboard;
        public Action setRepresentativeTarget;
        public Action scienceGoalFeedback;
        public Action generateWholePDF;
        public Action calTool;
        public Action loTool;
        public Action newProject;
        public Action newVLBIProject;
        public Action newSupplementalCallProject;
        public Action newCommissioningProject;
        public Action newProposal;
        public Action newDDTProposal;
        public Action newSupplementalCallProposal;
        public Action generateSBs;
        public Action runProjectSummaryDisplay;
        public Action runPhaseIGenerator;
        public Action runPhaseIGeneratorBatch;
        public Action runPhaseIIGeneratorBatch;
        public Action exportSB;
        public Action cloneProjectTreeNode;
        public Action copy;
        public Action cut;
        public Action paste;
        public Action delete;
        public Action validate;
        public Action rename;
        public Action expandNodes;
        public Action collapseNodes;
        public Action csvSuspend;
        public Action csvResume;
        public Action repair;
        public Action terminate;
        public Action clone;
        public Action findNextSimilarNodeInProjectTree;
        public Action findPreviousSimilarNodeInProjectTree;
        public Action searchDownProjectTree;
        public Action searchUpProjectTree;
        public Action open;
        public Action openfind;
        public Action save;
        public Action saveAs;
        public Action revertProjectFromDisk;
        public Action retrieve;
        public Action retrieveAsNewProposal;
        public Action retrieveAsNewDDTProposal;
        public Action retrieveAsNewACASupplementalProposal;
        public Action submit;
        public Action submitAsNew;
        public Action close;
        public Action backupProject;
        public Action backupRestore;
        public Action importInvestigators;

        public void initialize(ObservingToolController observingToolController, ObservingToolGui observingToolGui, ProjectRepository projectRepository, ProjectTreePanels projectTreePanels) {
            ProjectTree projectTree = null;
            ProjectTree projectTree2 = null;
            if (projectTreePanels != null) {
                projectTree = projectTreePanels.getPhase2Tree();
                projectTree2 = projectTreePanels.getPhase1Tree();
            }
            ActionProperties actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.OBSUNITSET.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.obsUnitSet;
            this.addObsUnitSet = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.OBSUNITSET), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.SCHEDBLOCK.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.schedBlock;
            this.addSchedblock = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.SCHEDBLOCK), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.OBSERVINGGROUP.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.observingGroup;
            this.addObservingGroup = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.OBSERVINGGROUP), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.TARGET.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.target;
            this.addTarget = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.TARGET), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.FIELDSOURCE.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.target;
            this.addFieldSource = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.FIELDSOURCE), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.BLSPECTRALSPEC.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.target;
            this.addBLSpectralSpec = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.BLSPECTRALSPEC), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.ACASPECTRALSPEC.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.target;
            this.addACASpectralSpec = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.ACASPECTRALSPEC), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.SQUARELAWSPECTRALSPEC.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.target;
            this.addSquareLawSpectralSpec = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.SQUARELAWSPECTRALSPEC), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.OPTICALCAMERASPEC.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.target;
            this.addOpticalCameraSpec = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.OPTICALCAMERASPEC), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.SCIENCEPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addScienceParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.SCIENCEPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.PHASECALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addPhaseCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.PHASECALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.POINTINGCALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addPointingCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.POINTINGCALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.AMPLITUDECALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addAmplitudeCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.AMPLITUDECALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.POLARIZATIONCALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addPolarizationCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.POLARIZATIONCALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.FOCUSCALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addFocusCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.FOCUSCALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.ATMOSPHERICCALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addAtmosphericCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.ATMOSPHERICCALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.DELAYCALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addDelayCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.DELAYCALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.DGCREFERENCECALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addDGCReferenceCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.DGCREFERENCECALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.DGCSCIENCECALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addDGCScienceCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.DGCSCIENCECALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.CHECKSOURCECALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addCheckSourceCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.CHECKSOURCECALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.SIDEBANDRATIOCALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addSidebandRatioCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.SIDEBANDRATIOCALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.BANDPASSCALPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addBandpassCalParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.BANDPASSCALPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.OPTICALPOINTINGPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addOpticalPointingParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.OPTICALPOINTINGPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.RADIOMETRICPOINTINGPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addRadiometricPointingParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.RADIOMETRICPOINTINGPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.HOLOGRAPHYPARAMETERS.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.calibrator;
            this.addHolographyParameters = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.HOLOGRAPHYPARAMETERS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Find next";
            actionProperties.shortDesc = "Find the next node in the tree which is of the same type";
            actionProperties.longDesc = "Find the next node in the project tree which has the same underlying data object";
            actionProperties.accelKey = 40;
            actionProperties.accelMask = 512;
            this.findNextSimilarNodeInProjectTree = OTActions.createAction(new FindNode(FindNode.SearchDirection.NEXT), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Find previous";
            actionProperties.shortDesc = "Find the previous node in the tree which is of the same type";
            actionProperties.longDesc = "Find the previous node in the project tree which has the same underlying data object";
            actionProperties.accelKey = 38;
            actionProperties.accelMask = 512;
            this.findPreviousSimilarNodeInProjectTree = OTActions.createAction(new FindNode(FindNode.SearchDirection.PREVIOUS), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Attach/Detach...";
            actionProperties.shortDesc = "Attach/detach resources to/from Target";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.attach;
            this.attachComponents = OTActions.createAction(new Attach(projectTree), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Show XML";
            actionProperties.shortDesc = "Dump the XML associated with the BO for the node to a window";
            actionProperties.longDesc = null;
            this.dumpXMLToWindow = OTActions.createAction(new DumpXML(DumpXMLInteractor.XMLDestination.Dialogue), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Copy XML to clipboard";
            actionProperties.shortDesc = "Dump the XML associated with the BO for the node to the clipboard";
            actionProperties.longDesc = null;
            this.dumpXMLToClipboard = OTActions.createAction(new DumpXML(DumpXMLInteractor.XMLDestination.Clipboard), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Set As Representative Target";
            actionProperties.name = "Set As Representative Target";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.attach;
            this.setRepresentativeTarget = OTActions.createAction(new SetRepresentativeTarget(projectTree), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "ALMA Calibrator Selection Tool...";
            actionProperties.name = "ALMA Calibrator Selection Tool...";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.runCalTool;
            this.calTool = OTActions.createAction(new CalTool(projectTree), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "ALMA LO Configuration Tool...";
            actionProperties.name = "ALMA LO Configuration Tool...";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.loTool = OTActions.createAction(new LOSolutionTool(projectTree), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Copy";
            actionProperties.name = "Copy";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 67;
            actionProperties.icon = null;
            this.copy = OTActions.createAction(new Copy(projectTree, projectTree2), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Cut";
            actionProperties.name = "Cut";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 88;
            actionProperties.icon = null;
            this.cut = OTActions.createAction(new Cut(projectTree, projectTree2), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Delete";
            actionProperties.name = "Delete";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 127;
            actionProperties.accelMask = 0;
            actionProperties.icon = Icons.delete;
            this.delete = OTActions.createAction(new Delete(projectTree, projectTree2), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "New Proposal";
            actionProperties.shortDesc = "New Proposal (Phase I)";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 78;
            actionProperties.icon = Icons.phase1Project;
            this.newProposal = OTActions.createAction(new NewProposal(observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "New DDT Proposal";
            actionProperties.shortDesc = "New DDT Proposal (Phase I)";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 68;
            actionProperties.icon = Icons.phase1DDTProject;
            this.newDDTProposal = OTActions.createAction(new NewDDTProposal(observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "New Supplemental Call Proposal";
            actionProperties.shortDesc = "New Supplemental Call Proposal (Phase I)";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.phase1SupplementalCallProject;
            this.newSupplementalCallProposal = OTActions.createAction(new NewSupplementalCallProposal(observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "New Program";
            actionProperties.shortDesc = "New Program (Phase II)";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.phase2Project;
            this.newProject = OTActions.createAction(new NewProject(observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Clone node";
            actionProperties.shortDesc = "Clones the currently selected node";
            actionProperties.longDesc = null;
            this.cloneProjectTreeNode = OTActions.createAction(new CloneProjectTreeNode(projectTree, projectTree2), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "New VLBI Program";
            actionProperties.shortDesc = "New VLBI Program (Phase II)";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.phase2VLBIProject;
            this.newVLBIProject = OTActions.createAction(new NewProject(observingToolGui, NewProject.ProjectMode.VLBI), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "New Supplemental Program";
            actionProperties.shortDesc = "New Supplemental Program (Phase II)";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.phase1SupplementalCallProject;
            this.newSupplementalCallProject = OTActions.createAction(new NewProject(observingToolGui, NewProject.ProjectMode.ACASUPPLEMENTALCALL), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "New Commissioning Program";
            actionProperties.shortDesc = "New Commissioning Program (Phase II)";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.commissionProject;
            this.newCommissioningProject = OTActions.createAction(new NewProject(observingToolGui, NewProject.ProjectMode.COMMISSIONING), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Paste";
            actionProperties.name = "Paste";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 86;
            actionProperties.icon = null;
            this.paste = OTActions.createAction(new Paste(projectTree, projectTree2), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Add Calibrator Survey Goal";
            actionProperties.name = "Add Calibrator Survey Goal";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.optical;
            this.addCalibratorSurveyGoal = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.CALIBRATORSURVEYWIZARD), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Add Radiometric Pointing Goal";
            actionProperties.name = "Add Radiometric Pointing Goal";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.optical;
            this.addRadiometricPointing = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.RADIOMETRICPOINTINGWIZARD), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Add Baseline Calibration Goal";
            actionProperties.name = "Add Baseline Calibration Goal";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.optical;
            this.addBaselineCalibrationGoal = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.BASELINECALIBRATIONWIZARD), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "New Optical Pointing Science Goal";
            actionProperties.name = "New Optical Pointing Science Goal";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.optical;
            this.addOpticalPointingScienceGoal = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.OPTICALPOINTINGWIZARD), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = actionProperties.shortDesc = "Add " + AddInteractor.ObjectType.HOLOGRAPHYSETUP.toString();
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.optical;
            this.addHolographySetup = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.HOLOGRAPHYSETUP), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "New Science Goal";
            actionProperties.name = "New Science Goal";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 71;
            actionProperties.icon = Icons.scienceGoal;
            this.addPhase2ScienceGoal = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.SCIENCEGOAL, true), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "New Science Goal";
            actionProperties.name = "New Science Goal";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.scienceGoal;
            this.addPhaseIScienceGoal = OTActions.createAction(new Add(projectTree2, AddInteractor.ObjectType.PHASEISCIENCEGOAL, true), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "New Calibrator Survey";
            actionProperties.name = "New Calibrator Survey";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.scienceGoal;
            this.addCalibratorSurveyScienceGoal = OTActions.createAction(new Add(projectTree, AddInteractor.ObjectType.CALIBRATORSURVEYWIZARD), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Displays a Printable Summary in a separate window";
            actionProperties.name = "Displays a Printable Summary in a separate window";
            actionProperties.longDesc = null;
            this.scienceGoalFeedback = OTActions.createAction(new SummaryFeedbackAction(), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Generate a PDF of Whole Proposal";
            actionProperties.name = "Generate a PDF of Whole Proposal";
            actionProperties.longDesc = null;
            this.generateWholePDF = OTActions.createAction(new GenerateWholePDFAction(), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Generate SBs from the Selected Goal";
            actionProperties.name = "Generate SBs from the Selected Goal";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.newGenerateSB;
            actionProperties.accelKey = 66;
            this.generateSBs = OTActions.createAction(new WizardAction(projectTree, observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Display Project Time Summary";
            actionProperties.name = "Display Project Time Summary";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.clock;
            this.runProjectSummaryDisplay = OTActions.createAction(new DisplayProjectTimeSummary(projectTree2, observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Generate Phase 1 SBs from the Selected Goal";
            actionProperties.name = "Generate Phase 1 SBs from the Selected Goal";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.obsUnitSet;
            this.runPhaseIGenerator = OTActions.createAction(new WizardAction(projectTree2, observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Generate Phase 1 SBs from all the Science Goals";
            actionProperties.name = "Generate Phase 1 SBs from all the Science Goals";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.obsUnitSet;
            this.runPhaseIGeneratorBatch = OTActions.createAction(new BatchGenerationAction(projectTree2, observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Generate Phase 2 SBs from all the Science Goals";
            actionProperties.name = "Generate Phase 2 SBs from all the Science Goals";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.newGenerateAllSBs;
            actionProperties.accelKey = 66;
            this.runPhaseIIGeneratorBatch = OTActions.createAction(new BatchGenerationAction(projectTree2, observingToolGui, true), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Rename";
            actionProperties.name = "Rename";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.rename = OTActions.createAction(new Rename(projectTree, projectTree2), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "From Disk...";
            actionProperties.shortDesc = "Open Project from Disk";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 79;
            actionProperties.icon = Icons.open;
            this.open = OTActions.createAction(new ImportProject(observingToolGui, false), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Backup project";
            actionProperties.shortDesc = "Backs up current project to disk";
            actionProperties.longDesc = null;
            this.backupProject = OTActions.createAction(new ProjectBackupAction(observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Restore Project from Backups";
            actionProperties.shortDesc = "Restores a project from the backups";
            actionProperties.longDesc = null;
            this.backupRestore = OTActions.createAction(new ProjectBackupRestoreAction(observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Find Projects on Disk...";
            actionProperties.shortDesc = "Find Projects on Disk";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.openfind = OTActions.createAction(new ImportProject(observingToolGui, true), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Import Investigators";
            actionProperties.shortDesc = "Import investigators from a project on disk";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.open;
            this.importInvestigators = OTActions.createAction(new ImportInvestigators(observingToolGui, false), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Save";
            actionProperties.shortDesc = "Save Project to Disk";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 83;
            actionProperties.icon = Icons.save;
            this.save = OTActions.createAction(new Export(observingToolGui, false), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Save As...";
            actionProperties.shortDesc = "Save Project As New File";
            actionProperties.longDesc = null;
            this.saveAs = OTActions.createAction(new Export(observingToolGui, true), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "From ALMA Archive...";
            actionProperties.shortDesc = "Open Project from ALMA Archive";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.retrieveFromArchive;
            this.retrieve = OTActions.createAction(new RetrieveProject(observingToolGui, projectRepository), actionProperties);
            if (MiscUtils.isDeveloperUIFeaturesEnabled()) {
                actionProperties = new ActionProperties();
                actionProperties.name = "Revert Project";
                actionProperties.shortDesc = "Discards all edits and reloads last project file imported";
                actionProperties.longDesc = null;
                actionProperties.accelKey = 82;
                this.revertProjectFromDisk = OTActions.createAction(new RevertProjectFromDisk(observingToolGui), actionProperties);
            }
            actionProperties = new ActionProperties();
            actionProperties.name = "Open Archive Proposal as a New Proposal";
            actionProperties.shortDesc = "Open Project from ALMA Archive, and edit as new Proposal";
            actionProperties.longDesc = null;
            this.retrieveAsNewProposal = OTActions.createAction(new RetrieveAsNew(observingToolGui, projectRepository), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Open Archive Proposal as a New DDT Proposal";
            actionProperties.shortDesc = "Open Project from ALMA Archive, and edit as new DDT Proposal";
            actionProperties.longDesc = null;
            this.retrieveAsNewDDTProposal = OTActions.createAction(new RetrieveAsNewDDTProposal(observingToolGui, projectRepository), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Open Archive Proposal as a New ACA Supplemental Call Proposal";
            actionProperties.shortDesc = "Open Project from ALMA Archive, and edit as new ACA Supplemental Call Proposal";
            actionProperties.longDesc = null;
            this.retrieveAsNewACASupplementalProposal = OTActions.createAction(new RetrieveAsNewACASupplementalCallProposal(observingToolGui, projectRepository), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Submit Project";
            actionProperties.shortDesc = "Submit Project to ALMA";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.submitToArchive;
            this.submit = OTActions.createAction(new Store(observingToolController, observingToolGui, false, projectRepository), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Submit Project as New";
            actionProperties.name = "Submit Project as New";
            actionProperties.longDesc = null;
            this.submitAsNew = OTActions.createAction(new Store(observingToolController, observingToolGui, true, projectRepository), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Export selected Scheduling Block to File";
            actionProperties.name = "Export selected Scheduling Block to File";
            this.exportSB = OTActions.createAction(new ExportSB.Action(), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.shortDesc = "Validate";
            actionProperties.name = "Validate";
            actionProperties.longDesc = null;
            actionProperties.accelKey = 76;
            actionProperties.icon = Icons.validateProject;
            this.validate = OTActions.createAction(new Validate(observingToolGui), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Expand all";
            actionProperties.shortDesc = "Show all tree elements below";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            actionProperties.accelKey = 90;
            this.expandNodes = OTActions.createAction(new ExpandCollapseTreeNodes(projectTree, projectTree2, true), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Collapse all";
            actionProperties.shortDesc = "Hide all tree elements below";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.collapseNodes = OTActions.createAction(new ExpandCollapseTreeNodes(projectTree, projectTree2, false), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Close Project";
            actionProperties.shortDesc = "Close Project";
            actionProperties.longDesc = null;
            actionProperties.icon = null;
            this.close = OTActions.createAction(new Close(observingToolGui, projectTreePanels), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Suspend";
            actionProperties.shortDesc = "Suspend observation of this SchedBlock";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.delete;
            this.csvSuspend = OTActions.createAction(new Suspend(projectTree), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Resume";
            actionProperties.shortDesc = "Allow further observation of this SchedBlock";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.okay;
            this.csvResume = OTActions.createAction(new Resume(projectTree), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Terminate";
            actionProperties.shortDesc = "Terminate further observation of this broken SchedBlock";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.destroy;
            this.terminate = OTActions.createAction(new Terminate(projectTree), actionProperties);
            actionProperties = new ActionProperties();
            actionProperties.name = "Mark as Repaired";
            actionProperties.shortDesc = "Mark this broken SchedBlock as repaired";
            actionProperties.longDesc = null;
            actionProperties.icon = Icons.okay;
            this.repair = OTActions.createAction(new Repair(projectTree), actionProperties);
        }
    }
}

