/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsPhase;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.actions.WizardInteractor;
import alma.obsprep.ot.boEditors.AbstractWizard;
import alma.obsprep.ot.editors.misc.UserEditRestrictionController;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.GUIUtilities;
import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class WizardPerformer
extends Performer
implements Performer.Async2 {
    public WizardPerformer(WizardInteractor wizardInteractor) {
        super(wizardInteractor);
    }

    private boolean isNonDeletableOUSorSBPresent(@NonNull AbstractScienceGoal abstractScienceGoal) {
        if (abstractScienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        ObsUnitSet obsUnitSet = abstractScienceGoal.gettrueObsUnitSet();
        if (obsUnitSet == null) {
            return false;
        }
        if (!obsUnitSet.isDeletable()) {
            return true;
        }
        try {
            for (SchedBlock obsUnitSetComponent : obsUnitSet.findSchedBlocks()) {
                if (obsUnitSetComponent.isDeletable()) continue;
                return true;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        for (ObsUnitSet obsUnitSet2 : obsUnitSet.findObsUnitSets()) {
            if (obsUnitSet2.isDeletable()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() {
        Object object;
        ArrayList<ScienceGoal> arrayList = new ArrayList<ScienceGoal>();
        ArrayList<ScienceGoal> arrayList2 = new ArrayList<ScienceGoal>();
        WizardInteractor wizardInteractor = (WizardInteractor)this.getGui();
        boolean bl = wizardInteractor.requestConfirmation(ConfirmationReasons.GENERATESBSFORDELETEABLESSCIENCEGOALS.getReason());
        if (!bl) {
            return;
        }
        boolean bl2 = wizardInteractor.confirmOverwrite();
        AbstractScienceGoal[] abstractScienceGoalArray = wizardInteractor.getScienceGoals();
        int n = abstractScienceGoalArray.length;
        try {
            wizardInteractor.busy(true);
            object = null;
            this.clearPhase1PlanIfRegeneratingP1(wizardInteractor);
            ArrayList<AbstractScienceGoal> arrayList3 = new ArrayList<AbstractScienceGoal>();
            for (AbstractScienceGoal abstractScienceGoal : abstractScienceGoalArray) {
                ScienceGoal scienceGoal;
                if (abstractScienceGoal == null || !bl2 && abstractScienceGoal.getObsUnitSet() != null) continue;
                if (this.isSBRegenerationAllowed(abstractScienceGoal)) {
                    Log.logger(WizardPerformer.class).fine("SG regeneration performed by P2G member as SG OUS in a state that permits regeneration");
                } else if (this.isNonDeletableOUSorSBPresent(abstractScienceGoal)) {
                    if (abstractScienceGoalArray.length != 1) continue;
                    GUIUtilities.error(null, "The SBs associated with science goal " + abstractScienceGoal.getName() + " cannot be deleted");
                    continue;
                }
                if (abstractScienceGoal instanceof ScienceGoal && (scienceGoal = (ScienceGoal)((Object)abstractScienceGoal)).getIsDescoped()) {
                    arrayList.add(scienceGoal);
                    continue;
                }
                if (abstractScienceGoal instanceof ScienceGoal) {
                    scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                    UserEditRestrictionController userEditRestrictionController = UserEditRestrictionController.getInstance();
                    if (!RoleDirectoryServiceHelper.isUserP2G() && !userEditRestrictionController.isPreExistingP2GMajorEditsInPlace(scienceGoal)) {
                        DefaultProblemListModel defaultProblemListModel = new DefaultProblemListModel();
                        userEditRestrictionController.performUserRestrictedValidationChecks(scienceGoal, defaultProblemListModel);
                        if (defaultProblemListModel.hasErrorOrWorse()) {
                            arrayList2.add(scienceGoal);
                            continue;
                        }
                    }
                }
                try {
                    if (object == null) {
                        object = abstractScienceGoal.placeToAdd().gettrueObsPlan();
                    }
                    scienceGoal = Stopwatch.createStarted();
                    abstractScienceGoal.getWizard().generate(wizardInteractor.shouldScienceGoalKnowItGotGenerated());
                    scienceGoal.stop();
                    Log.logger(WizardPerformer.class).info("SB generation process took : " + scienceGoal.toString());
                    arrayList3.add(abstractScienceGoal);
                    ActionLog.performed("Generate SBs for", abstractScienceGoal);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    wizardInteractor.error("Error generating SBs for " + abstractScienceGoal.getNameOrDefault(), exception);
                }
            }
            if (object != null) {
                ((ObsUnitSet)object).ensureSBNamesAreUnique(Arrays.asList(abstractScienceGoalArray), arrayList3);
            }
        }
        finally {
            wizardInteractor.busy(false);
        }
        if (!arrayList2.isEmpty()) {
            object = new StringBuilder("<html>As PI, you cannot generate SBs for the following Science Goals as they contain major changes: <ul>");
            arrayList2.stream().forEach(arg_0 -> WizardPerformer.lambda$perform$0((StringBuilder)object, arg_0));
            GUIUtilities.info(null, StringUtils.chop((String)((StringBuilder)object).toString()) + "</ul><P><br>Please validate the project for more information.</html>");
        }
        if (!arrayList.isEmpty()) {
            if (n > 1) {
                object = new StringBuilder("<html>The following Science Goals have been descoped during proposal review and will not be generated: ");
                arrayList.stream().forEach(arg_0 -> WizardPerformer.lambda$perform$1((StringBuilder)object, arg_0));
                GUIUtilities.info(null, StringUtils.chop((String)((StringBuilder)object).toString()) + "</html>");
            } else {
                GUIUtilities.info(null, "Cannot generate SBs from this Science Goal as it has been descoped during proposal review.");
            }
        }
    }

    private boolean isSBRegenerationAllowed(AbstractScienceGoal abstractScienceGoal) {
        ObsUnitSet obsUnitSet = abstractScienceGoal.gettrueObsUnitSet();
        if (obsUnitSet == null) {
            return false;
        }
        return obsUnitSet.isSBRegenerationPossible() && RoleDirectoryServiceHelper.isUserP2G();
    }

    private void clearPhase1PlanIfRegeneratingP1(WizardInteractor wizardInteractor) {
        ObsPhase obsPhase;
        AbstractScienceGoal[] abstractScienceGoalArray = wizardInteractor.getScienceGoals();
        if (abstractScienceGoalArray != null && abstractScienceGoalArray.length > 0 && (obsPhase = (ObsPhase)abstractScienceGoalArray[0].getParent()) instanceof ObsProposal) {
            ObsProposal obsProposal = (ObsProposal)((Object)obsPhase);
            try {
                ObsUnitSet obsUnitSet = AbstractWizard.getPlanForPhase1SBs(obsProposal);
                obsUnitSet.clearObsUnitSet();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void lambda$perform$1(StringBuilder stringBuilder, ScienceGoal scienceGoal) {
        stringBuilder.append("<b>" + scienceGoal.getName() + "</b>,");
    }

    private static /* synthetic */ void lambda$perform$0(StringBuilder stringBuilder, ScienceGoal scienceGoal) {
        stringBuilder.append("<li><b>" + scienceGoal.getName() + "</b></li>");
    }

    public static enum ConfirmationReasons {
        GENERATESBSFORDELETEABLESSCIENCEGOALS("Generate SBs for SGs with deleteable OUSes");

        private final String reason;

        private ConfirmationReasons(String string2) {
            this.reason = string2;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

