/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.schedblock;

import alma.common.sourcecatalog.utilities.TextUtils;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AbstractCorrelatorConfiguration;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.data.SchedBlockData;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.ContextSwitchInterface;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.boEditors.FrequencyVerifier;
import alma.obsprep.ot.editors.misc.TabbedEditorWithSummaryTable;
import alma.obsprep.ot.editors.schedblock.BaseBandConfigEditor;
import alma.obsprep.ot.editors.schedblock.BaseBandConfigTable;
import alma.obsprep.ot.editors.schedblock.LOSetupPreferenceEditor;
import alma.obsprep.ot.editors.schedblock.SpectralSpecVisualEditor;
import alma.obsprep.ot.editors.valuetypes.ValueUnitPairEditor;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.models.misc.TabbedEditorModel;
import alma.obsprep.ot.models.schedblock.BaseBandConfigTabbedModel;
import alma.obsprep.ot.models.schedblock.BaseBandConfigTableModel;
import alma.obsprep.ot.models.schedblock.LOSetupPreferenceModel;
import alma.obsprep.ot.models.schedblock.SpectralSpecModel;
import alma.valuetypes.DataRate;
import alma.valuetypes.Frequency;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class BaseBandConfigTabbedEditor
extends TabbedEditorWithSummaryTable {
    private static final long serialVersionUID = -3286410973444277553L;
    protected FieldID addButtonFID = new FieldID("BaseBandConfig.addBtn");
    protected FieldID copyButtonFID = new FieldID("BaseBandConfig.copyBtn");
    protected FieldID delButtonFID = new FieldID("BaseBandConfig.delBtn");
    protected FieldID printButtonFID = new FieldID("BaseBandConfig.printBtn");
    public static final FieldID documentFID = new FieldID("BaseBandConfig.document");
    public static final FieldID OPTIM_PANEL_FID = new FieldID("BaseBandConfigTabbedEditor.OptimizationPanel");
    public static final FieldID LO1FREQUENCY_FID = new FieldID("BaseBandConfigTabbedEditor.LO1Frequency");
    public static final FieldID TOTALDATARATE_FID = new FieldID("BaseBandConfigTabbedEditor.TotalDataRate");
    public static final FieldID HAS_HWSETUP_FID = new FieldID("BaseBandConfigTabbedEditor.hasHardwareSetup");
    public static final FieldID TUNEHIGH_FID = new FieldID("BaseBandConfigTabbedEditor.tuneHigh");
    public static final FieldID FLOOG_VALUE_FID = new FieldID("BaseBandConfigTabbedEditor.floogValue");
    public static final FieldID FLOOG_UNIT_FID = new FieldID("BaseBandConfigTabbedEditor.floogUnit");
    public static final FieldID LO1FREQUENCY_VALUE_FID = new FieldID("BaseBandConfigTabbedEditor.lo1FrequencyValue");
    public static final FieldID LO1FREQUENCY_UNIT_FID = new FieldID("BaseBandConfigTabbedEditor.lo1FrequencyUnit");
    private final Set<Component> acaComponents = new HashSet<Component>();
    private final Set<Component> blComponents = new HashSet<Component>();
    protected OptimisationComponentEditor oce;

    public BaseBandConfigTabbedEditor(TabbedEditorModel tabbedEditorModel, BaseBandConfigEditor baseBandConfigEditor) {
        this.setModel(tabbedEditorModel);
        this.subEditor = baseBandConfigEditor;
        this.registerSubView(baseBandConfigEditor);
        BaseBandConfigTableModel baseBandConfigTableModel = this.getMyModel().getBaseBandConfigTableModel();
        this.setTable(new BaseBandConfigTable(baseBandConfigTableModel));
        this.build();
        tabbedEditorModel.publish();
        this.setMaxNumberOfSubBO(10);
        this.setupTabTitleAndBBPrefsUpdater();
        this.addChangeListener(changeEvent -> this.getBaseBandConfigEditor().cancelCellEditingOnSwTable());
    }

    public BaseBandConfigTabbedModel getMyModel() {
        return (BaseBandConfigTabbedModel)this.getModel();
    }

    public BaseBandConfigEditor getBaseBandConfigEditor() {
        return (BaseBandConfigEditor)this.subEditor;
    }

    @Override
    public BaseBandConfigTable getTable() {
        return (BaseBandConfigTable)super.getTable();
    }

    @Override
    protected void build() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Tip: Add basebands separately, set center frequency, calculate new LO setup after each");
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        this.oce = new OptimisationComponentEditor(this.getMyModel());
        this.registerSubView(this.oce);
        this.register(this.oce, OPTIM_PANEL_FID);
        this.add((Component)this.oce, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        if (this.getTable() != null) {
            ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(this.getTable());
            scrollWhenFocusedPane.setMinimumSize(this.getTable().getPreferredScrollableViewportSize());
            this.add((Component)scrollWhenFocusedPane, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.add((Component)this.getButtons(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.tabbedPane, gridBagConstraints);
    }

    public JPanel getButtons() {
        JButton jButton = new JButton("Add BaseBand");
        this.initEvents(jButton, this.addButtonFID);
        jButton.setToolTipText("Add a BaseBand");
        JButton jButton2 = new JButton("Copy&Add BaseBand");
        this.initEvents(jButton2, this.copyButtonFID);
        jButton2.setToolTipText("Add a BaseBand copying the selected one");
        JButton jButton3 = new JButton("Delete BaseBand");
        this.initEvents(jButton3, this.delButtonFID);
        jButton3.setToolTipText("Delete a BaseBand");
        JButton jButton4 = new JButton("Print");
        this.initEvents(jButton4, this.printButtonFID);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton3);
        return jPanel;
    }

    public void setAdvancedHardwareSetupVisible(boolean bl) {
        if (this.oce != null) {
            this.oce.setAdvancedHardwareSetupVisible(bl);
        }
    }

    @Override
    protected void updateButtons() {
        if (!this.isEnabled()) {
            return;
        }
        int n = this.getMyModel().getBOCount();
        this.setEnabled(this.getComponent(this.addButtonFID), n < SpectralSpec.maxBaseBandCount());
        this.setEnabled(this.getComponent(this.copyButtonFID), n > 0 && n < SpectralSpec.maxBaseBandCount());
        this.setEnabled(this.getComponent(this.delButtonFID), n > 0 && this.getSelectedIndex() != -1);
    }

    public void updateDeviceDependingComponent() {
    }

    private boolean isInVisualEditor() {
        Container container = this;
        while (container.getParent() != null) {
            if (!((container = container.getParent()) instanceof SpectralSpecVisualEditor)) continue;
            return true;
        }
        return false;
    }

    public void updateCorrelatorDependingComponent() {
        SpectralSpec spectralSpec = this.getMyModel().getSpectralSpec();
        if (spectralSpec != null && spectralSpec.hasCorrelatorConfiguration()) {
            AbstractCorrelatorConfiguration abstractCorrelatorConfiguration = spectralSpec.getCorrelatorConfiguration();
            boolean bl = abstractCorrelatorConfiguration.getCorrelatorType().equals((Object)CorrelatorType.ACA);
            for (Component component : this.blComponents) {
                component.setVisible(!bl);
            }
            for (Component component : this.acaComponents) {
                component.setVisible(bl);
            }
        }
    }

    @Override
    protected String tabTitle(int n) {
        SpectralSpec spectralSpec = this.getMyModel().getSpectralSpec();
        String string = spectralSpec == null ? null : spectralSpec.getBaseBand(n).getBaseBandName();
        return string;
    }

    private void setupTabTitleAndBBPrefsUpdater() {
        this.getMyModel().getSubModel().subscribe((model, fieldID, object) -> {
            if (fieldID.equals(BaseBandConfigEditor.BASEBANDNAME_CB_FID)) {
                int n = this.getSelectedIndex();
                try {
                    this.setTitle(n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return;
                }
                this.oce.bbcAdded();
                this.oce.setButtons();
            }
        });
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        BaseBandConfigTabbedModel baseBandConfigTabbedModel = this.getMyModel();
        if (fieldID.equals(documentFID)) {
            this.updateButtons();
            this.updateDeviceDependingComponent();
            this.updateCorrelatorDependingComponent();
            return;
        }
        if (fieldID.equals(this.addButtonFID)) {
            int n = this.getSelectedIndex();
            baseBandConfigTabbedModel.newBO(n + 1);
            this.oce.bbcAdded();
            this.setSelectedIndex(n + 1);
            this.fireStateChanged();
            this.updateButtons();
            return;
        }
        if (fieldID.equals(this.delButtonFID)) {
            int n = this.getSelectedIndex();
            this.oce.bbcDeleted();
            baseBandConfigTabbedModel.deleteBO(baseBandConfigTabbedModel.getBO(n));
            if (n == 0) {
                if (baseBandConfigTabbedModel.getBOCount() != 0) {
                    this.setSelectedIndex(n);
                } else {
                    this.setSelectedIndex(-1);
                }
            } else if (n == baseBandConfigTabbedModel.getBOCount()) {
                this.setSelectedIndex(n - 1);
            } else if (n != -1) {
                this.setSelectedIndex(n);
            }
            this.fireStateChanged();
            this.updateButtons();
            return;
        }
        if (fieldID.equals(this.printButtonFID)) {
            Log.logger((Object)this).info("\n" + this.getMyModel().getSpectralSpec());
            return;
        }
        super.update(fieldID, object);
    }

    public void doClickAddButton() {
        ((JButton)this.getComponent(this.addButtonFID)).doClick();
    }

    public void doClickDeleteButton() {
        ((JButton)this.getComponent(this.delButtonFID)).doClick();
    }

    public static void main(String[] stringArray) {
        SpectralSpec spectralSpec;
        InitServices.initModelSupportClasses();
        JFrame jFrame = new JFrame("BaseBandConfigTabbedEditor");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setLocation(new Point(500, 20));
        jFrame.setPreferredSize(new Dimension(900, 1200));
        SchedBlock schedBlock = SchedBlockData.createSchedBlock();
        SpectralSpec spectralSpec2 = spectralSpec = SpectralSpec.createSpectralSpecWithBLCorrelatorConfiguration(Optional.empty());
        schedBlock.addSpectralSpec(spectralSpec2);
        spectralSpec2.getCorrelatorConfiguration().setEnable90DegreeWalshFunction(true);
        spectralSpec2.setRestFrequency(Frequency.createFrequencyGHZ(660.0));
        spectralSpec2.getFrequencySetup().setReceiverBand(ReceiverBand.getReceiverBandName(660.0));
        AbstractBaseBandConfig abstractBaseBandConfig = spectralSpec2.addNewBaseBand().getBaseBandConfig();
        abstractBaseBandConfig.setCenterFrequency(Frequency.createFrequencyGHZ(660.01));
        abstractBaseBandConfig.addNewSpectralWindow();
        abstractBaseBandConfig = spectralSpec2.addNewBaseBand().getBaseBandConfig();
        abstractBaseBandConfig.setCenterFrequency(Frequency.createFrequencyGHZ(662.0));
        abstractBaseBandConfig.setBaseBandName(BaseBandSpecification.BASEBANDNAME_BB_4);
        BaseBandConfigTabbedModel baseBandConfigTabbedModel = new BaseBandConfigTabbedModel(null);
        BaseBandConfigEditor baseBandConfigEditor = new BaseBandConfigEditor(baseBandConfigTabbedModel.getSubModel());
        BaseBandConfigTabbedEditor baseBandConfigTabbedEditor = new BaseBandConfigTabbedEditor((TabbedEditorModel)baseBandConfigTabbedModel, baseBandConfigEditor);
        baseBandConfigTabbedModel.setDocument(spectralSpec2);
        SpectralSpecModel spectralSpecModel = new SpectralSpecModel(null);
        baseBandConfigTabbedModel.setParentModel(spectralSpecModel);
        jFrame.getContentPane().setLayout(new BoxLayout(jFrame.getContentPane(), 3));
        jFrame.getContentPane().setPreferredSize(new Dimension(800, 600));
        jFrame.getContentPane().add(baseBandConfigTabbedEditor);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void finalizeUserEdits() {
        BaseBandConfigTable baseBandConfigTable = this.getTable();
        if (baseBandConfigTable == null) {
            return;
        }
        Enumeration<TableColumn> enumeration = baseBandConfigTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableCellEditor tableCellEditor;
            TableColumn tableColumn = enumeration.nextElement();
            if (tableColumn == null || (tableCellEditor = tableColumn.getCellEditor()) == null || !ContextSwitchInterface.class.isAssignableFrom(tableCellEditor.getClass())) continue;
            ContextSwitchInterface contextSwitchInterface = (ContextSwitchInterface)((Object)tableCellEditor);
            contextSwitchInterface.finalizeUserEdits();
        }
    }

    public class OptimisationComponentEditor
    extends EditorWithGridBagLayout {
        private static final long serialVersionUID = -8714858806881075179L;
        protected JPanel hardwareSetupOptions = null;
        private JCheckBox hasHardwareSetupButton = null;
        private JCheckBox tuneHighButton = null;
        private ValueUnitPairEditor floog = null;
        private ValueUnitPairEditor lo1Frequency = null;
        protected LOSetupPreferenceEditor loSetupPrefsEditor;
        protected ActionListener calcLOListener = actionEvent -> this.getModel().publish();

        public OptimisationComponentEditor(BaseBandConfigTabbedModel baseBandConfigTabbedModel) {
            this.setModel(baseBandConfigTabbedModel);
            this.build();
        }

        @Override
        public BaseBandConfigTabbedModel getModel() {
            return (BaseBandConfigTabbedModel)super.getModel();
        }

        @Override
        public void build() {
            super.build("OptimisationComponents");
        }

        public void setAdvancedHardwareSetupVisible(boolean bl) {
            if (this.hardwareSetupOptions != null) {
                this.hardwareSetupOptions.setVisible(bl);
            }
        }

        public void bbcAdded() {
            this.getModel().getLOSetupPreferenceModel().publishWeights();
        }

        public void bbcDeleted() {
            this.getModel().getLOSetupPreferenceModel().publishWeights();
        }

        @Override
        public void update(FieldID fieldID, Object object) {
            if (fieldID.equals(LO1FREQUENCY_FID)) {
                Frequency frequency = (Frequency)((Object)object);
                super.update(fieldID, TextUtils.format((ValueUnitPair)frequency, (int)5));
                return;
            }
            if (fieldID.equals(TOTALDATARATE_FID)) {
                DataRate dataRate = (DataRate)((Object)object);
                super.update(fieldID, TextUtils.format((ValueUnitPair)dataRate, (int)3));
                return;
            }
            super.update(fieldID, object);
            this.setHardwareSetupMode(this.hasHardwareSetupButton.isSelected());
            BaseBandConfigTabbedEditor.this.getBaseBandConfigEditor().setHardwareSetupMode(this.hasHardwareSetupButton.isSelected());
        }

        @Override
        protected void addComponents(String string) {
            JPanel jPanel = this.createNewGroup();
            GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
            GridBagConstraints gridBagConstraints = this.createNewConstraints();
            gridBagConstraints.weightx = 1.0;
            JPanel jPanel2 = this.createHardwareSetupGroup();
            this.hardwareSetupOptions = this.createCollapsingGroup(jPanel2, "Hardware Setup", true);
            this.loSetupPrefsEditor = this.createUserPreferencesGroup();
            JPanel jPanel3 = this.createResultsGroup();
            jPanel3.setBorder(BorderFactory.createTitledBorder("Results"));
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(this.hardwareSetupOptions, gridBagConstraints);
            jPanel.add(this.hardwareSetupOptions);
            ++gridBagConstraints.gridy;
            gridBagLayout.setConstraints(this.loSetupPrefsEditor, gridBagConstraints);
            jPanel.add(this.loSetupPrefsEditor);
            ++gridBagConstraints.gridx;
            gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
            jPanel.add(jPanel3);
            this.constraints.weightx = 1.0;
            this.addComponent(jPanel);
        }

        private LOSetupPreferenceEditor createUserPreferencesGroup() {
            LOSetupPreferenceModel lOSetupPreferenceModel = this.getModel().getLOSetupPreferenceModel();
            LOSetupPreferenceEditor lOSetupPreferenceEditor = new LOSetupPreferenceEditor(lOSetupPreferenceModel);
            lOSetupPreferenceEditor.addCalculateLOListener(this.calcLOListener);
            this.registerSubView(lOSetupPreferenceEditor);
            return lOSetupPreferenceEditor;
        }

        private JPanel createResultsGroup() {
            JPanel jPanel = this.createNewGroup();
            GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
            GridBagConstraints gridBagConstraints = this.createNewConstraints();
            OTTextField oTTextField = this.makeTextField(LO1FREQUENCY_FID, false, "The frequency of the first local oscillator");
            oTTextField.setFocusable(true);
            this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "<html>LO<sub>1</sub> Frequency</html>", (JComponent)oTTextField);
            oTTextField = this.makeTextField(TOTALDATARATE_FID, false, "Total output data rate for this Spectral Spec");
            oTTextField.setFocusable(true);
            this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "<html>Total Data Rate</html>", (JComponent)oTTextField);
            return jPanel;
        }

        private JPanel createHardwareSetupGroup() {
            JPanel jPanel = this.createNewGroup();
            GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
            GridBagConstraints gridBagConstraints = this.createNewConstraints();
            ComponentCollection componentCollection = new ComponentCollection();
            this.hasHardwareSetupButton = this.makeCheckBox(HAS_HWSETUP_FID, "", "Use advanced hardware setup mode features");
            this.addLabeledComponent((JComponent)jPanel, gridBagLayout, gridBagConstraints, "Hardware Set-up", (JComponent)this.hasHardwareSetupButton);
            this.floog = this.makeValueUnitPairEditor(this.getModel().getFloogModel(), "Floog frequency");
            this.floog.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(this.floog, 0.0, 2000.0));
            componentCollection.remember(this.makeLabel("FLOOG"));
            componentCollection.remember(this.floog);
            this.tuneHighButton = this.makeCheckBox(TUNEHIGH_FID, "", "Tune high option");
            componentCollection.remember(this.makeLabel("Tune High"));
            componentCollection.remember(this.tuneHighButton);
            this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
            this.lo1Frequency = this.addValueUnitPair((JComponent)jPanel, gridBagLayout, gridBagConstraints, this.getModel().getLO1FrequencyModel(), "<html>LO<sub>1</sub> Frequency</html>", "The frequency of the first local oscillator");
            this.lo1Frequency.setVerifier("FOCUSLOST_VERIFIER", new FrequencyVerifier(this.lo1Frequency, 0.0, 2000.0));
            return jPanel;
        }

        protected void setButtons() {
            this.loSetupPrefsEditor.setButtons();
        }

        protected void setHardwareSetupMode(boolean bl) {
            this.floog.setEnabled(bl);
            this.tuneHighButton.setEnabled(bl);
            this.lo1Frequency.setEnabled(bl);
            BaseBandConfigTabbedEditor.this.getMyModel().getBaseBandConfigTableModel().setHardwareSetupMode(bl);
        }
    }
}

