/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.spatialvisual;

import alma.obsprep.bo.annotations.RectanglePatternI;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.editors.spatialvisual.BaseSpatialVisualModel;
import alma.obsprep.ot.editors.spatialvisual.VisualModelHelperForTargetParameters;
import alma.obsprep.ot.editors.spatialvisual.mapper.OverlayPointingMapperModel;
import alma.obsprep.ot.editors.spatialvisual.mapper.ShowPointingsException;
import alma.obsprep.ot.models.obsproject.RectangleModel;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.sciencegoals.FieldSetupModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import javax.swing.Timer;

public class ScienceGoalSpatialVisualModel
extends BaseSpatialVisualModel {
    public ScienceGoalSpatialVisualModel(Object object, FieldSetupModel fieldSetupModel) {
        super(object, fieldSetupModel);
        this.visualModelHelper = new VisualModelHelperForTargetParameters(this);
        this.configureFormChangeListener();
    }

    @Override
    public FieldSetupModel getFormModel() {
        return (FieldSetupModel)this.formModel;
    }

    @Override
    public VisualModelHelperForTargetParameters getVisualModelHelper() {
        return (VisualModelHelperForTargetParameters)super.getVisualModelHelper();
    }

    @Override
    public SkyCoordsModel getSourceCoordinatesModel() {
        return this.getFormModel().getTargetParametersModel().getSourceCoordinatesModel();
    }

    @Override
    public PointingPatternModel getPointingPatternModel() {
        return this.getFormModel().getTargetParametersModel().getFieldModel().getPointingPatternModel();
    }

    @Override
    public RectangleModel getRectanglePatternModel() {
        return this.getFormModel().getTargetParametersModel().getFieldModel().getRectangleModel();
    }

    @Override
    protected void configureFormChangeListener() {
        this.configureTargetParametersChangeListener();
        super.configureFormChangeListener();
    }

    private void configureTargetParametersChangeListener() {
        this.getFormModel().addTargetParametersSelectionChangeListener(changeEvent -> {
            TargetParameters targetParameters = this.getFormModel().getTargetParametersModel().getTargetParameters();
            this.getSpatialVisualParametersModel().setonlyDocument(targetParameters.getSpatialVisualParameters());
            this.publishVisual();
        });
    }

    @Override
    protected ModelChangeSubscriber getRectangleChangeListener() {
        ModelChangeSubscriber modelChangeSubscriber = new ModelChangeSubscriber(){
            private boolean isTimerActive = false;

            @Override
            public void modelChanged(Model model, FieldID fieldID, Object object) {
                if (!this.isTimerActive) {
                    this.isTimerActive = true;
                    Timer timer = new Timer(100, actionEvent -> {
                        this.isTimerActive = false;
                        OverlayPointingMapperModel overlayPointingMapperModel = ScienceGoalSpatialVisualModel.this.visualModelHelper.getRoiMapperModel().getOverlayPointingMapperModel();
                        RectangleModel rectangleModel = ScienceGoalSpatialVisualModel.this.getRectanglePatternModel();
                        if ((model == rectangleModel.getCoordsModel() || model == rectangleModel.getSpacingModel() || model == rectangleModel.getLongModel() || model == rectangleModel.getShortModel() || model == rectangleModel.getPALongModel()) && overlayPointingMapperModel != null) {
                            try {
                                overlayPointingMapperModel.initialize();
                                overlayPointingMapperModel.configurePointingPattern();
                                ScienceGoalSpatialVisualModel.this.visualModelHelper.getRoiMapperModel().deleteRectangleRoi((RectanglePatternI)rectangleModel.getDocument());
                            }
                            catch (ShowPointingsException showPointingsException) {
                                // empty catch block
                            }
                        }
                        ScienceGoalSpatialVisualModel.this.visualModelHelper.getSDRoiMapperModel().publish();
                        ScienceGoalSpatialVisualModel.this.visualModelHelper.getRoiMapperModel().publish();
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        };
        return modelChangeSubscriber;
    }
}

