/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.Source;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.SpatialDocument;
import alma.obsprep.bo.annotations.SpatialPartOfSpatialDocument;
import alma.obsprep.bo.annotations.TargetContext;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SourceProperty;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.FieldSourceEditor;
import alma.obsprep.ot.editors.schedblock.NameResolver;
import alma.obsprep.ot.editors.spatialvisual.SpatialPartModel;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.schedblock.CrossPatternModel;
import alma.obsprep.ot.models.schedblock.FieldPatternModel;
import alma.obsprep.ot.models.schedblock.PointingPatternModel;
import alma.obsprep.ot.models.schedblock.RectanglePatternModel;
import alma.obsprep.ot.models.schedblock.ReferenceModel;
import alma.obsprep.ot.models.schedblock.SourcePropertiesTableModel;
import alma.obsprep.ot.models.schedblock.UsedByTargetModel;
import alma.obsprep.ot.models.sciencegoals.ProperMotionModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.VelocityModel;
import alma.obsprep.services.experts.CalibratorExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.TextUtils;
import alma.obsprep.util.astro.Resolver;
import alma.valuetypes.Angle;
import alma.valuetypes.AngularVelocity;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Magnitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class FieldSourceModel
extends ProperMotionModel
implements SpatialPartModel {
    private static final String QUERY_STRING = "query";
    public static final FieldID sourceVelocitySystemFID = new FieldID("sourceVelocitySystemFID");
    public static final FieldID sourceVelocityValueFID = new FieldID("sourceVelocityValueFID");
    public static final FieldID sourceVelocityUnitsFID = new FieldID("sourceVelocityUnitsFID");
    public static final FieldID sourceVelocityDopplerCalcTypeFID = new FieldID("sourceVelocityDopplerCalcTypeFID");
    public static final FieldID sourceVelocityRedshiftFID = new FieldID("sourceVelocityRedshiftFID");
    private UsedByTargetModel usedByTargetModel = null;
    private ReferenceModel referenceModel = null;
    private ValueUnitPairModel integrationTimeModel = null;
    private ValueUnitPairModel cycleTimeModel = null;
    protected SourcePropertiesTableModel sourcePropertiesTableModel = null;
    private FieldPatternModel fieldPatternModel = null;
    private final CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(null);
    private final CalibratorExpertController calibratorExpertController = new CalibratorExpertController();
    private final NameResolver nameResolver;
    private TargetContext context;

    public FieldSourceModel(Object object2) {
        super(object2);
        this.usedByTargetModel = new UsedByTargetModel(null);
        this.sourceCoordinatesModel = new SkyCoordsModel(null);
        this.sourceVelocityModel = new VelocityModel(null, sourceVelocityValueFID, sourceVelocityUnitsFID, sourceVelocitySystemFID, sourceVelocityDopplerCalcTypeFID, sourceVelocityRedshiftFID);
        this.referenceModel = new ReferenceModel(null);
        this.integrationTimeModel = new ValueUnitPairModel();
        this.cycleTimeModel = new ValueUnitPairModel();
        this.sourcePropertiesTableModel = new SourcePropertiesTableModel(null);
        this.fieldPatternModel = new FieldPatternModel(null);
        this.registerSubModel(this.sourceCoordinatesModel);
        this.registerSubModel(this.sourceVelocityModel);
        this.registerSubModel(this.referenceModel);
        this.registerSubModel(this.integrationTimeModel);
        this.registerSubModel(this.cycleTimeModel);
        this.registerSubModel(this.fieldPatternModel);
        this.registerSubModel(this.calibratorExpertModel);
        this.calibratorExpertModel.subscribe(this.calibratorExpertController);
        this.sourceCoordinatesModel.subscribe((Model model, FieldID fieldID, Object object) -> {
            if (fieldID == SkyCoordsModel.FID_SYS) {
                this.getPointingPatternModel().originCoordinatesSystemUpdated();
            }
        });
        this.nameResolver = new NameResolver();
        this.setDocument(object2);
    }

    public FieldSource getFieldSource() {
        FieldSource fieldSource;
        if (this.document == null) {
            return null;
        }
        try {
            fieldSource = (FieldSource)((SpatialDocument)this.document).getSpatialPartOfSpatialDocument();
        }
        catch (ClassCastException classCastException) {
            Log.logger((Object)this).warning("Unexpected document : " + this.document.getClass().getSimpleName());
            return null;
        }
        return fieldSource;
    }

    public PointingPatternModel getPointingPatternModel() {
        return this.getFieldPatternModel().getPointingPatternModel();
    }

    public CrossPatternModel getCrossPatternModel() {
        return this.getFieldPatternModel().getCrossPatternModel();
    }

    public RectanglePatternModel getRectanglePatternModel() {
        return this.getFieldPatternModel().getRectanglePatternModel();
    }

    @Override
    public void publish() {
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource == null) {
            return;
        }
        this.getSourceCoordinatesModel().publish();
        this.getSourceVelocityModel().publish();
        this.getParallaxModel().publish();
        this.publish(FieldSourceEditor.SOURCENAME_FID, fieldSource.getSourceName());
        boolean bl = fieldSource.getIsQuery();
        this.publish(FieldSourceEditor.USE_QUERY_FID, bl);
        this.getCalibratorExpertModel().publish();
        this.publish(FieldSourceEditor.FIELDSOURCENAME_FID, fieldSource.getName());
        this.publish(FieldSourceEditor.SOLARSYSTEMOBJECT_FID, fieldSource.getSolarSystemObject());
        this.publish(FieldSourceEditor.SOURCEEPHEMERIS_FID, fieldSource.getSourceEphemeris());
        this.publish(sourceVelocitySystemFID, fieldSource.getSourceVelocity().getReferenceSystem());
        this.publish(FieldSourceEditor.NONSIDEREAL_FID, fieldSource.getNonSiderealMotion());
        Magnitude magnitude = fieldSource.getVisibleMagnitudeOrNull();
        String string = magnitude == null ? "" : TextUtils.format(magnitude.getValue(), 0, 3);
        this.publish(FieldSourceEditor.VISIBLEMAGNITUDE_FID, string);
        this.publish(FieldSourceEditor.REFERENCE_USED_FID, fieldSource.getReferenceCount() > 0);
        this.getPmRAModel().publish();
        this.getPmDecModel().publish();
        this.getReferenceModel().publish();
        this.getIntegrationTimeModel().publish();
        this.getCycleTimeModel().publish();
        this.getFieldPatternModel().publish();
        this.getFieldPatternModel().updateBeamsizeFields();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource == null) {
            return object;
        }
        String string = object.toString();
        if (fieldID.equals(FieldSourceEditor.USE_QUERY_FID)) {
            if (!(object instanceof Boolean)) throw new AssertionError((Object)"Use query checkbox is publishing non-booleans");
            Boolean bl = (Boolean)object;
            fieldSource.setIsQuery(bl);
            if (bl.booleanValue()) {
                Object object2;
                QuerySource querySource = fieldSource.gettrueQuerySource();
                if (querySource == null) {
                    if (fieldSource.getPreviousQuerySource() != null) {
                        querySource = fieldSource.getPreviousQuerySource();
                        this.restoreDefaultQueryCoordinates(fieldSource, querySource);
                    } else {
                        querySource = fieldSource.getQuerySource();
                        object2 = fieldSource.getSourceCoordinates().deepCopy();
                        querySource.setQueryCenter((SkyCoordinates)object2);
                        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
                        querySource.setMaxSources(40);
                        BusinessObject businessObject = fieldSource.getParent();
                        if (!(businessObject instanceof SchedBlock)) throw new AssertionError((Object)"Most unexpected. FieldSource parent is not a SchedBlock");
                        querySource.setSearchFrequenciesFromSB((SchedBlock)businessObject);
                    }
                }
                fieldSource.setQuerySource(querySource);
                if (!fieldSource.getSourceName().equals(QUERY_STRING)) {
                    fieldSource.setPreviousNonQuerySourceName(fieldSource.getSourceName());
                }
                fieldSource.setSourceName(QUERY_STRING);
                this.publish(FieldSourceEditor.SOURCENAME_FID, fieldSource.getSourceName());
                object2 = new QuerySourceAdapter(querySource);
                this.calibratorExpertModel.setDocument(object2);
                return object;
            } else {
                String string2;
                if (fieldSource.gettrueQuerySource() != null) {
                    fieldSource.setPreviousQuerySource((QuerySource)fieldSource.getQuerySource().deepCopy());
                }
                if (!StringUtils.isEmpty((CharSequence)(string2 = fieldSource.getPreviousNonQuerySourceName()))) {
                    fieldSource.setSourceName(!fieldSource.getSourceName().equals(QUERY_STRING) ? string2 : "");
                    this.publish(FieldSourceEditor.SOURCENAME_FID, fieldSource.getSourceName());
                }
                fieldSource.setQuerySource(null);
                this.calibratorExpertModel.setDocument(null);
            }
            return object;
        } else if (fieldID.equals(FieldSourceEditor.FIELDSOURCENAME_FID)) {
            fieldSource.setName(string);
            return object;
        } else if (fieldID.equals(FieldSourceEditor.SOURCENAME_FID)) {
            fieldSource.setSourceName(string);
            return object;
        } else if (fieldID.equals(FieldSourceEditor.SOLARSYSTEMOBJECT_FID)) {
            fieldSource.setSolarSystemObject(string);
            this.updateFieldSourceWithNonSiderealData();
            return object;
        } else if (fieldID.equals(FieldSourceEditor.SOURCEEPHEMERIS_FID)) {
            fieldSource.setSourceEphemeris(string);
            return object;
        } else if (fieldID.equals(sourceVelocitySystemFID)) {
            fieldSource.getSourceVelocity().setReferenceSystem(string);
            return object;
        } else if (fieldID.equals(FieldSourceEditor.NONSIDEREAL_FID)) {
            Boolean bl = Boolean.valueOf(string);
            fieldSource.setNonSiderealMotion(bl);
            this.updateFieldSourceWithNonSiderealData();
            return object;
        } else if (fieldID.equals(FieldSourceEditor.VISIBLEMAGNITUDE_FID)) {
            Double d = Double.parseDouble((String)object);
            fieldSource.setVisibleMagnitude(d);
            return object;
        } else if (fieldID.equals(FieldSourceEditor.RESOLVE_FID)) {
            this.resolveName();
            return object;
        } else if (fieldID.equals(FieldSourceEditor.REFERENCE_USED_FID)) {
            boolean bl = (Boolean)object;
            if (bl) {
                fieldSource.restoreReferences();
            } else {
                fieldSource.saveReferences();
                fieldSource.clearReference();
            }
            this.getReferenceModel().publish();
            return object;
        } else {
            if (!FieldSourceEditor.FIXED_CALIBRATOR_SELECTED.equals(fieldID)) return object;
            if (!(object instanceof Measurement)) {
                throw new IllegalArgumentException("Expected Measurement to be published but got " + object.getClass().getName());
            }
            Measurement measurement = (Measurement)object;
            Integer n = measurement.getSourceId();
            Source source = null;
            if (n != null) {
                source = CalibratorExpert.getInstance().getSource(n);
            }
            String string3 = CalibratorExpert.findJ2000NameOrDefault(measurement.getNames());
            if (source != null) {
                this.setTargetFromSource(source, measurement);
                fieldSource.setSourceName(string3);
                fieldSource.setPreviousNonQuerySourceName(string3);
            } else {
                fieldSource.setSourceName(string3);
                Double d = measurement.getRa();
                Double d2 = measurement.getDec();
                fieldSource.getSourceCoordinates().setAbsoluteCoordinatesInDegInSystem(d, d2, SkyCoordinates.SYSTEM_ICRS);
                fieldSource.clearSourceProperty();
                SourceProperty sourceProperty = SourceProperty.createSourceProperty();
                Frequency frequency = Frequency.createFrequency((double)measurement.getFrequency(), (String)Frequency.UNIT_HZ).convertToFriendlyUnit();
                sourceProperty.setSourceFrequency(frequency);
                sourceProperty.setSourceFluxI(Flux.createFlux((double)measurement.getFlux(), (String)Flux.UNIT_JY));
                fieldSource.addSourceProperty(sourceProperty);
                fieldSource.getSourceVelocity().setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
            }
            fieldSource.setIsQuery(false);
            this.publish();
        }
        return object;
    }

    private void restoreDefaultQueryCoordinates(@NonNull FieldSource fieldSource, @NonNull QuerySource querySource) {
        if (fieldSource == null) {
            throw new NullPointerException("fieldSource is marked non-null but is null");
        }
        if (querySource == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        SchedBlock schedBlock = (SchedBlock)fieldSource.getParent();
        if (schedBlock != null) {
            querySource.setQueryCenter(schedBlock.getSchedulingConstraints().getRepresentativeCoordinates().deepCopy());
        }
    }

    private void setTargetFromSource(@NonNull Source source, @NonNull Measurement measurement) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (measurement == null) {
            throw new NullPointerException("userSelectedMeasurement is marked non-null but is null");
        }
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource != null && source != null) {
            fieldSource.setSourceName(source.getFormattedName());
            fieldSource.getSourceCoordinates().setAbsoluteCoordinatesInDegInSystem(measurement.getRa(), measurement.getDec(), SkyCoordinates.SYSTEM_ICRS);
            fieldSource.getSourceVelocity().setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
            fieldSource.clearSourceProperty();
            for (Measurement measurement2 : source.getMeasurements()) {
                SourceProperty sourceProperty = SourceProperty.createSourceProperty();
                Frequency frequency = Frequency.createFrequency((double)measurement2.getFrequency(), (String)Frequency.UNIT_HZ).convertToFriendlyUnit();
                sourceProperty.setSourceFrequency(frequency);
                sourceProperty.setSourceFluxI(Flux.createFlux((double)measurement2.getFlux(), (String)Flux.UNIT_JY));
                fieldSource.addSourceProperty(sourceProperty);
            }
        }
    }

    private void updateFieldSourceWithNonSiderealData() {
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource == null) {
            return;
        }
        boolean bl = fieldSource.getNonSiderealMotion();
        if (bl) {
            String string = fieldSource.getSolarSystemObject();
            if (string != FieldSource.SOLARSYSTEMOBJECT_EPHEMERIS && string != FieldSource.SOLARSYSTEMOBJECT_SUN) {
                fieldSource.setSourceName(string);
                this.publish(FieldSourceEditor.SOURCENAME_FID, string);
            } else {
                fieldSource.initialiseFieldSourceAttributesWithEphemerisData(Optional.empty());
                this.publish(FieldSourceEditor.SOURCENAME_FID, fieldSource.getSourceName());
                this.sourceCoordinatesModel.publish();
            }
            fieldSource.getSourceVelocity().setReferenceSystem(Velocity.REFERENCESYSTEM_TOPO);
            this.sourceVelocityModel.publish();
        }
    }

    public void resolveName() {
        Object object = this.nameResolver.resolve(this.getFieldSource());
        if (object instanceof Resolver) {
            Resolver resolver = (Resolver)object;
            this.publish();
            this.sourceCoordinatesModel.publish(SkyCoordsModel.FID_RESOLVEDBY, resolver.getNameServer());
            ObservingToolGui observingToolGui = ObservingToolController.getMyInstance().getGui();
            if (observingToolGui != null) {
                observingToolGui.addInformationMessage(this.nameResolver.getFeedback());
            }
        }
    }

    @Override
    public void setonlyDocument(Object object) {
        FieldPattern fieldPattern;
        Object object2;
        super.setonlyDocument(object);
        if (object == null) {
            return;
        }
        try {
            this.setTargetContext((TargetContext)object);
        }
        catch (ClassCastException classCastException) {
            Log.logger((Object)this).warning("Unexpected document : " + object.getClass());
            return;
        }
        if (object instanceof Target) {
            this.document = ((Target)object).getFieldSource();
        } else if (object instanceof FieldSource) {
            this.document = object;
        } else {
            Log.logger((Object)this).warning("Unexpected document : " + object.getClass());
        }
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource == null) {
            return;
        }
        QuerySource querySource = fieldSource.gettrueQuerySource();
        if (querySource != null) {
            object2 = new QuerySourceAdapter(querySource);
            this.calibratorExpertModel.setDocument(object2);
        }
        this.getUsedByTargetModel().setDocument(fieldSource, this.isTargetContext());
        object2 = this.getFieldSource();
        AngularVelocity angularVelocity = object2.getPMRA();
        this.getPmRAModel().setonlyDocument((Object)angularVelocity);
        angularVelocity = object2.getPMDec();
        this.getPmDecModel().setonlyDocument((Object)angularVelocity);
        SkyCoordinates skyCoordinates = object2.getSourceCoordinates();
        this.getSourceCoordinatesModel().setonlyDocument(skyCoordinates);
        Velocity velocity = object2.getSourceVelocity();
        this.getSourceVelocityModel().setonlyDocument((Object)velocity);
        Angle angle = this.getFieldSource().getParallax();
        this.getParallaxModel().setonlyDocument((Object)angle);
        this.getReferenceModel().setonlyDocument(this.getFieldSource());
        SourcePropertiesTableModel sourcePropertiesTableModel = this.getSourcePropertiesTableModel();
        if (sourcePropertiesTableModel != null) {
            sourcePropertiesTableModel.setFieldSource(this.getFieldSource());
            sourcePropertiesTableModel.fireTableDataChanged();
        }
        if ((fieldPattern = this.getFieldSource().getFieldPattern()) == null) {
            fieldPattern = this.getFieldSource().setDefaultFieldPattern();
        }
        this.getFieldPatternModel().setonlyDocument(fieldPattern);
    }

    @Override
    public void setDocument(Object object) {
        this.setonlyDocument(object);
        this.publish();
        this.updateFieldSourceWithNonSiderealData();
    }

    private void setTargetContext(TargetContext targetContext) {
        this.context = targetContext;
    }

    public boolean isTargetContext() {
        return this.context instanceof Target;
    }

    public void addSourceProperty(int n) {
        SourceProperty sourceProperty = SourceProperty.createSourceProperty();
        if (n == -1) {
            n = this.getSourcePropertiesCount();
        }
        this.getFieldSource().addSourceProperty(n, sourceProperty);
        this.getSourcePropertiesTableModel().fireTableRowsInserted(n, n);
    }

    public void deleteSourceProperty(int n) {
        if (n != -1) {
            SourceProperty sourceProperty = this.getFieldSource().getSourceProperty(n);
            this.getFieldSource().removeSourceProperty(sourceProperty);
            this.getSourcePropertiesTableModel().fireTableRowsDeleted(n, n);
        }
    }

    public int getSourcePropertiesCount() {
        SourcePropertiesTableModel sourcePropertiesTableModel = this.getSourcePropertiesTableModel();
        if (sourcePropertiesTableModel == null) {
            return 0;
        }
        return this.getSourcePropertiesTableModel().getRowCount();
    }

    @Override
    public SpatialPartOfSpatialDocument getSpatialPart() {
        return (SpatialPartOfSpatialDocument)this.getDocument();
    }

    public SkyCoordinates getSourceCoordinates() {
        FieldSource fieldSource = this.getFieldSource();
        return fieldSource == null ? null : fieldSource.getSourceCoordinates();
    }

    public QuerySource getQuerySource() {
        FieldSource fieldSource = this.getFieldSource();
        QuerySource querySource = fieldSource.getQuerySource();
        return querySource;
    }

    public void setQuerySource(QuerySource querySource) {
        FieldSource fieldSource = this.getFieldSource();
        fieldSource.setQuerySource(querySource);
        if (querySource == null) {
            fieldSource.setIsQuery(false);
        } else {
            fieldSource.setIsQuery(true);
        }
        this.publish();
    }

    public UsedByTargetModel getUsedByTargetModel() {
        return this.usedByTargetModel;
    }

    public ReferenceModel getReferenceModel() {
        return this.referenceModel;
    }

    public ValueUnitPairModel getIntegrationTimeModel() {
        return this.integrationTimeModel;
    }

    public ValueUnitPairModel getCycleTimeModel() {
        return this.cycleTimeModel;
    }

    public SourcePropertiesTableModel getSourcePropertiesTableModel() {
        return this.sourcePropertiesTableModel;
    }

    public FieldPatternModel getFieldPatternModel() {
        return this.fieldPatternModel;
    }

    public CalibratorExpertModel getCalibratorExpertModel() {
        return this.calibratorExpertModel;
    }
}

