/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsUnit;
import alma.obsprep.bo.obsproject.Preconditions;
import alma.obsprep.bo.obsproject.WeatherConstraints;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedBlockControl;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.bo.schedblock.data.SchedBlockData;
import alma.obsprep.defaulters.CircularDependencyException;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.misc.ExpertParametersEditor;
import alma.obsprep.ot.models.misc.ExpertParametersModel;
import alma.obsprep.ot.models.obsproject.ObsUnitModel;
import alma.obsprep.ot.models.schedblock.SchedBlockObservingGroupModel;
import alma.obsprep.ot.models.schedblock.SchedBlockTemporalTabbedModel;
import alma.obsprep.ot.models.valuetypes.SkyCoordsModel;
import alma.obsprep.ot.models.valuetypes.UserUnitValueUnitPairModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.obsprep.ot.valdef.obsproject.ControlBlockDefaulter;
import alma.obsprep.ot.valdef.schedblock.SchedBlockDefaulter;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;
import org.apache.commons.lang3.StringUtils;

public class SchedBlockModel
extends ObsUnitModel {
    private ValueUnitPairModel sbMaximumTimeModel = new ValueUnitPairModel(null, FieldIDs.sbMaximumTimeValueFID, FieldIDs.sbMaximumTimeUnitsFID);
    private ValueUnitPairModel representativeFrequencyModel = new ValueUnitPairModel(null, FieldIDs.representativeFrequencyValueFID, FieldIDs.representativeFrequencyUnitsFID);
    private ValueUnitPairModel minAcceptableAngResolutionModel = null;
    private ValueUnitPairModel maxAcceptableAngResolutionModel = null;
    private ValueUnitPairModel maxPWVCModel = null;
    private ValueUnitPairModel seeingModel = null;
    private ValueUnitPairModel phaseStabilityModel = null;
    private ValueUnitPairModel maxWindVelocityModel = null;
    private UserUnitValueUnitPairModel minAllowedHaModel = null;
    private UserUnitValueUnitPairModel maxAllowedHaModel = null;
    private ExpertParametersModel expertParametersModel = null;
    private SchedBlockObservingGroupModel schedBlockObservingGroupModel = null;
    private SkyCoordsModel representativeCoordinatesModel = new SkyCoordsModel(null);
    private SchedBlockTemporalTabbedModel schedBlockTemporalTabbedModel = null;
    private SchedBlockDefaulter sbDefaulter = null;
    private ControlBlockDefaulter cbDefaulter = null;
    private ValueUnitPairModel bwForSpectraDynamicRangeModel;

    public SchedBlockModel(SchedBlock schedBlock) {
        super((ObsUnit)((Object)schedBlock));
        this.minAcceptableAngResolutionModel = new ValueUnitPairModel(null, FieldIDs.minAcceptableAngResolutionValueFID, FieldIDs.minAcceptableAngResolutionUnitsFID);
        this.maxAcceptableAngResolutionModel = new ValueUnitPairModel(null, FieldIDs.maxAcceptableAngResolutionValueFID, FieldIDs.maxAcceptableAngResolutionUnitsFID);
        this.maxAcceptableAngResolutionModel = new ValueUnitPairModel(null, FieldIDs.maxAcceptableAngResolutionValueFID, FieldIDs.maxAcceptableAngResolutionUnitsFID);
        this.maxPWVCModel = new ValueUnitPairModel(null, FieldIDs.maxPWVCValueFID, FieldIDs.maxPWVCUnitsFID);
        this.seeingModel = new ValueUnitPairModel(null, FieldIDs.seeingValueFID, FieldIDs.seeingUnitsFID);
        this.phaseStabilityModel = new ValueUnitPairModel(null, FieldIDs.phaseStabilityValueFID, FieldIDs.phaseStabilityUnitsFID);
        this.maxWindVelocityModel = new ValueUnitPairModel(null, FieldIDs.maxWindVelocityValueFID, FieldIDs.maxWindVelocityUnitsFID);
        this.minAllowedHaModel = new UserUnitValueUnitPairModel(null, FieldIDs.minAllowedHaValueFID, FieldIDs.minAllowedHaUnitsFID);
        this.maxAllowedHaModel = new UserUnitValueUnitPairModel(null, FieldIDs.maxAllowedHaValueFID, FieldIDs.maxAllowedHaUnitsFID);
        this.bwForSpectraDynamicRangeModel = new ValueUnitPairModel(null, FieldIDs.bwForSpectraDynamicRangeModelValueFID, FieldIDs.bwForSpectraDynamicRangeModelUnitsFID);
        this.expertParametersModel = new ExpertParametersModel(null);
        this.schedBlockObservingGroupModel = new SchedBlockObservingGroupModel(null);
        this.schedBlockTemporalTabbedModel = new SchedBlockTemporalTabbedModel(null);
    }

    private SchedBlock getSchedBlock() {
        return (SchedBlock)this.getDocument();
    }

    public ValueUnitPairModel getSBMaximumTimeModel() {
        return this.sbMaximumTimeModel;
    }

    @Override
    public void publish() {
        SchedBlock schedBlock = this.getSchedBlock();
        if (schedBlock == null) {
            return;
        }
        super.publish();
        Preconditions preconditions = schedBlock.getPreconditions();
        if (preconditions == null) {
            Log.logger(SchedBlockModel.class).warning("No Preconditions in ObsUnit");
            return;
        }
        WeatherConstraints weatherConstraints = preconditions.getWeatherConstraints();
        if (weatherConstraints == null) {
            Log.logger(SchedBlockModel.class).warning("No WeatherConstraints in ObsUnit.Preconditions");
            return;
        }
        this.publish(FieldIDs.entityIDFID, schedBlock.getEntityID());
        this.publish(FieldIDs.standardModeFID, schedBlock.getStandardMode());
        this.publish(FieldIDs.modeNameFID, schedBlock.getModeName());
        if (schedBlock.getModeType().length() == 0) {
            schedBlock.setModeType(this.getModeTypeList()[0]);
        }
        this.publish(FieldIDs.modeTypeFID, schedBlock.getModeType());
        this.publish(FieldIDs.baselineCalFID, preconditions.getBaselineCalValid());
        this.publish(FieldIDs.polarisationFID, preconditions.getPolarizationCalValid());
        this.publish(FieldIDs.obsProcScriptFID, schedBlock.getObsProcedure().getObsProcScript());
        this.publish(FieldIDs.repeatCountFID, String.valueOf(schedBlock.getSchedBlockControl().getExecutionCount()));
        this.publish(FieldIDs.indefiniteRepeatFID, schedBlock.getSchedBlockControl().getIndefiniteRepeat());
        this.getSBMaximumTimeModel().publish();
        this.publish(FieldIDs.runQuicklookFID, schedBlock.getSchedBlockControl().getRunQuicklook());
        this.publish(FieldIDs.requiresTPAntennas, schedBlock.getSchedulingConstraints().getSbRequiresTPAntennas());
        String string = null;
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        Target target = schedulingConstraints.getRepresentativeTarget();
        if (target != null) {
            string = target.toTreeString(0, true, false);
        }
        this.publish(FieldIDs.representativeTargetFID, string);
        this.publish(FieldIDs.representativeBandFID, schedulingConstraints.getRepresentativeReceiverBand());
        this.getRepresentativeFrequencyModel().publish();
        this.getRepresentativeCoordinatesModel().publish();
        this.getBwForSpectraDynamicRangeModel().publish();
        this.getMinAcceptableAngResolutionModel().publish();
        this.getMaxAcceptableAngResolutionModel().publish();
        this.publish(FieldIDs.imagingDynamicRangeFID, String.valueOf(schedulingConstraints.getDynamicRange()));
        this.publish(FieldIDs.spectralDynamicRangeFID, String.valueOf(schedulingConstraints.getSpectralDynamicRange()));
        this.getMaxPWVCModel().publish();
        this.getSeeingModel().publish();
        this.getPhaseStabilityModel().publish();
        this.getMaxWindVelocityModel().publish();
        this.getMinAllowedHaModel().publish();
        this.getMaxAllowedHaModel().publish();
        this.publish(ExpertParametersEditor.KEYWORDVALUE_TABLE_FID, this.getSchedBlock().getExpertParameterList());
        if (this.getExpertParametersModel() != null) {
            this.getExpertParametersModel().publish();
        }
        this.publish(FieldIDs.desiredAngularResolution, (Object)schedulingConstraints.getScienceGoalDesiredResolution());
        this.publish(FieldIDs.desiredLAS, (Object)schedulingConstraints.getScienceGoalLargestAngularScale());
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : schedulingConstraints.getNominalConfiguration()) {
            stringBuilder.append(string2 + ",");
        }
        this.publish(FieldIDs.nominalConfiguration, StringUtils.chomp((String)stringBuilder.toString(), (String)","));
        this.publish(FieldIDs.maxAllowedBeamAxialRatio, schedulingConstraints.getMaxAllowedBeamAxialRatio());
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        SchedBlock schedBlock = this.getSchedBlock();
        Preconditions preconditions = schedBlock.getPreconditions();
        SchedBlockControl schedBlockControl = schedBlock.getSchedBlockControl();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        if (!fieldID.equals(FieldIDs.entityIDFID)) {
            if (fieldID.equals(FieldIDs.standardModeFID)) {
                Boolean bl = Boolean.valueOf(string);
                schedBlock.setStandardMode(bl);
            } else if (fieldID.equals(FieldIDs.modeNameFID)) {
                schedBlock.setModeName(string);
            } else if (fieldID.equals(FieldIDs.modeTypeFID)) {
                schedBlock.setModeType(string);
            } else if (fieldID.equals(FieldIDs.obsProcScriptFID)) {
                schedBlock.getObsProcedure().setObsProcScript(string);
            } else if (fieldID.equals(FieldIDs.repeatCountFID)) {
                schedBlockControl.setExecutionCount(Integer.parseInt(string));
            } else if (fieldID.equals(FieldIDs.indefiniteRepeatFID)) {
                schedBlockControl.setIndefiniteRepeat(Boolean.parseBoolean(string));
            } else if (fieldID.equals(FieldIDs.runQuicklookFID)) {
                schedBlockControl.setRunQuicklook((Boolean)object);
            } else if (fieldID.equals(FieldIDs.imagingDynamicRangeFID)) {
                schedulingConstraints.setDynamicRange(Double.parseDouble(string));
            } else if (fieldID.equals(FieldIDs.spectralDynamicRangeFID)) {
                schedulingConstraints.setSpectralDynamicRange(Double.parseDouble(string));
            } else if (fieldID.equals(FieldIDs.baselineCalFID)) {
                preconditions.setBaselineCalValid((Boolean)object);
            } else if (fieldID.equals(FieldIDs.polarisationFID)) {
                preconditions.setPolarizationCalValid((Boolean)object);
            } else if (fieldID.equals(FieldIDs.maxAllowedBeamAxialRatio)) {
                try {
                    double d = Double.parseDouble((String)object);
                    schedulingConstraints.setMaxAllowedBeamAxialRatio(d);
                }
                catch (NullPointerException | NumberFormatException runtimeException) {}
            } else {
                if (fieldID == FieldIDs.representativeBandFID) {
                    schedulingConstraints.setRepresentativeReceiverBand(string);
                    return string;
                }
                if (fieldID.equals(FieldIDs.requiresTPAntennas)) {
                    schedulingConstraints.setSbRequiresTPAntennas((Boolean)object);
                } else {
                    super.update(editor, fieldID, object);
                }
            }
        }
        return object;
    }

    @Override
    public void setDocument(Object object) {
        super.setDocument(object);
        SchedBlock schedBlock = this.getSchedBlock();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        Time time = schedBlock.getSchedBlockControl().getSBMaximumTime();
        this.getSBMaximumTimeModel().setDocument(time);
        Frequency frequency = schedulingConstraints.getRepresentativeFrequency();
        this.getRepresentativeFrequencyModel().setDocument((Object)frequency);
        SkyCoordinates skyCoordinates = schedulingConstraints.getRepresentativeCoordinates();
        this.getRepresentativeCoordinatesModel().setDocument(skyCoordinates);
        this.getBwForSpectraDynamicRangeModel().setDocument((Object)schedulingConstraints.getSpectralDynamicRangeBandwidth());
        Angle angle = schedulingConstraints.getMinAcceptableAngResolution();
        this.getMinAcceptableAngResolutionModel().setDocument((Object)angle);
        angle = schedulingConstraints.getMaxAcceptableAngResolution();
        this.getMaxAcceptableAngResolutionModel().setDocument((Object)angle);
        WeatherConstraints weatherConstraints = schedBlock.getPreconditions().getWeatherConstraints();
        this.getMaxPWVCModel().setDocument((Object)weatherConstraints.getMaxPWVC());
        this.getSeeingModel().setDocument((Object)weatherConstraints.getSeeing());
        this.getPhaseStabilityModel().setDocument((Object)weatherConstraints.getPhaseStability());
        this.getMaxWindVelocityModel().setDocument((Object)weatherConstraints.getMaxWindVelocity());
        UserAngle userAngle = schedBlock.getPreconditions().getMinAllowedHA();
        userAngle.convertToUserUnit(UserAngle.USERUNIT_H);
        this.getMinAllowedHaModel().setDocument(userAngle);
        userAngle = schedBlock.getPreconditions().getMaxAllowedHA();
        userAngle.convertToUserUnit(UserAngle.USERUNIT_H);
        this.getMaxAllowedHaModel().setDocument(userAngle);
        this.getExpertParametersModel().setDocument(schedBlock);
        this.getSchedBlockObservingGroupModel().setDocument(schedBlock);
        this.getSchedBlockTemporalTabbedModel().setDocument(schedBlock);
        this.setupDefaulters();
    }

    public String[] getModeNameList() {
        ObservingModeExpert observingModeExpert = ObservingModeExpert.getInstance();
        String[] stringArray = observingModeExpert.getAvailableModes();
        return stringArray;
    }

    public String[] getModeTypeList() {
        return SchedBlockData.getKnownModeTypeList();
    }

    public ReceiverBand getRepresentativeReceiverBand() {
        SchedBlock schedBlock = this.getSchedBlock();
        if (null == schedBlock) {
            return null;
        }
        return ReceiverBand.getReceiverBand(schedBlock.getSchedulingConstraints().getRepresentativeReceiverBand());
    }

    private void setupDefaulters() {
        SchedBlock schedBlock = this.getSchedBlock();
        if (this.sbDefaulter != null) {
            this.sbDefaulter.deactivate();
        }
        try {
            this.sbDefaulter = new SchedBlockDefaulter(schedBlock, this);
        }
        catch (CircularDependencyException circularDependencyException) {
            circularDependencyException.printStackTrace();
            GUIUtilities.error(null, "Failure setting up model defaults.", circularDependencyException);
        }
        if (this.cbDefaulter != null) {
            this.cbDefaulter.deactivate();
        }
        try {
            this.cbDefaulter = new ControlBlockDefaulter(schedBlock, this);
        }
        catch (CircularDependencyException circularDependencyException) {
            circularDependencyException.printStackTrace();
            GUIUtilities.error(null, "Failure setting up model defaults.", circularDependencyException);
        }
    }

    public ValueUnitPairModel getRepresentativeFrequencyModel() {
        return this.representativeFrequencyModel;
    }

    public ValueUnitPairModel getMinAcceptableAngResolutionModel() {
        return this.minAcceptableAngResolutionModel;
    }

    public ValueUnitPairModel getMaxAcceptableAngResolutionModel() {
        return this.maxAcceptableAngResolutionModel;
    }

    public ValueUnitPairModel getMaxPWVCModel() {
        return this.maxPWVCModel;
    }

    public ValueUnitPairModel getSeeingModel() {
        return this.seeingModel;
    }

    public ValueUnitPairModel getPhaseStabilityModel() {
        return this.phaseStabilityModel;
    }

    public ValueUnitPairModel getMaxWindVelocityModel() {
        return this.maxWindVelocityModel;
    }

    public UserUnitValueUnitPairModel getMinAllowedHaModel() {
        return this.minAllowedHaModel;
    }

    public UserUnitValueUnitPairModel getMaxAllowedHaModel() {
        return this.maxAllowedHaModel;
    }

    public ExpertParametersModel getExpertParametersModel() {
        return this.expertParametersModel;
    }

    public SchedBlockObservingGroupModel getSchedBlockObservingGroupModel() {
        return this.schedBlockObservingGroupModel;
    }

    public SkyCoordsModel getRepresentativeCoordinatesModel() {
        return this.representativeCoordinatesModel;
    }

    public SchedBlockTemporalTabbedModel getSchedBlockTemporalTabbedModel() {
        return this.schedBlockTemporalTabbedModel;
    }

    public ValueUnitPairModel getBwForSpectraDynamicRangeModel() {
        return this.bwForSpectraDynamicRangeModel;
    }
}

