/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.sciencegoals;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.CorrBits;
import alma.obsprep.bo.enumerations.CorrFraction;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.AbstractSpectralLine;
import alma.obsprep.bo.obsproject.ExpectedSpectralLine;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.OverlaidSpectralLine;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.sciencegoals.SfiSpectralSetupEditor;
import alma.obsprep.ot.editors.sciencegoals.SpectralWindowGroupEditor;
import alma.obsprep.ot.models.sciencegoals.CorrFractionFinder;
import alma.obsprep.ot.models.sciencegoals.MultiResolutionElementTableModel;
import alma.obsprep.ot.models.sciencegoals.WalshSwitchControllerInterface;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.NonNull;

public class SpectralWindowGroupModel
extends Model {
    private WalshSwitchControllerInterface walshSwitchController = null;
    public static final FieldID REPRESENTATIVE_WINDOW_MODIFIED = new FieldID("SpectralWindowGroup.ReprWindowModified");
    public static final FieldID REPRESENTATIVE_WINDOW_SELECTED = new FieldID("SpectralWindowGroup.ReprWindowSelected");
    public static final int MAX_WINDOWS_PER_BASEBAND = (int)((double)AlmaCapabilities.getInstance().getMaxNumberSw() / 4.0);
    private final MultiResolutionElementTableModel tableModel = new MultiResolutionElementTableModel();
    private final int groupIndex;

    public SpectralWindowGroupModel(SpectralSetupParameters spectralSetupParameters, int n) {
        super(null);
        this.groupIndex = n;
        this.tableModel.addTableModelListener(tableModelEvent -> {
            ScienceSpectralWindow scienceSpectralWindow;
            int n;
            ScienceSpectralWindow[] scienceSpectralWindowArray = this.getScienceSpectralWindows();
            this.getController().modelChanged(SpectralWindowGroupEditor.FID_TABLE, scienceSpectralWindowArray);
            int n2 = tableModelEvent.getColumn();
            if (this.walshSwitchController != null) {
                this.walshSwitchController.setWalshSwitchingUserAvailability();
            }
            if (tableModelEvent.getType() == 0 && n2 > -1 && (n = tableModelEvent.getFirstRow()) < this.tableModel.getRowCount() && (scienceSpectralWindow = this.tableModel.getSpectralWindow(tableModelEvent.getFirstRow())).getRepresentativeWindow()) {
                if (MultiResolutionElementTableModel.ColumnDescriptor.SETREPFREQ.getColumnIndex() == n2) {
                    this.publish(REPRESENTATIVE_WINDOW_SELECTED, scienceSpectralWindow);
                } else {
                    this.publish(REPRESENTATIVE_WINDOW_MODIFIED, scienceSpectralWindow);
                }
            }
        });
        this.setDocument((Object)spectralSetupParameters);
    }

    @Override
    public void setDocument(Object object) {
        this.document = object;
        this.tableModel.setDocument(this.getSpectralSetupParameters(), this.groupIndex);
        this.publish();
    }

    public ScienceSpectralWindow[] getScienceSpectralWindows() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters != null) {
            return this.getSpectralSetupParameters().getScienceSpectralWindowGroup(this.groupIndex);
        }
        return new ScienceSpectralWindow[0];
    }

    public SpectralSetupParameters getSpectralSetupParameters() {
        return (SpectralSetupParameters)((Object)this.document);
    }

    public ScienceSpectralWindow[] getSpectralWindows() {
        if (this.document == null) {
            return new ScienceSpectralWindow[0];
        }
        return this.getSpectralSetupParameters().getScienceSpectralWindowGroup(this.groupIndex);
    }

    public ScienceSpectralWindow[] getSpectralWindowsInOtherGroups() {
        if (this.document == null) {
            return new ScienceSpectralWindow[0];
        }
        ArrayList<ScienceSpectralWindow> arrayList = new ArrayList<ScienceSpectralWindow>();
        for (ScienceSpectralWindow scienceSpectralWindow : this.getSpectralSetupParameters().getScienceSpectralWindow()) {
            if (scienceSpectralWindow.getGroupIndex() == this.groupIndex) continue;
            arrayList.add(scienceSpectralWindow);
        }
        return arrayList.toArray(new ScienceSpectralWindow[arrayList.size()]);
    }

    @Override
    public void publish() {
        this.publish(SpectralWindowGroupEditor.FID_TABLE, this.document);
        this.tableModel.fireTableDataChanged();
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters != null) {
            this.publish(REPRESENTATIVE_WINDOW_MODIFIED, spectralSetupParameters.getRepresentativeSpectralWindow());
            this.publish(SfiSpectralSetupEditor.FID_WALSH_SWITCHING, spectralSetupParameters.getAdvancedSpectralSetup().getSideBandSeparation());
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (SpectralWindowGroupEditor.FID_SELECT_LINES.equals(fieldID)) {
            if (object instanceof List) {
                Object object2;
                int n;
                List list = (List)object;
                if (list.size() > MAX_WINDOWS_PER_BASEBAND) {
                    list = list.subList(0, MAX_WINDOWS_PER_BASEBAND);
                }
                SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
                spectralSetupParameters.setSuspendAdvancedFeedback(true);
                HashMap<UUID, ScienceSpectralWindow> hashMap = new HashMap<UUID, ScienceSpectralWindow>();
                for (ScienceSpectralWindow comparable : this.getScienceSpectralWindows()) {
                    hashMap.put(comparable.getUUID(), comparable);
                }
                Set set = hashMap.keySet();
                ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
                for (SpectralLine spectralLine : list) {
                    UUID uUID = spectralLine.getScienceSpectralWindowUUID();
                    if (uUID == null || !set.contains(uUID)) continue;
                    arrayList.add(spectralLine);
                    hashMap.remove(uUID);
                }
                list.removeAll(arrayList);
                for (ScienceSpectralWindow scienceSpectralWindow : hashMap.values()) {
                    this.deleteWindow(scienceSpectralWindow);
                }
                double d = this.getCorrelatorFraction(arrayList);
                if (d >= 1.0) {
                    n = this.getWindowCount() + list.size();
                    object2 = CorrFractionFinder.getCorrFraction(n);
                } else {
                    object2 = CorrFractionFinder.getCorrFraction(list.size(), d);
                }
                n = this.getWindowCount();
                for (SpectralLine spectralLine : list) {
                    if (n >= MAX_WINDOWS_PER_BASEBAND) continue;
                    ScienceSpectralWindow scienceSpectralWindow = this.addSpectralLine(n++, spectralLine);
                    scienceSpectralWindow.setGroupResourceUse(((CorrFraction)((Object)object2)).getResourceUse());
                }
                spectralSetupParameters.setSuspendAdvancedFeedback(false);
                try {
                    if (spectralSetupParameters.getScienceGoal() != null) {
                        spectralSetupParameters.feedbackAdvancedSetup(spectralSetupParameters.getScienceGoal().getKeyTargetParametersPosition());
                    }
                }
                catch (InvalidGroupIndexException invalidGroupIndexException) {
                    invalidGroupIndexException.printStackTrace();
                }
            }
        } else {
            boolean bl;
            if (fieldID.equals(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX)) {
                this.tableModel.setImageSpectralWindowMode((Boolean)object);
                this.publish();
                return object;
            }
            if (fieldID.equals(SpectralWindowGroupEditor.FID_DISPLAY_IMAGE_TABLE_CHECKBOX_USER_CONTROLLABLE)) {
                this.publish(fieldID, object);
                return object;
            }
            if (fieldID.equals(SfiSpectralSetupEditor.FID_WALSH_SWITCHING) && !(bl = ((Boolean)object).booleanValue())) {
                SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)((Object)this.getDocument());
                for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindowGroup(this.groupIndex)) {
                    scienceSpectralWindow.getAdvancedWindowSetup().setUseImage(false);
                }
            }
        }
        return null;
    }

    private double getCorrelatorFraction(Collection<SpectralLine> collection) {
        int n = 0;
        for (SpectralLine spectralLine : collection) {
            UUID uUID = spectralLine.getScienceSpectralWindowUUID();
            ScienceSpectralWindow scienceSpectralWindow = this.getScienceSpectralWindow(uUID);
            if (scienceSpectralWindow == null) continue;
            n += scienceSpectralWindow.getFraction().getUnits();
        }
        return (double)n / 32.0;
    }

    private ScienceSpectralWindow getScienceSpectralWindow(UUID uUID) {
        for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindows()) {
            if (scienceSpectralWindow.getUUID() != uUID) continue;
            return scienceSpectralWindow;
        }
        return null;
    }

    public ScienceSpectralWindow addSpectralLine(int n, SpectralLine spectralLine) {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return null;
        }
        ScienceSpectralWindow scienceSpectralWindow = this.convertToWindow(spectralLine);
        if (Telescope.getTelescopeSelection() == Telescope.ESALMA && n > 0) {
            ScienceSpectralWindow scienceSpectralWindow2 = spectralSetupParameters.getScienceSpectralWindow(0);
            scienceSpectralWindow.setCorrConfigMode(scienceSpectralWindow2.getCorrConfigMode());
        }
        if (spectralSetupParameters.isWalshSwitching()) {
            scienceSpectralWindow.getAdvancedWindowSetup().setUseImage(true);
        }
        this.addExistingRestFrequenciesToSPW(scienceSpectralWindow, spectralSetupParameters);
        spectralSetupParameters.addScienceSpectralWindow(this.groupIndex, n, scienceSpectralWindow);
        if (VLBIExpert.isScienceGoalLegalVLBISpectralLine(spectralSetupParameters.getScienceGoal())) {
            scienceSpectralWindow.setIsSkyFrequency(true);
        }
        if (this.walshSwitchController != null) {
            this.walshSwitchController.setSPWBandwidthToWalshSwitchingCompatibility();
        }
        return scienceSpectralWindow;
    }

    private void addExistingRestFrequenciesToSPW(@NonNull ScienceSpectralWindow scienceSpectralWindow, @NonNull SpectralSetupParameters spectralSetupParameters) {
        Object object;
        if (scienceSpectralWindow == null) {
            throw new NullPointerException("newWindow is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        Frequency frequency = scienceSpectralWindow.getEffectiveBandwidth().inverseDopplerShifted(spectralSetupParameters.getSourceVelocity());
        FrequencyRange frequencyRange = FrequencyRange.centredOn(scienceSpectralWindow.getCenterFrequency(), frequency);
        Optional<FrequencyRange> optional = spectralSetupParameters.getSPWImageFrequency(scienceSpectralWindow);
        HashSet<String> hashSet = new HashSet<String>();
        for (OverlaidSpectralLine overlaidSpectralLine : spectralSetupParameters.getOverlaidSpectralLine()) {
            if (hashSet.contains(overlaidSpectralLine.getUniqueId())) continue;
            object = null;
            if (frequencyRange.contains(overlaidSpectralLine.getRestFrequency())) {
                object = ExpectedSpectralLine.createNewExpectedLine((AbstractSpectralLine)((Object)overlaidSpectralLine));
                hashSet.add(overlaidSpectralLine.getUniqueId());
            } else if (optional.isPresent() && optional.get().contains(overlaidSpectralLine.getRestFrequency())) {
                object = ExpectedSpectralLine.createNewExpectedLine((AbstractSpectralLine)((Object)overlaidSpectralLine));
                hashSet.add(overlaidSpectralLine.getUniqueId());
            }
            if (object == null) continue;
            scienceSpectralWindow.addExpectedSpectralLine((ExpectedSpectralLine)((Object)object));
        }
        for (ScienceSpectralWindow scienceSpectralWindow2 : spectralSetupParameters.getScienceSpectralWindow()) {
            object = spectralSetupParameters.getSPWImageFrequency(scienceSpectralWindow2);
            for (ExpectedSpectralLine expectedSpectralLine : scienceSpectralWindow2.getExpectedSpectralLine()) {
                if (hashSet.contains(expectedSpectralLine.getUniqueId())) continue;
                ExpectedSpectralLine expectedSpectralLine2 = null;
                if (frequencyRange.contains(expectedSpectralLine.getRestFrequency())) {
                    expectedSpectralLine2 = ExpectedSpectralLine.createNewExpectedLine((AbstractSpectralLine)((Object)expectedSpectralLine));
                    hashSet.add(expectedSpectralLine.getUniqueId());
                } else if (((Optional)object).isPresent() && ((FrequencyRange)((Optional)object).get()).contains(expectedSpectralLine.getRestFrequency())) {
                    expectedSpectralLine2 = ExpectedSpectralLine.createNewExpectedLine((AbstractSpectralLine)((Object)expectedSpectralLine));
                    hashSet.add(expectedSpectralLine.getUniqueId());
                }
                if (expectedSpectralLine2 == null) continue;
                scienceSpectralWindow.addExpectedSpectralLine(expectedSpectralLine2);
            }
        }
    }

    private ScienceSpectralWindow convertToWindow(SpectralLine spectralLine) {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        scienceSpectralWindow.getCenterFrequency().setContentAndUnit((ValueUnitPair)spectralLine.getFrequency());
        scienceSpectralWindow.getCenterFrequency().convertToGHz();
        scienceSpectralWindow.setTransitionName(spectralLine.getTitle());
        Integer n = spectralLine.getLineId();
        if (n != null) {
            scienceSpectralWindow.setSplatalogId(n);
        }
        return scienceSpectralWindow;
    }

    public void deleteWindow(int n) {
        this.deleteWindow(this.getSpectralWindows()[n]);
    }

    public void deleteWindow(ScienceSpectralWindow scienceSpectralWindow) {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        spectralSetupParameters.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow));
    }

    public int getWindowCount() {
        if (this.getSpectralWindows() == null) {
            return 0;
        }
        return this.getSpectralWindows().length;
    }

    public boolean isVLBIConstrainingAddingFurtherSPWsToBaseband() {
        try {
            if (!ObsProposal.isVLBIRelated()) {
                return false;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            return false;
        }
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return false;
        }
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        if (receiverBand != null && ReceiverBand.isReceiverBandInSet(receiverBand, 1, 3) && this.groupIndex == 0) {
            return spectralSetupParameters.getScienceSpectralWindowGroup(this.groupIndex).length > 0;
        }
        return false;
    }

    public boolean is4x4ModeConstrainingAddingFurtherSPWsToBaseband() {
        SpectralSetupParameters spectralSetupParameters = this.getSpectralSetupParameters();
        if (spectralSetupParameters == null) {
            return false;
        }
        ScienceSpectralWindow[] scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindowGroup(this.groupIndex);
        if (scienceSpectralWindowArray == null || scienceSpectralWindowArray.length == 0) {
            return false;
        }
        return Stream.of(scienceSpectralWindowArray).anyMatch(scienceSpectralWindow -> scienceSpectralWindow.getCorrConfigMode() != null && CorrBits.is4x4(scienceSpectralWindow.getCorrConfigMode().getBits()));
    }

    public void setWalshSwitchController(WalshSwitchControllerInterface walshSwitchControllerInterface) {
        this.walshSwitchController = walshSwitchControllerInterface;
    }

    public MultiResolutionElementTableModel getTableModel() {
        return this.tableModel;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }
}

