/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.HashCodeGeneratorInterface;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.data.ObsProjectData;
import alma.obsprep.bo.obsproject.data.ObsUnitData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.services.experts.BackgroundCalibratorDatabaseInteractor;
import alma.obsprep.util.MiscUtils;
import alma.scheduling.projectstatus.StatusBase;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import lombok.NonNull;

public class ValidatorSet {
    public static final AtomicBoolean isValidationCacheUsed = new AtomicBoolean(true);
    private static final int HASH_UNDEFINED = -1;
    private static final long CACHE_PURGE_TIMEOUT = 1800L;
    private static final Stopwatch purgeCacheStopWatch = Stopwatch.createUnstarted();
    private static AtomicInteger obsProposalHashCode = new AtomicInteger(-1);
    private static AtomicInteger obsProjectHashCode = new AtomicInteger(-1);
    private static ConcurrentHashMap<BusinessObject, HashMap<Class<? extends AbstractValidator>, ValidationCacheRecord>> validatedBOCache = new ConcurrentHashMap(2000);
    private final ConcurrentLinkedQueue<Future<?>> validatorThreadCompletionList = new ConcurrentLinkedQueue();
    private ExecutorService fixedThreadPool;
    private final HashMap<String, Set<AbstractValidator>> validatorMap = new HashMap(200);
    private final Set<AbstractValidator> validatorsForAny = new HashSet<AbstractValidator>(200);
    private int maxNumberOfProblemsLimit = 600;

    public void registerValidator(AbstractValidator abstractValidator, Class<?> clazz) {
        Set<AbstractValidator> set = this.mapGet(clazz.getName());
        set.add(abstractValidator);
    }

    public void registerValidator(AbstractValidator abstractValidator) {
        this.validatorsForAny.add(abstractValidator);
    }

    private Set<AbstractValidator> mapGet(String string2) {
        return this.validatorMap.computeIfAbsent(string2, string -> new HashSet());
    }

    private Set<AbstractValidator> getValidatorsForBusinessObject(@NonNull BusinessObject businessObject) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        HashSet<AbstractValidator> hashSet = new HashSet<AbstractValidator>(200);
        hashSet.addAll(this.mapGet(businessObject.getClass().getName()));
        hashSet.addAll(this.validatorsForAny);
        return hashSet;
    }

    public void shutdownValidation() {
        this.fixedThreadPool.shutdownNow();
    }

    public void validate(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel) {
        Object object;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("problemModel is marked non-null but is null");
        }
        this.validatorMap.entrySet().stream().forEach(entry -> ((Set)entry.getValue()).forEach(AbstractValidator::resetValidatorRanFlag));
        if (isValidationCacheUsed.get() && businessObject instanceof ObsProject) {
            object = (ObsProject)businessObject;
            this.resetValidationCacheIfRequired((ObsProject)object);
        }
        BackgroundCalibratorDatabaseInteractor.getInstance().resetCalibratorDatabaseCommsTimer();
        object = new HashSet();
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.fixedThreadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        problemListModel.start();
        this.recursivelyValidate(businessObject, problemListModel, (Set<IBusinessObject>)object, true);
        boolean bl = true;
        block2: do {
            bl = true;
            for (Future<?> future : this.validatorThreadCompletionList) {
                if (future.isDone() || future.isCancelled()) continue;
                bl = false;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
                continue block2;
            }
        } while (!bl);
        this.fixedThreadPool.shutdown();
        if (problemListModel.getSize() == 0) {
            problemListModel.add(DefaultProblem.createSuccess("No problems found", "", null));
        }
        problemListModel.finish();
        stopwatch.stop();
        if (isValidationCacheUsed.get() && businessObject instanceof ObsProject) {
            ObsProject obsProject = (ObsProject)businessObject;
            this.updateValidationCacheHashes(obsProject);
        }
        Log.logger(ValidatorSet.class).info("Time for validation process : " + stopwatch.toString());
    }

    private void updateValidationCacheHashes(@NonNull ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        ObsProject obsProject2 = this.normalizeObsProjectBeforeHashing(obsProject);
        obsProjectHashCode.set(Objects.hashCode(ValidatorSet.removeEntityIDs(obsProject2.toXml())));
        try {
            ObsProposal obsProposal = obsProject2.getObsProposal().deepCopy();
            obsProposal.clearAbstractScienceGoal();
            obsProposalHashCode.set(Objects.hashCode(ValidatorSet.removeEntityIDs(obsProposal.toXml())));
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    private void recursivelyValidate(BusinessObject businessObject, @NonNull ProblemListModel problemListModel, Set<IBusinessObject> set, boolean bl) {
        HashMap<Class<? extends AbstractValidator>, ValidationCacheRecord> hashMap;
        Iterator iterator;
        if (problemListModel == null) {
            throw new NullPointerException("problemModel is marked non-null but is null");
        }
        if (businessObject == null || set.contains(businessObject) || problemListModel.getSize() > this.maxNumberOfProblemsLimit) {
            return;
        }
        if (businessObject instanceof ScienceGoal) {
            iterator = (ScienceGoal)businessObject;
            ((ScienceGoal)((Object)iterator)).generateObjectHash();
        }
        if (businessObject instanceof SchedBlock) {
            ObsProject obsProject;
            iterator = (SchedBlock)businessObject;
            Object object2 = null;
            try {
                obsProject = iterator.getObsProject();
            }
            catch (UnknownEntityException unknownEntityException) {
                return;
            }
            if (obsProject == null) {
                return;
            }
            if (iterator.getStatus().equals(ObsUnitData.STATUS_NEWPHASE1) && (hashMap = obsProject.getStatus()) != ObsProjectData.STATUS_NEWPHASE1 && hashMap != ObsProjectData.STATUS_PHASE1SUBMITTED) {
                return;
            }
            ((SchedBlock)((Object)iterator)).generateObjectHash();
        }
        if (businessObject instanceof ObsProposal) {
            void var6_10;
            iterator = (ObsProposal)businessObject;
            ((ObsProposal)((Object)iterator)).generateObjectHash();
            Object var6_8 = null;
            try {
                ObsProject obsProject = iterator.getObsProject();
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
            if (var6_10 == null) {
                return;
            }
            if (!var6_10.isPhase1Project()) {
                Log.logger((Object)this).log(Level.INFO, "Warning - not validating proposal items");
                return;
            }
        }
        if (businessObject instanceof ObsProject) {
            iterator = (ObsProject)businessObject;
            if (!bl) {
                return;
            }
            ((ObsProject)((Object)iterator)).generateObjectHash();
        }
        if (businessObject instanceof StatusBase) {
            return;
        }
        set.add((IBusinessObject)businessObject);
        for (AbstractValidator abstractValidator : this.getValidatorsForBusinessObject(businessObject)) {
            ValidationCacheRecord validationCacheRecord;
            hashMap = validatedBOCache.get(businessObject);
            if (hashMap != null && (validationCacheRecord = (ValidationCacheRecord)hashMap.get(abstractValidator.getClass())) != null && !validationCacheRecord.isExistingValidationResultsValid()) {
                Log.logger(ValidatorSet.class).fine("Clearing validation record for " + businessObject.getClass().getSimpleName());
                validationCacheRecord.clearValidationRecord();
            }
            if (abstractValidator.isValidatorThreadSafe() && MiscUtils.isParallelismToBeUsed()) {
                this.validatorThreadCompletionList.add(this.fixedThreadPool.submit(() -> this.runValidator(businessObject, problemListModel, abstractValidator)));
                continue;
            }
            this.waitForAllExecutingValidatorsToStop();
            this.runValidator(businessObject, problemListModel, abstractValidator);
        }
        for (BusinessObject businessObject2 : businessObject.associatedObjects()) {
            this.recursivelyValidate(businessObject2, problemListModel, set, false);
        }
    }

    private void runValidator(@NonNull BusinessObject businessObject2, @NonNull ProblemListModel problemListModel, @NonNull AbstractValidator abstractValidator) {
        if (businessObject2 == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("problemModel is marked non-null but is null");
        }
        if (abstractValidator == null) {
            throw new NullPointerException("validator is marked non-null but is null");
        }
        Log.logger(ValidatorSet.class).fine("Executing validator " + abstractValidator.getClass().getSimpleName());
        DefaultProblemListModel defaultProblemListModel = new DefaultProblemListModel();
        HashMap hashMap = validatedBOCache.computeIfAbsent(businessObject2, businessObject -> new HashMap());
        ValidationCacheRecord validationCacheRecord = hashMap.computeIfAbsent(abstractValidator.getClass(), clazz -> ValidationCacheRecord.builder().bo(businessObject2).parentSB(SchedBlock.getBOsParentSB(businessObject2)).parentSG(ScienceGoal.getBOsParentScienceGoal(businessObject2)).build());
        if (validationCacheRecord.isExistingValidationResultsValid()) {
            Log.logger(ValidatorSet.class).fine("Using cached validator results " + abstractValidator.getClass().getSimpleName());
            problemListModel.mergeProblems(validationCacheRecord.getProblemListModel());
        } else {
            Log.logger(ValidatorSet.class).fine("Validator cache miss for " + abstractValidator.getClass().getSimpleName());
            abstractValidator.validate(businessObject2, defaultProblemListModel);
            defaultProblemListModel.removeDuplicateProblemsFromBuffer();
            defaultProblemListModel.commitProblemsToModel();
            problemListModel.mergeProblems(defaultProblemListModel);
            this.storeBOValidationResultsInCache(defaultProblemListModel, validationCacheRecord);
        }
    }

    private void waitForAllExecutingValidatorsToStop() {
        if (!MiscUtils.isParallelismToBeUsed()) {
            return;
        }
        boolean bl = false;
        block2: do {
            bl = true;
            for (Future<?> future : this.validatorThreadCompletionList) {
                if (future.isDone() || future.isCancelled()) continue;
                bl = false;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
                continue block2;
            }
        } while (!bl);
    }

    private void storeBOValidationResultsInCache(@NonNull DefaultProblemListModel defaultProblemListModel, @NonNull ValidationCacheRecord validationCacheRecord) {
        if (defaultProblemListModel == null) {
            throw new NullPointerException("validationResults is marked non-null but is null");
        }
        if (validationCacheRecord == null) {
            throw new NullPointerException("boValidationRecord is marked non-null but is null");
        }
        ProblemListModel problemListModel = validationCacheRecord.getProblemListModel();
        defaultProblemListModel.iterator().forEachRemaining(problemListModel::add);
        validationCacheRecord.setLastValidationRunMarker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean resetValidationCacheIfRequired(@NonNull ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        boolean bl = false;
        Object object = purgeCacheStopWatch;
        synchronized (object) {
            if (!purgeCacheStopWatch.isRunning()) {
                purgeCacheStopWatch.start();
            }
            if (purgeCacheStopWatch.isRunning() && purgeCacheStopWatch.elapsed(TimeUnit.SECONDS) > 1800L) {
                purgeCacheStopWatch.reset();
                obsProposalHashCode.set(-1);
                validatedBOCache.clear();
                bl = true;
                Log.logger(ValidatorSet.class).info("Purging validation result cache - validation cache timer expired");
            }
        }
        object = this.normalizeObsProjectBeforeHashing(obsProject);
        int n = Objects.hashCode(ValidatorSet.removeEntityIDs(object.toXml()));
        if (n != obsProjectHashCode.getAcquire()) {
            obsProjectHashCode.set(n);
            validatedBOCache.clear();
            bl = true;
            Log.logger(ValidatorSet.class).info("Purging validation result cache - obsProject has changed");
        }
        if (obsProject.isPhase1Project()) {
            try {
                ObsProposal obsProposal = obsProject.getObsProposal();
                ObsProposal obsProposal2 = obsProposal.deepCopy();
                if (obsProposal2 != null) {
                    obsProposal2.clearAbstractScienceGoal();
                    int n2 = Objects.hashCode(ValidatorSet.removeEntityIDs(obsProposal2.toXml()));
                    if (n2 != obsProposalHashCode.getAcquire()) {
                        obsProposalHashCode.set(n2);
                        validatedBOCache.clear();
                        bl = true;
                        Log.logger(ValidatorSet.class).info("Purging validation result cache - obsproposal has changed");
                    }
                }
                obsProject.setObsProposal(obsProposal);
            }
            catch (UnknownEntityException unknownEntityException) {
                obsProposalHashCode.set(-1);
                return bl;
            }
        }
        return bl;
    }

    private ObsProject normalizeObsProjectBeforeHashing(@NonNull ObsProject obsProject) {
        if (obsProject == null) {
            throw new NullPointerException("obsProject is marked non-null but is null");
        }
        ObsProposal obsProposal = null;
        try {
            obsProposal = obsProject.getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        ObsProject obsProject2 = obsProject.deepCopy();
        if (obsProposal != null) {
            obsProposal.setObsProject(obsProject);
        }
        try {
            obsProject2.setObsProposal(obsProject.getObsProposal().deepCopy());
        }
        catch (CopyException | UnknownEntityException throwable) {
            // empty catch block
        }
        ObsProgram obsProgram = obsProject2.getObsProgram();
        if (obsProgram != null) {
            obsProgram.clearAbstractScienceGoal();
            ObsUnitSet obsUnitSet = obsProgram.getObsPlan();
            if (obsUnitSet != null) {
                obsUnitSet.clearObsUnitSet();
                try {
                    obsUnitSet.clearSchedBlock();
                }
                catch (UnknownEntityException unknownEntityException) {
                    // empty catch block
                }
            }
        }
        return obsProject2;
    }

    public static String removeEntityIDs(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("boXML is marked non-null but is null");
        }
        return string.replaceAll("entityId=\\\".*?\\\"", "").replaceAll("entityPartId=\\\".*?\\\"", "");
    }

    public HashMap<String, Set<AbstractValidator>> getValidatorMap() {
        return this.validatorMap;
    }

    public void setMaxNumberOfProblemsLimit(int n) {
        this.maxNumberOfProblemsLimit = n;
    }

    static class ValidationCacheRecord {
        private ProblemListModel problemListModel;
        private BusinessObject bo;
        private Optional<ScienceGoal> parentSG;
        private Optional<SchedBlock> parentSB;
        private int scienceGoalHashWhenLastValidated;
        private int obsProposalHashWhenLastValidated;
        private int obsProjectHashWhenLastValidated;
        private int sbHashWhenLastValidated;

        public void clearValidationRecord() {
            this.sbHashWhenLastValidated = -1;
            this.scienceGoalHashWhenLastValidated = -1;
            this.obsProjectHashWhenLastValidated = -1;
            this.obsProposalHashWhenLastValidated = -1;
            this.problemListModel.clear();
        }

        public boolean isExistingValidationResultsValid() {
            HashCodeGeneratorInterface hashCodeGeneratorInterface;
            if (!isValidationCacheUsed.get()) {
                return false;
            }
            if (this.bo instanceof ScienceGoal && ((HashCodeGeneratorInterface)this.bo).getObjectHash() == this.scienceGoalHashWhenLastValidated || this.bo instanceof SchedBlock && ((HashCodeGeneratorInterface)this.bo).getObjectHash() == this.sbHashWhenLastValidated) {
                return true;
            }
            if (this.bo instanceof ObsProposal && ((HashCodeGeneratorInterface)this.bo).getObjectHash() == this.obsProposalHashWhenLastValidated) {
                return true;
            }
            if (this.bo instanceof ObsProject && ((HashCodeGeneratorInterface)this.bo).getObjectHash() == this.obsProjectHashWhenLastValidated) {
                return true;
            }
            if (this.parentSG.isPresent() && ((ScienceGoal)(hashCodeGeneratorInterface = this.parentSG.get())).getObjectHash() == this.scienceGoalHashWhenLastValidated) {
                return true;
            }
            return this.parentSB.isPresent() && ((SchedBlock)(hashCodeGeneratorInterface = this.parentSB.get())).getObjectHash() == this.sbHashWhenLastValidated;
        }

        public void setLastValidationRunMarker() {
            BusinessObject businessObject = this.bo;
            if (businessObject instanceof ScienceGoal) {
                ScienceGoal scienceGoal2 = (ScienceGoal)businessObject;
                this.scienceGoalHashWhenLastValidated = scienceGoal2.getObjectHash();
            } else {
                businessObject = this.bo;
                if (businessObject instanceof SchedBlock) {
                    SchedBlock schedBlock2 = (SchedBlock)businessObject;
                    this.sbHashWhenLastValidated = schedBlock2.getObjectHash();
                } else {
                    businessObject = this.bo;
                    if (businessObject instanceof ObsProposal) {
                        ObsProposal obsProposal = (ObsProposal)businessObject;
                        this.obsProposalHashWhenLastValidated = obsProposal.getObjectHash();
                    } else {
                        businessObject = this.bo;
                        if (businessObject instanceof ObsProject) {
                            ObsProject obsProject = (ObsProject)businessObject;
                            this.obsProjectHashWhenLastValidated = obsProject.getObjectHash();
                        } else {
                            this.parentSG.ifPresent(scienceGoal -> {
                                this.scienceGoalHashWhenLastValidated = scienceGoal.getObjectHash();
                            });
                            this.parentSB.ifPresent(schedBlock -> {
                                this.sbHashWhenLastValidated = schedBlock.getObjectHash();
                            });
                        }
                    }
                }
            }
        }

        private static ProblemListModel $default$problemListModel() {
            return new DefaultProblemListModel();
        }

        private static BusinessObject $default$bo() {
            return null;
        }

        private static Optional<ScienceGoal> $default$parentSG() {
            return Optional.empty();
        }

        private static Optional<SchedBlock> $default$parentSB() {
            return Optional.empty();
        }

        private static int $default$scienceGoalHashWhenLastValidated() {
            return -1;
        }

        private static int $default$obsProposalHashWhenLastValidated() {
            return -1;
        }

        private static int $default$obsProjectHashWhenLastValidated() {
            return -1;
        }

        private static int $default$sbHashWhenLastValidated() {
            return -1;
        }

        ValidationCacheRecord(ProblemListModel problemListModel, BusinessObject businessObject, Optional<ScienceGoal> optional, Optional<SchedBlock> optional2, int n, int n2, int n3, int n4) {
            this.problemListModel = problemListModel;
            this.bo = businessObject;
            this.parentSG = optional;
            this.parentSB = optional2;
            this.scienceGoalHashWhenLastValidated = n;
            this.obsProposalHashWhenLastValidated = n2;
            this.obsProjectHashWhenLastValidated = n3;
            this.sbHashWhenLastValidated = n4;
        }

        public static ValidationCacheRecordBuilder builder() {
            return new ValidationCacheRecordBuilder();
        }

        public ProblemListModel getProblemListModel() {
            return this.problemListModel;
        }

        public BusinessObject getBo() {
            return this.bo;
        }

        public Optional<ScienceGoal> getParentSG() {
            return this.parentSG;
        }

        public Optional<SchedBlock> getParentSB() {
            return this.parentSB;
        }

        public int getScienceGoalHashWhenLastValidated() {
            return this.scienceGoalHashWhenLastValidated;
        }

        public int getObsProposalHashWhenLastValidated() {
            return this.obsProposalHashWhenLastValidated;
        }

        public int getObsProjectHashWhenLastValidated() {
            return this.obsProjectHashWhenLastValidated;
        }

        public int getSbHashWhenLastValidated() {
            return this.sbHashWhenLastValidated;
        }

        public void setProblemListModel(ProblemListModel problemListModel) {
            this.problemListModel = problemListModel;
        }

        public void setBo(BusinessObject businessObject) {
            this.bo = businessObject;
        }

        public void setParentSG(Optional<ScienceGoal> optional) {
            this.parentSG = optional;
        }

        public void setParentSB(Optional<SchedBlock> optional) {
            this.parentSB = optional;
        }

        public void setScienceGoalHashWhenLastValidated(int n) {
            this.scienceGoalHashWhenLastValidated = n;
        }

        public void setObsProposalHashWhenLastValidated(int n) {
            this.obsProposalHashWhenLastValidated = n;
        }

        public void setObsProjectHashWhenLastValidated(int n) {
            this.obsProjectHashWhenLastValidated = n;
        }

        public void setSbHashWhenLastValidated(int n) {
            this.sbHashWhenLastValidated = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ValidationCacheRecord)) {
                return false;
            }
            ValidationCacheRecord validationCacheRecord = (ValidationCacheRecord)object;
            if (!validationCacheRecord.canEqual(this)) {
                return false;
            }
            if (this.getScienceGoalHashWhenLastValidated() != validationCacheRecord.getScienceGoalHashWhenLastValidated()) {
                return false;
            }
            if (this.getObsProposalHashWhenLastValidated() != validationCacheRecord.getObsProposalHashWhenLastValidated()) {
                return false;
            }
            if (this.getObsProjectHashWhenLastValidated() != validationCacheRecord.getObsProjectHashWhenLastValidated()) {
                return false;
            }
            if (this.getSbHashWhenLastValidated() != validationCacheRecord.getSbHashWhenLastValidated()) {
                return false;
            }
            ProblemListModel problemListModel = this.getProblemListModel();
            ProblemListModel problemListModel2 = validationCacheRecord.getProblemListModel();
            if (problemListModel == null ? problemListModel2 != null : !problemListModel.equals(problemListModel2)) {
                return false;
            }
            BusinessObject businessObject = this.getBo();
            BusinessObject businessObject2 = validationCacheRecord.getBo();
            if (businessObject == null ? businessObject2 != null : !businessObject.equals(businessObject2)) {
                return false;
            }
            Optional<ScienceGoal> optional = this.getParentSG();
            Optional<ScienceGoal> optional2 = validationCacheRecord.getParentSG();
            if (optional == null ? optional2 != null : !((Object)optional).equals(optional2)) {
                return false;
            }
            Optional<SchedBlock> optional3 = this.getParentSB();
            Optional<SchedBlock> optional4 = validationCacheRecord.getParentSB();
            return !(optional3 == null ? optional4 != null : !((Object)optional3).equals(optional4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ValidationCacheRecord;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + this.getScienceGoalHashWhenLastValidated();
            n = n * 59 + this.getObsProposalHashWhenLastValidated();
            n = n * 59 + this.getObsProjectHashWhenLastValidated();
            n = n * 59 + this.getSbHashWhenLastValidated();
            ProblemListModel problemListModel = this.getProblemListModel();
            n = n * 59 + (problemListModel == null ? 43 : problemListModel.hashCode());
            BusinessObject businessObject = this.getBo();
            n = n * 59 + (businessObject == null ? 43 : businessObject.hashCode());
            Optional<ScienceGoal> optional = this.getParentSG();
            n = n * 59 + (optional == null ? 43 : ((Object)optional).hashCode());
            Optional<SchedBlock> optional2 = this.getParentSB();
            n = n * 59 + (optional2 == null ? 43 : ((Object)optional2).hashCode());
            return n;
        }

        public String toString() {
            return "ValidatorSet.ValidationCacheRecord(problemListModel=" + this.getProblemListModel() + ", bo=" + this.getBo() + ", parentSG=" + this.getParentSG() + ", parentSB=" + this.getParentSB() + ", scienceGoalHashWhenLastValidated=" + this.getScienceGoalHashWhenLastValidated() + ", obsProposalHashWhenLastValidated=" + this.getObsProposalHashWhenLastValidated() + ", obsProjectHashWhenLastValidated=" + this.getObsProjectHashWhenLastValidated() + ", sbHashWhenLastValidated=" + this.getSbHashWhenLastValidated() + ")";
        }

        public static class ValidationCacheRecordBuilder {
            private boolean problemListModel$set;
            private ProblemListModel problemListModel$value;
            private boolean bo$set;
            private BusinessObject bo$value;
            private boolean parentSG$set;
            private Optional<ScienceGoal> parentSG$value;
            private boolean parentSB$set;
            private Optional<SchedBlock> parentSB$value;
            private boolean scienceGoalHashWhenLastValidated$set;
            private int scienceGoalHashWhenLastValidated$value;
            private boolean obsProposalHashWhenLastValidated$set;
            private int obsProposalHashWhenLastValidated$value;
            private boolean obsProjectHashWhenLastValidated$set;
            private int obsProjectHashWhenLastValidated$value;
            private boolean sbHashWhenLastValidated$set;
            private int sbHashWhenLastValidated$value;

            ValidationCacheRecordBuilder() {
            }

            public ValidationCacheRecordBuilder problemListModel(ProblemListModel problemListModel) {
                this.problemListModel$value = problemListModel;
                this.problemListModel$set = true;
                return this;
            }

            public ValidationCacheRecordBuilder bo(BusinessObject businessObject) {
                this.bo$value = businessObject;
                this.bo$set = true;
                return this;
            }

            public ValidationCacheRecordBuilder parentSG(Optional<ScienceGoal> optional) {
                this.parentSG$value = optional;
                this.parentSG$set = true;
                return this;
            }

            public ValidationCacheRecordBuilder parentSB(Optional<SchedBlock> optional) {
                this.parentSB$value = optional;
                this.parentSB$set = true;
                return this;
            }

            public ValidationCacheRecordBuilder scienceGoalHashWhenLastValidated(int n) {
                this.scienceGoalHashWhenLastValidated$value = n;
                this.scienceGoalHashWhenLastValidated$set = true;
                return this;
            }

            public ValidationCacheRecordBuilder obsProposalHashWhenLastValidated(int n) {
                this.obsProposalHashWhenLastValidated$value = n;
                this.obsProposalHashWhenLastValidated$set = true;
                return this;
            }

            public ValidationCacheRecordBuilder obsProjectHashWhenLastValidated(int n) {
                this.obsProjectHashWhenLastValidated$value = n;
                this.obsProjectHashWhenLastValidated$set = true;
                return this;
            }

            public ValidationCacheRecordBuilder sbHashWhenLastValidated(int n) {
                this.sbHashWhenLastValidated$value = n;
                this.sbHashWhenLastValidated$set = true;
                return this;
            }

            public ValidationCacheRecord build() {
                ProblemListModel problemListModel = this.problemListModel$value;
                if (!this.problemListModel$set) {
                    problemListModel = ValidationCacheRecord.$default$problemListModel();
                }
                BusinessObject businessObject = this.bo$value;
                if (!this.bo$set) {
                    businessObject = ValidationCacheRecord.$default$bo();
                }
                Optional<ScienceGoal> optional = this.parentSG$value;
                if (!this.parentSG$set) {
                    optional = ValidationCacheRecord.$default$parentSG();
                }
                Optional<SchedBlock> optional2 = this.parentSB$value;
                if (!this.parentSB$set) {
                    optional2 = ValidationCacheRecord.$default$parentSB();
                }
                int n = this.scienceGoalHashWhenLastValidated$value;
                if (!this.scienceGoalHashWhenLastValidated$set) {
                    n = ValidationCacheRecord.$default$scienceGoalHashWhenLastValidated();
                }
                int n2 = this.obsProposalHashWhenLastValidated$value;
                if (!this.obsProposalHashWhenLastValidated$set) {
                    n2 = ValidationCacheRecord.$default$obsProposalHashWhenLastValidated();
                }
                int n3 = this.obsProjectHashWhenLastValidated$value;
                if (!this.obsProjectHashWhenLastValidated$set) {
                    n3 = ValidationCacheRecord.$default$obsProjectHashWhenLastValidated();
                }
                int n4 = this.sbHashWhenLastValidated$value;
                if (!this.sbHashWhenLastValidated$set) {
                    n4 = ValidationCacheRecord.$default$sbHashWhenLastValidated();
                }
                return new ValidationCacheRecord(problemListModel, businessObject, optional, optional2, n, n2, n3, n4);
            }

            public String toString() {
                return "ValidatorSet.ValidationCacheRecord.ValidationCacheRecordBuilder(problemListModel$value=" + this.problemListModel$value + ", bo$value=" + this.bo$value + ", parentSG$value=" + this.parentSG$value + ", parentSB$value=" + this.parentSB$value + ", scienceGoalHashWhenLastValidated$value=" + this.scienceGoalHashWhenLastValidated$value + ", obsProposalHashWhenLastValidated$value=" + this.obsProposalHashWhenLastValidated$value + ", obsProjectHashWhenLastValidated$value=" + this.obsProjectHashWhenLastValidated$value + ", sbHashWhenLastValidated$value=" + this.sbHashWhenLastValidated$value + ")";
            }
        }
    }
}

