/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproject;

import alma.common.sensitivitycalculatorcore.lookup.AtmosphereTable;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.enumerations.CorrBits;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.ExpectedSpectralLine;
import alma.obsprep.bo.obsproject.Field;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.schedblock.SpectralSpecValidator;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.lang3.StringUtils;

public class SpectralSetupParametersValidator
extends AbstractValidator {
    private static CacheAccess<Integer, ObsUnitSet> sbOutputCache = JCS.getInstance((String)"obsUnitSetCache");

    public SpectralSetupParametersValidator() {
        this.setValidatorThreadSafe(false);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        boolean bl;
        Object object;
        String[] stringArray;
        Problem problem;
        Collection<ScienceGoal> collection;
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)businessObject;
        ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal();
        SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice = spectralSetupParameters.getSpectralType();
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException);
        }
        SpectralScan spectralScan = null;
        SpectralScan.SpectralScanTunings spectralScanTunings = null;
        if (spectralSetupParameters.isSpectralScan()) {
            spectralScan = spectralSetupParameters.getSpectralScan();
        }
        if (!spectralSetupParameters.isSpectralScan() && spectralSetupParameters.getScienceSpectralWindowCount() == 0) {
            problem = DefaultProblem.createError("No spectral windows are defined!", "Select the Spectral Setup in the Science Goal and enter some", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!Arrays.asList(stringArray = SpectralSetupParameters.getKnownPolarisationList()).contains(spectralSetupParameters.getPolarisation())) {
            problem = DefaultProblem.createError("Polarization " + spectralSetupParameters.getPolarisation() + " not valid", "Select the spectral setup in the Science Goal and choose a valid polarization", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (spectralSetupParameters.isSingleContinuum()) {
            if (!spectralSetupParameters.getSoleFrequency().hasContent()) {
                problem = DefaultProblem.createError("Continuum is chosen and frequency is not set", "Select the Spectral Setup in the Science Goal and enter the frequency", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (((ScienceSpectralWindow)(object = spectralSetupParameters.getScienceSpectralWindow(0))).getCorrConfigMode() == CorrConfigMode.INVALID_CORRCONFIGMODE) {
                Log.logger((Object)this).warning("inconsistent bandwidth/resolution/polarization found in the ScienceSpectralWindow. trying to correct.");
                ((ScienceSpectralWindow)object).updateContinuumCorrMode();
            }
        } else if (spectralSetupParameters.isSpectralScan()) {
            spectralScanTunings = this.validateSpectralScanSetup(businessObject, problemListModel, spectralSetupParameters, scienceGoal, spectralScan, spectralScanTunings);
        } else if (spectralSetupParameters.isSpectralLine()) {
            this.validateSpectralLineSetup(businessObject, problemListModel, spectralSetupParameters);
        }
        object = AlmaCapabilities.getInstance();
        List<String> list = ((AlmaCapabilities)object).getAvailableReceiverBands();
        boolean bl2 = false;
        scienceGoal.clearRequiredReceiverBands();
        if (spectralSetupParameters.isSpectralScan()) {
            if (spectralScanTunings != null) {
                try {
                    Iterator<ScienceGoal> iterator = spectralSetupParameters.getReceiverBand().getName();
                    bl2 = true;
                    scienceGoal.addRequiredReceiverBands((String)((Object)iterator));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        } else {
            for (String object2 : list) {
                try {
                    if (!object2.equals(spectralSetupParameters.getReceiverBand().getName())) continue;
                    bl2 = true;
                    scienceGoal.addRequiredReceiverBands(object2);
                }
                catch (Exception exception) {}
            }
        }
        if (!bl2) {
            problem = DefaultProblem.createError("Required receiver band is not available!", "Select the Spectral Setup in the Science Goal and revise your selections", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (!spectralSetupParameters.getRepresentativeFrequency().hasContent()) {
            problem = DefaultProblem.createError("There is no value for the representative frequency", "Select the Spectral Setup Parameters in the Science Goal and choose a representative window", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        } else if (spectralSetupParameters.getRepresentativeFrequency().getContentInUnits(Frequency.UNIT_GHZ) <= 0.0) {
            problem = DefaultProblem.createError("Representative frequency is not valid", "Select the Spectral Setup Parameters in the Science Goal and enter a valid value", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        this.validateWalshSwitching(businessObject, problemListModel, spectralSetupParameters);
        this.validateRestFrequenciesAreInSPWs(businessObject, problemListModel, spectralSetupParameters);
        this.validateBasebandResources(businessObject, problemListModel, spectralSetupParameters, spectralSetupTypeChoice);
        this.validateRepresentativeAttributes(businessObject, problemListModel, spectralSetupParameters, spectralSetupTypeChoice);
        this.validateVLBISpectralLineConfigurations(businessObject, problemListModel, spectralSetupParameters);
        this.validateNo4x4SPWsWithSACA(problemListModel, spectralSetupParameters);
        this.validateSingle4x4SPWPerBaseband(problemListModel, spectralSetupParameters);
        this.validateCorrelatorEfficiencyMismatch(problemListModel, spectralSetupParameters);
        try {
            this.validateSPWSNotTooCloseToBasebandEdge(businessObject, problemListModel, spectralSetupParameters);
        }
        catch (UnableToValidateSSPException unableToValidateSSPException) {
            Log.logger(SpectralSetupParametersValidator.class).warning("Unable to determine if SPWs are too close to the baseband edges");
        }
        if (spectralSetupParameters.isFullPolarisation()) {
            for (ScienceGoal scienceGoal2 : collection) {
                List<MinTuningsCalculator.TuningResult> list2 = null;
                try {
                    list2 = MinTuningsCalculator.getLO1Tunings(scienceGoal2);
                }
                catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings unableToCalculateMinNumberOfTunings) {
                    problem = DefaultProblem.createError("The OT cannot process this many separate velocities", "Distribute your sources over multiple Science Goals", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                    return;
                }
                if (list2 == null) {
                    Log.logger(SpectralSetupParametersValidator.class).warning("Unable to determine the number of tunings");
                    continue;
                }
                if (Telescope.isOTConfiguredAs(Telescope.CSVALMA) || list2.size() <= 1) continue;
                problem = DefaultProblem.createError("Only a single tuning is supported with full polarization: " + list2.size() + " tunings are required", "Ensure that all of the sources defined can be observed using a single tuning.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
        this.validateMosaicsNotUsedInB10(businessObject, problemListModel, collection);
        boolean bl22 = false;
        boolean bl3 = false;
        try {
            bl22 = scienceGoal.getObsProposal().isVLBIorPhasedArray();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SpectralSetupParametersValidator.class).info("Unable to determine if project is VLBI: " + unknownEntityException.getMessage());
        }
        if (bl22) {
            this.validateVLBISpectralSetup(spectralSetupParameters, problemListModel);
        }
        try {
            bl = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SpectralSetupParametersValidator.class).info("Unable to determine if science goal is solar: " + unknownEntityException.getMessage());
        }
        if (bl) {
            this.validateSolarSpectralSetup(spectralSetupParameters, problemListModel);
        }
        this.validateAllBasebandsHaveAnSPW(spectralSetupParameters, problemListModel);
        this.validateLowAtmosphericTransmissionInSPWs(spectralSetupParameters, problemListModel);
        this.validateNoACA4x4With937BW(problemListModel, spectralSetupParameters);
    }

    private void validateSingle4x4SPWPerBaseband(@NonNull ProblemListModel problemListModel, @NonNull SpectralSetupParameters spectralSetupParameters) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        IntStream.range(0, 3).forEach(n -> {
            long l = Stream.of(spectralSetupParameters.getScienceSpectralWindowGroup(n)).filter(scienceSpectralWindow -> scienceSpectralWindow.getCorrConfigMode() != null && CorrBits.is4x4(scienceSpectralWindow.getCorrConfigMode().getBits())).count();
            if (l > 1L) {
                problemListModel.add(DefaultProblem.createError("Baseband-" + (n + 1) + ": There is more than one SPW using a 4x4 correlator mode", "Adjust the correlator modes in the baseband.", (IBusinessObject)spectralSetupParameters));
            }
        });
    }

    private void validateNoACA4x4With937BW(@NonNull ProblemListModel problemListModel, @NonNull SpectralSetupParameters spectralSetupParameters) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (!spectralSetupParameters.getScienceGoal().getPerformanceParameters().getUseACA()) {
            return;
        }
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
            CorrConfigMode corrConfigMode = scienceSpectralWindow.getCorrConfigMode();
            if (corrConfigMode == null || !CorrBits.is4x4(scienceSpectralWindow.getCorrConfigMode().getBits()) || !corrConfigMode.getEffectiveBandwidth().equals((Object)Frequency.createFrequencyMHZ(937.5))) continue;
            if (Telescope.isOTConfiguredAs(Telescope.CSVALMA)) {
                problemListModel.add(DefaultProblem.createWarning("4-bit 937.5 MHz BW spectral windows are not supported by the ACA", "Adjust the correlator modes in the baseband.", (IBusinessObject)spectralSetupParameters));
                continue;
            }
            problemListModel.add(DefaultProblem.createError("4-bit 937.5 MHz BW spectral windows are not supported by the ACA", "Adjust the correlator modes in the baseband.", (IBusinessObject)spectralSetupParameters));
        }
    }

    private void validateCorrelatorEfficiencyMismatch(@NonNull ProblemListModel problemListModel, @NonNull SpectralSetupParameters spectralSetupParameters) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (!CorrBits.is4x4(spectralSetupParameters.getRepresentativeSpectralWindow().getCorrConfigMode().getBits())) {
            return;
        }
        if (Stream.of(spectralSetupParameters.getScienceSpectralWindow()).filter(scienceSpectralWindow -> scienceSpectralWindow.getCorrConfigMode() != null && CorrBits.is2x2(scienceSpectralWindow.getCorrConfigMode().getBits())).count() > 0L) {
            problemListModel.add(DefaultProblem.createWarning("A 4-bit BL correlator mode with increased sensitivity has been selected. This will imply reduced integration times", "Standard 2-bit BLC modes can be set in the spectral setup", (IBusinessObject)spectralSetupParameters));
        }
    }

    private void validateNo4x4SPWsWithSACA(@NonNull ProblemListModel problemListModel, @NonNull SpectralSetupParameters spectralSetupParameters) {
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (!spectralSetupParameters.getScienceGoal().isStandAloneACA()) {
            return;
        }
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getAbstractScienceSpectralWindowScienceSpectralWindow()) {
            if (!CorrBits.is4x4(scienceSpectralWindow.getCorrConfigMode().getBits())) continue;
            problemListModel.add(DefaultProblem.createError("4-bit modes are not offered for ACA standalone", "Please select 2-bit modes in the Spectral setup", (IBusinessObject)spectralSetupParameters));
            return;
        }
    }

    private void validateLowAtmosphericTransmissionInSPWs(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull ProblemListModel problemListModel) {
        List<MinTuningsCalculator.TuningResult> list;
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal();
        try {
            list = MinTuningsCalculator.getLO1Tunings(scienceGoal);
        }
        catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings unableToCalculateMinNumberOfTunings) {
            Log.logger(SpectralSetupParametersValidator.class).warning("Unable to perform validation checks for low atmospheric transmission " + unableToCalculateMinNumberOfTunings.getMessage());
            return;
        }
        assert (list != null) : "We should have tunings now";
        HashMap<ScienceSpectralWindow, Integer> hashMap = new HashMap<ScienceSpectralWindow, Integer>();
        HashMap<ScienceSpectralWindow, ImageSPWPoorTransmissionRecord> hashMap2 = new HashMap<ScienceSpectralWindow, ImageSPWPoorTransmissionRecord>();
        HashMap<ScienceSpectralWindow, Integer> hashMap3 = new HashMap<ScienceSpectralWindow, Integer>();
        boolean bl = spectralSetupParameters.isSpectralLine();
        for (MinTuningsCalculator.TuningResult tuningResult : list) {
            TargetParameters targetParameters = tuningResult.getKeyTarget();
            for (ScienceSpectralWindow scienceSpectralWindow2 : spectralSetupParameters.getScienceSpectralWindow()) {
                int n;
                Velocity velocity = targetParameters.getSourceVelocity();
                Frequency frequency = bl ? velocity.dopplerShift(scienceSpectralWindow2.getCenterFrequency()) : scienceSpectralWindow2.getCenterFrequency();
                double d = Math.exp(-AtmosphereTable.getInstance().lookup(frequency.getContentInGHz(), scienceGoal.getRecommendedWVCIndex()).getTau());
                int n2 = tuningResult.getTargets().size();
                if (d < 0.05) {
                    if (scienceSpectralWindow2.getRepresentativeWindow()) {
                        n = hashMap3.computeIfAbsent(scienceSpectralWindow2, scienceSpectralWindow -> 0) + n2;
                        hashMap3.put(scienceSpectralWindow2, n);
                    } else {
                        n = hashMap.computeIfAbsent(scienceSpectralWindow2, scienceSpectralWindow -> 0) + n2;
                        hashMap.put(scienceSpectralWindow2, n);
                    }
                }
                int n3 = n = spectralSetupParameters.isWalshSwitching() && ReceiverBand.isReceiverBandInSet(spectralSetupParameters.getReceiverBand(), 9, 10) ? 1 : 0;
                if (n == 0 || !scienceSpectralWindow2.getAdvancedWindowSetup().getUseImage()) continue;
                Frequency frequency2 = ScienceSpectralWindow.getImageSPWSkyCenterFrequency(tuningResult.getFrequency(), frequency);
                d = Math.exp(-AtmosphereTable.getInstance().lookup(frequency2.getContentInGHz(), scienceGoal.getRecommendedWVCIndex()).getTau());
                if (!(d < 0.05)) continue;
                ImageSPWPoorTransmissionRecord imageSPWPoorTransmissionRecord = hashMap2.computeIfAbsent(scienceSpectralWindow2, scienceSpectralWindow -> new ImageSPWPoorTransmissionRecord(frequency2, velocity, 0));
                imageSPWPoorTransmissionRecord.setNoOfTargetsInPoorTransmission(imageSPWPoorTransmissionRecord.getNoOfTargetsInPoorTransmission() + n2);
                hashMap2.put(scienceSpectralWindow2, imageSPWPoorTransmissionRecord);
            }
        }
        int n = scienceGoal.getTargetParametersCount();
        hashMap.entrySet().stream().forEach(entry -> {
            ScienceSpectralWindow scienceSpectralWindow = (ScienceSpectralWindow)entry.getKey();
            Frequency frequency = scienceSpectralWindow.getCenterFrequencyRest();
            Integer n2 = (Integer)entry.getValue();
            String string = String.format("A spectral window (%s@rest freq=%.1f GHz) other than the representative one has transmission &lt;5%% for %d out of %d sources.", scienceSpectralWindow.getTransitionName(), frequency.getContentInGHz(), n2, n);
            problemListModel.add(DefaultProblem.createError(string, "Please move the spw such that it lies in a better part of the atmosphere.", (IBusinessObject)spectralSetupParameters));
        });
        hashMap3.entrySet().stream().forEach(entry -> {
            Integer n2 = (Integer)entry.getValue();
            String string = String.format("The representative spectral window has transmission &lt;5%% for %d out of %d sources.", n2, n);
            problemListModel.add(DefaultProblem.createWarning(string, "This lies in a very opaque part of the atmosphere and should be moved if possible.", (IBusinessObject)spectralSetupParameters));
        });
        hashMap2.entrySet().stream().forEach(entry -> {
            ScienceSpectralWindow scienceSpectralWindow = (ScienceSpectralWindow)entry.getKey();
            Frequency frequency = scienceSpectralWindow.getCenterFrequencyRest();
            ImageSPWPoorTransmissionRecord imageSPWPoorTransmissionRecord = (ImageSPWPoorTransmissionRecord)entry.getValue();
            int n2 = imageSPWPoorTransmissionRecord.getNoOfTargetsInPoorTransmission();
            String string = String.format("A spectral window (%s@rest freq=%.1f GHz) other than the representative one has transmission &lt;5%% for %d out of %d sources.", scienceSpectralWindow.getTransitionName(), frequency.getContentInGHz(), n2, n);
            problemListModel.add(DefaultProblem.createError(string, "Please move the spw such that it lies in a better part of the atmosphere.", (IBusinessObject)spectralSetupParameters));
        });
    }

    private void validateAllBasebandsHaveAnSPW(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull ProblemListModel problemListModel) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (!spectralSetupParameters.isSpectralLine()) {
            return;
        }
        try {
            if (spectralSetupParameters.getGroupIndexSet().size() != 4) {
                Problem problem = DefaultProblem.createWarning("Not all basebands have been used", "Adding wide spectral windows in empty basebands can improve calibration", (IBusinessObject)spectralSetupParameters);
                problemListModel.add(problem);
            }
        }
        catch (InvalidGroupIndexException invalidGroupIndexException) {
            Log.logger(SpectralSetupParametersValidator.class).warning("Unable to determine basebands (groups) used in the SSP" + invalidGroupIndexException.getMessage());
        }
    }

    void validateMosaicsNotUsedInB10(BusinessObject businessObject, ProblemListModel problemListModel, Collection<ScienceGoal> collection) {
        for (ScienceGoal scienceGoal : collection) {
            SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
            if (!ReceiverBand.getReceiverBand(10).equals(spectralSetupParameters.getReceiverBand())) continue;
            for (TargetParameters targetParameters : spectralSetupParameters.getScienceGoal().getTargetParameters()) {
                if (!targetParameters.isRectanglePattern() && (!targetParameters.isMosaic() || targetParameters.getNumberOfPointings(scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M) <= 1)) continue;
                Problem problem = DefaultProblem.createError("Mosaics are not permitted with band 10", "Custom mosaics with more than a single pointing and rectangle pointing patterns are not permitted in band 10 (see " + targetParameters.getSourceName() + ")", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
    }

    private void validateRestFrequenciesAreInSPWs(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters) {
        int n = 0;
        int n2 = 0;
        HashSet<String> hashSet = new HashSet<String>();
        for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
            Frequency frequency = scienceSpectralWindow.getEffectiveBandwidth().inverseDopplerShifted(spectralSetupParameters.getSourceVelocity());
            FrequencyRange frequencyRange = FrequencyRange.fastCentredOn(scienceSpectralWindow.getCenterFrequencyRest(), frequency);
            Optional<FrequencyRange> optional = spectralSetupParameters.getSPWImageFrequency(scienceSpectralWindow);
            for (ExpectedSpectralLine expectedSpectralLine : scienceSpectralWindow.getExpectedSpectralLine()) {
                if (hashSet.contains(expectedSpectralLine.getSpatalogId())) continue;
                ++n2;
                if (frequencyRange.contains(expectedSpectralLine.getRestFrequency()) || optional.isPresent() && optional.get().contains(expectedSpectralLine.getRestFrequency())) continue;
                Log.logger(SpectralSetupParametersValidator.class).info("Is outside of the passband of the SPWs : " + expectedSpectralLine.getTransition());
                ++n;
                hashSet.add(expectedSpectralLine.getSpatalogId());
            }
        }
        if (n > 0) {
            Problem problem = DefaultProblem.createError(String.format("%d out of %d rest frequencies do not lie within a spectral window", n, n2), "Remove the non-observable rest frequencies", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void validateSpectralLineSetup(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters) {
        Problem problem;
        Object object = "Can not observe these spectral windows in one science goal";
        String string = "Revise spectral windows so that all of them fit in sidebands";
        ScienceSpectralWindow[] scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindow();
        int n = scienceSpectralWindowArray.length;
        for (int i = 0; i < n; ++i) {
            ScienceSpectralWindow scienceSpectralWindow = scienceSpectralWindowArray[i];
            scienceSpectralWindow.resetCorrConfigMode();
            if (scienceSpectralWindow.getCorrConfigMode() == CorrConfigMode.INVALID_CORRCONFIGMODE) {
                problem = DefaultProblem.createError("Spectral Window setup is invalid", "Please correct your spectral window setup", (IBusinessObject)spectralSetupParameters);
                problemListModel.add(problem);
            }
            if (StringUtils.stripToEmpty((String)scienceSpectralWindow.getTransitionName().replaceAll("\\s+", "")).equals("...Enter Name Here...".replaceAll("\\s+", ""))) {
                problem = DefaultProblem.createError("Spectral window name is invalid", "Change the name to something more meaningful", (IBusinessObject)spectralSetupParameters);
                problemListModel.add(problem);
            }
            if (StringUtils.stripToNull((String)scienceSpectralWindow.getTransitionName()) != null) continue;
            problem = DefaultProblem.createError("Spectral window name is empty", "Change the name to something more meaningful", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
        }
        if (spectralSetupParameters.isAdvancedSetup()) {
            boolean bl = false;
            for (n = 0; n < 4; ++n) {
                ScienceSpectralWindow[] scienceSpectralWindowArray2 = spectralSetupParameters.getScienceSpectralWindowGroup(n);
                if (scienceSpectralWindowArray2.length > 0) {
                    int n2 = n + 1;
                    ScienceSpectralWindow scienceSpectralWindow = scienceSpectralWindowArray2[0];
                    for (ScienceSpectralWindow scienceSpectralWindow2 : scienceSpectralWindowArray2) {
                        if (!scienceSpectralWindow.getSpectralResolution().equals(scienceSpectralWindow2.getSpectralResolution())) {
                            object = "Baseband-" + n2 + " : Spectral window resolution mismatch in spectral set-up. All windows must be allocated the same resolution.";
                            string = "Revise spectral windows so that they all have the same resolution.";
                            bl = true;
                            break;
                        }
                        if (scienceSpectralWindow2.getCorrConfigMode().isValid()) continue;
                        object = "Spectral window baseband " + n2 + " has an invalid correlator configuration.";
                        string = "Select a valid correlator configuration for this baseband.";
                        bl = true;
                        break;
                    }
                }
                if (bl) break;
            }
            if (bl) {
                problem = DefaultProblem.createError((String)object, string, (IBusinessObject)spectralSetupParameters);
                problemListModel.add(problem);
            }
        }
    }

    private SpectralScan.SpectralScanTunings validateSpectralScanSetup(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters, ScienceGoal scienceGoal, SpectralScan spectralScan, SpectralScan.SpectralScanTunings spectralScanTunings) {
        if (spectralScan == null) {
            Problem problem = DefaultProblem.createError("Spectral scan has not been defined", "Select the spectral scan setup in the Science Goal and set up the spectral scan", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        } else {
            Problem problem;
            if (!spectralScan.getStartFrequency().hasContent()) {
                problem = DefaultProblem.createError("A spectral scan has been selected but the scan start frequency is not set", "Select the Spectral Scan Setup in the Science Goal and enter the start frequency", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (!spectralScan.getEndFrequency().hasContent()) {
                problem = DefaultProblem.createError("A spectral scan has been selected but the scan end frequency is not set", "Select the Spectral Scan Setup in the Science Goal and enter the end frequency", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (!spectralScan.getBandWidth().hasContent()) {
                problem = DefaultProblem.createError("A spectral scan has been selected but the bandwidth has not been specified", "Select the Spectral Scan Setup in the Science Goal and select the bandwidth", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (!spectralScan.getSpectralResolution().hasContent()) {
                problem = DefaultProblem.createError("A spectral scan has been selected but the spectral resolution is not defined", "Select the Spectral Scan Setup in the Science Goal and setup the spectral resolution", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            if (spectralSetupParameters.getRepresentativeFrequency().hasContent()) {
                TargetParameters[] targetParametersArray = spectralScan.getRealisableScanRange();
                if (targetParametersArray != null && !targetParametersArray.contains(spectralSetupParameters.getRepresentativeFrequency())) {
                    problem = DefaultProblem.createError("The representative frequency is outside of the achievable scan range", "Modify the representative frequency so that it lies between the achievable start and end frequencies of the spectral scan", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            } else {
                problem = DefaultProblem.createError("A spectral scan has been selected but no representative frequency is not defined", "Select the Spectral Scan Setup in the Science Goal and define the representative frequency", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            try {
                spectralScanTunings = spectralScan.getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                problem = DefaultProblem.createError("Unable to determine a valid set of spectral scan tunings", "Revise the spectral scan setup", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
            block2: for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                int n = 0;
                for (Field field : targetParameters.getField()) {
                    if (field.getFieldPatternType().equals((Object)FieldPattern.FieldPatternType.POINT)) {
                        if (++n <= 1) continue;
                        problem = DefaultProblem.createError("Only single pointing field setups permitted for spectral scans", "Revise the field setup for source " + targetParameters.getSourceName(), (IBusinessObject)businessObject);
                        problemListModel.add(problem);
                        continue block2;
                    }
                    problem = DefaultProblem.createError("Spectral scans can only be used with single point setups not mosaics", "Revise the field setup for source " + targetParameters.getSourceName(), (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            }
        }
        return spectralScanTunings;
    }

    private void validateBasebandResources(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull SpectralSetupParameters spectralSetupParameters, @NonNull SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (spectralSetupTypeChoice == null) {
            throw new NullPointerException("setupType is marked non-null but is null");
        }
        if (spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE) || spectralSetupTypeChoice.equals((Object)SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM)) {
            int n;
            int n2;
            Set<ReceiverBand> set = ReceiverBand.getFullPolarizationReceiverBands();
            if (spectralSetupParameters.isFullPolarisation() && !set.contains(spectralSetupParameters.getReceiverBand())) {
                problemListModel.add(DefaultProblem.createError("Unsupported receiver band for full polarisation", "Only receiver bands 3,4,5,6 and 7 are supported when full polarization is selected.", (IBusinessObject)businessObject));
            }
            for (n2 = 0; n2 < 4; ++n2) {
                ScienceSpectralWindow[] scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindowGroup(n2);
                if (this.verifyTotalFraction(scienceSpectralWindowArray)) continue;
                n = n2 + 1;
                problemListModel.add(DefaultProblem.createError("Baseband-" + n + ": The sum of fractions for all spectral windows must be equal to or less than 1", "Delete or modify the windows in the baseband", (IBusinessObject)businessObject));
            }
            if (AlmaCapabilities.getInstance().getMaxNumberSw() == 4) {
                for (n2 = 0; n2 < 4; ++n2) {
                    int n3 = spectralSetupParameters.getScienceSpectralWindowCount(n2);
                    n = n2 + 1;
                    if (n3 <= 1) continue;
                    problemListModel.add(DefaultProblem.createError("Baseband-" + n + ": A maximum of one spectral window is allowed per baseband", "Delete excess spectral windows from baseband " + n, (IBusinessObject)businessObject));
                }
            }
        }
    }

    private void validateVLBISpectralLineConfigurations(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull SpectralSetupParameters spectralSetupParameters) {
        ScienceSpectralWindow[] scienceSpectralWindowArray;
        Optional<ScienceSpectralWindow> optional;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (!VLBIExpert.isScienceGoalLegalVLBISpectralLine(spectralSetupParameters.getScienceGoal())) {
            return;
        }
        ScienceSpectralWindow[] scienceSpectralWindowArray2 = spectralSetupParameters.getAbstractScienceSpectralWindowScienceSpectralWindow();
        int n = 0;
        while (n < 4) {
            int n2 = n++;
            optional = Stream.of(scienceSpectralWindowArray2).filter(scienceSpectralWindow -> scienceSpectralWindow.getGroupIndex() == n2).findFirst();
            if (!optional.isEmpty()) continue;
            Problem problem = DefaultProblem.createError("Spectral-line VLBI requires a spw in each baseband", "If not required scientifically, TDM spws are useful for calibration", (IBusinessObject)businessObject);
            problemListModel.add(problem);
            return;
        }
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        if (receiverBand != null && ReceiverBand.isReceiverBandInSet(receiverBand, 1, 3) && (scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralWindowGroup(0)).length > 0 && scienceSpectralWindowArray[0].getCorrConfigMode().getMode() != 52) {
            optional = DefaultProblem.createError("The correlator mode for the SPW in baseband 1 is incompatible with VLBI", "Please select the VLBI correlator mode for the SPW in baseband 1", (IBusinessObject)businessObject);
            problemListModel.add((Problem)((Object)optional));
        }
        if (receiverBand != null && ReceiverBand.isReceiverBandInSet(receiverBand, 6, 7) && Stream.of(spectralSetupParameters.getScienceSpectralWindow()).noneMatch(scienceSpectralWindow -> scienceSpectralWindow.getCorrConfigMode().getMode() == 52)) {
            Problem problem = DefaultProblem.createError("None of the SPWs are VLBI compatible", "Ensure that at least one spectral window uses a VLBI compatible correlator mode", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }

    private void validateRepresentativeAttributes(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters, SpectralSetupParameters.SpectralSetupTypeChoice spectralSetupTypeChoice) {
        if (SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE == spectralSetupTypeChoice || SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM == spectralSetupTypeChoice) {
            ScienceSpectralWindow scienceSpectralWindow = spectralSetupParameters.getRepresentativeSpectralWindow();
            if (scienceSpectralWindow == null) {
                Problem problem = DefaultProblem.createError("There is no Representative Window set", "Please select a representative spectral window.", (IBusinessObject)businessObject);
                problemListModel.add(problem);
            } else {
                FrequencyRange frequencyRange;
                Frequency frequency = spectralSetupParameters.getRepresentativeFrequency();
                ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal();
                if (spectralSetupParameters.isSingleContinuumSkyFrequency() || spectralSetupParameters.isSpectralScan() || VLBIExpert.isScienceGoalLegalVLBISpectralLine(scienceGoal)) {
                    Frequency frequency2 = scienceSpectralWindow.getCorrConfigMode().getEffectiveBandwidth();
                    frequencyRange = FrequencyRange.centredOn(frequency, frequency2);
                } else {
                    frequencyRange = new FrequencyRange(scienceSpectralWindow.minInRest(), scienceSpectralWindow.maxInRest());
                }
                if (!frequencyRange.contains(frequency)) {
                    Problem problem = DefaultProblem.createError("Representative frequency is outside the range of the representative spectral window.", "Enter a new representative frequency that is inside the range of the representative spectral window.", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            }
        }
    }

    private void validateVLBISpectralSetup(SpectralSetupParameters spectralSetupParameters, ProblemListModel problemListModel) {
        ReceiverBand receiverBand;
        if (spectralSetupParameters.isSpectralScan()) {
            Problem problem = DefaultProblem.createError("Spectral scans are not possible with VLBI", "Create a valid VLBI spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
            return;
        }
        try {
            receiverBand = ReceiverBand.getReceiverBand(spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Problem problem = DefaultProblem.createError("Invalid spectral setup for VLBI", "Create a valid VLBI spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
            return;
        }
        List<Frequency> list = null;
        try {
            list = AlmaCapabilities.getInstance().getVLBISPWCentralFrequencies(receiverBand.getNumber());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Problem problem = DefaultProblem.createError("Incompatible receiver band selected for VLBI", "Create a valid VLBI spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
            return;
        }
        for (int i = 0; i < spectralSetupParameters.getAbstractScienceSpectralWindow().length; ++i) {
            Frequency frequency = spectralSetupParameters.getAbstractScienceSpectralWindow()[i].getCenterFrequency();
            boolean bl = false;
            for (Frequency frequency2 : list) {
                if (!frequency.isEqual((AbstractDoubleWithUnit)frequency2, 1.0E-6)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            problemListModel.add(DefaultProblem.createWarning("SPW central frequencies vary from the VLBI default frequencies for this band", "Adjust your spectral setup if that is not your intention", (IBusinessObject)spectralSetupParameters));
            break;
        }
    }

    private void validateSolarSpectralSetup(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull ProblemListModel problemListModel) {
        Object object;
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (!spectralSetupParameters.isSingleContinuum()) {
            object = DefaultProblem.createError("Solar spectral setup should be continuum", "Select a valid solar spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add((Problem)object);
        }
        object = ReceiverBand.getReceiverBand(spectralSetupParameters.getRepresentativeFrequencyWithSkyOffset());
        Set<Frequency> set = null;
        switch (((ReceiverBand)object).getNumber()) {
            case 3: {
                set = Set.of(Frequency.createFrequencyGHZ(107.0), Frequency.createFrequencyGHZ(105.0), Frequency.createFrequencyGHZ(95.0), Frequency.createFrequencyGHZ(93.0));
                break;
            }
            case 5: {
                set = Set.of(Frequency.createFrequencyGHZ(191.0), Frequency.createFrequencyGHZ(193.0), Frequency.createFrequencyGHZ(203.0), Frequency.createFrequencyGHZ(205.0));
                break;
            }
            case 6: {
                set = Set.of(Frequency.createFrequencyGHZ(230.0), Frequency.createFrequencyGHZ(232.0), Frequency.createFrequencyGHZ(246.0), Frequency.createFrequencyGHZ(248.0));
                break;
            }
            case 7: {
                set = Set.of(Frequency.createFrequencyGHZ(339.6), Frequency.createFrequencyGHZ(341.6), Frequency.createFrequencyGHZ(351.6), Frequency.createFrequencyGHZ(353.6));
                break;
            }
            default: {
                throw new RuntimeException("Unable to process solar frequencies in band " + ((ReceiverBand)object).getNumber());
            }
        }
        assert (set != null);
        boolean bl = false;
        for (AbstractScienceSpectralWindow abstractScienceSpectralWindow : spectralSetupParameters.getAbstractScienceSpectralWindow()) {
            bl = false;
            for (Frequency frequency : set) {
                if (!abstractScienceSpectralWindow.getCenterFrequency().isEqual((AbstractDoubleWithUnit)frequency, 1.0E-9)) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        if (!bl) {
            Problem problem = DefaultProblem.createError("Invalid SPW central frequencies for Solar", "Select a valid solar spectral setup", (IBusinessObject)spectralSetupParameters);
            problemListModel.add(problem);
        }
        if (spectralSetupParameters.isFullPolarisation()) {
            this.validateFullPolarizationCompatibleWithBand(spectralSetupParameters, problemListModel);
        }
    }

    private void validateFullPolarizationCompatibleWithBand(@NonNull SpectralSetupParameters spectralSetupParameters, @NonNull ProblemListModel problemListModel) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        if (receiverBand == null) {
            return;
        }
        int n = receiverBand.getNumber();
        boolean bl = AlmaCapabilities.getInstance().getSolarBands().stream().anyMatch(solarBand -> solarBand.isIsFullPolarizationEnabled() && solarBand.getBand() == n);
        if (!bl) {
            problemListModel.add(DefaultProblem.createError("Band " + n + " not compatible with full polarization and Solar", "Select band which is compatible with full polarization", (IBusinessObject)spectralSetupParameters));
        }
    }

    private boolean verifyTotalFraction(ScienceSpectralWindow[] scienceSpectralWindowArray) {
        int n = 0;
        for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
            try {
                n += scienceSpectralWindow.getFraction().getUnits();
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return n <= 32;
    }

    private void validateWalshSwitching(BusinessObject businessObject, ProblemListModel problemListModel, SpectralSetupParameters spectralSetupParameters) {
        ScienceSpectralWindow[] scienceSpectralWindowArray;
        Object object;
        if (!spectralSetupParameters.isWalshSwitching()) {
            return;
        }
        ReceiverBand receiverBand = spectralSetupParameters.getReceiverBand();
        if (receiverBand == null) {
            Problem problem = DefaultProblem.createError("Unable to determine receiver band", "Please revise your setup.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
            return;
        }
        if (!ReceiverBand.isReceiverBandInSet(receiverBand, 9, 10)) {
            object = DefaultProblem.createError("Walsh switching is enabled but is incompatible with receiver band", "90-deg Walsh switching is only comptible with B9 and B10", (IBusinessObject)businessObject);
            problemListModel.add((Problem)object);
        }
        object = Frequency.createFrequencyMHZ(1875.0);
        if (spectralSetupParameters.isSpectralScan() && !(scienceSpectralWindowArray = spectralSetupParameters.getScienceSpectralScan(0)).getEffectiveBandwidth().isEqual((AbstractDoubleWithUnit)object)) {
            Problem problem = DefaultProblem.createError("The bandwidth is incompatible with 90-degree Walsh switching.", "Set the spectral scan bandwidth to 1875 MHz.", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
        if (spectralSetupParameters.isSpectralLine()) {
            for (ScienceSpectralWindow scienceSpectralWindow : spectralSetupParameters.getScienceSpectralWindow()) {
                if (scienceSpectralWindow.getEffectiveBandwidth().isEqual((AbstractDoubleWithUnit)object)) continue;
                Problem problem = DefaultProblem.createError("The bandwidth is incompatible with 90-degree Walsh switching.", "Set the bandwidth to 1875 MHz for window " + scienceSpectralWindow.getTransitionName(), (IBusinessObject)businessObject);
                problemListModel.add(problem);
            }
        }
    }

    private void validateSPWSNotTooCloseToBasebandEdge(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel, @NonNull SpectralSetupParameters spectralSetupParameters) throws UnableToValidateSSPException {
        Object object2;
        List<SchedBlock> list;
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        if (!spectralSetupParameters.isSpectralLine()) {
            return;
        }
        boolean bl = false;
        for (ScienceSpectralWindow object22 : spectralSetupParameters.getScienceSpectralWindow()) {
            if (!object22.getBandwidth().isLessThan((AbstractDoubleWithUnit)Frequency.createFrequencyGHZ(2.0))) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        ScienceGoal scienceGoal = spectralSetupParameters.getScienceGoal();
        if (scienceGoal == null) {
            Log.logger(SpectralSetupParametersValidator.class).warning("Unable to determine the science goal associated with the SSP");
            return;
        }
        int n = Objects.hash(scienceGoal.toXml());
        ObsUnitSet obsUnitSet = (ObsUnitSet)sbOutputCache.get((Object)n);
        if (obsUnitSet == null) {
            obsUnitSet = ObsUnitSet.createObsUnitSet();
            ScienceGoalSchedBlockGenerator scienceGoalSchedBlockGenerator = new ScienceGoalSchedBlockGenerator(scienceGoal, obsUnitSet, false);
            try {
                scienceGoalSchedBlockGenerator.generate();
            }
            catch (WizardSBGenerationException wizardSBGenerationException) {
                Log.logger(SpectralSetupParametersValidator.class).warning("Unable to generate SBs: " + wizardSBGenerationException.getMessage());
                return;
            }
            sbOutputCache.put((Object)n, (Object)obsUnitSet);
        }
        ObsUnitSet obsUnitSet2 = obsUnitSet.getObsUnitSet(0).getObsUnitSet(0);
        Array array = scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M;
        try {
            list = obsUnitSet2.findSchedBlocks();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(SpectralSetupParametersValidator.class).warning("Unable to find SBs after Sb generation");
            return;
        }
        Optional<Object> optional = Optional.empty();
        block9: for (Object object2 : list) {
            switch (array) {
                case ARRAY_7M: {
                    if (!object2.isACA7mArraySB()) continue block9;
                    optional = Optional.of(object2);
                    break;
                }
                case ARRAY_12M: {
                    if (!object2.is12mExtendedArraySB()) continue block9;
                    optional = Optional.of(object2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Can only deal with the ACA 7-m and the 12-m array types");
                }
            }
            if (!optional.isPresent()) continue;
            break;
        }
        if (!optional.isPresent()) {
            Log.logger(SpectralSetupParametersValidator.class).warning("Unable to find the SB for the array that we are look for: " + array);
            return;
        }
        List<Target> list2 = ((SchedBlock)optional.get()).getAllTargets(ScienceParameters.scienceParametersFilter);
        object2 = Frequency.createFrequencyMHZ(list2.stream().map(target -> target.getFieldSource().getTargetParameters()).mapToDouble(SpectralSetupParametersValidator::getLineWidthInMHz).max().orElseThrow(UnableToValidateSSPException::new));
        this.validateSBForBasebandEdgeInfringements(businessObject, problemListModel, (SchedBlock)optional.get(), (Frequency)((Object)object2));
    }

    public static synchronized double getLineWidthInMHz(TargetParameters targetParameters) {
        return targetParameters.getExpectedProperties().getExpectedLineWidth().getContentInMHz();
    }

    private boolean validateSBForBasebandEdgeInfringements(BusinessObject businessObject, ProblemListModel problemListModel, SchedBlock schedBlock, Frequency frequency) throws UnableToValidateSSPException {
        boolean bl = false;
        List<Target> list = schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter);
        HashSet<SpectralSpec> hashSet = new HashSet<SpectralSpec>();
        for (Target target : list) {
            SpectralSpec spectralSpec = target.getSpectralSpec();
            if (hashSet.contains(spectralSpec)) continue;
            hashSet.add(spectralSpec);
            bl = SpectralSpecValidator.validateBasebandEdgeInfringementbySPWs(businessObject, problemListModel, frequency, spectralSpec, true);
        }
        return bl;
    }

    public static class UnableToValidateSSPException
    extends Exception {
    }

    class ImageSPWPoorTransmissionRecord {
        private Frequency imageSPWSky;
        private Velocity sourceVelocity;
        private int noOfTargetsInPoorTransmission = 1;

        public Frequency getImageSPWSky() {
            return this.imageSPWSky;
        }

        public Velocity getSourceVelocity() {
            return this.sourceVelocity;
        }

        public int getNoOfTargetsInPoorTransmission() {
            return this.noOfTargetsInPoorTransmission;
        }

        public void setImageSPWSky(Frequency frequency) {
            this.imageSPWSky = frequency;
        }

        public void setSourceVelocity(Velocity velocity) {
            this.sourceVelocity = velocity;
        }

        public void setNoOfTargetsInPoorTransmission(int n) {
            this.noOfTargetsInPoorTransmission = n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ImageSPWPoorTransmissionRecord)) {
                return false;
            }
            ImageSPWPoorTransmissionRecord imageSPWPoorTransmissionRecord = (ImageSPWPoorTransmissionRecord)object;
            if (!imageSPWPoorTransmissionRecord.canEqual(this)) {
                return false;
            }
            if (this.getNoOfTargetsInPoorTransmission() != imageSPWPoorTransmissionRecord.getNoOfTargetsInPoorTransmission()) {
                return false;
            }
            Frequency frequency = this.getImageSPWSky();
            Frequency frequency2 = imageSPWPoorTransmissionRecord.getImageSPWSky();
            if (frequency == null ? frequency2 != null : !((Object)((Object)frequency)).equals((Object)frequency2)) {
                return false;
            }
            Velocity velocity = this.getSourceVelocity();
            Velocity velocity2 = imageSPWPoorTransmissionRecord.getSourceVelocity();
            return !(velocity == null ? velocity2 != null : !((Object)((Object)velocity)).equals((Object)velocity2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof ImageSPWPoorTransmissionRecord;
        }

        public int hashCode() {
            int n = 1;
            n = n * 59 + this.getNoOfTargetsInPoorTransmission();
            Frequency frequency = this.getImageSPWSky();
            n = n * 59 + (frequency == null ? 43 : ((Object)((Object)frequency)).hashCode());
            Velocity velocity = this.getSourceVelocity();
            n = n * 59 + (velocity == null ? 43 : ((Object)((Object)velocity)).hashCode());
            return n;
        }

        public String toString() {
            return "SpectralSetupParametersValidator.ImageSPWPoorTransmissionRecord(imageSPWSky=" + this.getImageSPWSky() + ", sourceVelocity=" + this.getSourceVelocity() + ", noOfTargetsInPoorTransmission=" + this.getNoOfTargetsInPoorTransmission() + ")";
        }

        public ImageSPWPoorTransmissionRecord(Frequency frequency, Velocity velocity, int n) {
            this.imageSPWSky = frequency;
            this.sourceVelocity = velocity;
            this.noOfTargetsInPoorTransmission = n;
        }
    }
}

