/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.obsproposal;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsattachment.DocumentLink;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.JointProposal;
import alma.obsprep.bo.obsproposal.JointProposalPartner;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateInterface;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.obsproject.ObsProjectValidationUtils;
import alma.obsprep.ot.valdef.obsproposal.CalculateHowMuchTextTooSmallTextExtractionStrategy;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Time;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.PdfTextExtractor;
import com.itextpdf.text.pdf.parser.TextExtractionStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ObsProposalValidator
extends AbstractValidator {
    private static Time MAX_ALLOWED_PROPOSAL_TIME;
    private static int MAX_ABSTRACT_CHARACTERS;
    private static int MAX_DUPLICATION_TEXTAREA_CHARACTERS;
    private static int MAX_SCIENCECASE_PAGES;
    private static int MAX_MANAGEMENT_PLAN_PAGES;
    private static int MAX_SCIENCE_GOALS;
    private static int MAX_TOTAL_SOURCES;
    private static int MAX_NUMBER_POINTINGS;
    private static Time MIN_LARGE_PROGRAM_TIME_TWELVEM;
    private static int MAX_LARGEPROGRAM_SCIENCECASE_PAGES;
    private static Time MIN_LARGE_PROGRAM_TIME_SACA;
    private static final int MIN_FONT_SIZE = 12;
    private static final int MAX_PCT_OF_SMALLER_TEXT = 15;
    private static final int MIN_KEYWORDS = 1;
    private static final int MAX_KEYWORDS = 2;
    private static final int MAX_TITLE_LENGTH = 120;

    public static void refreshLimits() {
        AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
        MAX_ALLOWED_PROPOSAL_TIME = almaPolicies.getMaxStandardProposalTime();
        MAX_ABSTRACT_CHARACTERS = almaPolicies.getMaxAbstractCharacters();
        MAX_DUPLICATION_TEXTAREA_CHARACTERS = almaPolicies.getMaxTextAreaCharacters();
        MAX_SCIENCECASE_PAGES = almaPolicies.getMaxScienceCasePages();
        MAX_LARGEPROGRAM_SCIENCECASE_PAGES = almaPolicies.getMaxScienceCasePagesForLargeProgram();
        MAX_MANAGEMENT_PLAN_PAGES = almaPolicies.getMaxManagementPlanPages();
        MAX_SCIENCE_GOALS = almaPolicies.getMaxScienceGoals();
        MAX_TOTAL_SOURCES = almaPolicies.getMaxSourcesPerGoal() * MAX_SCIENCE_GOALS;
        MAX_NUMBER_POINTINGS = almaPolicies.getMaxNumberPointings();
        MIN_LARGE_PROGRAM_TIME_TWELVEM = almaPolicies.getMinLargeProgramTimeNoACA();
        MIN_LARGE_PROGRAM_TIME_SACA = almaPolicies.getMinLargeProgramTimeWithSACA();
    }

    @Override
    public void localValidate(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (!(businessObject instanceof ObsProposal)) {
            problemListModel.add(DefaultProblem.createError("ObsProposal validator asked to validate object which is not an ObsProposal", "Report this to your support centre", (IBusinessObject)businessObject));
            return;
        }
        ObsProposal obsProposal = (ObsProposal)businessObject;
        ObsProject obsProject = null;
        try {
            obsProject = obsProposal.getObsProject();
        }
        catch (UnknownEntityException unknownEntityException) {
            problemListModel.add(DefaultProblem.createError("Cannot find the containing project!", "Report this to your support centre", (IBusinessObject)businessObject));
            return;
        }
        if (obsProject == null) {
            return;
        }
        if (obsProject.isPhase1Project()) {
            this.checkAbstractAndMiscellaneous(obsProposal, problemListModel);
            this.checkDocuments(obsProposal, problemListModel);
            this.checkTime(obsProposal, problemListModel);
            this.checkKeywords(obsProposal, problemListModel);
            this.checkInvestigatorConstraints(obsProposal, problemListModel);
            this.checkProposalTitleLength(obsProposal, problemListModel);
            this.checkSolarNotUsedWithVLBIorPhasedArray(obsProposal, problemListModel);
            if (obsProject.isDPRRequired()) {
                this.validateDPRProposal(obsProposal, problemListModel);
            }
            try {
                this.validateJointProposals(obsProposal, problemListModel);
            }
            catch (TimeEstimateInterface.UnableToGenerateTimeEstimateException | InvalidObsProgramParametersException exception) {
                exception.getMessage();
            }
        }
    }

    private void validateJointProposals(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException, InvalidObsProgramParametersException {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        JointProposal jointProposal = obsProposal.getJointProposal();
        if (jointProposal == null) {
            return;
        }
        if (jointProposal.isMainJointProposal()) {
            this.validateMainJointProposals(obsProposal, jointProposal, problemListModel);
        } else if (jointProposal.isPartnerJointProposal()) {
            this.validatePartnerJointProposals(obsProposal, jointProposal, problemListModel);
        }
    }

    private void validatePartnerJointProposals(@NonNull ObsProposal obsProposal, @NonNull JointProposal jointProposal, @NonNull ProblemListModel problemListModel) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (jointProposal == null) {
            throw new NullPointerException("jointProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        Optional<Object> optional = Optional.empty();
        for (JointProposalPartner jointProposalPartnerArray : jointProposal.getJointProposalPartner()) {
            if (jointProposalPartnerArray.getIsMainObservatory()) {
                optional = Optional.of(jointProposalPartnerArray);
                if (jointProposalPartnerArray.getRequestedTime() != null && !jointProposalPartnerArray.getRequestedTime().isZero()) continue;
                problemListModel.add(DefaultProblem.createError("The requested time for the main observatory " + jointProposalPartnerArray.getObservatory() + " must be a positive number", "Select Proposal node and enter a valid value", (IBusinessObject)obsProposal));
                continue;
            }
            if (jointProposalPartnerArray.getRequestedTime() != null && !jointProposalPartnerArray.getRequestedTime().isZero()) continue;
            problemListModel.add(DefaultProblem.createError("The requested time for the partner observatory " + jointProposalPartnerArray.getObservatory() + " must be a positive number", "Select Proposal node and enter a valid value", (IBusinessObject)obsProposal));
        }
        if (optional.isEmpty()) {
            problemListModel.add(DefaultProblem.createError("No main observatory selected", "Select Proposal node and select the Main Observatory", (IBusinessObject)obsProposal));
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (JointProposalPartner jointProposalPartner : jointProposal.getJointProposalPartner()) {
            if (!jointProposalPartner.getIsMainObservatory()) continue;
            optional = Optional.of(jointProposalPartner);
            for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
                if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
                ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                if (scienceGoal.isStandAloneACA()) {
                    if (!jointProposalPartner.getRequestedTime().isLessThan((AbstractDoubleWithUnit)obsProposal.getTotalRequestedTime(Array.ARRAY_7M, true)) || ++n != obsProposal.getAbstractScienceGoalScienceGoalCount()) continue;
                    n2 = 1;
                    continue;
                }
                if (!jointProposalPartner.getRequestedTime().isLessThan((AbstractDoubleWithUnit)obsProposal.getTotalRequestedTime(Array.ARRAY_12M, false))) continue;
                n3 = 1;
            }
        }
        if (n2 != 0 || n3 != 0) {
            problemListModel.add(DefaultProblem.createWarning("The requested ALMA time exceeds the time requested at main Observatory.", "Please revisit your inputs in Control and Performance.", (IBusinessObject)obsProposal));
        }
    }

    private void validateMainJointProposals(@NonNull ObsProposal obsProposal, @NonNull JointProposal jointProposal, @NonNull ProblemListModel problemListModel) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (jointProposal == null) {
            throw new NullPointerException("jointProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (jointProposal.getJointProposalPartnerCount() == 0) {
            problemListModel.add(DefaultProblem.createError("No Partner Observatory selected", "Select Proposal node and select at least one Partner Observatory", (IBusinessObject)obsProposal));
        }
        for (JointProposalPartner object : jointProposal.getJointProposalPartner()) {
            if (object.getRequestedTime() != null && !object.getRequestedTime().isZero()) continue;
            problemListModel.add(DefaultProblem.createError("The time estimate for the " + object.getObservatory() + " partner observatory must be a positive number", "Select Proposal node and enter a valid value", (IBusinessObject)obsProposal));
        }
        for (JointProposalPartner jointProposalPartner : jointProposal.getJointProposalPartner()) {
            if (jointProposalPartner.getJustification() != null && jointProposalPartner.getJustification().length() >= 50) continue;
            problemListModel.add(DefaultProblem.createError("The justification for the " + jointProposalPartner.getObservatory() + " partner observatory must be at least 50 characters long", "Select Proposal node and edit the text", (IBusinessObject)obsProposal));
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (JointProposalPartner jointProposalPartner : jointProposal.getJointProposalPartner()) {
            for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
                if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
                ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                if (scienceGoal.isStandAloneACA()) {
                    if (!jointProposalPartner.getRequestedTime().isGreaterThan((AbstractDoubleWithUnit)obsProposal.getTotalRequestedTime(Array.ARRAY_7M, true)) || ++n != obsProposal.getAbstractScienceGoalScienceGoalCount()) continue;
                    n2 = 1;
                    continue;
                }
                if (!jointProposalPartner.getRequestedTime().isGreaterThan((AbstractDoubleWithUnit)obsProposal.getTotalRequestedTime(Array.ARRAY_12M, false))) continue;
                n3 = 1;
            }
        }
        if (n2 != 0 || n3 != 0) {
            problemListModel.add(DefaultProblem.createError("The requested time at one of the partner observatories exceeds the time requested at ALMA.", "Please edit the Partner Observatory requested time or revisit your inputs for the ALMA proposal.", (IBusinessObject)obsProposal));
        }
    }

    private void checkSolarNotUsedWithVLBIorPhasedArray(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (!obsProposal.isVLBIorPhasedArray()) {
            return;
        }
        Stream.of(obsProposal.getAbstractScienceGoalScienceGoal()).filter(scienceGoal -> {
            for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                if (!targetParameters.getNonSiderealMotion() || !targetParameters.getSolarSystemObject().equals(TargetParameters.SOLARSYSTEMOBJECT_SUN)) continue;
                return true;
            }
            return false;
        }).findFirst().ifPresent(scienceGoal -> problemListModel.add(DefaultProblem.createError("Solar is not allowed with VLBI/Phased Array", "Either select a different field source or Proposal Type", (IBusinessObject)scienceGoal)));
    }

    private void validateDPRProposal(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsProposal.gettrueReviewer() == null || obsProposal.getReviewer() == null || StringUtils.isEmpty((CharSequence)obsProposal.getReviewer().getUserId())) {
            problemListModel.add(DefaultProblem.createError("No reviewer has been defined", "Please select a reviewer from the list of investigators", (IBusinessObject)obsProposal));
            return;
        }
        Investigator investigator = obsProposal.getReviewer();
        boolean bl = false;
        Investigator investigator2 = obsProposal.getPrincipalInvestigator();
        if (investigator2 == null) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = investigator2.getUserId().equals(investigator.getUserId());
        if (bl4) {
            bl = true;
        } else {
            for (Investigator investigator3 : obsProposal.getCoInvestigator()) {
                if (!investigator3.getUserId().equals(investigator.getUserId())) continue;
                bl = true;
                bl2 = true;
                break;
            }
            if (!bl) {
                for (Investigator investigator3 : obsProposal.getCoPrincipalInvestigator()) {
                    if (!investigator3.getUserId().equals(investigator.getUserId())) continue;
                    bl = true;
                    bl3 = true;
                    break;
                }
            }
        }
        if (!bl) {
            problemListModel.add(DefaultProblem.createError("No reviewer has been defined", "Please select a reviewer from the list of investigators", (IBusinessObject)obsProposal));
            return;
        }
        boolean bl5 = investigator.getHasPhD();
        int n = 0;
        if (!bl5 && !bl4) {
            problemListModel.add(DefaultProblem.createError("A reviewer who is not the PI must have a PhD", "Either select another co-I with a PhD or the PI", (IBusinessObject)obsProposal));
            n = 1;
        }
        if (!bl5) {
            if (!(bl3 || bl2 || obsProposal.gettrueMentor() != null && obsProposal.getMentor() != null && !StringUtils.isEmpty((CharSequence)obsProposal.getMentor().getUserId()))) {
                problemListModel.add(DefaultProblem.createError("No mentor has been defined", "Please select a mentor (must be a registered ALMA user)", (IBusinessObject)obsProposal));
            }
            Investigator investigator4 = obsProposal.getMentor();
            if (investigator.getUserId().equals(investigator4.getUserId())) {
                problemListModel.add(DefaultProblem.createError("The reviewer and mentor must be different people", "Please select a different reviewer or mentor", (IBusinessObject)obsProposal));
            }
            if (n == 0 && !investigator4.getHasPhD()) {
                problemListModel.add(DefaultProblem.createError("Neither the reviewer or mentor have a PhD", "Please select a reviewer or mentor with a PhD", (IBusinessObject)obsProposal));
            }
        }
    }

    private void checkInvestigatorConstraints(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (!obsProposal.isLargeProgram() && obsProposal.getCoPrincipalInvestigatorCount() > 0) {
            problemListModel.add(DefaultProblem.createError("CoPIs are not allowed unless a Large Program is specified", "Remove the CoPIs from the proposal", (IBusinessObject)obsProposal));
        }
    }

    void checkAbstractAndMiscellaneous(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel) {
        AbstractScienceGoal[] abstractScienceGoalArray;
        int n;
        String string;
        String string2;
        String string3;
        int n2;
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        String string4 = obsProposal.getDuplicateObservationsJustification();
        int n3 = string4.length();
        if (n3 > MAX_DUPLICATION_TEXTAREA_CHARACTERS) {
            problemListModel.add(DefaultProblem.createError("The justification for a duplicate observation contains too many characters (" + n3 + ")", "Select the proposal node in the Proposal tab and edit the justification for a duplicate observation (max " + MAX_DUPLICATION_TEXTAREA_CHARACTERS + " characters)", (IBusinessObject)obsProposal));
        }
        if ((n2 = (string3 = obsProposal.getAbstract()).length()) > MAX_ABSTRACT_CHARACTERS) {
            problemListModel.add(DefaultProblem.createError("Abstract contains too many characters (" + n2 + ")", "Select the proposal node in the Proposal tab and edit your abstract (max " + MAX_ABSTRACT_CHARACTERS + " characters)", (IBusinessObject)obsProposal));
        }
        if (string3.isEmpty() || string3.length() == 0) {
            problemListModel.add(DefaultProblem.createError("Abstract appears to be empty", "Select the proposal node in the Proposal tab and edit your abstract", (IBusinessObject)obsProposal));
        }
        if ((string2 = obsProposal.getScientificCategoryCode()) == null || string2.equals("0") || obsProposal.getScientificCategoryString().equals("")) {
            problemListModel.add(DefaultProblem.createError("No scientific category defined", "Select Proposal node and set a scientific category", (IBusinessObject)obsProposal));
        }
        if ((string = obsProposal.getProposalTypeCode()) == null || string.equals("-") || obsProposal.getProposalTypeString().equals("")) {
            problemListModel.add(DefaultProblem.createError("No proposal type defined", "Select Proposal node and set a proposal type", (IBusinessObject)obsProposal));
        }
        if ((n = obsProposal.getAbstractScienceGoalCount()) == 0) {
            problemListModel.add(DefaultProblem.createError("This proposal contains no Science Goals", "Select the Planned Observing node in the Proposal tab and add science goals", (IBusinessObject)obsProposal));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (AbstractScienceGoal abstractScienceGoal : abstractScienceGoalArray = obsProposal.getAbstractScienceGoal()) {
            try {
                ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                String object = scienceGoal.getName().trim();
                if (hashSet.contains(object)) {
                    problemListModel.add(DefaultProblem.createError("This proposal already contains a science goal labelled " + object, "Please change the name of the science goal.", (IBusinessObject)obsProposal));
                    continue;
                }
                hashSet.add(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (MAX_SCIENCE_GOALS > 0) {
            if (n > MAX_SCIENCE_GOALS) {
                problemListModel.add(DefaultProblem.createError("This proposal contains too many Science Goals (maximum number is " + MAX_SCIENCE_GOALS + ")", "Select the Planned Observing node in the Proposal tab and remove some science goals", (IBusinessObject)obsProposal));
            }
            int n4 = 0;
            int n5 = 0;
            for (AbstractScienceGoal abstractScienceGoal : abstractScienceGoalArray) {
                try {
                    ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                    n4 += scienceGoal.getTargetParametersCount();
                    for (TargetParameters targetParameters : scienceGoal.getTargetParameters()) {
                        if (targetParameters.isRectanglePattern()) {
                            for (Rectangle rectangle : targetParameters.getFieldRectangle()) {
                                n5 += rectangle.getNumberOfPointings(scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M);
                            }
                            continue;
                        }
                        if (!targetParameters.isPointingPattern()) continue;
                        n5 += targetParameters.getNumberOfPointings(scienceGoal.isStandAloneACA() ? Array.ARRAY_7M : Array.ARRAY_12M);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n4 > MAX_TOTAL_SOURCES) {
                problemListModel.add(DefaultProblem.createError("This proposal contains too many Sources (maximum number is " + MAX_TOTAL_SOURCES + ")", "Remove some sources from your science goals", (IBusinessObject)obsProposal));
            }
            if (n5 > MAX_NUMBER_POINTINGS) {
                problemListModel.add(DefaultProblem.createError("Your science goals contain too many pointings in total (limit is " + MAX_NUMBER_POINTINGS + ")", "Try reducing the map sizes or increasing spacing in your science goals", (IBusinessObject)obsProposal));
            }
        }
    }

    void checkDocuments(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel) {
        if (obsProposal == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        obsProposal.resetAttentionFlag();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = obsProposal.isLargeProgram();
        try {
            ObsAttachment obsAttachment = obsProposal.getDocuments();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (obsAttachment != null) {
                for (DocumentLink documentLink : obsAttachment.getDocumentLink()) {
                    this.isAttachmentFileTypeValid(obsProposal, problemListModel, documentLink);
                    for (String string : arrayList) {
                        if (!documentLink.getFileName().equals(string)) continue;
                        bl2 = true;
                    }
                    arrayList.add(documentLink.getFileName());
                    String string = documentLink.getDocumentClass();
                    if (string.equals(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE)) {
                        bl = true;
                        this.checkScienceCaseAttachment(obsProposal, problemListModel, obsAttachment);
                    }
                    if (!string.equals(DocumentLink.DOCUMENTCLASS_MANAGEMENT_PLAN) || !(bl3 = true)) continue;
                    this.checkManagementPlanAttachment(obsProposal, problemListModel, obsAttachment);
                }
                if (bl2) {
                    problemListModel.add(DefaultProblem.createError("Duplicate filenames found", "Select the proposal node in the Proposal tab and check the names of your attached files", (IBusinessObject)obsProposal));
                }
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        if (!bl) {
            problemListModel.add(DefaultProblem.createError("No document found - you must add a Science Case to your proposal", "Select the proposal node in the Proposal tab and add your document", (IBusinessObject)obsProposal));
        }
        if (!bl3 && bl4) {
            problemListModel.add(DefaultProblem.createError("No document found - you must add a Management Plan to your Large Program", "Select the proposal node in the Proposal tab and add a management plan", (IBusinessObject)obsProposal));
        }
    }

    void isAttachmentFileTypeValid(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel, @NonNull DocumentLink documentLink) {
        if (obsProposal == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (documentLink == null) {
            throw new NullPointerException("documentLink is marked non-null but is null");
        }
        String string = documentLink.getFileType();
        boolean bl = true;
        for (String string2 : DocumentLink.getKnownFileTypeList()) {
            if (!string.equals(string2)) continue;
            bl = false;
        }
        if (bl) {
            problemListModel.add(DefaultProblem.createError("Bad document type (" + documentLink.getFileName() + "): Only files of type +" + Arrays.asList(DocumentLink.getKnownFileTypeList()) + " are accepted", "Select the proposal node in the Proposal tab and attach a file of the correct type", (IBusinessObject)obsProposal));
        }
    }

    private void checkManagementPlanAttachment(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel, @NonNull ObsAttachment obsAttachment) {
        if (obsProposal == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsAttachment == null) {
            throw new NullPointerException("docs is marked non-null but is null");
        }
        try {
            Object object;
            File file = obsAttachment.getDocumentLink(DocumentLink.DOCUMENTCLASS_MANAGEMENT_PLAN).getTemporaryFileToView();
            PdfReader pdfReader = new PdfReader((InputStream)new FileInputStream(file));
            int n = pdfReader.getNumberOfPages();
            int n2 = MAX_MANAGEMENT_PLAN_PAGES;
            if (n > n2) {
                object = String.format("Maximum number of pages allowed for the management plan is %d, while your attached document has %d pages.", n2, n);
                problemListModel.add(DefaultProblem.createError((String)object, "Select the proposal node in the Proposal tab and replace or modify your management plan", (IBusinessObject)obsProposal));
            }
            object = new CalculateHowMuchTextTooSmallTextExtractionStrategy(12);
            this.scanThroughPagesInPdf(pdfReader, n, (CalculateHowMuchTextTooSmallTextExtractionStrategy)object);
            double d = ((CalculateHowMuchTextTooSmallTextExtractionStrategy)object).getInvalidTextPercent();
            if (d > 15.0) {
                String string = String.format("Too much of the PDF text is smaller than %d point.", 12);
                problemListModel.add(DefaultProblem.createError(string, "Please update your management plan PDF. See the Proposer's Guide for more details.", (IBusinessObject)obsProposal));
                obsProposal.addForAttention(ObsProposal.AttentionReasons.SMALLTEXTINPDF);
            }
        }
        catch (IOException iOException) {
            problemListModel.add(DefaultProblem.createError("There was a problem reading your management plan", "Select the proposal node in the Proposal tab and check or replace the attached management plan", (IBusinessObject)obsProposal));
        }
    }

    void checkScienceCaseAttachment(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel, @NonNull ObsAttachment obsAttachment) {
        if (obsProposal == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsAttachment == null) {
            throw new NullPointerException("docs is marked non-null but is null");
        }
        if (obsProposal.getJointProposal() != null && obsProposal.getJointProposal().isPartnerJointProposal()) {
            return;
        }
        try {
            Object object;
            File file = obsAttachment.getDocumentLink(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE).getTemporaryFileToView();
            PdfReader pdfReader = new PdfReader((InputStream)new FileInputStream(file));
            int n = pdfReader.getNumberOfPages();
            int n2 = MAX_SCIENCECASE_PAGES;
            if (StringUtils.contains((CharSequence)obsProposal.getProposalTypeCode(), (CharSequence)"L")) {
                n2 = MAX_LARGEPROGRAM_SCIENCECASE_PAGES;
            }
            if (n > n2) {
                object = String.format("Maximum number of pages allowed for the science case is %d, while your attached case has %d pages.", n2, n);
                problemListModel.add(DefaultProblem.createError((String)object, "Select the proposal node in the Proposal tab and replace or modify your science case", (IBusinessObject)obsProposal));
            }
            object = new CalculateHowMuchTextTooSmallTextExtractionStrategy(12);
            this.scanThroughPagesInPdf(pdfReader, n, (CalculateHowMuchTextTooSmallTextExtractionStrategy)object);
            double d = ((CalculateHowMuchTextTooSmallTextExtractionStrategy)object).getInvalidTextPercent();
            if (d > 15.0) {
                String string = String.format("Too much of the PDF text is smaller than %d point.", 12);
                problemListModel.add(DefaultProblem.createError(string, "Please update your PDF. See the Proposer's Guide for more details.", (IBusinessObject)obsProposal));
                obsProposal.addForAttention(ObsProposal.AttentionReasons.SMALLTEXTINPDF);
            }
        }
        catch (IOException iOException) {
            problemListModel.add(DefaultProblem.createError("There was a problem reading your science case", "Select the proposal node in the Proposal tab and check or replace the attached science case", (IBusinessObject)obsProposal));
        }
    }

    private void scanThroughPagesInPdf(PdfReader pdfReader, int n, CalculateHowMuchTextTooSmallTextExtractionStrategy calculateHowMuchTextTooSmallTextExtractionStrategy) throws IOException {
        for (int i = 1; i <= n; ++i) {
            PdfTextExtractor.getTextFromPage((PdfReader)pdfReader, (int)i, (TextExtractionStrategy)calculateHowMuchTextTooSmallTextExtractionStrategy);
        }
    }

    void checkTime(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsProposal.isVLBIorPhasedArray()) {
            this.checkVLBIRequestedTime(obsProposal, problemListModel);
            return;
        }
        boolean bl = obsProposal.isLargeProgram();
        AbstractScienceGoal[] abstractScienceGoalArray = obsProposal.getAbstractScienceGoal();
        Time time = Time.createTimeSec(0.0);
        Time time2 = Time.createTimeSec(0.0);
        for (AbstractScienceGoal abstractScienceGoal : abstractScienceGoalArray) {
            Object object;
            try {
                Collection<ScienceGoal> collection;
                ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
                scienceGoal.setEstimatedTotalTime(Time.createTime());
                scienceGoal.setEstimated12mTime(Time.createTime());
                scienceGoal.setEstimated7mTime(Time.createTime());
                scienceGoal.setEstimatedTPTime(Time.createTime());
                scienceGoal.setEstimatedACATime(Time.createTime());
                object = new SourceClusterDetector(scienceGoal);
                try {
                    collection = ((SourceClusterDetector)object).splitScienceGoalIntoSourceClusters();
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    throw new WizardSBGenerationException(invalidObsProgramParametersException);
                }
                for (ScienceGoal scienceGoal2 : collection) {
                    Object object2;
                    PerformanceParameters performanceParameters = scienceGoal2.gettruePerformanceParameters();
                    ObservingTimeCalculator observingTimeCalculator = new ObservingTimeCalculator(scienceGoal2);
                    Time time3 = Time.createTimeSec(0.0);
                    if (!scienceGoal2.isStandAloneACA()) {
                        time3 = observingTimeCalculator.getRequestedTimeForAllConfigurations(Array.ARRAY_12M, true);
                    }
                    Time time4 = Time.createTimeSec(0.0);
                    Time time5 = Time.createTimeSec(0.0);
                    if (performanceParameters != null) {
                        object2 = AlmaCapabilities.getInstance();
                        int n = ((AlmaCapabilities)object2).getNumAntennas(Array.ARRAY_7M, scienceGoal2.getSpectralSetupParameters());
                        if (performanceParameters.gettrueUseACA() && n > 0) {
                            time4 = observingTimeCalculator.getRequestedTimeForAllConfigurations(Array.ARRAY_7M, true);
                        }
                        int n2 = ((AlmaCapabilities)object2).getNumAntennas(Array.ARRAY_TP, scienceGoal2.getSpectralSetupParameters());
                        if (performanceParameters.gettrueUseTP() && n2 > 0) {
                            time5 = observingTimeCalculator.getRequestedTimeForAllConfigurations(Array.ARRAY_TP, true);
                        }
                    }
                    Object object3 = object2 = time4.isGreaterThan((AbstractDoubleWithUnit)time5) ? time4 : time5;
                    if (scienceGoal2.isStandAloneACA()) {
                        time2.aggregate(time4);
                    } else {
                        time.aggregate(time3);
                    }
                    Time time6 = (Time)time3.plus((AbstractDoubleWithUnit)object2);
                    scienceGoal.getEstimatedTotalTime().aggregate(time6);
                    scienceGoal.getEstimated12mTime().aggregate(time3);
                    scienceGoal.getEstimated7mTime().aggregate(time4);
                    scienceGoal.getEstimatedTPTime().aggregate(time5);
                    scienceGoal.getEstimatedACATime().aggregate((Time)object2);
                }
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                object = TextUtils.stripClasspaths(invalidObsProgramParametersException.getMessage());
                problemListModel.add(DefaultProblem.createError("Unable to calculate estimated array times", "Please revise your setup: " + (String)object, (IBusinessObject)obsProposal));
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            this.performLargeProgramsValidation(obsProposal, problemListModel, time2, time);
        } else {
            this.performNonLargeProgramsValidation(obsProposal, problemListModel, time2, time);
        }
    }

    private void performNonLargeProgramsValidation(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel, @NonNull Time time, @NonNull Time time2) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (time == null) {
            throw new NullPointerException("totalSACAProjectTime is marked non-null but is null");
        }
        if (time2 == null) {
            throw new NullPointerException("total12mProjectTime is marked non-null but is null");
        }
        if (time2.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)MIN_LARGE_PROGRAM_TIME_TWELVEM)) {
            problemListModel.add(DefaultProblem.createError("12-m time is >= " + (int)MIN_LARGE_PROGRAM_TIME_TWELVEM.getContentInUnits(Time.UNIT_H) + " hours", "Either change Proposal Type to Large Program, or reduce requested time.", (IBusinessObject)obsProposal));
        }
        if (time.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)MIN_LARGE_PROGRAM_TIME_SACA)) {
            problemListModel.add(DefaultProblem.createError("Stand-alone ACA time (7-m) is >= " + (int)MIN_LARGE_PROGRAM_TIME_SACA.getContentInUnits(Time.UNIT_H) + " hours", "Either change Proposal Type to Large Program, or request less time.", (IBusinessObject)obsProposal));
        }
    }

    private void checkVLBIRequestedTime(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        Time time = Time.createTimeSec(0.0);
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            PerformanceParameters performanceParameters = scienceGoal.gettruePerformanceParameters();
            if (performanceParameters == null) continue;
            time.aggregate(performanceParameters.getDesiredTime());
        }
        if (time.isGreaterThan((AbstractDoubleWithUnit)MAX_ALLOWED_PROPOSAL_TIME)) {
            problemListModel.add(DefaultProblem.createError("Total time requested, including calibration, is greater than " + MAX_ALLOWED_PROPOSAL_TIME.getContentInUnits(Time.UNIT_H) + " hours", "Try to reduce time required for VLBI", (IBusinessObject)obsProposal));
        }
    }

    private void checkProposalTitleLength(ObsProposal obsProposal, ProblemListModel problemListModel) {
        if (obsProposal.getTitle().length() > 120) {
            problemListModel.add(DefaultProblem.createError("Proposal title cannot exceed 120 characters.", "Please shorten the proposal title to fit within this limit", (IBusinessObject)obsProposal));
        }
    }

    private void checkKeywords(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (obsProposal.getKeywordCount() < 1) {
            problemListModel.add(DefaultProblem.createError("Must select a minimum of 1 science keywords", "Select the Proposal node and then add some science keywords (minimum 1 keywords)", (IBusinessObject)obsProposal));
        }
        if (obsProposal.getKeywordCount() > 2) {
            problemListModel.add(DefaultProblem.createError("Not permitted to select more than 2 science keywords", "Select the Proposal node and then reduce the number of science keywords (maximum 2 keywords)", (IBusinessObject)obsProposal));
        }
    }

    private void performLargeProgramsValidation(@NonNull ObsProposal obsProposal, @NonNull ProblemListModel problemListModel, @NonNull Time time, @NonNull Time time2) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        if (time == null) {
            throw new NullPointerException("sacaProjectTime is marked non-null but is null");
        }
        if (time2 == null) {
            throw new NullPointerException("twelveMProjectTime is marked non-null but is null");
        }
        if (!obsProposal.isLargeProgram()) {
            throw new IllegalArgumentException("obsproposal should be a large program");
        }
        for (AbstractScienceGoal abstractScienceGoal : obsProposal.getAbstractScienceGoal()) {
            Collection<ScienceGoal> collection;
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            ObsProjectValidationUtils.validateNoDGCInLargeProgram(problemListModel, scienceGoal);
            SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
            try {
                collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new WizardSBGenerationException(invalidObsProgramParametersException);
            }
            for (ScienceGoal scienceGoal2 : collection) {
                Object object;
                EnumSet<SingleFieldScienceGoalModel.NonStandardMode> enumSet = null;
                try {
                    enumSet = SingleFieldScienceGoalModel.establishNonStandardObservingModes(scienceGoal2);
                }
                catch (SingleFieldScienceGoalModel.UnableToDetermineObservingModesException unableToDetermineObservingModesException) {
                    Log.logger(ObsProposalValidator.class).warning("Unable to determine non-standard observing modes: " + unableToDetermineObservingModesException.getMessage());
                    return;
                }
                assert (enumSet != null);
                for (SingleFieldScienceGoalModel.NonStandardMode nonStandardMode : enumSet) {
                    Problem problem = DefaultProblem.createError("Non-standard observing modes not allowed with large program proposals", nonStandardMode.getExplanation(), (IBusinessObject)scienceGoal);
                    problemListModel.addUnpublishedProblem(problem);
                }
                if (enumSet.contains((Object)SingleFieldScienceGoalModel.NonStandardMode.SOLAR_MODE)) {
                    object = DefaultProblem.createError("Solar observations are not allowed with Large Programs", "Remove these Science Goals or request less time", (IBusinessObject)scienceGoal);
                    problemListModel.add((Problem)object);
                }
                if (!enumSet.contains((Object)SingleFieldScienceGoalModel.NonStandardMode.FULL_POLARIZATION)) continue;
                object = DefaultProblem.createError("Full-polarization observations are not allowed with Large Programs", "Remove these Science Goals or request less time", (IBusinessObject)scienceGoal);
                problemListModel.add((Problem)object);
            }
        }
        if (time2.isLessThan((AbstractDoubleWithUnit)MIN_LARGE_PROGRAM_TIME_TWELVEM) && time.isLessThan((AbstractDoubleWithUnit)MIN_LARGE_PROGRAM_TIME_SACA)) {
            problemListModel.add(DefaultProblem.createError("Minimum time for a Large Program has not been reached", "Ensure that the SACA or 12-m time exceeds the minimum or deselect Large Program.", (IBusinessObject)obsProposal));
        }
    }

    static {
        ObsProposalValidator.refreshLimits();
    }
}

