/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.etc.ETCTimeCalculator;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.ObservingTimeCalculatorInterface;
import alma.obsprep.services.etc.Phase1DataRateCalculator;
import alma.obsprep.services.etc.Phase1DataRateCalculatorInterface;
import alma.obsprep.services.etc.SBRetriever;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.TimeSummary;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.valuetypes.DataRate;
import alma.valuetypes.StorageVolume;
import alma.valuetypes.Time;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class SchedBlockObservingTimeCalculator
implements ObservingTimeCalculatorInterface,
Phase1DataRateCalculatorInterface {
    private final ScienceGoal scienceGoal;
    private Collection<ScienceGoal> scienceGoalsWithClusters;
    private Map<ScienceGoal, ObservingTimeCalculator> otcMap = new HashMap<ScienceGoal, ObservingTimeCalculator>();

    public SchedBlockObservingTimeCalculator(Builder builder) throws InvalidObsProgramParametersException {
        this.scienceGoal = builder.scienceGoal;
        this.scienceGoalsWithClusters = new SourceClusterDetector(this.scienceGoal).splitScienceGoalIntoSourceClusters();
        assert (this.scienceGoalsWithClusters != null && !this.scienceGoalsWithClusters.isEmpty());
        for (ScienceGoal scienceGoal : this.scienceGoalsWithClusters) {
            this.otcMap.put(scienceGoal, new ObservingTimeCalculator(scienceGoal));
        }
        assert (!this.otcMap.isEmpty());
    }

    @Override
    public Time getTotalTimeForScienceGoal(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(entry.getKey());
            assert (observingTimeCalculator != null);
            time.aggregate(observingTimeCalculator.getTotalTimeForScienceGoal(bl, bl2, bl3, bl4));
        }
        return time;
    }

    @Override
    public Time getTotalTimeForScienceGoal(boolean bl) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        return this.getTotalTimeForScienceGoal(false, bl, false, true);
    }

    @Override
    public Time getCalibrationExecutionTimeStats(boolean bl, Array array, TargetParameters targetParameters, boolean bl2, SBRetriever sBRetriever) throws InvalidObsProgramParametersException, SourceNeverVisibleException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            time.aggregate(this.otcMap.get(entry.getKey()).getCalibrationExecutionTimeStats(bl, array, targetParameters, bl2, this.otcMap.get(entry.getKey())::getSBsViaSBGeneration));
        }
        return time;
    }

    @Override
    public DataRate getPeakDataRate(Array array, boolean bl) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        DataRate dataRate = DataRate.createDataRate();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            dataRate.aggregate(this.otcMap.get(entry.getKey()).getPeakDataRate(array, false));
        }
        return dataRate;
    }

    @Override
    public StorageVolume getDataVolume(Array array) throws InvalidObsProgramParametersException {
        StorageVolume storageVolume = StorageVolume.createStorageVolume();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            storageVolume.aggregate(this.otcMap.get(entry.getKey()).getDataVolume(array));
        }
        return storageVolume;
    }

    @Override
    public Time getOnSourceOverheadsTime(boolean bl, Array array) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            time.aggregate(this.otcMap.get(entry.getKey()).getOnSourceOverheadsTime(bl, array));
        }
        return time;
    }

    @Override
    public Time getTheoreticalOnSourceTimeForArray(Array array) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            time.aggregate(this.otcMap.get(entry.getKey()).getTheoreticalOnSourceTimeForArray(array));
        }
        return time;
    }

    @Override
    public Time getOverheadTimeForCalObs() {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            time.aggregate(this.otcMap.get(entry.getKey()).getOverheadTimeForCalObs());
        }
        return time;
    }

    @Override
    public Time getOverheadTimes(boolean bl, EnumSet<ObservingTimeCalculator.CalibrationOverheads> enumSet, Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            time.aggregate(this.otcMap.get(entry.getKey()).getOverheadTimes(bl, enumSet, array, targetParameters));
        }
        return time;
    }

    @Override
    public Time getRequestedTimeForAllConfigurations(Array array, boolean bl) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            time.aggregate(this.otcMap.get(entry.getKey()).getRequestedTimeForAllConfigurations(array, true));
        }
        return time;
    }

    @Override
    public Time getTimeForSecond12mCompactArray(Time time, boolean bl) throws InvalidObsProgramParametersException {
        Time time2 = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            time2.aggregate(this.otcMap.get(entry.getKey()).getTimeForSecond12mCompactArray(time, bl));
        }
        return time2;
    }

    @Override
    public Time getTimeForSecond12mCompactArray(Time time, boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        Time time2 = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            time2.aggregate(this.otcMap.get(entry.getKey()).getTimeForSecond12mCompactArray(time, bl, bl2));
        }
        return time2;
    }

    public Time getTotal12mExtendedArraySBScienceIntegrationTime(Boolean bl, ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, UnknownEntityException {
        return this.getTotalArraySBScienceIntegrationTime(bl, scienceGoal, Array.ARRAY_12M);
    }

    public Time getTotalArraySBScienceIntegrationTime(Boolean bl, ScienceGoal scienceGoal, Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        assert (this.otcMap != null);
        ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
        assert (observingTimeCalculator != null);
        return observingTimeCalculator.getTotalArraySBScienceIntegrationTime(bl, array);
    }

    @Override
    public Time getTotalOnSourceTime(Array array, boolean bl) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            assert (this.otcMap.get(entry.getKey()) != null);
            time.aggregate(this.otcMap.get(entry.getKey()).getTotalOnSourceTime(array, bl));
        }
        return time;
    }

    @Override
    public Time getTotalRequestedTime(Array array) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        assert (this.otcMap != null);
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            time.aggregate(this.otcMap.get(entry.getKey()).getTotalRequestedTime(array));
        }
        return time;
    }

    public Time getTotalRequestedTime(Array array, boolean bl, boolean bl2, @NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sgCluster is marked non-null but is null");
        }
        Time time = Time.createTime();
        assert (this.otcMap != null);
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Clustered science goal not found");
        }
        ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
        assert (observingTimeCalculator != null);
        time.aggregate(observingTimeCalculator.getTotalRequestedTime(array, bl, bl2, true));
        return time;
    }

    @Override
    public boolean isSBToBeExecutedUsingSessions() {
        Iterator<Map.Entry<ScienceGoal, ObservingTimeCalculator>> iterator = this.otcMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<ScienceGoal, ObservingTimeCalculator> entry = iterator.next();
            return this.otcMap.get(entry.getKey()).isSBToBeExecutedUsingSessions();
        }
        throw new IllegalArgumentException("Unable to find an OTC to use");
    }

    public Time getTotalTimeForScienceGoal(@NonNull ScienceGoal scienceGoal, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalTimeForScienceGoal(bl, bl2, bl3, bl4);
    }

    public Time getTotalTimeForScienceGoal(@NonNull ScienceGoal scienceGoal, Boolean bl) throws ObservingTimeCalculator.UnableToCalculateTimeEstimateException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalTimeForScienceGoal(bl);
    }

    public Time getCalibrationExecutionTimeStats(@NonNull ScienceGoal scienceGoal, Boolean bl, Array array, TargetParameters targetParameters, boolean bl2) throws InvalidObsProgramParametersException, SourceNeverVisibleException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        ObservingTimeCalculator observingTimeCalculator = this.otcMap.get(scienceGoal);
        return observingTimeCalculator.getCalibrationExecutionTimeStats(bl, array, targetParameters, bl2, observingTimeCalculator::getSBsViaSBGeneration);
    }

    public StorageVolume getDataVolume(@NonNull ScienceGoal scienceGoal, Array array) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getDataVolume(array);
    }

    public Time getOnSourceOverheadsTime(@NonNull ScienceGoal scienceGoal, Boolean bl, Array array) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getOnSourceOverheadsTime(bl, array);
    }

    public Time getOnSourceTimeFor12mExtendedConfiguration(@NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTheoreticalOnSourceTimeForArray(Array.ARRAY_12M);
    }

    public Time getOverheadTimeForCalObs(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getOverheadTimeForCalObs();
    }

    public Time getOverheadTimes(@NonNull ScienceGoal scienceGoal, Boolean bl, EnumSet<ObservingTimeCalculator.CalibrationOverheads> enumSet, Array array, TargetParameters targetParameters) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getOverheadTimes(bl, enumSet, array, targetParameters);
    }

    public Time getRequestedTimeForAllConfigurations(@NonNull ScienceGoal scienceGoal, Array array) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getRequestedTimeForAllConfigurations(array, true);
    }

    public Time getTimeForSecond12mCompactArray(@NonNull ScienceGoal scienceGoal, Time time, boolean bl) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTimeForSecond12mCompactArray(time, bl);
    }

    public Time getTimeForSecond12mCompactArray(@NonNull ScienceGoal scienceGoal, Time time, boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTimeForSecond12mCompactArray(time, bl, bl2);
    }

    public Map<CalType, TimeSummary> getCalibrationTimeSummary(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getCalibrationTimeSummary();
    }

    public Time getTotalArraySBScienceIntegrationTime(@NonNull ScienceGoal scienceGoal, Boolean bl, Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalArraySBScienceIntegrationTime(bl, array);
    }

    public Time getTotalOnSourceTime(@NonNull ScienceGoal scienceGoal, Array array, boolean bl) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalOnSourceTime(array, bl);
    }

    public Time getTotalRequestedTime(@NonNull ScienceGoal scienceGoal, Array array) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalRequestedTime(array);
    }

    public Time getTotalRequestedTime(@NonNull ScienceGoal scienceGoal, Array array, boolean bl, boolean bl2) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getTotalRequestedTime(array, bl, bl2, true);
    }

    public Time singlePointOnSourceTime(@NonNull ScienceGoal scienceGoal, Array array, TargetParameters targetParameters, boolean bl) throws InvalidFrequencyException, SourceNeverVisibleException, InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        ETCTimeCalculator.CorrelatorModeConversionEnum correlatorModeConversionEnum = Array.isTM(array) ? ETCTimeCalculator.CorrelatorModeConversionEnum.NoCorrelatorConversion : ETCTimeCalculator.CorrelatorModeConversionEnum.Convert4BitModeTo2Bit;
        return this.otcMap.get(scienceGoal).singlePointOnSourceTime(array, targetParameters, bl, correlatorModeConversionEnum);
    }

    public Time singlePointOnSourceTimeFromSB(@NonNull ScienceGoal scienceGoal, TargetParameters targetParameters, Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).singlePointOnSourceTimeFromSB(targetParameters, array);
    }

    @Override
    public Time adjustForFullPolarization(Time time) {
        Iterator<Map.Entry<ScienceGoal, ObservingTimeCalculator>> iterator = this.otcMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<ScienceGoal, ObservingTimeCalculator> entry = iterator.next();
            return this.otcMap.get(entry.getKey()).adjustForFullPolarization(time);
        }
        throw new IllegalArgumentException("Unable to find an OTC to use");
    }

    public int getSBExecutionCount(@NonNull ScienceGoal scienceGoal, Array array) throws InvalidObsProgramParametersException, UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getSBExecutionCount(array);
    }

    public int getWaterVapourContentUsed(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getWaterVapourContentUsed();
    }

    public int getNumRetunings(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Unable to find an associated OTC for the science goal specified");
        }
        return this.otcMap.get(scienceGoal).getNumRetunings();
    }

    public int getNumberOfAntennaConfigurations(@NonNull ScienceGoal scienceGoal, RequestedArray requestedArray) throws InvalidObsProgramParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoalForCluster is marked non-null but is null");
        }
        if (!this.otcMap.containsKey(scienceGoal)) {
            throw new IllegalArgumentException("Science goal not found in map");
        }
        return this.otcMap.get(scienceGoal).getNumberOfAntennaConfigurations(requestedArray);
    }

    @Override
    public Time getTotalRequestedTime(Array array, boolean bl, boolean bl2, boolean bl3) throws InvalidObsProgramParametersException {
        Time time = Time.createTime();
        for (Map.Entry<ScienceGoal, ObservingTimeCalculator> entry : this.otcMap.entrySet()) {
            time.aggregate(this.otcMap.get(entry.getKey()).getTotalRequestedTime(array, bl, bl2, bl3));
        }
        return time;
    }

    @Override
    public DataRate getAverageDataRate(Array array) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<SpectralSpec, DataRate> getInstantaneousSpectralSpecBasedDataRates(RequestedArray requestedArray) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Phase1DataRateCalculator.SpectralSpecDataRate> getInstantaneousBaseBandBasedDataRates(RequestedArray requestedArray) throws Phase1DataRateCalculator.UnableToDetermineInstantaneousDataRateException {
        throw new UnsupportedOperationException();
    }

    public Collection<ScienceGoal> getScienceGoalsWithClusters() {
        return this.scienceGoalsWithClusters;
    }

    public static class Builder {
        private ScienceGoal scienceGoal;

        public Builder scienceGoal(@NonNull ScienceGoal scienceGoal) {
            if (scienceGoal == null) {
                throw new NullPointerException("scienceGoal is marked non-null but is null");
            }
            this.scienceGoal = scienceGoal;
            return this;
        }

        public SchedBlockObservingTimeCalculator build() throws InvalidObsProgramParametersException {
            return new SchedBlockObservingTimeCalculator(this);
        }
    }
}

