/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.PointingMethodMod.PointingMethod;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.ChannelAverageRegion;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.UserAngle;
import java.util.ArrayList;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.math3.util.ArithmeticUtils;

public abstract class CorrelatorExpert {
    private static CorrelatorExpert _instanceBL = null;
    private static CorrelatorExpert _instanceACA = null;
    private static final double MAX_SUBSCAN_DURATION = 300.0;
    private static final int CONTROL_REQUIRED_SUBSCAN_MULTIPLER_MS = 48;
    private static final double CORR_DUMP_DURATION_BASIC_UNIT = 48.0;
    private static final double ACA_DUMP_DURATION_BASIC_UNIT = 16.0;

    @Deprecated
    public static CorrelatorExpert getInstance() {
        return CorrelatorExpert.getBLInstance();
    }

    public abstract double calcDumpDurationInmsecs(double var1);

    public abstract double calcIntegrationDurationInsecs(double var1, double var3);

    public static CorrelatorExpert getInstance(CorrelatorType correlatorType) {
        return switch (correlatorType) {
            case CorrelatorType.BL -> CorrelatorExpert.getBLInstance();
            case CorrelatorType.ACA -> CorrelatorExpert.getACAInstance();
            case CorrelatorType.BL90DWS -> CorrelatorExpert.getBL90DWSInstance();
            case CorrelatorType.ACA90DWS -> CorrelatorExpert.getACA90DWSInstance();
            default -> throw new IllegalArgumentException("Unknown CorrelatorType : " + correlatorType);
        };
    }

    public static CorrelatorExpert getBLInstance() {
        if (_instanceBL == null) {
            _instanceBL = new BLCorrelatorExpert();
        }
        return _instanceBL;
    }

    public static CorrelatorExpert getBL90DWSInstance() {
        if (_instanceACA == null) {
            _instanceACA = new BLCorrelatorExpert(2048.0);
        }
        return _instanceACA;
    }

    public static CorrelatorExpert getACA90DWSInstance() {
        if (_instanceACA == null) {
            _instanceACA = new ACACorrelatorExpert(2048.0);
        }
        return _instanceACA;
    }

    public static CorrelatorExpert getACAInstance() {
        if (_instanceACA == null) {
            _instanceACA = new ACACorrelatorExpert();
        }
        return _instanceACA;
    }

    private CorrelatorExpert() {
    }

    public double calcChannelAverageDurationInmsecs(double d, double d2) {
        return d;
    }

    public abstract double calcDumpDurationInmsecs();

    public double calcSubscanDuration(double d, double d2, String string) {
        if (string != null) {
            if (PointingMethod.THREE_POINT.toString().equals(string)) {
                return this.calcSubscanDuration(d, d2, 3);
            }
            if (PointingMethod.FOUR_POINT.toString().equals(string)) {
                return this.calcSubscanDuration(d, d2, 4);
            }
            if (PointingMethod.FIVE_POINT.toString().equals(string)) {
                return this.calcSubscanDuration(d, d2, 5);
            }
        }
        return this.calcSubscanDuration(d, d2, 1);
    }

    public double calcSubscanDuration(double d, double d2, int n) {
        double d3 = d / 300.0;
        int n2 = (int)Math.ceil(d3);
        int n3 = (int)(d2 * 1000.0 + 0.5);
        CorrelatorExpert.gcd(n3, 48);
        int n4 = CorrelatorExpert.lcm(n3, 48);
        int n5 = CorrelatorExpert.myCeil(d * 1000.0 / (double)n2 / (double)n4 / (double)n);
        int n6 = n5 * n4;
        double d4 = (double)n6 / 1000.0;
        return d4;
    }

    static int myCeil(double d) {
        int n = (int)Math.floor(d);
        if (d - (double)n < 1.0E-5) {
            return n;
        }
        return (int)Math.ceil(d);
    }

    public static int gcd(int n, int n2) {
        if (n <= 0 || n2 < 0) {
            throw new IllegalArgumentException("gcd : arguments must be 2 natural numbers : " + n + ", " + n2);
        }
        return n2 == 0 ? n : CorrelatorExpert.gcd(n2, n % n2);
    }

    public static int lcm(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("lcm : arguments must be 2 natural numbers : " + n + ", " + n2);
        }
        return n * n2 / CorrelatorExpert.gcd(n, n2);
    }

    public abstract double calcIntegrationDurationInsecs();

    public abstract double calcIntegrationDurationInsecs(boolean var1);

    public abstract double calcIntegrationDurationInsecs(double var1);

    public abstract double calcChannelAverageDurationInsecs(double var1, double var3);

    public ChannelAverageRegion[] calcChannelAverageRegions(AbstractSpectralWindow abstractSpectralWindow, String string) {
        ArrayList<ChannelAverageRegion> arrayList = new ArrayList<ChannelAverageRegion>();
        if (string.equals(SpectralSetupParameters.TYPE_FULL)) {
            var4_4 = Double.valueOf((double)abstractSpectralWindow.getEffectiveNumberOfChannels() * 0.05).intValue();
            int n = Double.valueOf((double)abstractSpectralWindow.getEffectiveNumberOfChannels() * 0.9).intValue();
            arrayList.add(ChannelAverageRegion.createChannelAverageRegion(var4_4, n));
        } else if (string.equals(SpectralSetupParameters.TYPE_CONTINUUM)) {
            var4_4 = abstractSpectralWindow.getEffectiveNumberOfChannels();
            arrayList.add(ChannelAverageRegion.createChannelAverageRegion(0, var4_4));
        }
        ChannelAverageRegion[] channelAverageRegionArray = new ChannelAverageRegion[arrayList.size()];
        return arrayList.toArray(channelAverageRegionArray);
    }

    public CorrConfigMode getContinuumMode(CorrPolarization corrPolarization) {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        Set<CorrConfigMode> set = oTConfigModeDecoder.findMode(CorrFilter.TDM);
        Set<CorrConfigMode> set2 = oTConfigModeDecoder.findMode(corrPolarization, set);
        return this.determineCorrMode(set2);
    }

    public CorrConfigMode getFDMContinuumMode(@NonNull CorrPolarization corrPolarization) {
        if (corrPolarization == null) {
            throw new NullPointerException("poln is marked non-null but is null");
        }
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        Set<CorrConfigMode> set = oTConfigModeDecoder.findMode(CorrFilter.TFB);
        set = oTConfigModeDecoder.findMode(corrPolarization, set);
        set = oTConfigModeDecoder.findMode(Frequency.createFrequencyMHZ(2000.0), set);
        return this.determineCorrMode(set);
    }

    public CorrConfigMode determineCorrMode(@NonNull Set<CorrConfigMode> set) {
        CorrConfigMode corrConfigMode;
        if (set == null) {
            throw new NullPointerException("correlatorModes is marked non-null but is null");
        }
        switch (set.size()) {
            case 0: {
                corrConfigMode = CorrConfigMode.INVALID_CORRCONFIGMODE;
                break;
            }
            case 1: {
                corrConfigMode = set.iterator().next();
                break;
            }
            default: {
                corrConfigMode = CorrConfigMode.INVALID_CORRCONFIGMODE;
                int n = 8192;
                for (CorrConfigMode corrConfigMode2 : set) {
                    int n2 = corrConfigMode2.getNominalChannels();
                    if (n2 >= n) continue;
                    n = n2;
                    corrConfigMode = corrConfigMode2;
                }
            }
        }
        return corrConfigMode;
    }

    public CorrConfigMode getSpectralLineWalshSwitchMode(@NonNull CorrPolarization corrPolarization) {
        if (corrPolarization == null) {
            throw new NullPointerException("polarization is marked non-null but is null");
        }
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        Set<CorrConfigMode> set = oTConfigModeDecoder.findMode(CorrFilter.TFB);
        set = oTConfigModeDecoder.findMode(Frequency.createFrequencyMHZ(2000.0), set);
        set = oTConfigModeDecoder.findMode(corrPolarization, set);
        return this.determineCorrMode(set);
    }

    static class BLCorrelatorExpert
    extends CorrelatorExpert {
        private double corrDumpDurationBasicUnit = 48.0;

        private BLCorrelatorExpert() {
        }

        public BLCorrelatorExpert(double d) {
            this.corrDumpDurationBasicUnit = d;
        }

        @Override
        public double calcDumpDurationInmsecs(double d) {
            int n = BLCorrelatorExpert.myCeil(d / this.corrDumpDurationBasicUnit);
            double d2 = (double)n * this.corrDumpDurationBasicUnit;
            return d2;
        }

        @Override
        public double calcDumpDurationInmsecs() {
            return 1008.0;
        }

        @Override
        public double calcIntegrationDurationInsecs(double d, double d2) {
            int n = BLCorrelatorExpert.myCeil(d / d2);
            double d3 = d2 * 1000.0;
            double d4 = (double)n * d3;
            return d4 / 1000.0;
        }

        @Override
        public double calcChannelAverageDurationInsecs(double d, double d2) {
            int n = BLCorrelatorExpert.myCeil(d / d2);
            double d3 = d2 * 1000.0;
            double d4 = (double)n * d3;
            return d4 / 1000.0;
        }

        @Override
        public double calcIntegrationDurationInsecs(double d) {
            return d * 2.0;
        }

        @Override
        public double calcIntegrationDurationInsecs() {
            return this.calcIntegrationDurationInsecs(this.calcDumpDurationInmsecs() / 1000.0);
        }

        @Override
        public double calcIntegrationDurationInsecs(boolean bl) {
            double d = this.calcDumpDurationInmsecs() / 1000.0;
            if (bl) {
                return this.calcIntegrationDurationInsecs(d);
            }
            return 3.0 * this.calcIntegrationDurationInsecs(d);
        }
    }

    static class ACACorrelatorExpert
    extends CorrelatorExpert {
        private double corrDumpDurationBasicUnit = 16.0;

        private ACACorrelatorExpert() {
        }

        public ACACorrelatorExpert(double d) {
            this.corrDumpDurationBasicUnit = d;
        }

        @Override
        public double calcDumpDurationInmsecs() {
            return this.corrDumpDurationBasicUnit;
        }

        @Override
        public double calcDumpDurationInmsecs(double d) {
            return this.corrDumpDurationBasicUnit;
        }

        @Override
        public double calcIntegrationDurationInsecs(double d) {
            return d * 2.0;
        }

        @Override
        public double calcIntegrationDurationInsecs() {
            return 1.008;
        }

        @Override
        public double calcIntegrationDurationInsecs(boolean bl) {
            return this.calcIntegrationDurationInsecs();
        }

        @Override
        public double calcIntegrationDurationInsecs(double d, double d2) {
            int n = ACACorrelatorExpert.myCeil(d / d2);
            double d3 = d2 * 1000.0;
            double d4 = (double)n * d3;
            return d4 / 1000.0;
        }

        @Override
        public double calcChannelAverageDurationInsecs(double d, double d2) {
            int n = ACACorrelatorExpert.myCeil(d / d2);
            double d3 = d2 * 1000.0;
            double d4 = (double)n * d3;
            return d4 / 1000.0;
        }
    }

    public static class TPCorrelatorConfiguratorHelper {
        public static double getEstimatedSubscanDuration(Integer n, ObsType obsType) {
            double d = 0.0;
            if (obsType == null) {
                throw new IllegalArgumentException("obsType is null");
            }
            if (n == null) {
                throw new IllegalArgumentException("receiverBand is null");
            }
            switch (obsType) {
                case AMPLITUDE: {
                    d = 4.0;
                    break;
                }
                case SCIENCE: {
                    if (ReceiverBand.getReceiverBand(n) == null) {
                        throw new WizardSBGenerationException("Unknown receiver band : " + n);
                    }
                    d = switch (n) {
                        case 1, 3, 4 -> 20.0;
                        case 5, 6 -> 15.0;
                        case 7, 8 -> 10.0;
                        case 9, 10 -> 10.0;
                        default -> throw new WizardSBGenerationException("Unable to establish subscan duration for band " + n + " : this is not a legal spectral configuration for TP");
                    };
                    break;
                }
                default: {
                    throw new WizardSBGenerationException("Unable to determine estimated subscan duration for target of type : " + obsType);
                }
            }
            assert (d > 0.0);
            return d;
        }

        public static double calcSubscanDuration(double d, double d2) {
            long l = (long)(d2 * 1000.0);
            long l2 = ArithmeticUtils.lcm((long)l, (long)48L);
            return Math.ceil(d * 1000.0 / (double)l2) * (double)l2 / 1000.0;
        }

        public static double calculateChannelAverageDurationInMsecs(ValueUnitPair<Angle> valueUnitPair, Integer n, Frequency frequency, ObsType obsType) {
            double d = TPCorrelatorConfiguratorHelper.calcIntegrationDurationInMsecs(valueUnitPair, n, frequency, obsType);
            double d2 = d > 1024.0 ? 512.0 : d;
            return d2;
        }

        public static double calcIntegrationDurationInMsecs(ValueUnitPair<Angle> valueUnitPair, Integer n, Frequency frequency, ObsType obsType) {
            return 1000.0 * TPCorrelatorConfiguratorHelper.calcIntegrationDurationInSecs(valueUnitPair, n, frequency, obsType);
        }

        public static double calcIntegrationDurationInSecs(ValueUnitPair<Angle> valueUnitPair, Integer n, Frequency frequency, ObsType obsType) {
            Double d = null;
            d = TPCorrelatorConfiguratorHelper.getEstimatedSubscanDuration(n, obsType);
            UserAngle userAngle = UserAngle.createUserAngle(1.0, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
            userAngle.setAntenna(Antenna.ANTENNA_12M);
            double d2 = userAngle.getContentInUnits(Angle.UNIT_ARCSEC) * 1.0;
            double d3 = d * d2 / valueUnitPair.getContentInUnits(Angle.UNIT_ARCSEC) / 5.0 * 1000.0;
            double d4 = d3 > 1024.0 ? 512.0 : 16.0;
            d3 = Math.floor(d3 / d4) * d4;
            Log.logger(TPCorrelatorConfiguratorHelper.class).fine("t_int_ms : " + d3 + " L (arcsec) : " + valueUnitPair.getContentInUnits(Angle.UNIT_ARCSEC) + " HPBW (arcsec) : " + d2);
            if (d3 == 0.0) {
                Log.logger(TPCorrelatorConfiguratorHelper.class).warning("Unable to calculate t_int : is the rectangle too big");
                throw new WizardSBGenerationException("Unable to calculate t_int: is the rectangle too big?");
            }
            return d3 / 1000.0;
        }
    }
}

