/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.calibrators;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.Source;
import alma.obsprep.bo.schedblock.SourceProperty;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import java.util.ArrayList;
import java.util.List;

public class CalibratorUtils {
    public static List<SourceProperty> getSourceProperties(Source source) {
        ArrayList<SourceProperty> arrayList = new ArrayList<SourceProperty>();
        for (Measurement measurement : source.getMeasurements()) {
            SourceProperty sourceProperty = SourceProperty.createSourceProperty();
            if (measurement.getFlux() == null || measurement.getFrequency() == null) continue;
            Flux flux = Flux.createFlux((double)measurement.getFlux(), (String)Flux.UNIT_JY);
            sourceProperty.setSourceFluxI(flux);
            Frequency frequency = Frequency.createFrequency((double)measurement.getFrequency(), (String)Frequency.UNIT_HZ);
            sourceProperty.setSourceFrequency(frequency);
            arrayList.add(sourceProperty);
        }
        return arrayList;
    }
}

