/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.ReceiverExpert;
import alma.obsprep.util.Range;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class FrequencyRangeInspector {
    private boolean isVLBISpectralLine = false;
    protected List<Range<Frequency>> windowList;
    private final StringBuilder warningMessage = new StringBuilder();
    private Velocity sourceVelocity = null;

    public FrequencyRangeInspector(Range<Frequency>[] rangeArray) {
        this.setWindowList(rangeArray);
    }

    public FrequencyRangeInspector(List<Range<Frequency>> list) {
        this.setWindowList(list);
    }

    public void setWindowList(Range<Frequency>[] rangeArray) {
        this.setWindowList(Arrays.asList(rangeArray));
    }

    public void setWindowList(List<Range<Frequency>> list) {
        this.windowList = list;
    }

    public Velocity getSourceVelocity() {
        if (this.sourceVelocity == null) {
            this.sourceVelocity = Velocity.createVelocity();
        }
        return this.sourceVelocity;
    }

    public void setSourceVelocity(Velocity velocity) {
        this.sourceVelocity = velocity;
    }

    public String getWarningMessage() {
        return this.warningMessage.toString();
    }

    public void addWarningMessage(String string) {
        this.warningMessage.append(string + "\n");
    }

    public Set<ReceiverBand> getSuitableReceiverSet(@NonNull Velocity velocity) {
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        if (this.windowList.size() == 0) {
            this.addWarningMessage("No spectral window in the list.");
            return new HashSet<ReceiverBand>();
        }
        Range<Frequency> range = this.getSkyrange(velocity);
        return ReceiverExpert.getInstance().getSuitableReceiverSet(range);
    }

    public boolean inOneReceiverBand(@NonNull Velocity velocity) {
        boolean bl;
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        boolean bl2 = bl = this.getSuitableReceiverSet(velocity).size() > 0;
        if (!bl) {
            Range<Frequency> range = this.isVLBISpectralLine ? this.getWholeFrequencyRangeRest() : this.toSkyRange(this.getWholeFrequencyRangeRest(), velocity);
            this.addWarningMessage("No suitable receiver band for the range :" + range);
        }
        return bl;
    }

    private Range<Frequency> getSkyrange(@NonNull Velocity velocity) {
        Range<Frequency> range;
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        if (this.isVLBISpectralLine) {
            range = this.getWholeFrequencyRangeRest();
        } else {
            Range<Frequency> range2 = this.getWholeFrequencyRangeRest();
            range = this.isVLBISpectralLine ? range2 : this.toSkyRange(range2, velocity);
        }
        return range;
    }

    public boolean inOneBaseBand(@NonNull Velocity velocity) {
        boolean bl;
        if (velocity == null) {
            throw new NullPointerException("v is marked non-null but is null");
        }
        boolean bl2 = this.windowList.size() == 0;
        boolean bl3 = bl = this.windowList.size() == 1;
        if (bl2 || bl) {
            return true;
        }
        Range<Frequency> range = this.getSkyrange(velocity);
        boolean bl4 = range.range().getContentInGHz() < 2.0;
        this.addWarningMessage("The desired frequency range " + this.getWholeFrequencyRangeRest() + " is too wide for a BaseBand.");
        return bl4;
    }

    public Range<Frequency> getWholeFrequencyRangeRest() {
        if (this.windowList.size() == 0) {
            return new VupRange<Frequency>(Frequency.createFrequency(), Frequency.createFrequency());
        }
        VupRange<Frequency> vupRange = new VupRange<Frequency>(this.windowList.get(0));
        for (Range<Frequency> range : this.windowList) {
            vupRange = vupRange.expand(range);
        }
        return vupRange;
    }

    public Range<Frequency> toSkyRange(Range<Frequency> range, Velocity velocity) {
        return new VupRange<Frequency>(velocity.dopplerShift(range.min()), velocity.dopplerShift(range.max()));
    }

    public Range<Frequency> toRestRange(Range<Frequency> range, Velocity velocity) {
        return new VupRange<Frequency>(velocity.reverseShift(range.min()), velocity.reverseShift(range.max()));
    }

    public Range<Frequency> getRangeCenterRange() {
        if (this.windowList.size() == 0) {
            return new VupRange<Frequency>(Frequency.createFrequency(), Frequency.createFrequency());
        }
        Frequency frequency = this.windowList.get(0).mid();
        VupRange<Frequency> vupRange = new VupRange<Frequency>(frequency, frequency);
        for (Range<Frequency> range : this.windowList) {
            vupRange = vupRange.expand(range.mid());
        }
        return vupRange;
    }

    public String toString() {
        return "FrequencyRangeInspector(isVLBISpectralLine=" + this.isVLBISpectralLine + ", windowList=" + this.windowList + ", warningMessage=" + this.getWarningMessage() + ", sourceVelocity=" + this.getSourceVelocity() + ")";
    }

    public void setVLBISpectralLine(boolean bl) {
        this.isVLBISpectralLine = bl;
    }
}

