/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.TestUtilities;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.ScienceSpectralWindowFactory;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.GridSearchInputParameters;
import alma.obsprep.util.FileUtilities;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserSensitivity;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import lombok.NonNull;

public class DGCCalibratorGridSearch {
    private boolean search(@NonNull GridSearchInputParameters gridSearchInputParameters) {
        if (gridSearchInputParameters == null) {
            throw new NullPointerException("gridSearchInputParameters is marked non-null but is null");
        }
        DGCExpert.DGCTypeEnum dGCTypeEnum = gridSearchInputParameters.getDgcCalibratorToSearchFor();
        int n = (int)gridSearchInputParameters.getRadiusOfSearch().getDegs();
        for (int i = -n; i < n; ++i) {
            block5: for (int j = -n; j < n; ++j) {
                Log.logger(DGCCalibratorGridSearch.class).info("Searching RA " + i + " dec " + j);
                ScienceGoal scienceGoal = this.buildScienceGoal(i, j, gridSearchInputParameters);
                DGCExpert.B2BSchedulingOutcome b2BSchedulingOutcome = DGCExpert.getExpert(false).isB2BScheduled(scienceGoal, false);
                switch (dGCTypeEnum) {
                    case DGCBandToBand: {
                        if (!Set.of(DGCExpert.B2BSchedulingOutcome.Scheduled, DGCExpert.B2BSchedulingOutcome.B2BWeakCalibratorFound).contains((Object)b2BSchedulingOutcome)) continue block5;
                        Log.logger(DGCCalibratorGridSearch.class).info("B2B calibrator found at " + scienceGoal.getTargetParameters()[0].getFieldCenterCoordinates() + " at " + scienceGoal.getSpectralSetupParameters().getRepresentativeFrequency());
                        return true;
                    }
                    case DGCBandwidthSwitching: {
                        if (!b2BSchedulingOutcome.equals((Object)DGCExpert.B2BSchedulingOutcome.UseBWSW)) continue block5;
                        Log.logger(DGCCalibratorGridSearch.class).info("BWSW calibrator found at " + scienceGoal.getTargetParameters()[0].getFieldCenterCoordinates() + " at " + scienceGoal.getSpectralSetupParameters().getRepresentativeFrequency());
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private ScienceGoal buildScienceGoal(int n, int n2, @NonNull GridSearchInputParameters gridSearchInputParameters) {
        double d;
        if (gridSearchInputParameters == null) {
            throw new NullPointerException("gridSearchInputParameters is marked non-null but is null");
        }
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        ObsProposal obsProposal = ObsProposal.createObsProposal();
        obsProposal.addAbstractScienceGoal((AbstractScienceGoal)((Object)scienceGoal));
        scienceGoal.clearTargetParameters();
        TargetParameters targetParameters = TargetParameters.createTargetParameters();
        targetParameters.setSourceName("test");
        SkyCoordinates skyCoordinates = targetParameters.getTargetCenter();
        skyCoordinates.setAbsoluteCoordinatesInDegInSystem(gridSearchInputParameters.getRa().getAbsoluteSkyPointInICRSDeg().getX() + (double)n, gridSearchInputParameters.getDec().getAbsoluteSkyPointInICRSDeg().getY() + (double)n2, SkyCoordinates.SYSTEM_ICRS);
        scienceGoal.addTargetParameters(targetParameters);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        spectralSetupParameters.setSpectralType(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE);
        spectralSetupParameters.clearAbstractScienceSpectralWindow();
        spectralSetupParameters.setPolarisation(SpectralSetupParameters.POLARISATION_DOUBLE);
        double d2 = d = gridSearchInputParameters.getReceiverBand().getRFMax() - gridSearchInputParameters.getReceiverBand().getRFMin() / 2.0;
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindowFactory.createScienceSpectralWindow(d2, "", 1875.0, 0.0);
        scienceSpectralWindow.setGroupIndex(0);
        scienceSpectralWindow.setCorrConfigMode(64);
        spectralSetupParameters.addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow));
        spectralSetupParameters.setRepresentativeFrequency(Frequency.createFrequencyGHZ(d2));
        try {
            spectralSetupParameters.verifyBasebandSetting();
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            throw new RuntimeException("Unable to calculate LO1" + baseBandNotDeployableException.getMessage());
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        performanceParameters.setAcceptableAngularResolution(UserAngle.createUserAngle());
        performanceParameters.setDesiredAngularResolution(UserAngle.createUserAngle((Angle)((Object)gridSearchInputParameters.getAngularResolution())));
        performanceParameters.setDesiredSensitivity(UserSensitivity.createUserSensitivity(1.0, UserSensitivity.UNIT_JY));
        performanceParameters.setDesiredLargestScale(Angle.createAngleDegs(0.0));
        performanceParameters.setRepresentativeFrequency(Frequency.createFrequencyGHZ(d2));
        return scienceGoal;
    }

    public static void main(String[] stringArray) {
        System.setProperty("sourcecat.url", "https://almascience.eso.org/sc");
        try {
            InitServices.init();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.exit(-1);
        }
        File file = new File(TestUtilities.getBaseDirectory(), "config/otData");
        String string = FileUtilities.makeRelativePath(file);
        System.setProperty("otData.dir", string);
        GridSearchInputParameters.GridSearchInputParametersBuilder gridSearchInputParametersBuilder = GridSearchInputParameters.builder();
        gridSearchInputParametersBuilder.radiusOfSearch(Angle.createAngle((double)10.0, (String)Angle.UNIT_DEG)).dgcCalibratorToSearchFor(DGCExpert.DGCTypeEnum.DGCBandwidthSwitching).angularResolution(UserAngle.createUserAngle(0.02, Angle.UNIT_ARCSEC));
        boolean bl = new DGCCalibratorGridSearch().search(gridSearchInputParametersBuilder.build());
        if (!bl) {
            Log.logger(DGCCalibratorGridSearch.class).info("Unable to find calibrator");
        }
    }
}

