/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored;

import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.UserAngle;
import java.util.Optional;

public class GridSearchInputParameters {
    private SkyCoordinates ra;
    private SkyCoordinates dec;
    private Angle radiusOfSearch;
    private ReceiverBand receiverBand;
    private UserAngle angularResolution;
    private DGCExpert.DGCTypeEnum dgcCalibratorToSearchFor;
    private Optional<DGCExpert.B2BSchedulingOutcome> b2bCalibratorCategory;

    private static SkyCoordinates $default$ra() {
        return SkyCoordinates.createAbsoluteCoordinates();
    }

    private static SkyCoordinates $default$dec() {
        return SkyCoordinates.createAbsoluteCoordinates();
    }

    private static Angle $default$radiusOfSearch() {
        return Angle.createAngle((double)1.0, (String)Angle.UNIT_DEG);
    }

    private static ReceiverBand $default$receiverBand() {
        return ReceiverBand.getReceiverBand(9);
    }

    private static UserAngle $default$angularResolution() {
        return UserAngle.createUserAngle(1.0, UserAngle.UNIT_ARCSEC);
    }

    private static DGCExpert.DGCTypeEnum $default$dgcCalibratorToSearchFor() {
        return DGCExpert.DGCTypeEnum.DGCBandToBand;
    }

    private static Optional<DGCExpert.B2BSchedulingOutcome> $default$b2bCalibratorCategory() {
        return Optional.empty();
    }

    GridSearchInputParameters(SkyCoordinates skyCoordinates, SkyCoordinates skyCoordinates2, Angle angle, ReceiverBand receiverBand, UserAngle userAngle, DGCExpert.DGCTypeEnum dGCTypeEnum, Optional<DGCExpert.B2BSchedulingOutcome> optional) {
        this.ra = skyCoordinates;
        this.dec = skyCoordinates2;
        this.radiusOfSearch = angle;
        this.receiverBand = receiverBand;
        this.angularResolution = userAngle;
        this.dgcCalibratorToSearchFor = dGCTypeEnum;
        this.b2bCalibratorCategory = optional;
    }

    public static GridSearchInputParametersBuilder builder() {
        return new GridSearchInputParametersBuilder();
    }

    public SkyCoordinates getRa() {
        return this.ra;
    }

    public SkyCoordinates getDec() {
        return this.dec;
    }

    public Angle getRadiusOfSearch() {
        return this.radiusOfSearch;
    }

    public ReceiverBand getReceiverBand() {
        return this.receiverBand;
    }

    public UserAngle getAngularResolution() {
        return this.angularResolution;
    }

    public DGCExpert.DGCTypeEnum getDgcCalibratorToSearchFor() {
        return this.dgcCalibratorToSearchFor;
    }

    public Optional<DGCExpert.B2BSchedulingOutcome> getB2bCalibratorCategory() {
        return this.b2bCalibratorCategory;
    }

    public void setRa(SkyCoordinates skyCoordinates) {
        this.ra = skyCoordinates;
    }

    public void setDec(SkyCoordinates skyCoordinates) {
        this.dec = skyCoordinates;
    }

    public void setRadiusOfSearch(Angle angle) {
        this.radiusOfSearch = angle;
    }

    public void setReceiverBand(ReceiverBand receiverBand) {
        this.receiverBand = receiverBand;
    }

    public void setAngularResolution(UserAngle userAngle) {
        this.angularResolution = userAngle;
    }

    public void setDgcCalibratorToSearchFor(DGCExpert.DGCTypeEnum dGCTypeEnum) {
        this.dgcCalibratorToSearchFor = dGCTypeEnum;
    }

    public void setB2bCalibratorCategory(Optional<DGCExpert.B2BSchedulingOutcome> optional) {
        this.b2bCalibratorCategory = optional;
    }

    public static class GridSearchInputParametersBuilder {
        private boolean ra$set;
        private SkyCoordinates ra$value;
        private boolean dec$set;
        private SkyCoordinates dec$value;
        private boolean radiusOfSearch$set;
        private Angle radiusOfSearch$value;
        private boolean receiverBand$set;
        private ReceiverBand receiverBand$value;
        private boolean angularResolution$set;
        private UserAngle angularResolution$value;
        private boolean dgcCalibratorToSearchFor$set;
        private DGCExpert.DGCTypeEnum dgcCalibratorToSearchFor$value;
        private boolean b2bCalibratorCategory$set;
        private Optional<DGCExpert.B2BSchedulingOutcome> b2bCalibratorCategory$value;

        GridSearchInputParametersBuilder() {
        }

        public GridSearchInputParametersBuilder ra(SkyCoordinates skyCoordinates) {
            this.ra$value = skyCoordinates;
            this.ra$set = true;
            return this;
        }

        public GridSearchInputParametersBuilder dec(SkyCoordinates skyCoordinates) {
            this.dec$value = skyCoordinates;
            this.dec$set = true;
            return this;
        }

        public GridSearchInputParametersBuilder radiusOfSearch(Angle angle) {
            this.radiusOfSearch$value = angle;
            this.radiusOfSearch$set = true;
            return this;
        }

        public GridSearchInputParametersBuilder receiverBand(ReceiverBand receiverBand) {
            this.receiverBand$value = receiverBand;
            this.receiverBand$set = true;
            return this;
        }

        public GridSearchInputParametersBuilder angularResolution(UserAngle userAngle) {
            this.angularResolution$value = userAngle;
            this.angularResolution$set = true;
            return this;
        }

        public GridSearchInputParametersBuilder dgcCalibratorToSearchFor(DGCExpert.DGCTypeEnum dGCTypeEnum) {
            this.dgcCalibratorToSearchFor$value = dGCTypeEnum;
            this.dgcCalibratorToSearchFor$set = true;
            return this;
        }

        public GridSearchInputParametersBuilder b2bCalibratorCategory(Optional<DGCExpert.B2BSchedulingOutcome> optional) {
            this.b2bCalibratorCategory$value = optional;
            this.b2bCalibratorCategory$set = true;
            return this;
        }

        public GridSearchInputParameters build() {
            SkyCoordinates skyCoordinates = this.ra$value;
            if (!this.ra$set) {
                skyCoordinates = GridSearchInputParameters.$default$ra();
            }
            SkyCoordinates skyCoordinates2 = this.dec$value;
            if (!this.dec$set) {
                skyCoordinates2 = GridSearchInputParameters.$default$dec();
            }
            Angle angle = this.radiusOfSearch$value;
            if (!this.radiusOfSearch$set) {
                angle = GridSearchInputParameters.$default$radiusOfSearch();
            }
            ReceiverBand receiverBand = this.receiverBand$value;
            if (!this.receiverBand$set) {
                receiverBand = GridSearchInputParameters.$default$receiverBand();
            }
            UserAngle userAngle = this.angularResolution$value;
            if (!this.angularResolution$set) {
                userAngle = GridSearchInputParameters.$default$angularResolution();
            }
            DGCExpert.DGCTypeEnum dGCTypeEnum = this.dgcCalibratorToSearchFor$value;
            if (!this.dgcCalibratorToSearchFor$set) {
                dGCTypeEnum = GridSearchInputParameters.$default$dgcCalibratorToSearchFor();
            }
            Optional<DGCExpert.B2BSchedulingOutcome> optional = this.b2bCalibratorCategory$value;
            if (!this.b2bCalibratorCategory$set) {
                optional = GridSearchInputParameters.$default$b2bCalibratorCategory();
            }
            return new GridSearchInputParameters(skyCoordinates, skyCoordinates2, angle, receiverBand, userAngle, dGCTypeEnum, optional);
        }

        public String toString() {
            return "GridSearchInputParameters.GridSearchInputParametersBuilder(ra$value=" + this.ra$value + ", dec$value=" + this.dec$value + ", radiusOfSearch$value=" + this.radiusOfSearch$value + ", receiverBand$value=" + this.receiverBand$value + ", angularResolution$value=" + this.angularResolution$value + ", dgcCalibratorToSearchFor$value=" + this.dgcCalibratorToSearchFor$value + ", b2bCalibratorCategory$value=" + this.b2bCalibratorCategory$value + ")";
        }
    }
}

