/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetWithIntent;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.TargetCache;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTargetFactory;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.intermediatetarget.PointingCalForCalGroupIntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.PolarizationCalIntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.util.MiscUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.NonNull;

public abstract class InterferometrySchedBlockGenerator
extends SBGeneratorTemplate {
    protected InterferometrySchedBlockGenerator(@NonNull RequestedArray requestedArray) {
        super(requestedArray);
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<Collection<SchedBlock>> getSchedBlocks(@NonNull ScienceGoal scienceGoal) {
        void var8_17;
        Object object;
        List<IntermediateTarget> list;
        EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet;
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        try {
            this.antennaRelatedTOSTimeMultiplier = this.getAntennaMultiplier(scienceGoal);
            this.sbContext.setAntennaRelatedTOSTimeMultiplier(this.antennaRelatedTOSTimeMultiplier);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new WizardSBGenerationException(invalidObsProgramParametersException.getMessage());
        }
        List<ScienceGoal> list2 = null;
        try {
            list2 = ScienceGoalSchedBlockGenerator.splitByTuning(scienceGoal);
            if (list2.isEmpty() && !scienceGoal.getSpectralSetupParameters().isSpectralScan()) {
                throw new WizardSBGenerationException("Unable to determine tunings - is the spectral setup valid?");
            }
        }
        catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings | IndexOutOfBoundsException exception) {
            Log.logger(InterferometrySchedBlockGenerator.class).warning("Unable to split the science goal up into distinct tunings");
            throw new WizardSBGenerationException(exception);
        }
        assert (list2 != null);
        try {
            enumSet = SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, this.array, Optional.of(list2.size() > 1));
        }
        catch (UnknownEntityException unknownEntityException) {
            throw new WizardSBGenerationException(unknownEntityException);
        }
        this.sbContext.setScienceGoal(scienceGoal).setSBGenerationSchema(enumSet);
        this.parentScienceGoal = scienceGoal;
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.SPECTRAL_SCAN)) {
            list = this.getIntermediateTargets(scienceGoal, enumSet);
        } else if (list2.size() == 1) {
            this.setKeyTargetParameterToTuningMasterSource(scienceGoal, list2.get(0));
            list = this.getIntermediateTargets(scienceGoal, enumSet);
        } else {
            int n = 1;
            list = new ArrayList<IntermediateTarget>();
            for (ScienceGoal object4 : list2) {
                list.addAll(this.getIntermediateTargets(object4, n++, enumSet));
            }
            this.removeRedundantCalibrationsFromOG1(list, enumSet);
        }
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        TargetCache targetCache = TargetCache.getInstance();
        for (IntermediateTarget intermediateTarget : list) {
            for (Target target : intermediateTarget.getTargets()) {
                targetCache.addTarget(target, this.sbContext.getSBType());
                this.addTargetToSchedBlock(schedBlock, target);
            }
            this.getObservingGroup(schedBlock, "Calibrators 1");
            for (OrderedTarget orderedTarget : intermediateTarget.getOrderedTargets()) {
                Target target = orderedTarget.getTarget();
                ObservingGroup observingGroup = this.getObservingGroup(schedBlock, target);
                orderedTarget.setIndex(observingGroup.getOrderedTargetCount() + 1);
                observingGroup.addOrderedTarget(orderedTarget);
            }
            object = intermediateTarget.getRepresentativeTarget();
            if (object == null) continue;
            this.setRepresentativeTarget(schedBlock, (Target)object);
        }
        boolean bl = InterferometrySchedBlockGenerator.enforceMinimumOnSourceTimePerSB(schedBlock);
        Double d = this.antennaRelatedTOSTimeMultiplier;
        if (bl && this.antennaRelatedTOSTimeMultiplier < 1.0) {
            Double d2 = 1.0;
        }
        schedBlock.setSbGenerationContext(this.sbContext);
        SchedBlockWorker.setupSchedBlock(scienceGoal, schedBlock, this.array, (Double)var8_17, enumSet);
        SchedBlockWorker.renameMultipleTuningObservingGroups(schedBlock, enumSet);
        object = new ArrayList<SchedBlock>();
        object.add(schedBlock);
        ArrayList<Collection<SchedBlock>> arrayList = new ArrayList<Collection<SchedBlock>>();
        arrayList.add((Collection<SchedBlock>)object);
        this.setObservingGroupDopplerTarget(schedBlock);
        return arrayList;
    }

    private void removeRedundantCalibrationsFromOG1(List<IntermediateTarget> list, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.POLARISATION)) {
            ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
            boolean bl = false;
            for (IntermediateTarget intermediateTarget : list) {
                PolarizationCalIntermediateTarget polarizationCalIntermediateTarget;
                if (!(intermediateTarget instanceof PolarizationCalIntermediateTarget) || (polarizationCalIntermediateTarget = (PolarizationCalIntermediateTarget)intermediateTarget).getObservingGroupPointer() != ObservingGroupManager.ObservingGroupType.CALIBRATOR.getNominalObservingGroup()) continue;
                if (bl) {
                    arrayList.add(intermediateTarget);
                    continue;
                }
                bl = true;
            }
            list.removeAll(arrayList);
        }
    }

    protected List<IntermediateTarget> getAmpCalInclusiveSystemCalIntermediateTargets(@NonNull ScienceGoal scienceGoal, Integer n, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        boolean bl = enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC) && !scienceGoal.getCalibrationSetupParameters().getIsDGCOverride();
        ArrayList<QuerySource> arrayList = new ArrayList<QuerySource>();
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_AMPLITUDE));
        if (bl) {
            arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_AMPLITUDE));
        }
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_BANDPASS));
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_PHASE));
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POINTING));
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.POLARISATION)) {
            arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POLARIZATION));
        }
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        for (QuerySource object : arrayList) {
            object.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
            object.setQueryCenter(skyCoordinates.deepCopy());
            object.setMaxSources(40);
        }
        ArrayList arrayList2 = new ArrayList();
        for (QuerySource querySource : arrayList) {
            arrayList2.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        if (bl) {
            this.addDGCCalibrators(scienceGoal, n, arrayList2, enumSet);
        }
        return arrayList2;
    }

    protected List<IntermediateTarget> getSystemCalIntermediateTargets(@NonNull ScienceGoal scienceGoal, Integer n, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        ArrayList<QuerySource> arrayList = new ArrayList<QuerySource>();
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_BANDPASS));
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_PHASE));
        arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POINTING));
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.POLARISATION)) {
            arrayList.add(QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POLARIZATION));
        }
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        for (QuerySource object : arrayList) {
            object.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
            object.setQueryCenter(skyCoordinates.deepCopy());
            object.setMaxSources(40);
        }
        ArrayList arrayList2 = new ArrayList();
        for (QuerySource querySource : arrayList) {
            arrayList2.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC)) {
            this.addDGCCalibrators(scienceGoal, n, arrayList2, enumSet);
        }
        return arrayList2;
    }

    protected List<IntermediateTarget> getManualCalIntermediateTargets(@NonNull ScienceGoal scienceGoal, @NonNull Integer n, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        ObsType obsType;
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("tuningIndex is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        ArrayList<IntermediateTarget> arrayList = new ArrayList<IntermediateTarget>();
        CalibrationSetupParameters calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters();
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POINTING);
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        querySource.setQueryCenter(skyCoordinates.deepCopy());
        querySource.setMaxSources(40);
        arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        if (enumSet.contains((Object)SBGeneratorTemplate.SBGenerationSchema.DGC)) {
            this.addDGCCalibrators(scienceGoal, n, arrayList, enumSet);
        }
        boolean bl = false;
        for (CalibrationTargetParameters targetWithIntent : calibrationSetupParameters.getCalibrationTargetParameters()) {
            obsType = targetWithIntent.getObsType();
            if (obsType.equals((Object)ObsType.POINTING)) continue;
            if (obsType.equals((Object)ObsType.AMPLITUDE) && scienceGoal.isSpectralScan()) {
                bl = true;
            }
            if (obsType.equals((Object)ObsType.CHECKSOURCE)) {
                this.createCheckSourceFixedCalibratorSource(scienceGoal, n, arrayList, targetWithIntent);
                continue;
            }
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, targetWithIntent, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        for (TargetWithIntent targetWithIntent : calibrationSetupParameters.getQuerySource()) {
            obsType = ((QuerySource)targetWithIntent).getObsType();
            if (obsType.equals((Object)ObsType.POINTING)) continue;
            if (obsType.equals((Object)ObsType.AMPLITUDE) && scienceGoal.isSpectralScan()) {
                bl = true;
            }
            if (obsType.equals((Object)ObsType.CHECKSOURCE)) {
                this.createCheckSourceQuerySource(scienceGoal, n, arrayList, (QuerySource)targetWithIntent);
                continue;
            }
            arrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, targetWithIntent, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext));
        }
        if (bl) {
            this.addSpectralScanRelatedAmpcalPointing(scienceGoal, n, arrayList, skyCoordinates);
        }
        return arrayList;
    }

    private void createCheckSourceQuerySource(ScienceGoal scienceGoal, Integer n, List<IntermediateTarget> list, QuerySource querySource) {
        Collection<IntermediateTarget> collection = IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext);
        IQuerySource iQuerySource = querySource.deepCopy();
        iQuerySource.setIntendedUse(QuerySource.INTENDEDUSE_PHASE);
        ((QuerySource)iQuerySource).setDependentTargetsMandated(true);
        Collection<IntermediateTarget> collection2 = IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, (TargetWithIntent)((Object)iQuerySource), scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext);
        for (IntermediateTarget intermediateTarget : collection2) {
            collection.stream().forEach(intermediateTarget2 -> {
                intermediateTarget2.useAsTemplate(intermediateTarget);
                intermediateTarget2.getTargets().forEach(target -> target.getFieldSource().setName("Check"));
            });
        }
        list.addAll(collection);
    }

    private void createCheckSourceFixedCalibratorSource(ScienceGoal scienceGoal, Integer n, List<IntermediateTarget> list, CalibrationTargetParameters calibrationTargetParameters) {
        Collection<IntermediateTarget> collection = IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, calibrationTargetParameters, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext);
        CalibrationTargetParameters calibrationTargetParameters2 = calibrationTargetParameters.deepCopy();
        calibrationTargetParameters2.setIntendedUse(QuerySource.INTENDEDUSE_PHASE);
        calibrationTargetParameters2.setDependentTargetsMandated(true);
        Collection<IntermediateTarget> collection2 = IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, calibrationTargetParameters2, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext);
        for (IntermediateTarget intermediateTarget : collection2) {
            collection.stream().forEach(intermediateTarget2 -> {
                intermediateTarget2.useAsTemplate(intermediateTarget);
                intermediateTarget2.getTargets().forEach(target -> target.getFieldSource().setName("Check"));
            });
        }
        list.addAll(collection);
    }

    protected void addDGCCalibrators(@NonNull ScienceGoal scienceGoal, @NonNull Integer n, @NonNull List<IntermediateTarget> list, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("tuningIndex is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("intermediateTargets is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUse is marked non-null but is null");
        }
        if (scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
            return;
        }
        SkyCoordinates skyCoordinates = scienceGoal.getKeyTargetParameters().getSourceCoordinates().getJ2000SkyCoordinates();
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_DGCREFERENCE);
        querySource.setSearchRadius(Angle.createAngle((double)40.0, (String)Angle.UNIT_DEG));
        querySource.setQueryCenter(skyCoordinates.deepCopy());
        querySource.setMaxSources(40);
        QuerySource querySource2 = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_DGCSCIENCE);
        querySource2.setSearchRadius(Angle.createAngle((double)40.0, (String)Angle.UNIT_DEG));
        querySource2.setQueryCenter(skyCoordinates.deepCopy());
        querySource2.setMaxSources(40);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        list.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, spectralSetupParameters, this.array, this.getObservingGroupManager(), n, this.sbContext));
        list.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource2, spectralSetupParameters, this.array, this.getObservingGroupManager(), n, this.sbContext));
    }

    private void addSpectralScanRelatedAmpcalPointing(@NonNull ScienceGoal scienceGoal, int n, @NonNull List<IntermediateTarget> list, @NonNull SkyCoordinates skyCoordinates) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("targets is marked non-null but is null");
        }
        if (skyCoordinates == null) {
            throw new NullPointerException("coords is marked non-null but is null");
        }
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_POINTING);
        querySource.setSearchRadius(Angle.createAngle((double)20.0, (String)Angle.UNIT_DEG));
        querySource.setQueryCenter(skyCoordinates.deepCopy());
        querySource.setMaxSources(40);
        Collection<IntermediateTarget> collection = IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, querySource, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), n, this.sbContext);
        List list2 = collection.stream().filter(intermediateTarget -> !(intermediateTarget instanceof PointingCalForCalGroupIntermediateTarget)).collect(Collectors.toList());
        list2.stream().forEach(collection::remove);
        collection.stream().forEach(intermediateTarget -> intermediateTarget.getTargets().stream().forEach(target -> target.getFieldSource().setName("Amplitude pointing")));
        list.addAll(collection);
    }

    protected List<IntermediateTarget> getIntermediateTargets(ScienceGoal scienceGoal, Integer n, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        this.tuningGroup = n;
        return this.getIntermediateTargets(scienceGoal, enumSet);
    }

    protected List<IntermediateTarget> getIntermediateTargets(@NonNull ScienceGoal scienceGoal, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        CopyOnWriteArrayList<IntermediateTarget> copyOnWriteArrayList = new CopyOnWriteArrayList<IntermediateTarget>();
        if (MiscUtils.isParallelismToBeUsed()) {
            // empty if block
        }
        Arrays.asList(scienceGoal.getTargetParameters()).stream().forEach(targetParameters -> copyOnWriteArrayList.addAll(IntermediateTargetFactory.getIntermediateTarget(this.parentScienceGoal, targetParameters, scienceGoal.getSpectralSetupParameters(), this.array, this.getObservingGroupManager(), this.tuningGroup, this.sbContext)));
        CalibrationSetupParameters calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters();
        if (calibrationSetupParameters.isSystemDefinedCalibration()) {
            copyOnWriteArrayList.addAll(this.getSystemCalIntermediateTargets(scienceGoal, this.tuningGroup, enumSet));
        } else if (calibrationSetupParameters.isAmplitudeSpecificSystemDefinedCalibration()) {
            copyOnWriteArrayList.addAll(this.getAmpCalInclusiveSystemCalIntermediateTargets(scienceGoal, this.tuningGroup, enumSet));
        } else {
            copyOnWriteArrayList.addAll(this.getManualCalIntermediateTargets(scienceGoal, this.tuningGroup, enumSet));
        }
        this.sortTargets(copyOnWriteArrayList);
        return copyOnWriteArrayList;
    }
}

