/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.schedblock.AbstractBaseBandConfig;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.FrequencySetup;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.ObservingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SchedulingConstraints;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.calibration.SBTimeEstimateHelper;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.MinTuningsCalculator;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.ScienceGoalSchedBlockGenerator;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.intermediatetarget.ObservingGroupManager;
import alma.obsprep.services.generator.refactored.sbbuilder.RepresentativeTargetCalculator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerator;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.IntTimeSource;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.NonNull;

public abstract class SBGeneratorTemplate
implements SBGenerator {
    protected SBGenerationContext sbContext = new SBGenerationContext();
    protected ScienceGoal parentScienceGoal = null;
    protected Double antennaRelatedTOSTimeMultiplier = 1.0;
    private ObservingGroupManager observingGroupManager = new ObservingGroupManager();
    protected final RequestedArray array;
    protected int tuningGroup = 1;

    protected abstract double getAntennaMultiplier(@NonNull ScienceGoal var1) throws InvalidObsProgramParametersException;

    protected SBGeneratorTemplate(@NonNull RequestedArray requestedArray) {
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.array = requestedArray;
        this.sbContext.setArray(requestedArray);
        this.observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.CALIBRATOR, 1);
        this.observingGroupManager.getObservingGroupIndex(ObservingGroupManager.ObservingGroupType.SCIENCE, 1);
    }

    protected void setRepresentativeTarget(@NonNull SchedBlock schedBlock, @NonNull Target target) {
        Object object;
        Object object2;
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("repTarget is marked non-null but is null");
        }
        FieldSource fieldSource = target.getFieldSource();
        SchedulingConstraints schedulingConstraints = schedBlock.getSchedulingConstraints();
        schedulingConstraints.setRepresentativeTarget(target);
        try {
            object2 = fieldSource.getSourceCoordinates().deepCopy();
            object2.getLatitude().convertToUnit(Latitude.UNIT_DEG);
            object2.getLongitude().convertToUnit(Longitude.UNIT_DEG);
            schedulingConstraints.setRepresentativeCoordinates((SkyCoordinates)object2);
        }
        catch (Exception exception) {
            GUIUtilities.error(null, "Could not get coordinate information from representative target");
            object = SkyCoordinates.createAbsoluteCoordinates();
            object.getLatitude().convertToUnit(Latitude.UNIT_DEG);
            object.getLongitude().convertToUnit(Longitude.UNIT_DEG);
            schedulingConstraints.setRepresentativeCoordinates((SkyCoordinates)object);
        }
        try {
            object2 = target.getSpectralSpec().getFrequencySetup().getReceiverBand();
            schedulingConstraints.setRepresentativeReceiverBand((String)object2);
        }
        catch (Exception exception) {
            GUIUtilities.error(null, "Could not get frequency information from representative target");
            object = FrequencySetup.RECEIVERBAND_UNDEFINED;
            schedulingConstraints.setRepresentativeReceiverBand((String)object);
        }
    }

    protected void sortTargets(@NonNull List<IntermediateTarget> list) {
        if (list == null) {
            throw new NullPointerException("targets is marked non-null but is null");
        }
        Collections.sort(list, (intermediateTarget, intermediateTarget2) -> intermediateTarget.getTargetPriority() - intermediateTarget2.getTargetPriority());
    }

    private void sortOrderedGroupsByIndex(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        ObservingGroup[] observingGroupArray = schedBlock.getObservingGroup();
        List<String> list = this.observingGroupManager.getOrderedListOfObservingGroupNames();
        Arrays.sort(observingGroupArray, (observingGroup, observingGroup2) -> list.indexOf(observingGroup.getName()) - list.indexOf(observingGroup2.getName()));
        schedBlock.setObservingGroup(observingGroupArray);
        for (ObservingGroup observingGroup3 : schedBlock.getObservingGroup()) {
            try {
                observingGroup3.setIndex(this.observingGroupManager.getObservingGroupIndex(observingGroup3.getName()));
            }
            catch (ObservingGroupManager.ObservingGroupNotFoundException observingGroupNotFoundException) {
                throw new RuntimeException("Unable to determine group index");
            }
        }
    }

    protected void addTargetToSchedBlock(@NonNull SchedBlock schedBlock, @NonNull Target target) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        schedBlock.addFieldSource(target.getFieldSource());
        schedBlock.addSpectralSpec(target.getSpectralSpec());
        Stream.of(target.getObservingParameters()).forEach(observingParameters -> schedBlock.addObservingParameters((ObservingParameters)observingParameters));
        schedBlock.addTarget(target);
        Stream.of(target.getSpectralSpec().getCorrelatorConfiguration().getBaseBandConfig()).forEach(AbstractBaseBandConfig::getBaseBandSpecification);
    }

    ObservingGroup getObservingGroup(@NonNull SchedBlock schedBlock, @NonNull String string) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (string == null) {
            throw new NullPointerException("observingGroupLabel is marked non-null but is null");
        }
        ObservingGroupManager.ObservingGroupData observingGroupData = null;
        try {
            observingGroupData = this.observingGroupManager.getObservingGroupByIndex(this.observingGroupManager.getObservingGroupIndex(string));
        }
        catch (ObservingGroupManager.ObservingGroupNotFoundException observingGroupNotFoundException) {
            throw new RuntimeException(observingGroupNotFoundException);
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            if (!observingGroup.getName().equals(observingGroupData.getObservingGroupName()) || observingGroup.getIndex() != observingGroupData.getObservingGroupIndex().intValue()) continue;
            return observingGroup;
        }
        ObservingGroup observingGroup = ObservingGroup.createObservingGroup();
        observingGroup.setName(observingGroupData.getObservingGroupName());
        observingGroup.setIndex(observingGroupData.getObservingGroupIndex());
        schedBlock.addObservingGroup(observingGroup);
        this.sortOrderedGroupsByIndex(schedBlock);
        return observingGroup;
    }

    protected ObservingGroup getObservingGroup(@NonNull SchedBlock schedBlock, @NonNull Target target) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        ObservingGroupManager.ObservingGroupData observingGroupData = null;
        try {
            observingGroupData = this.observingGroupManager.getObservingGroupByIndex(target.getIntendedObservingGroupList()[0]);
        }
        catch (ObservingGroupManager.ObservingGroupNotFoundException observingGroupNotFoundException) {
            throw new WizardSBGenerationException(observingGroupNotFoundException);
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            if (!observingGroup.getName().equals(observingGroupData.getObservingGroupName()) || observingGroup.getIndex() != observingGroupData.getObservingGroupIndex().intValue()) continue;
            return observingGroup;
        }
        ObservingGroup observingGroup = ObservingGroup.createObservingGroup();
        observingGroup.setName(observingGroupData.getObservingGroupName());
        observingGroup.setIndex(observingGroupData.getObservingGroupIndex());
        schedBlock.addObservingGroup(observingGroup);
        this.sortOrderedGroupsByIndex(schedBlock);
        return observingGroup;
    }

    public static boolean enforceMinimumOnSourceTimePerSB(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        ArrayList<ScienceParameters> arrayList = new ArrayList<ScienceParameters>();
        Time time = Time.createTimeSec(0.0);
        for (ObservingGroup object : schedBlock.getObservingGroup()) {
            for (OrderedTarget orderedTarget : object.getOrderedTarget()) {
                Target target = orderedTarget.getTarget();
                for (ScienceParameters scienceParameters : target.getScienceParametersList()) {
                    time.aggregate(scienceParameters.getIntegrationTime().getTime());
                    arrayList.add(scienceParameters);
                }
            }
        }
        boolean bl = false;
        Time time2 = Time.createTime();
        for (Target target : schedBlock.getAllTargets(Optional.of(Target::hasAmplitudeCalParameters))) {
            for (AmplitudeCalParameters amplitudeCalParameters : target.getAmplitudeCalParametersList()) {
                time2.aggregate(amplitudeCalParameters.getDefaultIntegrationTime());
            }
        }
        for (Target target : schedBlock.getAllTargets(Optional.of(Target::hasBandpassCalParameters))) {
            for (BandpassCalParameters bandpassCalParameters : target.getBandpassCalParametersList()) {
                time2.aggregate(bandpassCalParameters.getDefaultIntegrationTime());
            }
        }
        Time time3 = Time.max(time2 = (Time)time2.divide(2.0), AlmaPolicies.getInstance().getMinTimeOnSourcePerSB());
        if (time.isLessThan((AbstractDoubleWithUnit)time3)) {
            bl = true;
            Integer n = arrayList.size();
            Time time4 = (Time)((Time)time3.minus((AbstractDoubleWithUnit)time)).divide(n.intValue());
            for (ScienceParameters scienceParameters : arrayList) {
                Time time5 = (Time)scienceParameters.getIntegrationTime().getTime().plus((AbstractDoubleWithUnit)time4);
                scienceParameters.setIntegrationTime(IntTimeSource.createIntTimeSource((double)time5.getContentInDefaultUnits(), (String)IntTimeSource.UNIT_S));
            }
        }
        return bl;
    }

    @Override
    public void setObservingGroupDopplerTarget(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        for (ObservingGroup observingGroup : schedBlock.getObservingGroup()) {
            String string = observingGroup.getName();
            assert (string != null);
            try {
                if (!SBTimeEstimateHelper.GroupType.SCIENCE.equals((Object)SBTimeEstimateHelper.GroupType.getGroupType(string))) continue;
                RepresentativeTargetCalculator representativeTargetCalculator = new RepresentativeTargetCalculator();
                Target target = representativeTargetCalculator.getRepresentativeScienceTargetInObservingGroup(observingGroup, schedBlock, this.sbContext);
                observingGroup.setMainTarget(target);
                Log.logger(SBGeneratorTemplate.class).fine(String.format("Rep. target for observing group %s is %s", observingGroup.getName(), target.getFieldSource().getSourceName()));
            }
            catch (SchedBlock.UnableToFindParentScienceGoalException | SBTimeEstimateHelper.UnknownObservingGroupTypeException | RepresentativeTargetCalculator.UnableToDetermineRepTargetForObservingGroupException exception) {
                throw new WizardSBGenerationException("Unable to set the doppler target for the observing group: " + string + " " + exception.getMessage());
            }
        }
    }

    protected void setKeyTargetParameterToTuningMasterSource(@NonNull ScienceGoal scienceGoal, @NonNull ScienceGoal scienceGoal2) {
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        if (scienceGoal2 == null) {
            throw new NullPointerException("tuningSpecificSG is marked non-null but is null");
        }
        String string = scienceGoal2.getKeyTargetParameters().getSourceName();
        for (int i = 0; i < scienceGoal.getTargetParameters().length; ++i) {
            TargetParameters targetParameters = scienceGoal.getTargetParameters()[i];
            if (!targetParameters.getSourceName().equals(string)) continue;
            scienceGoal.setKeyTargetParameters(i);
            return;
        }
        throw new WizardSBGenerationException("Unable to find key target parameters in destination science goal for " + string);
    }

    private static void addMinorSBGenerationSchema(@NonNull EnumSet<SBGenerationSchema> enumSet, @NonNull SBGenerationSchema sBGenerationSchema) {
        if (enumSet == null) {
            throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
        }
        if (sBGenerationSchema == null) {
            throw new NullPointerException("minorMode is marked non-null but is null");
        }
        if (sBGenerationSchema.equals((Object)SBGenerationSchema.SOLAR) && enumSet.contains((Object)SBGenerationSchema.VLBI)) {
            return;
        }
        if (sBGenerationSchema.equals((Object)SBGenerationSchema.VLBI) && enumSet.contains((Object)SBGenerationSchema.SOLAR)) {
            enumSet.remove((Object)SBGenerationSchema.SOLAR);
        }
        enumSet.add(sBGenerationSchema);
    }

    public static EnumSet<SBGenerationSchema> determineSBGenerationSchema(@NonNull ScienceGoal scienceGoal, @NonNull RequestedArray requestedArray, @NonNull Optional<Boolean> optional) throws UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("sbGoal is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("isMultipleTuning is marked non-null but is null");
        }
        EnumSet<SBGenerationSchema> enumSet = SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, optional);
        if (requestedArray.equals((Object)RequestedArray.ACA) || requestedArray.equals((Object)RequestedArray.SEVEN_M)) {
            enumSet.add(SBGenerationSchema.ACA_7M);
        }
        return enumSet;
    }

    private static EnumSet<SBGenerationSchema> determineSBGenerationSchema(@NonNull ScienceGoal scienceGoal, @NonNull Optional<Boolean> optional) throws UnknownEntityException {
        Object object;
        Object object2;
        List<Object> list;
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("isMultipleTuning is marked non-null but is null");
        }
        EnumSet<SBGenerationSchema> enumSet = EnumSet.noneOf(SBGenerationSchema.class);
        SchedBlockWorker.setMajorSBGenerationSchema(enumSet, SBGenerationSchema.STANDARD);
        if (scienceGoal.isSpectralScan()) {
            SchedBlockWorker.setMajorSBGenerationSchema(enumSet, SBGenerationSchema.SPECTRAL_SCAN);
        } else if (!scienceGoal.getSpectralSetupParameters().isSingleContinuumSkyFrequency()) {
            if (optional.isEmpty()) {
                list = null;
                try {
                    list = ScienceGoalSchedBlockGenerator.splitByTuning(scienceGoal);
                }
                catch (MinTuningsCalculator.UnableToCalculateMinNumberOfTunings | IndexOutOfBoundsException exception) {
                    Log.logger(SchedBlockWorker.class).warning("Unable to split by tuning " + exception.getMessage());
                    throw new WizardSBGenerationException(exception);
                }
                assert (list != null);
                if (list.size() > 1) {
                    SchedBlockWorker.setMajorSBGenerationSchema(enumSet, SBGenerationSchema.MULTIPLE_TUNING);
                }
            } else if (optional.get().booleanValue()) {
                SchedBlockWorker.setMajorSBGenerationSchema(enumSet, SBGenerationSchema.MULTIPLE_TUNING);
            }
        }
        try {
            list = Configuration.getConfigurationsToBeScheduled(scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            list = null;
        }
        if (list != null) {
            boolean bl = false;
            object2 = ((ArrayList)list).iterator();
            while (object2.hasNext()) {
                object = (ConfigurationSet)object2.next();
                if (!object.getTM1Configuration().isPresent() || !Configuration.isLongBaselineConfiguration(object.getTM1Configuration().get())) continue;
                bl = true;
                break;
            }
            if ((object2 = scienceGoal.getReceiverBand()) != null && bl && scienceGoal.getSpectralSetupParameters().isWalshSwitching() && ReceiverBand.isReceiverBandInSet((ReceiverBand)object2, 9, 10)) {
                SBGeneratorTemplate.addMinorSBGenerationSchema(enumSet, SBGenerationSchema.HIGHBAND_WALSH_LONGBASELINE);
            }
        }
        if (scienceGoal.isPolarizationObservation()) {
            SBGeneratorTemplate.addMinorSBGenerationSchema(enumSet, SBGenerationSchema.POLARISATION);
        }
        if (scienceGoal.getObsProposal().isVLBIorPhasedArray()) {
            SBGeneratorTemplate.addMinorSBGenerationSchema(enumSet, SBGenerationSchema.VLBI);
        }
        if (scienceGoal.isSolarScienceGoal()) {
            SBGeneratorTemplate.addMinorSBGenerationSchema(enumSet, SBGenerationSchema.SOLAR);
        }
        assert (!enumSet.containsAll(List.of(SBGenerationSchema.SOLAR, SBGenerationSchema.VLBI))) : "VLBI and solar together is not permitted";
        Set<DGCExpert.DGCTypeEnum> set = DGCExpert.getExpert(false).dgcObservingStrategiesRequired(scienceGoal, true);
        if (!set.contains((Object)DGCExpert.DGCTypeEnum.None)) {
            SBGeneratorTemplate.addMinorSBGenerationSchema(enumSet, SBGenerationSchema.DGC);
            if (set.containsAll(DGCExpert.allDGCStrategies)) {
                object2 = scienceGoal.isStandAloneACA() ? RequestedArray.SEVEN_M : RequestedArray.TWELVE_M;
                object = scienceGoal.isStandAloneACA() ? SchedBlockType.ACA7M : SchedBlockType.TWELVEMEXTENDEDCONFIGURATION;
                set = DGCExpert.getExpert(false).resolveWhichDGCStrategyToUse(scienceGoal, (RequestedArray)((Object)object2), Optional.of(object), set, Optional.of(enumSet));
            }
            if (set.contains((Object)DGCExpert.DGCTypeEnum.DGCBandToBand)) {
                SBGeneratorTemplate.addMinorSBGenerationSchema(enumSet, SBGenerationSchema.DGC_B2B);
            } else if (set.contains((Object)DGCExpert.DGCTypeEnum.DGCBandwidthSwitching)) {
                SBGeneratorTemplate.addMinorSBGenerationSchema(enumSet, SBGenerationSchema.DGC_BWSW);
            }
        }
        return enumSet;
    }

    public static EnumSet<SBGenerationSchema> determineSBGenerationSchema(@NonNull ScienceGoal scienceGoal, @NonNull String string) throws UnknownEntityException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (string == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        EnumSet<SBGenerationSchema> enumSet = SBGeneratorTemplate.determineSBGenerationSchema(scienceGoal, Optional.empty());
        if (string.equals(RequestedArray.SEVEN_M.getType()) || string.equals(RequestedArray.ACA.getType())) {
            SBGeneratorTemplate.addMinorSBGenerationSchema(enumSet, SBGenerationSchema.ACA_7M);
        }
        if (string.equals(RequestedArray.TP.getType())) {
            SBGeneratorTemplate.addMinorSBGenerationSchema(enumSet, SBGenerationSchema.ACA_TP);
        }
        return enumSet;
    }

    public ObservingGroupManager getObservingGroupManager() {
        return this.observingGroupManager;
    }

    public void setObservingGroupManager(ObservingGroupManager observingGroupManager) {
        this.observingGroupManager = observingGroupManager;
    }

    public static enum SBGenerationSchema {
        STANDARD,
        SPECTRAL_SCAN,
        MULTIPLE_TUNING,
        POLARISATION,
        ACA_7M,
        ACA_TP,
        VLBI,
        OBSERVATORYGOAL,
        SOLAR,
        HIGHBAND_WALSH_LONGBASELINE,
        DGC,
        DGC_BWSW,
        DGC_B2B;


        public static boolean isDGC(@NonNull Set<SBGenerationSchema> set) {
            if (set == null) {
                throw new NullPointerException("schemaToUseForSBGeneration is marked non-null but is null");
            }
            return !Sets.intersection(EnumSet.of(DGC, DGC_B2B, DGC_BWSW), set).isEmpty();
        }
    }

    public static enum SchedBlockType {
        SCHEDBLOCKTYPEUNKNOWN("", null),
        TWELVEMEXTENDEDCONFIGURATION("12m extended configuration", RequestedArray.TWELVE_M),
        TWELVEMCOMPACTCONFIGURATION("12m compact configuration", RequestedArray.TWELVE_M),
        ACA7M("ACA 7m", RequestedArray.SEVEN_M),
        TPAMPCAL("TP ampcal", RequestedArray.TP),
        TPSCIENCE("TP science SB", RequestedArray.TP);

        private String description;
        private RequestedArray arrayType;

        private SchedBlockType(String string2, RequestedArray requestedArray) {
            this.description = string2;
            this.setArrayType(requestedArray);
        }

        public String getDescription() {
            return this.description;
        }

        public RequestedArray getArrayType() {
            return this.arrayType;
        }

        public void setArrayType(RequestedArray requestedArray) {
            this.arrayType = requestedArray;
        }
    }
}

