/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.AngularResolutionLimitsExpertInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.obsprep.services.generator.refactored.sbbuilder.TwelveMetreSBGenerator;
import alma.valuetypes.Frequency;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class TwelveMetreCompactConfigurationSBGenerator
extends TwelveMetreSBGenerator {
    @Override
    public double getAntennaMultiplier(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        return Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.COMPACT12M, scienceGoal);
    }

    public TwelveMetreCompactConfigurationSBGenerator(@NonNull ScienceGoal scienceGoal, Double d) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        this.sbContext.setSBType(SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION).setArray(RequestedArray.TWELVE_M);
        this.sbContext.setConfiguration(this.determineConfigurationToBeUsed(scienceGoal));
    }

    @Override
    protected void addDGCCalibrators(@NonNull ScienceGoal scienceGoal, @NonNull Integer n, @NonNull List<IntermediateTarget> list, EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("tuningIndex is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("intermediateTargets is marked non-null but is null");
        }
        if (scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
            return;
        }
        Set<DGCExpert.DGCTypeEnum> set = DGCExpert.getExpert(true).dgcObservingStrategiesRequired(scienceGoal, true);
        enumSet.remove((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW);
        enumSet.remove((Object)SBGeneratorTemplate.SBGenerationSchema.DGC_B2B);
        enumSet.remove((Object)SBGeneratorTemplate.SBGenerationSchema.DGC);
        if (set.containsAll(DGCExpert.allDGCStrategies) || set.equals(EnumSet.of(DGCExpert.DGCTypeEnum.DGCBandwidthSwitching))) {
            enumSet.add(SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW);
            enumSet.add(SBGeneratorTemplate.SBGenerationSchema.DGC);
            super.addDGCCalibrators(scienceGoal, n, list, enumSet);
        } else if (set.contains((Object)DGCExpert.DGCTypeEnum.DGCBandToBand)) {
            enumSet.add(SBGeneratorTemplate.SBGenerationSchema.DGC_B2B);
            enumSet.add(SBGeneratorTemplate.SBGenerationSchema.DGC);
            super.addDGCCalibrators(scienceGoal, n, list, enumSet);
        }
    }

    private Configuration determineConfigurationToBeUsed(@NonNull ScienceGoal scienceGoal) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException {
        Object object;
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        try {
            object = scienceGoal.getObsProposal();
            if (object != null && ((ObsProposal)object).isVLBIorPhasedArray()) {
                return Configuration.getMostCompactConfiguration(RequestedArray.TWELVE_M);
            }
        }
        catch (UnknownEntityException | Configuration.UnableToDetermineConfigurationException throwable) {
            Log.logger(TwelveMetreCompactConfigurationSBGenerator.class).warning("Unable to determine if project is a VLBI project");
            throw new InvalidObsProgramParametersException(throwable);
        }
        object = scienceGoal.getPerformanceParameters();
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        Configuration configuration = null;
        try {
            configuration = Configuration.getBestConfiguration(object.getDesiredAngularResolution(), frequency, RequestedArray.TWELVE_M, scienceGoal);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger((Object)this).severe("Cannot establish the best array configuration for a desired angular resolution of " + object.getDesiredAngularResolution() + " with a rep. freq of " + frequency);
            throw new InvalidObsProgramParametersException(invalidConfigurationParametersException);
        }
        return Configuration.getSecondCompactConfiguration(configuration);
    }

    @Override
    protected AngularResolutionLimitsExpertInterface getSBAngularResolutionLimitsExpert() {
        return AngularResolutionLimitsExpertFactory.getARLimitsExpert(SBGeneratorTemplate.SchedBlockType.TWELVEMCOMPACTCONFIGURATION);
    }
}

