/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions;

import alma.Control.LO2Parameters;
import alma.Control.LOSolutions.LOSolutions;
import alma.Control.LOSolutions.SidebandSelect;
import alma.Control.SkyFreqSideband;
import alma.Control.TuningParameters;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.losolutions.LOSolutionException;
import alma.obsprep.services.losolutions.LOToolParameters;
import alma.obsprep.services.losolutions.OTLOsolutions;
import alma.obsprep.services.losolutions.wrappers.AbstractBasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.LO2ParametersWrapper;
import alma.obsprep.services.losolutions.wrappers.SidebandSelectWrapper;
import alma.obsprep.services.losolutions.wrappers.TuningParametersWrapper;
import alma.obsprep.util.GUIUtilities;
import alma.valuetypes.Frequency;
import java.util.List;
import java.util.Optional;

public class LOToolHelper {
    private final OTLOsolutions worker = OTLOsolutions.createOTLOsolutions();
    private LOToolParameters params;
    private TuningParameters tuningParameters;

    public void setParameters(LOToolParameters lOToolParameters) {
        this.params = lOToolParameters;
    }

    public Frequency calculateLO1Frequency() {
        Frequency frequency = Frequency.createFrequency();
        if (this.tuningParameters != null) {
            try {
                double d = this.worker.LO1Freq(this.tuningParameters);
                frequency.setContentInGHz(d / 1.0E9);
            }
            catch (Exception exception) {
                GUIUtilities.warning(null, exception.getMessage());
            }
        }
        return frequency;
    }

    public TuningParametersWrapper computeSolutions(ReceiverBand receiverBand) throws LOSolutionException {
        if (this.params == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Number of BasebandSpec : " + this.params.getBasebandParametersCount() + "\n");
        TuningParametersWrapper tuningParametersWrapper = null;
        try {
            List<AbstractBasebandSpecWrapper> list = this.params.getLOSBasebandSpecList();
            for (AbstractBasebandSpecWrapper abstractBasebandSpecWrapper : list) {
                stringBuilder.append(AbstractBasebandSpecWrapper.nativeBasebandSpecString(abstractBasebandSpecWrapper) + "\n");
            }
            this.tuningParameters = this.worker.computeSolutions(list, Optional.of(receiverBand));
            tuningParametersWrapper = new TuningParametersWrapper(this.tuningParameters);
            tuningParametersWrapper.setBasebandCount(list.size());
            tuningParametersWrapper.setActualLO1(this.calculateLO1Frequency());
            for (int i = 0; i < tuningParametersWrapper.getLO2Count(); ++i) {
                LO2ParametersWrapper lO2ParametersWrapper = tuningParametersWrapper.getLO2(i);
                LO2Parameters lO2Parameters = this.tuningParameters.LO2[i];
                double d = this.worker.IFfrequency(lO2Parameters);
                lO2ParametersWrapper.setIFFrequency(Frequency.createFrequencyGHZ(d / 1.0E9));
                d = LOSolutions.getLO2Freq((LO2Parameters)lO2Parameters);
                lO2ParametersWrapper.setLO2Frequency(Frequency.createFrequencyGHZ(d / 1.0E9));
                SidebandSelect sidebandSelect = this.getSidebandSelect(lO2Parameters.skyFreqSideband);
                lO2ParametersWrapper.setLSBSkyFrequency(Frequency.createFrequencyGHZ(0.0));
                lO2ParametersWrapper.setUSBSkyFrequency(Frequency.createFrequencyGHZ(0.0));
                boolean bl = sidebandSelect == SidebandSelect.Upper || sidebandSelect == SidebandSelect.Both;
                boolean bl2 = sidebandSelect == SidebandSelect.Lower || sidebandSelect == SidebandSelect.Both;
                d = bl2 ? this.worker.actualSkyFreq(this.tuningParameters, i, SidebandSelectWrapper.Lower) : 0.0;
                lO2ParametersWrapper.setLSBSkyFrequency(Frequency.createFrequencyGHZ(d / 1.0E9));
                d = bl ? this.worker.actualSkyFreq(this.tuningParameters, i, SidebandSelectWrapper.Upper) : 0.0;
                lO2ParametersWrapper.setUSBSkyFrequency(Frequency.createFrequencyGHZ(d / 1.0E9));
            }
            Log.logger((Object)this).info(stringBuilder.toString());
        }
        catch (Exception exception) {
            Log.logger((Object)this).warning(exception.getMessage());
            Log.logger((Object)this).info(stringBuilder.toString());
            throw new LOSolutionException(exception.getMessage());
        }
        return tuningParametersWrapper;
    }

    private SidebandSelect getSidebandSelect(SkyFreqSideband skyFreqSideband) {
        if (skyFreqSideband == SkyFreqSideband.LSB) {
            return SidebandSelect.Lower;
        }
        if (skyFreqSideband == SkyFreqSideband.USB) {
            return SidebandSelect.Upper;
        }
        if (skyFreqSideband == SkyFreqSideband.DSB) {
            return SidebandSelect.Both;
        }
        return SidebandSelect.Unknown;
    }

    public String getHardwareInfo() {
        try {
            return this.worker.getHardwareParameters();
        }
        catch (Exception exception) {
            return "<font color=red>(Could not get Hardware Info)</font>";
        }
    }
}

