/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions;

import alma.obsprep.guiutil.ColumnResizer;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.boEditors.ComponentCollection;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.gui.factory.Table;
import alma.obsprep.services.losolutions.LOToolTuningParametersModel;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class LOToolTuningParametersEditor
extends EditorWithGridBagLayout {
    private static final String classBaseName = LOToolTuningParametersEditor.class.getSimpleName() + ".";
    public static final FieldID RECEIVERBAND_FID = new FieldID(classBaseName + "receiverBand");
    public static final FieldID LSFREQUENCY_FID = new FieldID(classBaseName + "LSFrequency");
    public static final FieldID FLOOGFREQUENCY_FID = new FieldID(classBaseName + "FLOOGFrequency");
    public static final FieldID TUNEHIGH_FID = new FieldID(classBaseName + "tuneHigh");
    public static final FieldID WEIGHTEDERROR_FID = new FieldID(classBaseName + "weightedError");
    public static final FieldID SCORE_FID = new FieldID(classBaseName + "score");
    public static final FieldID ACTUALLO1_FID = new FieldID(classBaseName + "actualLO1");

    public LOToolTuningParametersEditor(Model model) {
        this.setModel(model);
        this.build();
        model.publish();
    }

    @Override
    public LOToolTuningParametersModel getModel() {
        return (LOToolTuningParametersModel)super.getModel();
    }

    @Override
    protected void addComponents(String string) {
        this.constraints.weightx = 1.0;
        JPanel jPanel = this.createNewGroup();
        GridBagLayout gridBagLayout = this.createNewLayout(jPanel);
        GridBagConstraints gridBagConstraints = this.createNewConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        ComponentCollection componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Receiver Band"));
        componentCollection.remember(this.makeTextField(RECEIVERBAND_FID, 10, false, "The receiver cartridge."));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("<html>LS Frequency (F<i><sub>ls</sub></i>)</html>)"));
        componentCollection.remember(this.makeTextField(LSFREQUENCY_FID, 10, false, "The Laser Synth frequency."));
        componentCollection.remember(this.makeLabel("<html>FLOOG Frequency (F<i><sub>fts1</sub></i>)</html>"));
        componentCollection.remember(this.makeTextField(FLOOGFREQUENCY_FID, 10, false, "First LO Offset Generator (FTS1) frequency"));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("TuneHigh"));
        JComponent[] jComponentArray = new JComponent[1];
        JCheckBox jCheckBox = this.makeCheckBox(TUNEHIGH_FID, "True if the FLOOG frequency is added to the 1st LO frequency.");
        jComponentArray[0] = jCheckBox;
        componentCollection.remember(jComponentArray);
        jCheckBox.setEnabled(false);
        componentCollection.remember(this.makeLabel("Weighted Error"));
        componentCollection.remember(this.makeTextField(WEIGHTEDERROR_FID, 10, false, "<html>Weighted error; the weighted sum of abs(actual - requested) frequency over all basebands.<br>This is one measure of the goodness of the tuning.</html>"));
        componentCollection.remember(this.makeLabel("Score"));
        componentCollection.remember(this.makeTextField(SCORE_FID, 10, false, "Score is measure of the relative desirability of tuning."));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        componentCollection = new ComponentCollection();
        componentCollection.remember(this.makeLabel("Actual LO1"));
        componentCollection.remember(this.makeTextField(ACTUALLO1_FID, 10, false, "The actual LO1 frequency"));
        this.addComponentArray(jPanel, gridBagLayout, gridBagConstraints, componentCollection);
        this.addVerticalSpace(jPanel, gridBagLayout, gridBagConstraints, 5);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, new JLabel("LO2"));
        Table table = new Table(this.getModel().getLO2TableModel());
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string = object == null ? null : TextUtils.format((Frequency)((Object)object), 4);
                return super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            }
        };
        table.setDefaultRenderer(Frequency.class, defaultTableCellRenderer);
        table.getTableHeader().setReorderingAllowed(false);
        Dimension dimension = new Dimension(600, 64);
        table.setPreferredSize(dimension);
        table.setPreferredScrollableViewportSize(dimension);
        ColumnResizer.initColumnSizes(table, this.getModel().getLO2TableModel().getLongValues());
        ScrollWhenFocusedPane scrollWhenFocusedPane = new ScrollWhenFocusedPane(table);
        this.addComponent(jPanel, gridBagLayout, gridBagConstraints, scrollWhenFocusedPane);
        this.addGroup(jPanel, "TuningParameters");
    }

    @Override
    protected void build() {
        super.build("TuningParameters");
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == LSFREQUENCY_FID || fieldID == FLOOGFREQUENCY_FID || fieldID == ACTUALLO1_FID) {
            Frequency frequency = (Frequency)((Object)object);
            String string = frequency == null ? null : TextUtils.format(frequency);
            super.update(fieldID, string);
            return;
        }
        if (fieldID == WEIGHTEDERROR_FID) {
            double d = (Double)object;
            super.update(fieldID, TextUtils.format(d, 0, 5));
            return;
        }
        if (fieldID == SCORE_FID) {
            double d = (Double)object;
            super.update(fieldID, TextUtils.format(d, 0, 5));
            return;
        }
        super.update(fieldID, object);
    }
}

