/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.losolutions.wrappers;

import alma.Control.BasebandSpec;
import alma.Control.DSBbasebandSpec;
import alma.Control.SSBbasebandSpec;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;

public abstract class AbstractBasebandSpecWrapper {
    public abstract void importNativeBasebandSpec(Object var1);

    public abstract Object exportNativeBasebandSpec();

    public abstract void setOneSkyFrequency(Frequency var1);

    public static String nativeBasebandSpecString(Object object) {
        if (object instanceof BasebandSpec) {
            return AbstractBasebandSpecWrapper.nativeBasebandSpecString((BasebandSpec)object);
        }
        if (object instanceof SSBbasebandSpec) {
            return AbstractBasebandSpecWrapper.nativeBasebandSpecString((SSBbasebandSpec)object);
        }
        if (object instanceof DSBbasebandSpec) {
            return AbstractBasebandSpecWrapper.nativeBasebandSpecString((DSBbasebandSpec)object);
        }
        return null;
    }

    public static String nativeBasebandSpecString(BasebandSpec basebandSpec) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("skyF = " + TextUtils.format(basebandSpec.skyFreqHz / 1.0E9, 3, 3) + "[GHz], ");
        stringBuilder.append("weight = " + TextUtils.format(basebandSpec.weight, 3, 1) + ", ");
        stringBuilder.append("ifF = " + TextUtils.format(basebandSpec.ifFreqHz / 1.0E9, 3, 3) + "[GHz]");
        return stringBuilder.toString();
    }

    public static String nativeBasebandSpecString(SSBbasebandSpec sSBbasebandSpec) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("skyF = " + TextUtils.format(sSBbasebandSpec.skyFreqHz / 1.0E9, 3, 3) + "[GHz], ");
        stringBuilder.append("weight = " + TextUtils.format(sSBbasebandSpec.weight, 3, 1) + ", ");
        stringBuilder.append("ifF = " + TextUtils.format(sSBbasebandSpec.ifFreqHz / 1.0E9, 3, 3) + "[GHz], ");
        stringBuilder.append("pref = " + sSBbasebandSpec.sidebandPref);
        return stringBuilder.toString();
    }

    public static String nativeBasebandSpecString(DSBbasebandSpec dSBbasebandSpec) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dSBbasebandSpec.getClass().getSimpleName() + "\n");
        stringBuilder.append("  LSB:" + AbstractBasebandSpecWrapper.nativeBasebandSpecString(dSBbasebandSpec.LSB) + "\n");
        stringBuilder.append("  USB:" + AbstractBasebandSpecWrapper.nativeBasebandSpecString(dSBbasebandSpec.USB));
        return stringBuilder.toString();
    }
}

