/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.submission;

import alma.obsprep.services.submission.Codecs;
import alma.obsprep.services.submission.Data;
import alma.obsprep.services.submission.NullRemoteProgressListener;
import alma.obsprep.services.submission.RemoteProgressListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InOut {
    public Data.StoreResponseData sendStore(RequestCharacteristics requestCharacteristics, Data.StoreRequestData storeRequestData, String[] stringArray, RemoteProgressListener remoteProgressListener) throws EncodingException, SendingException, DecodingException {
        Codecs.PostEncoder postEncoder = new Codecs.PostEncoder(requestCharacteristics.urlString, requestCharacteristics.userAgent);
        postEncoder.add("store", storeRequestData.store);
        try {
            for (File file : storeRequestData.files) {
                postEncoder.add(file);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new EncodingException(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        try {
            postEncoder.send("store", stringArray[0], stringArray[1], remoteProgressListener);
        }
        catch (Exception exception) {
            throw new SendingException(exception.getMessage(), exception);
        }
        Codecs.ResponseDecoder responseDecoder = new Codecs.ResponseDecoder(postEncoder.getResponse());
        try {
            if (postEncoder.isOk() || postEncoder.statusCode == 201) {
                return new Data.StoreResponseData(postEncoder.statusCode, responseDecoder.decodeAsFile(), null);
            }
            return new Data.StoreResponseData(postEncoder.statusCode, null, responseDecoder.decodeAsHtml());
        }
        catch (Exception exception) {
            throw new DecodingException(exception.getMessage(), exception);
        }
    }

    public boolean isStore(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("action");
        return "store".equals(string);
    }

    public Data.StoreRequestData parseStore(HttpServletRequest httpServletRequest, File file) throws IOException {
        Codecs.PostDecoder postDecoder = new Codecs.PostDecoder();
        postDecoder.receive(httpServletRequest);
        Data.StoreRequestData storeRequestData = new Data.StoreRequestData();
        try {
            file.mkdirs();
            List<File> list = postDecoder.writeFiles(file);
            storeRequestData.files = list;
            storeRequestData.store = postDecoder.get("store");
            return storeRequestData;
        }
        catch (Exception exception) {
            throw new IOException("parsing the request failed: " + exception, exception);
        }
    }

    public void respondStore(Data.StoreResponseData storeResponseData, HttpServletResponse httpServletResponse) throws IOException {
        Codecs.ResponseEncoder responseEncoder = new Codecs.ResponseEncoder();
        httpServletResponse.setStatus(storeResponseData.status);
        if (storeResponseData.projectfile != null) {
            responseEncoder.send(storeResponseData.projectfile, httpServletResponse);
        } else if (storeResponseData.message != null) {
            responseEncoder.send(storeResponseData.message, httpServletResponse);
        } else {
            throw new IOException("internal problem (probably a bug)");
        }
        httpServletResponse.flushBuffer();
    }

    public Data.Query2ResponseData sendQuery2(RequestCharacteristics requestCharacteristics, Data.Query2RequestData query2RequestData, String[] stringArray, RemoteProgressListener remoteProgressListener) throws SendingException, DecodingException {
        Codecs.PostEncoder postEncoder = new Codecs.PostEncoder(requestCharacteristics.urlString, requestCharacteristics.userAgent);
        postEncoder.add("searchVariant", Integer.toString(query2RequestData.searchVariant));
        postEncoder.add("searchString", query2RequestData.searchString);
        postEncoder.add("caseSensitive", Boolean.toString(query2RequestData.caseSensitive));
        postEncoder.add("containsString", Boolean.toString(query2RequestData.containsString));
        try {
            postEncoder.send("query2", stringArray[0], stringArray[1], remoteProgressListener);
        }
        catch (Exception exception) {
            throw new SendingException(exception.getMessage(), exception);
        }
        Codecs.ResponseDecoder responseDecoder = new Codecs.ResponseDecoder(postEncoder.getResponse());
        try {
            if (postEncoder.isOk()) {
                return new Data.Query2ResponseData(postEncoder.statusCode, responseDecoder.decodeAsCsv(), null);
            }
            return new Data.Query2ResponseData(postEncoder.statusCode, null, responseDecoder.decodeAsHtml());
        }
        catch (Exception exception) {
            throw new DecodingException(exception.getMessage(), exception);
        }
    }

    public boolean isQuery2(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("action");
        return "query2".equals(string);
    }

    public Data.Query2RequestData parseQuery2(HttpServletRequest httpServletRequest) throws IOException {
        Codecs.PostDecoder postDecoder = new Codecs.PostDecoder();
        postDecoder.receive(httpServletRequest);
        Data.Query2RequestData query2RequestData = new Data.Query2RequestData();
        query2RequestData.searchVariant = Integer.parseInt(postDecoder.get("searchVariant"));
        query2RequestData.searchString = postDecoder.get("searchString");
        query2RequestData.caseSensitive = Boolean.parseBoolean(postDecoder.get("caseSensitive"));
        query2RequestData.containsString = Boolean.parseBoolean(postDecoder.get("containsString"));
        return query2RequestData;
    }

    public void respondQuery2(Data.Query2ResponseData query2ResponseData, HttpServletResponse httpServletResponse) throws IOException {
        Codecs.ResponseEncoder responseEncoder = new Codecs.ResponseEncoder();
        httpServletResponse.setStatus(query2ResponseData.status);
        if (query2ResponseData.fields != null) {
            responseEncoder.send(query2ResponseData.fields, httpServletResponse);
        } else if (query2ResponseData.message != null) {
            responseEncoder.send(query2ResponseData.message, httpServletResponse);
        } else {
            throw new IOException("internal problem (probably a bug)");
        }
        httpServletResponse.flushBuffer();
    }

    public Data.RetrieveResponseData sendRetrieve(RequestCharacteristics requestCharacteristics, Data.RetrieveRequestData retrieveRequestData, String[] stringArray) throws SendingException, DecodingException {
        Codecs.PostEncoder postEncoder = new Codecs.PostEncoder(requestCharacteristics.urlString, requestCharacteristics.userAgent);
        postEncoder.add("retrieveVariant", retrieveRequestData.retrieveVariant);
        postEncoder.add("projectId", retrieveRequestData.projectId);
        try {
            postEncoder.send("retrieve", stringArray[0], stringArray[1], new NullRemoteProgressListener());
        }
        catch (Exception exception) {
            throw new SendingException(exception.getMessage(), exception);
        }
        Codecs.ResponseDecoder responseDecoder = new Codecs.ResponseDecoder(postEncoder.getResponse());
        try {
            if (postEncoder.isOk()) {
                return new Data.RetrieveResponseData(postEncoder.statusCode, responseDecoder.decodeAsFile(), null);
            }
            return new Data.RetrieveResponseData(postEncoder.statusCode, null, responseDecoder.decodeAsHtml());
        }
        catch (Exception exception) {
            throw new DecodingException(exception.getMessage(), exception);
        }
    }

    public boolean isRetrieve(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("action");
        return "retrieve".equals(string);
    }

    public Data.RetrieveRequestData parseRetrieve(HttpServletRequest httpServletRequest) throws IOException {
        Codecs.PostDecoder postDecoder = new Codecs.PostDecoder();
        postDecoder.receive(httpServletRequest);
        Data.RetrieveRequestData retrieveRequestData = new Data.RetrieveRequestData();
        retrieveRequestData.projectId = postDecoder.get("projectId");
        retrieveRequestData.retrieveVariant = postDecoder.get("retrieveVariant");
        return retrieveRequestData;
    }

    public void respondRetrieve(Data.RetrieveResponseData retrieveResponseData, HttpServletResponse httpServletResponse) throws IOException {
        Codecs.ResponseEncoder responseEncoder = new Codecs.ResponseEncoder();
        httpServletResponse.setStatus(retrieveResponseData.status);
        if (retrieveResponseData.projectfile != null) {
            responseEncoder.send(retrieveResponseData.projectfile, httpServletResponse);
        } else if (retrieveResponseData.message != null) {
            responseEncoder.send(retrieveResponseData.message, httpServletResponse);
        } else {
            throw new IOException("internal problem (probably a bug)");
        }
        httpServletResponse.flushBuffer();
    }

    public Data.DeleteResponseData sendDelete(RequestCharacteristics requestCharacteristics, Data.DeleteRequestData deleteRequestData, String[] stringArray) throws SendingException, DecodingException {
        Codecs.PostEncoder postEncoder = new Codecs.PostEncoder(requestCharacteristics.urlString, requestCharacteristics.userAgent);
        postEncoder.add("projectId", deleteRequestData.projectId);
        try {
            postEncoder.send("delete", stringArray[0], stringArray[1], new NullRemoteProgressListener());
        }
        catch (Exception exception) {
            throw new SendingException(exception.getMessage(), exception);
        }
        Codecs.ResponseDecoder responseDecoder = new Codecs.ResponseDecoder(postEncoder.getResponse());
        try {
            if (postEncoder.isOk()) {
                return new Data.DeleteResponseData(postEncoder.statusCode, responseDecoder.decodeAsHtml(), null);
            }
            return new Data.DeleteResponseData(postEncoder.statusCode, null, responseDecoder.decodeAsHtml());
        }
        catch (Exception exception) {
            throw new DecodingException(exception.getMessage(), exception);
        }
    }

    public boolean isDelete(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getParameter("action");
        return "delete".equals(string);
    }

    public Data.DeleteRequestData parseDelete(HttpServletRequest httpServletRequest) throws IOException {
        String string;
        Codecs.PostDecoder postDecoder = new Codecs.PostDecoder();
        postDecoder.receive(httpServletRequest);
        Data.DeleteRequestData deleteRequestData = new Data.DeleteRequestData();
        deleteRequestData.projectId = string = postDecoder.get("projectId");
        return deleteRequestData;
    }

    public void respondDelete(Data.DeleteResponseData deleteResponseData, HttpServletResponse httpServletResponse) throws IOException {
        Codecs.ResponseEncoder responseEncoder = new Codecs.ResponseEncoder();
        httpServletResponse.setStatus(deleteResponseData.status);
        if (deleteResponseData.success != null) {
            responseEncoder.send(deleteResponseData.success, httpServletResponse);
        } else if (deleteResponseData.message != null) {
            responseEncoder.send(deleteResponseData.message, httpServletResponse);
        } else {
            throw new IOException("internal problem (probably a bug)");
        }
        httpServletResponse.flushBuffer();
    }

    public static class RequestCharacteristics {
        public String urlString;
        public String userAgent;
    }

    public static class EncodingException
    extends IOException {
        private static final long serialVersionUID = 4144592016934628346L;

        EncodingException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class SendingException
    extends IOException {
        private static final long serialVersionUID = -3487168311236566047L;

        SendingException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static class DecodingException
    extends IOException {
        private static final long serialVersionUID = -636248318478028127L;

        public DecodingException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

