/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.JointProposal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.obsproposal.TimeAllocationBreakdown;
import alma.obsprep.ot.editors.sciencegoals.ProjectTimeEstimateSummary;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.valdef.DefaultProblemListModel;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.services.summaryfeedback.ObsProposalScienceGoalNavigator;
import alma.obsprep.services.summaryfeedback.PIContactInfo;
import alma.obsprep.services.summaryfeedback.PreviousProposalInfo;
import alma.obsprep.services.summaryfeedback.ScienceGoalInfo;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.SummaryDocument;
import alma.obsprep.services.userlookup.User;
import alma.obsprep.services.userlookup.UserLookup;
import alma.obsprep.services.userlookup.UserLookupException;
import alma.valuetypes.Time;
import com.sun.istack.NotNull;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.axis.utils.StringUtils;

public class ProposalSummaryParameters
implements SummaryDocument {
    protected String projectCode;
    protected String astronomicalCategoryString;
    protected String title;
    protected String piName;
    protected String piInstitute;
    protected Investigator[] copis;
    protected Time total12mTime;
    protected Time total7MTime;
    protected Time totalTPTime;
    protected String duplicateObservationsJustification;
    protected String abstractString;
    protected List<ScienceGoalInfo> scienceGoalInfo;
    protected Optional<JointProposal> jointProposal = Optional.empty();
    protected String timeConstraints;
    protected String extraTime;
    protected PIContactInfo piContactInfo;
    protected List<ScienceGoalSummaryParameters> sgSummary;
    private final ObsProposal obsProposal;
    private final ProblemListModel problems;
    private final ObsProposalScienceGoalNavigator obsProposalScienceGoalNavigator;

    public ProposalSummaryParameters(@NotNull ObsProposal obsProposal) {
        this.obsProposal = obsProposal;
        this.problems = new DefaultProblemListModel();
        this.obsProposalScienceGoalNavigator = new ObsProposalScienceGoalNavigator(obsProposal, true);
        this.sgSummary = new ArrayList<ScienceGoalSummaryParameters>();
    }

    public ObsProposal getUserObject() {
        return this.getObsProposal();
    }

    @Override
    public void collectInfo() {
        ObsProposal obsProposal = this.getObsProposal();
        try {
            obsProposal.getProposalFeedback().fill();
        }
        catch (Exception exception) {
            Log.logger((Object)this).warning(exception.getMessage());
        }
        this.sgSummary.clear();
        for (ScienceGoal scienceGoal : this.obsProposalScienceGoalNavigator.getScienceGoals()) {
            ScienceGoalSummaryParameters scienceGoalSummaryParameters = new ScienceGoalSummaryParameters(scienceGoal);
            scienceGoalSummaryParameters.collectInfo();
            this.sgSummary.add(scienceGoalSummaryParameters);
        }
        this.projectCode = this.getProjectCode();
        this.title = obsProposal.getTitle();
        this.astronomicalCategoryString = obsProposal.getScientificCategoryString();
        this.total12mTime = this.getTotal12mTime();
        this.total7MTime = this.getTotal7MTime();
        this.totalTPTime = this.getTotalTPTime();
        Object object = obsProposal.getPrincipalInvestigator();
        this.piName = object.getFullName();
        this.piInstitute = object.getOrganisation();
        this.piContactInfo = new PIContactInfo((Investigator)((Object)object));
        this.copis = obsProposal.getCoPrincipalInvestigator();
        this.duplicateObservationsJustification = obsProposal.getDuplicateObservationsJustification();
        this.abstractString = obsProposal.getAbstract();
        this.scienceGoalInfo = this.getScienceGoalInfo();
        if (obsProposal.getJointProposal() != null) {
            this.jointProposal = Optional.of(obsProposal.getJointProposal());
        }
        this.timeConstraints = this.getTimeConstraints();
        this.extraTime = this.getExtraTime();
    }

    public Time getTotal7MTime() {
        Time time = this.getObsProposal().getTotalRequestedTime(Array.ARRAY_7M, false);
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    protected String getProjectCode() {
        try {
            return this.getObsProposal().getObsProject().getCode();
        }
        catch (UnknownEntityException unknownEntityException) {
            return "Unknown";
        }
    }

    protected TimeAllocationBreakdown getTimeAllocationBreakdown() {
        return this.getObsProposal().getProposalFeedback().getTimeAllocationBreakdown();
    }

    public Time getTotal12mTime() {
        Time time = this.getObsProposal().getTotalRequestedTime(Array.ARRAY_12M, false);
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    public Time getTotalOtherTime() {
        Time time = this.getObsProposal().getTotalOtherTime();
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    public Time getTotal12mNonStandardTime() {
        Time time = this.getObsProposal().getTotal12mNonStandardTime();
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    public Time getTotalTPTime() {
        Time time = this.getObsProposal().getTotalRequestedTime(Array.ARRAY_TP, false);
        time.convertToUnit(Time.UNIT_H);
        return time;
    }

    protected String getResubmission() {
        if (this.getObsProposal().getIsResubmission()) {
            return this.getObsProposal().getResubmittedProjectCode();
        }
        return "";
    }

    protected String getTimeConstraints() {
        for (ScienceGoal scienceGoal : this.obsProposalScienceGoalNavigator.getScienceGoals()) {
            PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
            if (!performanceParameters.getIsTimeConstrained()) continue;
            return "There are time constraints.";
        }
        return "NONE";
    }

    public String capitalizeFirstLetter(String string) {
        if (string.length() == 0) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    /*
     * WARNING - void declaration
     */
    protected String getExtraTime() {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal != null && obsProposal.isVLBIorPhasedArray()) {
            return "No";
        }
        EnumSet<ReasonsForExtraTime> enumSet = EnumSet.noneOf(ReasonsForExtraTime.class);
        for (ScienceGoal object : this.obsProposalScienceGoalNavigator.getScienceGoals()) {
            boolean bl = false;
            try {
                bl = object.isSolarScienceGoal();
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger((Object)this).warning("Unable to determine if this is a Solar Science Goal : " + unknownEntityException.getMessage());
            }
            PerformanceParameters performanceParameters = object.getPerformanceParameters();
            if (performanceParameters.getNeedsMoreTime() && !bl) {
                enumSet.add(ReasonsForExtraTime.USERDEFINEDTIME);
            }
            if (!performanceParameters.getIsTimeConstrained() || performanceParameters.getMonitoringConstraintCount() <= 0) continue;
            enumSet.add(ReasonsForExtraTime.CONTINUOUSMONITORING);
        }
        if (!enumSet.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("");
            Integer n = 1;
            for (ReasonsForExtraTime reasonsForExtraTime : enumSet) {
                void var4_6;
                if (var4_6.intValue() == 1) {
                    stringBuilder.append(this.capitalizeFirstLetter(reasonsForExtraTime.getDescription()));
                } else {
                    stringBuilder.append(reasonsForExtraTime.getDescription());
                }
                if (var4_6.intValue() < enumSet.size()) {
                    stringBuilder.append(" and ");
                }
                void var7_15 = var4_6;
                Integer n2 = var4_6.intValue() + 1;
            }
            stringBuilder.append(" requested.");
            return stringBuilder.toString();
        }
        return "No";
    }

    protected List<ScienceGoalInfo> getScienceGoalInfo() {
        ArrayList<ScienceGoalInfo> arrayList = new ArrayList<ScienceGoalInfo>();
        for (ScienceGoal scienceGoal : this.obsProposalScienceGoalNavigator.getScienceGoals()) {
            arrayList.add(new ScienceGoalInfo(scienceGoal));
        }
        return arrayList;
    }

    protected List<RelatedProposalInfo> getRelatedProposalInfo() {
        ArrayList<RelatedProposalInfo> arrayList = new ArrayList<RelatedProposalInfo>();
        ObsProposal obsProposal = this.getObsProposal();
        String string = obsProposal.getRelatedProposals();
        if (string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\n")) {
                RelatedProposalInfo relatedProposalInfo;
                String[] stringArray2 = string2.split(",");
                if (stringArray2.length == 1) {
                    relatedProposalInfo = new RelatedProposalInfo();
                    relatedProposalInfo.code = stringArray2[0];
                    arrayList.add(relatedProposalInfo);
                    continue;
                }
                if (stringArray2.length != 3) continue;
                relatedProposalInfo = new RelatedProposalInfo();
                relatedProposalInfo.code = stringArray2[0];
                relatedProposalInfo.title = stringArray2[1];
                relatedProposalInfo.piName = stringArray2[2];
                arrayList.add(relatedProposalInfo);
            }
        }
        return arrayList;
    }

    protected List<PreviousProposalInfo> getPreviousProposalInfo() {
        ArrayList<PreviousProposalInfo> arrayList = new ArrayList<PreviousProposalInfo>();
        ObsProposal obsProposal = this.getObsProposal();
        String string = obsProposal.getPreviousProposals();
        if (string.length() > 0) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("\n")) {
                PreviousProposalInfo previousProposalInfo;
                String[] stringArray2 = string2.split(",");
                if (stringArray2.length == 1) {
                    previousProposalInfo = new PreviousProposalInfo();
                    previousProposalInfo.code = stringArray2[0];
                    arrayList.add(previousProposalInfo);
                    continue;
                }
                if (stringArray2.length != 4) continue;
                previousProposalInfo = new PreviousProposalInfo();
                previousProposalInfo.code = stringArray2[0];
                previousProposalInfo.title = stringArray2[1];
                previousProposalInfo.piName = stringArray2[2];
                previousProposalInfo.publicationStatus = stringArray2[3];
                arrayList.add(previousProposalInfo);
            }
        }
        return arrayList;
    }

    private List<String> getSanitizedInvestigatorNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ObsProposal obsProposal = this.getObsProposal();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            List<Investigator> list = this.getAllInvestigatorsEnsuringNamesPopulated(obsProposal);
            for (Investigator investigator : list) {
                byte[] byArray = messageDigest.digest(investigator.getFullName().getBytes());
                int n = new BigInteger(1, byArray).intValue();
                String string = investigator.getFirstName();
                String string2 = StringUtils.isEmpty((String)string) ? string : string.substring(0, 1) + ". " + investigator.getSurName();
                int n2 = Math.abs(n % (1 + arrayList.size()));
                arrayList.add(n2, string2);
            }
            return arrayList;
        }
        catch (UserLookupException userLookupException) {
            arrayList = new ArrayList();
            arrayList.add("The name information for one or more investigators is incomplete and cannot be looked up at this time.");
            arrayList.add("Please try regenerating the PDF at a point when you are able to connect to the submission server. ");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.logger(ProposalSummaryParameters.class).warning("No such algorithm for sanitizing investigator names");
        }
        return null;
    }

    private List<Investigator> getAllInvestigatorsInProposal(ObsProposal obsProposal) {
        ArrayList<Investigator> arrayList = new ArrayList<Investigator>();
        arrayList.addAll(Arrays.asList(obsProposal.getCoInvestigator()));
        arrayList.addAll(Arrays.asList(obsProposal.getCoPrincipalInvestigator()));
        arrayList.add(obsProposal.getPrincipalInvestigator());
        return arrayList;
    }

    private List<User> lookupInvestigatorsInDatabase(List<Investigator> list) throws UserLookupException {
        if (ObservingToolController.isOTInBatchMode()) {
            return new ArrayList<User>();
        }
        UserLookup userLookup = null;
        if (ObservingToolController.getMyInstance() != null) {
            userLookup = ObservingToolController.getMyInstance().getUserLookup();
        }
        if (userLookup == null) {
            Log.logger(ProjectTimeEstimateSummary.class).warning("Unable to identify user lookup service - check investigator names on pdf ");
            return new ArrayList<User>();
        }
        String[] stringArray = (String[])list.stream().map(investigator -> investigator.getUserId()).toArray(String[]::new);
        return userLookup.matchUid(stringArray);
    }

    protected List<Investigator> getAllInvestigatorsEnsuringNamesPopulated(ObsProposal obsProposal) throws UserLookupException {
        List<Investigator> list = this.getAllInvestigatorsInProposal(obsProposal);
        Exception exception = null;
        List<User> list2 = null;
        try {
            list2 = this.lookupInvestigatorsInDatabase(list);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        for (Investigator investigator : list) {
            if (investigator.gettrueFirstName() != null && investigator.gettrueFirstName().length() != 0 && investigator.gettrueSurName() != null && investigator.gettrueSurName().length() != 0) continue;
            Optional<User> optional = list2.stream().filter(user -> investigator.getUserId().equals(user.getUid())).findFirst();
            if (optional.isPresent()) {
                User user2 = optional.get();
                investigator.setFirstName(user2.getFirstName());
                investigator.setSurName(user2.getSurname());
                continue;
            }
            if (exception == null) continue;
            throw new UserLookupException("Investigator details needed to fill in name" + exception.getMessage());
        }
        return list;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public ObsProposal getObsProposal() {
        return this.obsProposal;
    }

    @Override
    public ProblemListModel getProblems() {
        return this.problems;
    }

    private static enum ReasonsForExtraTime {
        CONTINUOUSMONITORING("continuous monitoring"),
        USERDEFINEDTIME("extra time");

        String description;

        private ReasonsForExtraTime(String string2) {
            this.description = string2;
        }

        public String getDescription() {
            return this.description;
        }
    }

    protected static class RelatedProposalInfo {
        protected String code = "";
        protected String title = "";
        protected String piName = "";

        protected RelatedProposalInfo() {
        }
    }

    static enum PIContactProperty {
        TITLE,
        NAME,
        EMAIL("E-MAIL"),
        PHONE1("PHONE[FIRST]"),
        PHONE2("PHONE[SECOND]"),
        FAX,
        INSTITUTE("INSTITUTE &/OR DEPT."),
        ADDRESS("ADDRESS"),
        STREET("STREET ADDRESS"),
        POSTCODE("POSTCODE/ZIP CODE"),
        CITY("TOWN/CITY"),
        REGION("COUNTY/STATE/REGION"),
        COUNTRY,
        EXECUTIVE("ALMA EXECUTIVE"),
        PREFERREDARC("PREFERRED ARC[EA/EU/NA]");

        private String label;

        private PIContactProperty() {
            this.label = this.name();
        }

        public String toString() {
            return this.label;
        }

        private PIContactProperty(String string2) {
            this.label = string2;
        }
    }
}

