/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FitsURL {
    private final URL container;
    private final int hdu;

    private FitsURL(URL container, int hdu) {
        this.container = container;
        this.hdu = hdu;
    }

    public URL getContainer() {
        return this.container;
    }

    public int getHDU() {
        return this.hdu;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static FitsURL parseURL(URL url, List extensions) {
        int hduIndex;
        URL basicURL;
        Matcher mat;
        Pattern pat;
        String patstr;
        String urlstr = url.toExternalForm();
        if (urlstr.endsWith("]")) {
            patstr = "^(.*)\\[([0-9]+)\\]$";
            pat = Pattern.compile(patstr);
            mat = pat.matcher(urlstr);
            if (!mat.matches()) return null;
            try {
                basicURL = new URL(mat.group(1));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            hduIndex = Integer.parseInt(mat.group(2));
        } else if (url.getRef() != null) {
            patstr = "^(.*)#([0-9]+)$";
            pat = Pattern.compile(patstr);
            mat = pat.matcher(urlstr);
            if (!mat.matches()) return null;
            try {
                basicURL = new URL(mat.group(1));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            hduIndex = Integer.parseInt(mat.group(2));
        } else {
            basicURL = url;
            hduIndex = 0;
        }
        boolean isFits = false;
        Iterator it = extensions.iterator();
        while (it.hasNext()) {
            if (!basicURL.getPath().endsWith((String)it.next())) continue;
            isFits = true;
            break;
        }
        if (isFits) return new FitsURL(basicURL, hduIndex);
        return null;
    }

    public String toString() {
        return this.container + "#" + this.hdu;
    }

    public boolean equals(Object other) {
        if (!(other instanceof FitsURL)) {
            return false;
        }
        FitsURL fother = (FitsURL)other;
        if (fother.hdu != this.hdu) {
            return false;
        }
        return fother.container.toString().equals(this.container.toString());
    }
}

