/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.monitoring;

import alma.acs.monitoring.RemoteThreadsException;
import alma.acs.monitoring.RemoteThreadsMBean;
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import javax.management.JMX;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class RemoteThreadsClient {
    public static final int RMI_DEFAULT_PORT = 9999;
    private static final String LOCAL_CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private JMXServiceURL remoteURL = null;
    private MBeanServerConnection remote = null;
    private RemoteThreadsMBean rtmb = null;
    private JMXConnector connector = null;

    public RemoteThreadsClient(String className) throws RemoteThreadsException {
        int pid = 0;
        try {
            pid = this.getRemotePID(className);
        }
        catch (IOException e) {
            throw new RemoteThreadsException("Error while getting remote PID!", e);
        }
        if (pid == 0) {
            throw new RemoteThreadsException("Can't find PID for the " + className + " class");
        }
        try {
            this.getServiceURL(pid);
        }
        catch (IOException e) {
            throw new RemoteThreadsException("Can't connect to remote VM", e);
        }
        catch (AgentLoadException e) {
            throw new RemoteThreadsException("Can't load the JMX agent into the remote JVM", e);
        }
        catch (AttachNotSupportedException e) {
            throw new RemoteThreadsException("Can't attach to the remote JVM", e);
        }
        catch (AgentInitializationException e) {
            throw new RemoteThreadsException("Can't initialize the remote JMX agent", e);
        }
    }

    public RemoteThreadsClient(int pid) throws RemoteThreadsException {
        if (pid <= 0) {
            throw new RemoteThreadsException("PID must be grater than zero");
        }
        try {
            this.getServiceURL(pid);
        }
        catch (IOException e) {
            throw new RemoteThreadsException("Can't connect to remote VM", e);
        }
        catch (AgentLoadException e) {
            throw new RemoteThreadsException("Can't load the JMX agent into the remote JVM", e);
        }
        catch (AttachNotSupportedException e) {
            throw new RemoteThreadsException("Can't attach to the remote JVM", e);
        }
        catch (AgentInitializationException e) {
            throw new RemoteThreadsException("Can't initialize the remote JMX agent", e);
        }
    }

    public RemoteThreadsClient(InetAddress remoteHost) throws RemoteThreadsException {
        try {
            this.getServiceURL(remoteHost, 9999);
        }
        catch (MalformedURLException e) {
            throw new RemoteThreadsException(e);
        }
    }

    public RemoteThreadsClient(InetAddress remoteHost, int remotePort) throws RemoteThreadsException {
        if (remotePort <= 0) {
            throw new RemoteThreadsException("Port must be grater than zero");
        }
        try {
            this.getServiceURL(remoteHost, remotePort);
        }
        catch (MalformedURLException e) {
            throw new RemoteThreadsException(e);
        }
    }

    public boolean connect() {
        try {
            this.connector = JMXConnectorFactory.connect(this.remoteURL);
        }
        catch (IOException e) {
            System.err.println("Can't connect to the remote URL");
            return false;
        }
        try {
            this.remote = this.connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            System.err.println("Can't get a connection to the remote MBeanServer");
            return false;
        }
        return true;
    }

    public void close() throws RemoteThreadsException {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                System.err.println("Cannot close connection to the remote MBeanServer");
            }
        } else {
            throw new RemoteThreadsException("The connection has not been opened");
        }
    }

    public RemoteThreadsMBean getMBean() throws RemoteThreadsException {
        if (this.rtmb == null) {
            try {
                ObjectName remoteThreadsName = new ObjectName("alma.acs.monitoring:type=RemoteThreads");
                if (!this.remote.isRegistered(remoteThreadsName)) {
                    this.remote.createMBean("alma.acs.monitoring.RemoteThreads", remoteThreadsName);
                }
                this.rtmb = JMX.newMBeanProxy(this.remote, remoteThreadsName, RemoteThreadsMBean.class);
            }
            catch (MalformedObjectNameException remoteThreadsName) {
            }
            catch (MBeanRegistrationException e) {
                throw new RemoteThreadsException("Can't register the MBean in the remote server", e);
            }
            catch (Exception e) {
                throw new RemoteThreadsException("Can't get a reference to the remote MBean", e);
            }
        }
        return this.rtmb;
    }

    private int getRemotePID(String className) throws IOException {
        String s;
        Integer remotePID = null;
        Process p = Runtime.getRuntime().exec("jps -lm");
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((s = stdInput.readLine()) != null) {
            String[] ss = s.split("[\t ]+");
            if (ss.length <= 1 || !ss[1].equals(className)) continue;
            remotePID = Integer.valueOf(ss[0]);
            break;
        }
        stdInput.close();
        if (remotePID == null) {
            return 0;
        }
        return remotePID;
    }

    private void getServiceURL(int pid) throws IOException, AgentLoadException, RemoteThreadsException, AttachNotSupportedException, AgentInitializationException {
        VirtualMachine vm = VirtualMachine.attach(String.valueOf(pid));
        String connectorAddress = vm.getAgentProperties().getProperty(LOCAL_CONNECTOR_ADDRESS);
        if (connectorAddress == null) {
            vm.startLocalManagementAgent();
            connectorAddress = vm.getAgentProperties().getProperty(LOCAL_CONNECTOR_ADDRESS);
            if (connectorAddress == null) {
                throw new RemoteThreadsException("Can't get the remote JVM connector address");
            }
        }
        this.remoteURL = new JMXServiceURL(connectorAddress);
    }

    private void getServiceURL(InetAddress host, int port) throws MalformedURLException {
        String hostName = host.getHostName();
        String connectorAddress = "service:jmx:rmi:///jndi/rmi://" + hostName + ":" + port + "/jmxrmi";
        this.remoteURL = new JMXServiceURL(connectorAddress);
    }
}

