/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.demo;

import diva.canvas.FigureLayer;
import diva.canvas.GraphicsPane;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.toolbox.BasicController;
import diva.canvas.toolbox.BasicEllipse;
import diva.canvas.toolbox.BasicFigure;
import diva.canvas.toolbox.BasicRectangle;
import diva.util.java2d.Polygon2D;
import diva.util.java2d.ShapeUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class SimplePane
extends GraphicsPane {
    BasicController controller;
    SelectionInteractor selectionInteractor;
    FigureLayer figureLayer = this.getForegroundLayer();

    public SimplePane() {
        this.controller = new BasicController(this);
        this.selectionInteractor = this.controller.getSelectionInteractor();
        this.drawFigures();
    }

    public void drawFigures() {
        BasicRectangle rect = new BasicRectangle(40.0, 40.0, 80.0, 80.0);
        rect.setLineWidth(8.0f);
        rect.setStrokePaint(Color.red);
        this.figureLayer.add(rect);
        rect.setInteractor(this.selectionInteractor);
        BasicEllipse oval = new BasicEllipse(160.0, 10.0, 120.0, 80.0);
        oval.setLineWidth(2.0f);
        oval.setFillPaint(Color.magenta);
        this.figureLayer.add(oval);
        oval.setInteractor(this.selectionInteractor);
        Polygon2D.Double p = new Polygon2D.Double();
        ((Polygon2D)p).moveTo(-100.0, -25.0);
        ((Polygon2D)p).lineTo(100.0, -25.0);
        ((Polygon2D)p).lineTo(-50.0, 100.0);
        ((Polygon2D)p).lineTo(0.0, -100.0);
        ((Polygon2D)p).lineTo(50.0, 100.0);
        p.closePath();
        AffineTransform at = new AffineTransform();
        at.translate(200.0, 200.0);
        ((Polygon2D)p).transform(at);
        BasicFigure star = new BasicFigure(p);
        star.setLineWidth(2.0f);
        star.setStrokePaint(Color.blue);
        this.figureLayer.add(star);
        star.setInteractor(this.selectionInteractor);
        Shape area = ShapeUtilities.createCloudShape();
        AffineTransform cat = new AffineTransform();
        cat.translate(200.0, 100.0);
        cat.scale(2.0, 2.0);
        Shape bigarea = cat.createTransformedShape(area);
        BasicFigure cloud = new BasicFigure(bigarea, Color.blue);
        cloud.setComposite(AlphaComposite.getInstance(3, 0.5f));
        this.figureLayer.add(cloud);
        cloud.setInteractor(this.selectionInteractor);
    }

    public SelectionInteractor getSelectionInteractor() {
        return this.selectionInteractor;
    }
}

