/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.dynwrapper;

import alma.ACS.OffShoot;
import alma.acs.component.dynwrapper.ArrayMapper;
import alma.acs.component.dynwrapper.CastorMarshalMapper;
import alma.acs.component.dynwrapper.CastorUnmarshalMapper;
import alma.acs.component.dynwrapper.CompositionMapper;
import alma.acs.component.dynwrapper.DynWrapperException;
import alma.acs.component.dynwrapper.HolderMapper;
import alma.acs.component.dynwrapper.IdentityMapper;
import alma.acs.component.dynwrapper.OffShootMapper;
import alma.acs.component.dynwrapper.TypeMapper;
import alma.xmlentity.XmlEntityStruct;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ComponentInvocationHandler
implements InvocationHandler {
    private final Logger m_logger;
    private final Object m_delegate;
    private final Map<String, Method> m_delegateMethodMap;
    private final List<TypeMapper> m_typeMappers;
    private final Map<String, TypeMapper> m_mapperMap;

    ComponentInvocationHandler(Object delegate, Class delegateIF, Logger logger) {
        this.m_delegate = delegate;
        this.m_logger = logger;
        this.m_typeMappers = new ArrayList<TypeMapper>();
        this.m_mapperMap = new HashMap<String, TypeMapper>();
        this.m_delegateMethodMap = new HashMap<String, Method>();
        Method[] delegateMethods = delegateIF.getMethods();
        for (int i = 0; i < delegateMethods.length; ++i) {
            this.m_delegateMethodMap.put(delegateMethods[i].getName(), delegateMethods[i]);
        }
        this.addTypeMapper(new OffShootMapper(delegate, this.m_logger));
        this.addTypeMapper(new IdentityMapper(delegate, this.m_logger));
        this.addTypeMapper(new CastorMarshalMapper(delegate, this.m_logger));
        this.addTypeMapper(new CastorUnmarshalMapper(delegate, this.m_logger));
        this.addTypeMapper(new HolderMapper(delegate, this.m_logger));
        this.addTypeMapper(new ArrayMapper(delegate, this.m_logger));
        this.addTypeMapper(new CompositionMapper(delegate, this.m_logger));
    }

    void addTypeMapper(TypeMapper typeMapper) {
        this.m_typeMappers.add(typeMapper);
    }

    public void addOffshoot(Object offshootImpl, OffShoot shoot) {
        for (TypeMapper mapper : this.m_typeMappers) {
            if (!(mapper instanceof OffShootMapper)) continue;
            ((OffShootMapper)mapper).addOffshoot(offshootImpl, shoot);
            break;
        }
    }

    @Override
    public Object invoke(Object proxy, Method proxyMethod, Object[] proxyArgs) throws Throwable {
        Method delegateMethod = this.findDelegateMethod(proxyMethod);
        Object[] delegateArgs = null;
        if (proxyArgs != null) {
            delegateArgs = new Object[proxyArgs.length];
            for (int argIndex = 0; argIndex < proxyArgs.length; ++argIndex) {
                Class<?> delegateArgType = delegateMethod.getParameterTypes()[argIndex];
                delegateArgs[argIndex] = this.translate(proxyArgs[argIndex], null, delegateArgType);
            }
        }
        Object delegateReturn = null;
        try {
            delegateReturn = delegateMethod.invoke(this.m_delegate, delegateArgs);
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
        int argIndex = 0;
        try {
            if (proxyArgs != null) {
                for (argIndex = 0; argIndex < proxyArgs.length; ++argIndex) {
                    Class<?> facadeArgType = proxyMethod.getParameterTypes()[argIndex];
                    proxyArgs[argIndex] = this.translate(delegateArgs[argIndex], proxyArgs[argIndex], facadeArgType);
                }
            }
        }
        catch (Exception e) {
            String methodName = this.m_delegate.getClass().getName() + "#" + delegateMethod.getName();
            throw new DynWrapperException("failed to translate parameter in method " + methodName, e);
        }
        Object proxyRet = null;
        try {
            proxyRet = this.translate(delegateReturn, null, proxyMethod.getReturnType());
        }
        catch (Exception e) {
            throw new DynWrapperException("failed to translate return value.", e);
        }
        return proxyRet;
    }

    Method findDelegateMethod(Method method) throws DynWrapperException {
        Method matchingDelegateMethod = this.m_delegateMethodMap.get(method.getName());
        if (matchingDelegateMethod == null) {
            throw new DynWrapperException("no method '" + method.getName() + "' found in delegate object's functional interface.");
        }
        return matchingDelegateMethod;
    }

    boolean canTranslate(Class<?> oldObjClass, Class<?> newObjClass) {
        String mapKey = oldObjClass.getName() + newObjClass.getName();
        if (this.m_mapperMap.containsKey(mapKey)) {
            return true;
        }
        for (TypeMapper typeMapper : this.m_typeMappers) {
            if (!typeMapper.canTranslate(oldObjClass, newObjClass, this)) continue;
            this.m_mapperMap.put(mapKey, typeMapper);
            return true;
        }
        return false;
    }

    Object translate(Object oldObject, Object newObjectTemplate, Class newObjectClass) throws DynWrapperException {
        if (oldObject == null) {
            if (newObjectClass == XmlEntityStruct.class) {
                return new XmlEntityStruct();
            }
            return null;
        }
        if ((newObjectClass = this.primitiveToWrapper(newObjectClass)).isInstance(oldObject)) {
            return oldObject;
        }
        String mapKey = oldObject.getClass().getName() + newObjectClass.getName();
        TypeMapper typeMapper = this.m_mapperMap.get(mapKey);
        if (typeMapper == null) {
            this.canTranslate(oldObject.getClass(), newObjectClass);
            typeMapper = this.m_mapperMap.get(mapKey);
        }
        if (typeMapper == null) {
            String msg = "no TypeMapper found to translate " + oldObject.getClass().getName() + " to " + newObjectClass.getName();
            throw new DynWrapperException(msg);
        }
        Object newObject = typeMapper.translate(oldObject, newObjectTemplate, newObjectClass, this);
        return newObject;
    }

    private Class<?> primitiveToWrapper(Class<?> inClass) {
        if (inClass == Boolean.TYPE) {
            return Boolean.class;
        }
        if (inClass == Character.TYPE) {
            return Character.class;
        }
        if (inClass == Byte.TYPE) {
            return Byte.class;
        }
        if (inClass == Short.TYPE) {
            return Short.class;
        }
        if (inClass == Integer.TYPE) {
            return Integer.class;
        }
        if (inClass == Long.TYPE) {
            return Long.class;
        }
        if (inClass == Float.TYPE) {
            return Float.class;
        }
        if (inClass == Double.TYPE) {
            return Double.class;
        }
        if (inClass == Void.TYPE) {
            return Void.class;
        }
        return inClass;
    }
}

